/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent;

import java.util.concurrent.TimeUnit;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000353A!\u0001\u0002\u0001\u000f\t91+\u001f8d-\u0006\u0014(BA\u0002\u0005\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002\u000b\u0005)1oY1mC\u000e\u0001QC\u0001\u0005\u0015'\t\u0001\u0011\u0002\u0005\u0002\u000b\u00175\tA!\u0003\u0002\r\t\t1\u0011I\\=SK\u001aDQA\u0004\u0001\u0005\u0002=\ta\u0001P5oSRtD#\u0001\t\u0011\u0007E\u0001!#D\u0001\u0003!\t\u0019B\u0003\u0004\u0001\u0005\u000bU\u0001!\u0019\u0001\f\u0003\u0003\u0005\u000b\"a\u0006\u000e\u0011\u0005)A\u0012BA\r\u0005\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AC\u000e\n\u0005q!!aA!os\"1a\u0004\u0001Q!\n}\t\u0011\"[:EK\u001aLg.\u001a3\u0011\u0005)\u0001\u0013BA\u0011\u0005\u0005\u001d\u0011un\u001c7fC:D\u0011b\t\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\n\u0002\u000bY\fG.^3\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\u0007\u001d,G/F\u0001\u0013\u0011\u0015A\u0003\u0001\"\u0003*\u0003Q9\u0018-\u001b;NK\u0006\u001cXO]5oO\u0016c\u0017\r]:fIR\u0011!&\f\t\u0003\u0015-J!\u0001\f\u0003\u0003\t1{gn\u001a\u0005\u0006]\u001d\u0002\rAK\u0001\bi&lWm\\;u\u0011\u0015)\u0003\u0001\"\u00011)\t\tD\u0007E\u0002\u000beII!a\r\u0003\u0003\r=\u0003H/[8o\u0011\u0015qs\u00061\u0001+\u0011\u00151\u0004\u0001\"\u00018\u0003\u0011!\u0018m[3\u0015\u0003IAQA\u000e\u0001\u0005\u0002e\"\"A\u0005\u001e\t\u000b9B\u0004\u0019\u0001\u0016\t\u000bq\u0002A\u0011A\u001f\u0002\u0007A,H\u000f\u0006\u0002?\u0003B\u0011!bP\u0005\u0003\u0001\u0012\u0011A!\u00168ji\")!i\u000fa\u0001%\u0005\t\u0001\u0010C\u0003E\u0001\u0011\u0005Q)A\u0003jgN+G/F\u0001 \u0011\u00159\u0005\u0001\"\u0003I\u0003\u0019\u0019X\r\u001e,bYR\u0011a(\u0013\u0005\u0006\u0005\u001a\u0003\rA\u0005\u0005\u0006\u0017\u0002!I\u0001T\u0001\tk:\u001cX\r\u001e,bYR\ta\b")
public class SyncVar<A> {
    private boolean isDefined = false;
    private A value;

    public synchronized A get() {
        while (!this.isDefined) {
            this.wait();
        }
        return this.value;
    }

    private long waitMeasuringElapsed(long timeout) {
        long l;
        if (timeout <= 0L) {
            l = 0L;
        } else {
            long start = System.nanoTime();
            this.wait(timeout);
            long elapsed = System.nanoTime() - start;
            l = elapsed < 0L ? 0L : TimeUnit.NANOSECONDS.toMillis(elapsed);
        }
        return l;
    }

    public synchronized Option<A> get(long timeout) {
        long elapsed;
        for (long rest = timeout; !this.isDefined && rest > 0L; rest -= elapsed) {
            elapsed = this.waitMeasuringElapsed(rest);
        }
        return this.isDefined ? new Some<A>(this.value) : None$.MODULE$;
    }

    public synchronized A take() {
        A a;
        try {
            a = this.get();
        }
        finally {
            this.unsetVal();
        }
        return a;
    }

    public synchronized A take(long timeout) {
        A a;
        try {
            a = this.get(timeout).get();
        }
        finally {
            this.unsetVal();
        }
        return a;
    }

    public synchronized void put(A x) {
        while (this.isDefined) {
            this.wait();
        }
        this.setVal(x);
    }

    public synchronized boolean isSet() {
        return this.isDefined;
    }

    private synchronized void setVal(A x) {
        this.isDefined = true;
        this.value = x;
        this.notifyAll();
    }

    private synchronized void unsetVal() {
        this.isDefined = false;
        this.value = null;
        this.notifyAll();
    }
}

