/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ArraySeq$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2$mcIII$sp;

public final class ArrayOps$ {
    public static ArrayOps$ MODULE$;

    static {
        new ArrayOps$();
    }

    public final <A> ClassTag<A> elemTag$extension(Object $this) {
        return ClassTag$.MODULE$.apply($this.getClass().getComponentType());
    }

    public final <A> int size$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this);
    }

    public final <A> int knownSize$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this);
    }

    public final <A> boolean isEmpty$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) == 0;
    }

    public final <A> boolean nonEmpty$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) != 0;
    }

    public final <A> A head$extension(Object $this) {
        Object object;
        try {
            object = ScalaRunTime$.MODULE$.array_apply($this, 0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException("head of empty array");
        }
        return (A)object;
    }

    public final <A> A last$extension(Object $this) {
        Object object;
        try {
            object = ScalaRunTime$.MODULE$.array_apply($this, ScalaRunTime$.MODULE$.array_length($this) - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException("last of empty array");
        }
        return (A)object;
    }

    public final <A> Option<A> headOption$extension(Object $this) {
        return this.isEmpty$extension($this) ? None$.MODULE$ : new Some<A>(this.head$extension($this));
    }

    public final <A> Option<A> lastOption$extension(Object $this) {
        return this.isEmpty$extension($this) ? None$.MODULE$ : new Some<A>(this.last$extension($this));
    }

    public final <A> int lengthCompare$extension(Object $this, int len) {
        return ScalaRunTime$.MODULE$.array_length($this) - len;
    }

    public final <A> Object slice$extension(Object $this, int from, int until) {
        Object[] objectArray;
        int lo = package$.MODULE$.max(from, 0);
        int hi = package$.MODULE$.min(until, ScalaRunTime$.MODULE$.array_length($this));
        int len = hi - lo;
        if (len > 0) {
            Object[] objectArray2;
            Object object = $this;
            if (object instanceof Object[]) {
                Object[] objectArray3 = (Object[])object;
                objectArray2 = Arrays.copyOfRange(objectArray3, lo, hi);
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                objectArray2 = Arrays.copyOfRange(nArray, lo, hi);
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                objectArray2 = Arrays.copyOfRange(dArray, lo, hi);
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                objectArray2 = Arrays.copyOfRange(lArray, lo, hi);
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                objectArray2 = Arrays.copyOfRange(fArray, lo, hi);
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                objectArray2 = Arrays.copyOfRange(cArray, lo, hi);
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                objectArray2 = Arrays.copyOfRange(byArray, lo, hi);
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                objectArray2 = Arrays.copyOfRange(sArray, lo, hi);
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                objectArray2 = Arrays.copyOfRange(blArray, lo, hi);
            } else if (object instanceof BoxedUnit[]) {
                BoxedUnit[] res = new BoxedUnit[len];
                Array$.MODULE$.copy($this, lo, res, 0, len);
                objectArray2 = res;
            } else {
                throw new MatchError(object);
            }
            objectArray = objectArray2;
        } else {
            objectArray = this.elemTag$extension($this).newArray(0);
        }
        return objectArray;
    }

    public final <A> Object tail$extension(Object $this) {
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            throw new UnsupportedOperationException("tail of empty array");
        }
        return this.slice$extension($this, 1, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object init$extension(Object $this) {
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            throw new UnsupportedOperationException("init of empty array");
        }
        return this.slice$extension($this, 0, ScalaRunTime$.MODULE$.array_length($this) - 1);
    }

    public final <A> Iterator<Object> tails$extension(Object $this) {
        return this.iterateUntilEmpty$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)xs -> MODULE$.tail$extension(xs));
    }

    public final <A> Iterator<Object> inits$extension(Object $this) {
        return this.iterateUntilEmpty$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)xs -> MODULE$.init$extension(xs));
    }

    public final <A> Iterator<Object> iterateUntilEmpty$extension(Object $this, Function1<Object, Object> f) {
        return Iterator$.MODULE$.iterate($this, f).takeWhile((Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$iterateUntilEmpty$1(x))).$plus$plus((Function0<Iterator> & java.io.Serializable & Serializable)() -> Iterator$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{Array$.MODULE$.empty(MODULE$.elemTag$extension($this))})));
    }

    public final <A> Object take$extension(Object $this, int n) {
        return this.slice$extension($this, 0, package$.MODULE$.min(n, ScalaRunTime$.MODULE$.array_length($this)));
    }

    public final <A> Object drop$extension(Object $this, int n) {
        return this.slice$extension($this, package$.MODULE$.min(n, ScalaRunTime$.MODULE$.array_length($this)), ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object takeRight$extension(Object $this, int n) {
        return this.drop$extension($this, ScalaRunTime$.MODULE$.array_length($this) - package$.MODULE$.max(n, 0));
    }

    public final <A> Object dropRight$extension(Object $this, int n) {
        return this.take$extension($this, ScalaRunTime$.MODULE$.array_length($this) - package$.MODULE$.max(n, 0));
    }

    public final <A> Object takeWhile$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$takeWhile$1(p, x)), this.indexWhere$default$2$extension($this));
        int hi = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return this.slice$extension($this, 0, hi);
    }

    public final <A> Object dropWhile$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$dropWhile$1(p, x)), this.indexWhere$default$2$extension($this));
        int lo = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return this.slice$extension($this, lo, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Iterator<A> iterator$extension(Object $this) {
        return new ArrayOps.ArrayIterator($this);
    }

    public final <A> Iterator<Object> grouped$extension(Object $this, int size) {
        return new ArrayOps.GroupedIterator($this, size);
    }

    public final <A> Tuple2<Object, Object> span$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$span$1(p, x)), this.indexWhere$default$2$extension($this));
        int idx = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return new Tuple2<Object, Object>(this.slice$extension($this, 0, idx), this.slice$extension($this, idx, ScalaRunTime$.MODULE$.array_length($this)));
    }

    public final <A> Tuple2<Object, Object> splitAt$extension(Object $this, int n) {
        return new Tuple2<Object, Object>(this.take$extension($this, n), this.drop$extension($this, n));
    }

    public final <A> Tuple2<Object, Object> partition$extension(Object $this, Function1<A, Object> p) {
        ArrayBuilder<A> res1 = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        ArrayBuilder<A> res2 = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object x = ScalaRunTime$.MODULE$.array_apply($this, i);
            (BoxesRunTime.unboxToBoolean(p.apply(x)) ? res1 : res2).$plus$eq((A)x);
        }
        return new Tuple2<Object, Object>(res1.result(), res2.result());
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Object reverse$extension(Object $this) {
        void var3_3;
        int len = ScalaRunTime$.MODULE$.array_length($this);
        Object res = this.elemTag$extension($this).newArray(len);
        for (int i = 0; i < len; ++i) {
            ScalaRunTime$.MODULE$.array_update(res, len - i - 1, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        return var3_3;
    }

    public final <A> Iterator<A> reverseIterator$extension(Object $this) {
        return new ArrayOps.ReverseIterator($this);
    }

    public final <A> Object filter$extension(Object $this, Function1<A, Object> p) {
        ArrayBuilder<A> res = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object x = ScalaRunTime$.MODULE$.array_apply($this, i);
            Object object = BoxesRunTime.unboxToBoolean(p.apply(x)) ? res.$plus$eq((A)x) : BoxedUnit.UNIT;
        }
        return res.result();
    }

    public final <A> Object filterNot$extension(Object $this, Function1<A, Object> p) {
        return this.filter$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$filterNot$1(p, x)));
    }

    public final <B, A> Object sorted$extension(Object $this, Ordering<B> ord) {
        Object object;
        int len = ScalaRunTime$.MODULE$.array_length($this);
        if ($this.getClass().getComponentType().isPrimitive() && len > 1) {
            int i;
            Object[] a = new Object[len];
            for (i = 0; i < len; ++i) {
                a[i] = ScalaRunTime$.MODULE$.array_apply($this, i);
            }
            Arrays.sort(a, ord);
            Object res = this.elemTag$extension($this).newArray(len);
            for (i = 0; i < len; ++i) {
                ScalaRunTime$.MODULE$.array_update(res, i, a[i]);
            }
            object = res;
        } else {
            Object copy = this.slice$extension($this, 0, len);
            if (len > 1) {
                Arrays.sort((Object[])copy, ord);
            }
            object = copy;
        }
        return object;
    }

    public final <A> Object sortWith$extension(Object $this, Function2<A, A, Object> lt) {
        return this.sorted$extension($this, Ordering$.MODULE$.fromLessThan(lt));
    }

    public final <B, A> Object sortBy$extension(Object $this, Function1<A, B> f, Ordering<B> ord) {
        return this.sorted$extension($this, ord.on(f));
    }

    public final <A> ArrayOps.WithFilter<A> withFilter$extension(Object $this, Function1<A, Object> p) {
        return new ArrayOps.WithFilter<A>(p, $this);
    }

    public final <B, A> int indexOf$extension(Object $this, B elem, int from) {
        for (int i = from; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (!BoxesRunTime.equals(elem, ScalaRunTime$.MODULE$.array_apply($this, i))) continue;
            return i;
        }
        return -1;
    }

    public final <B, A> int indexOf$default$2$extension(Object $this) {
        return 0;
    }

    public final <A> int indexWhere$extension(Object $this, Function1<A, Object> f, int from) {
        for (int i = from; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (!BoxesRunTime.unboxToBoolean(f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int indexWhere$default$2$extension(Object $this) {
        return 0;
    }

    public final <B, A> int lastIndexOf$extension(Object $this, B elem, int end) {
        for (int i = package$.MODULE$.min(end, ScalaRunTime$.MODULE$.array_length($this) - 1); i >= 0; --i) {
            if (!BoxesRunTime.equals(elem, ScalaRunTime$.MODULE$.array_apply($this, i))) continue;
            return i;
        }
        return -1;
    }

    public final <B, A> int lastIndexOf$default$2$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) - 1;
    }

    public final <A> int lastIndexWhere$extension(Object $this, Function1<A, Object> p, int end) {
        for (int i = package$.MODULE$.min(end, ScalaRunTime$.MODULE$.array_length($this) - 1); i >= 0; --i) {
            if (!BoxesRunTime.unboxToBoolean(p.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int lastIndexWhere$default$2$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) - 1;
    }

    public final <A> Option<A> find$extension(Object $this, Function1<A, Object> f) {
        int idx = this.indexWhere$extension($this, f, this.indexWhere$default$2$extension($this));
        return idx == -1 ? None$.MODULE$ : new Some<Object>(ScalaRunTime$.MODULE$.array_apply($this, idx));
    }

    public final <A> boolean exists$extension(Object $this, Function1<A, Object> f) {
        return this.indexWhere$extension($this, f, this.indexWhere$default$2$extension($this)) >= 0;
    }

    public final <A> boolean forall$extension(Object $this, Function1<A, Object> f) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (BoxesRunTime.unboxToBoolean(f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return false;
        }
        return true;
    }

    public final <B, A> B foldLeft$extension(Object $this, B z, Function2<B, A, B> op) {
        Object object;
        Object object2 = $this;
        if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = ArrayOps$.f$2(objectArray, op, z);
        } else if (object2 instanceof int[]) {
            int[] nArray = (int[])object2;
            object = ArrayOps$.f$mIc$sp$1(nArray, op, z);
        } else if (object2 instanceof double[]) {
            double[] dArray = (double[])object2;
            object = ArrayOps$.f$mDc$sp$1(dArray, op, z);
        } else if (object2 instanceof long[]) {
            long[] lArray = (long[])object2;
            object = ArrayOps$.f$mJc$sp$1(lArray, op, z);
        } else if (object2 instanceof float[]) {
            float[] fArray = (float[])object2;
            object = ArrayOps$.f$mFc$sp$1(fArray, op, z);
        } else if (object2 instanceof char[]) {
            char[] cArray = (char[])object2;
            object = ArrayOps$.f$mCc$sp$1(cArray, op, z);
        } else if (object2 instanceof byte[]) {
            byte[] byArray = (byte[])object2;
            object = ArrayOps$.f$mBc$sp$1(byArray, op, z);
        } else if (object2 instanceof short[]) {
            short[] sArray = (short[])object2;
            object = ArrayOps$.f$mSc$sp$1(sArray, op, z);
        } else if (object2 instanceof boolean[]) {
            boolean[] blArray = (boolean[])object2;
            object = ArrayOps$.f$mZc$sp$1(blArray, op, z);
        } else if (object2 instanceof BoxedUnit[]) {
            BoxedUnit[] boxedUnitArray = (BoxedUnit[])object2;
            object = ArrayOps$.f$mVc$sp$1(boxedUnitArray, op, z);
        } else {
            if (object2 == null) {
                throw new NullPointerException();
            }
            throw new MatchError(object2);
        }
        return (B)object;
    }

    public final <B, A> Object scanLeft$extension(Object $this, B z, Function2<B, A, B> op, ClassTag<B> evidence$3) {
        int i;
        B v = z;
        Object res = evidence$3.newArray(ScalaRunTime$.MODULE$.array_length($this) + 1);
        for (i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update(res, i, v);
            v = op.apply(v, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        ScalaRunTime$.MODULE$.array_update(res, i, v);
        return res;
    }

    public final <B, A> Object scan$extension(Object $this, B z, Function2<B, B, B> op, ClassTag<B> evidence$4) {
        return this.scanLeft$extension($this, z, op, evidence$4);
    }

    public final <B, A> Object scanRight$extension(Object $this, B z, Function2<A, B, B> op, ClassTag<B> evidence$5) {
        B v = z;
        Object res = evidence$5.newArray(ScalaRunTime$.MODULE$.array_length($this) + 1);
        ScalaRunTime$.MODULE$.array_update(res, ScalaRunTime$.MODULE$.array_length($this), z);
        for (int i = ScalaRunTime$.MODULE$.array_length($this) - 1; i >= 0; --i) {
            v = op.apply(ScalaRunTime$.MODULE$.array_apply($this, i), v);
            ScalaRunTime$.MODULE$.array_update(res, i, v);
        }
        return res;
    }

    public final <B, A> B foldRight$extension(Object $this, B z, Function2<A, B, B> op) {
        Object object;
        Object object2 = $this;
        if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = ArrayOps$.f$3(objectArray, op, z);
        } else if (object2 instanceof int[]) {
            int[] nArray = (int[])object2;
            object = ArrayOps$.f$mIc$sp$2(nArray, op, z);
        } else if (object2 instanceof double[]) {
            double[] dArray = (double[])object2;
            object = ArrayOps$.f$mDc$sp$2(dArray, op, z);
        } else if (object2 instanceof long[]) {
            long[] lArray = (long[])object2;
            object = ArrayOps$.f$mJc$sp$2(lArray, op, z);
        } else if (object2 instanceof float[]) {
            float[] fArray = (float[])object2;
            object = ArrayOps$.f$mFc$sp$2(fArray, op, z);
        } else if (object2 instanceof char[]) {
            char[] cArray = (char[])object2;
            object = ArrayOps$.f$mCc$sp$2(cArray, op, z);
        } else if (object2 instanceof byte[]) {
            byte[] byArray = (byte[])object2;
            object = ArrayOps$.f$mBc$sp$2(byArray, op, z);
        } else if (object2 instanceof short[]) {
            short[] sArray = (short[])object2;
            object = ArrayOps$.f$mSc$sp$2(sArray, op, z);
        } else if (object2 instanceof boolean[]) {
            boolean[] blArray = (boolean[])object2;
            object = ArrayOps$.f$mZc$sp$2(blArray, op, z);
        } else if (object2 instanceof BoxedUnit[]) {
            BoxedUnit[] boxedUnitArray = (BoxedUnit[])object2;
            object = ArrayOps$.f$mVc$sp$2(boxedUnitArray, op, z);
        } else {
            if (object2 == null) {
                throw new NullPointerException();
            }
            throw new MatchError(object2);
        }
        return (B)object;
    }

    public final <A1, A> A1 fold$extension(Object $this, A1 z, Function2<A1, A1, A1> op) {
        Object object;
        Object object2 = $this;
        if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = ArrayOps$.f$4(objectArray, op, z);
        } else if (object2 instanceof int[]) {
            int[] nArray = (int[])object2;
            object = ArrayOps$.f$mIc$sp$3(nArray, op, z);
        } else if (object2 instanceof double[]) {
            double[] dArray = (double[])object2;
            object = ArrayOps$.f$mDc$sp$3(dArray, op, z);
        } else if (object2 instanceof long[]) {
            long[] lArray = (long[])object2;
            object = ArrayOps$.f$mJc$sp$3(lArray, op, z);
        } else if (object2 instanceof float[]) {
            float[] fArray = (float[])object2;
            object = ArrayOps$.f$mFc$sp$3(fArray, op, z);
        } else if (object2 instanceof char[]) {
            char[] cArray = (char[])object2;
            object = ArrayOps$.f$mCc$sp$3(cArray, op, z);
        } else if (object2 instanceof byte[]) {
            byte[] byArray = (byte[])object2;
            object = ArrayOps$.f$mBc$sp$3(byArray, op, z);
        } else if (object2 instanceof short[]) {
            short[] sArray = (short[])object2;
            object = ArrayOps$.f$mSc$sp$3(sArray, op, z);
        } else if (object2 instanceof boolean[]) {
            boolean[] blArray = (boolean[])object2;
            object = ArrayOps$.f$mZc$sp$3(blArray, op, z);
        } else if (object2 instanceof BoxedUnit[]) {
            BoxedUnit[] boxedUnitArray = (BoxedUnit[])object2;
            object = ArrayOps$.f$mVc$sp$3(boxedUnitArray, op, z);
        } else {
            if (object2 == null) {
                throw new NullPointerException();
            }
            throw new MatchError(object2);
        }
        return (A1)object;
    }

    public final <B, A> Object map$extension(Object $this, Function1<A, B> f, ClassTag<B> evidence$6) {
        Object res = evidence$6.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update(res, i, f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return res;
    }

    public final <A> Object mapInPlace$extension(Object $this, Function1<A, A> f) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update($this, i, f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return $this;
    }

    public final <B, A> Object flatMap$extension0(Object $this, Function1<A, IterableOnce<B>> f, ClassTag<B> evidence$7) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$7);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            b.$plus$plus$eq(f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return b.result();
    }

    public final <BS, B, A> Object flatMap$extension1(Object $this, Function1<A, BS> f, Function1<BS, Iterable<B>> asIterable, ClassTag<B> m) {
        return this.flatMap$extension0($this, (Function1<Object, Iterable> & java.io.Serializable & Serializable)x -> (Iterable)asIterable.apply(f.apply(x)), m);
    }

    public final <B, A> Object flatten$extension(Object $this, Function1<A, Iterable<B>> asIterable, ClassTag<B> m) {
        ArrayBuilder b = ArrayBuilder$.MODULE$.make(m);
        int[] sizes = (int[])this.map$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToInteger(ArrayOps$.$anonfun$flatten$1(x0$1)), ClassTag$.MODULE$.Int());
        b.sizeHint(BoxesRunTime.unboxToInt(this.fold$extension(sizes, BoxesRunTime.boxToInteger(0), (JFunction2$mcIII$sp & Serializable)(x$1, x$2) -> x$1 + x$2)));
        this.foreach$extension($this, (Function1<Object, ArrayBuilder> & java.io.Serializable & Serializable)xs -> (ArrayBuilder)b.$plus$plus$eq((IterableOnce)asIterable.apply(xs)));
        return b.result();
    }

    public final <B, A> Object collect$extension(Object $this, PartialFunction<A, B> f, ClassTag<B> evidence$8) {
        BooleanRef matched = BooleanRef.create(true);
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$8);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            matched.elem = true;
            Object v = f.applyOrElse(ScalaRunTime$.MODULE$.array_apply($this, i), (Function1<Object, Object> & java.io.Serializable & Serializable)x -> ArrayOps$.d$1(x, matched));
            Object object = matched.elem ? b.$plus$eq((B)v) : BoxedUnit.UNIT;
        }
        return b.result();
    }

    public final <B, A> Option<B> collectFirst$extension(Object $this, PartialFunction<A, B> f, ClassTag<B> evidence$9) {
        BooleanRef matched = BooleanRef.create(true);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            matched.elem = true;
            Object v = f.applyOrElse(ScalaRunTime$.MODULE$.array_apply($this, i), (Function1<Object, Object> & java.io.Serializable & Serializable)x -> ArrayOps$.d$2(x, matched));
            if (!matched.elem) continue;
            return new Some(v);
        }
        return None$.MODULE$;
    }

    public final <B, A> Tuple2<A, B>[] zip$extension(Object $this, Iterable<B> that) {
        ArrayBuilder.ofRef b = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(Tuple2.class));
        int k = that.knownSize();
        b.sizeHint(k >= 0 ? package$.MODULE$.min(k, ScalaRunTime$.MODULE$.array_length($this)) : ScalaRunTime$.MODULE$.array_length($this));
        Iterator it = that.iterator();
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this) && it.hasNext(); ++i) {
            b.$plus$eq(new Tuple2(ScalaRunTime$.MODULE$.array_apply($this, i), it.next()));
        }
        return (Tuple2[])b.result();
    }

    public final <A1, B, A> Tuple2<A1, B>[] zipAll$extension(Object $this, Iterable<B> that, A1 thisElem, B thatElem) {
        int i;
        ArrayBuilder.ofRef<Tuple2<Object, Object>> b = new ArrayBuilder.ofRef<Tuple2<Object, Object>>(ClassTag$.MODULE$.apply(Tuple2.class));
        int k = that.knownSize();
        b.sizeHint(k >= 0 ? package$.MODULE$.max(k, ScalaRunTime$.MODULE$.array_length($this)) : ScalaRunTime$.MODULE$.array_length($this));
        Iterator it = that.iterator();
        for (i = 0; i < ScalaRunTime$.MODULE$.array_length($this) && it.hasNext(); ++i) {
            b.$plus$eq(new Tuple2(ScalaRunTime$.MODULE$.array_apply($this, i), it.next()));
        }
        while (it.hasNext()) {
            b.$plus$eq(new Tuple2(thisElem, it.next()));
            ++i;
        }
        while (i < ScalaRunTime$.MODULE$.array_length($this)) {
            b.$plus$eq(new Tuple2<Object, B>(ScalaRunTime$.MODULE$.array_apply($this, i), thatElem));
            ++i;
        }
        return (Tuple2[])b.result();
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Tuple2<A, Object>[] zipWithIndex$extension(Object $this) {
        void var2_2;
        Tuple2[] b = new Tuple2[ScalaRunTime$.MODULE$.array_length($this)];
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            b[i] = new Tuple2<Object, Integer>(ScalaRunTime$.MODULE$.array_apply($this, i), BoxesRunTime.boxToInteger(i));
        }
        return var2_2;
    }

    public final <B, A> Object appended$extension(Object $this, B x, ClassTag<B> evidence$10) {
        Object dest = Array$.MODULE$.copyAs($this, ScalaRunTime$.MODULE$.array_length($this) + 1, evidence$10);
        ScalaRunTime$.MODULE$.array_update(dest, ScalaRunTime$.MODULE$.array_length($this), x);
        return dest;
    }

    public final <B, A> Object $colon$plus$extension(Object $this, B x, ClassTag<B> evidence$11) {
        return this.appended$extension($this, x, evidence$11);
    }

    public final <B, A> Object prepended$extension(Object $this, B x, ClassTag<B> evidence$12) {
        Object dest = evidence$12.newArray(ScalaRunTime$.MODULE$.array_length($this) + 1);
        ScalaRunTime$.MODULE$.array_update(dest, 0, x);
        Array$.MODULE$.copy($this, 0, dest, 1, ScalaRunTime$.MODULE$.array_length($this));
        return dest;
    }

    public final <B, A> Object $plus$colon$extension(Object $this, B x, ClassTag<B> evidence$13) {
        return this.prepended$extension($this, x, evidence$13);
    }

    public final <B, A> Object prependedAll$extension0(Object $this, Iterable<B> prefix, ClassTag<B> evidence$14) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$14);
        int k = prefix.knownSize();
        if (k >= 0) {
            b.sizeHint(k + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll((IterableOnce)prefix);
        if (k < 0) {
            b.sizeHint(b.length() + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll($this);
        return b.result();
    }

    public final <B, A> Object prependedAll$extension1(Object $this, Object prefix, ClassTag<B> evidence$15) {
        Object dest = Array$.MODULE$.copyAs(prefix, ScalaRunTime$.MODULE$.array_length(prefix) + ScalaRunTime$.MODULE$.array_length($this), evidence$15);
        Array$.MODULE$.copy($this, 0, dest, ScalaRunTime$.MODULE$.array_length(prefix), ScalaRunTime$.MODULE$.array_length($this));
        return dest;
    }

    public final <B, A> Object $plus$plus$colon$extension0(Object $this, Iterable<B> prefix, ClassTag<B> evidence$16) {
        return this.prependedAll$extension0($this, prefix, evidence$16);
    }

    public final <B, A> Object $plus$plus$colon$extension1(Object $this, Object prefix, ClassTag<B> evidence$17) {
        return this.prependedAll$extension1($this, prefix, evidence$17);
    }

    public final <B, A> Object appendedAll$extension0(Object $this, Iterable<B> suffix, ClassTag<B> evidence$18) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$18);
        int k = suffix.knownSize();
        if (k >= 0) {
            b.sizeHint(k + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll($this);
        b.addAll((IterableOnce)suffix);
        return b.result();
    }

    public final <B, A> Object appendedAll$extension1(Object $this, Object suffix, ClassTag<B> evidence$19) {
        Object dest = Array$.MODULE$.copyAs($this, ScalaRunTime$.MODULE$.array_length($this) + ScalaRunTime$.MODULE$.array_length(suffix), evidence$19);
        Array$.MODULE$.copy(suffix, 0, dest, ScalaRunTime$.MODULE$.array_length($this), ScalaRunTime$.MODULE$.array_length(suffix));
        return dest;
    }

    public final <B, A> Object $colon$plus$plus$extension0(Object $this, Iterable<B> suffix, ClassTag<B> evidence$20) {
        return this.appendedAll$extension0($this, suffix, evidence$20);
    }

    public final <B, A> Object $colon$plus$plus$extension1(Object $this, Object suffix, ClassTag<B> evidence$21) {
        return this.appendedAll$extension1($this, suffix, evidence$21);
    }

    public final <B, A> Object concat$extension0(Object $this, Iterable<B> suffix, ClassTag<B> evidence$22) {
        return this.appendedAll$extension0($this, suffix, evidence$22);
    }

    public final <B, A> Object concat$extension1(Object $this, Object suffix, ClassTag<B> evidence$23) {
        return this.appendedAll$extension1($this, suffix, evidence$23);
    }

    public final <B, A> Object $plus$plus$extension0(Object $this, Iterable<B> xs, ClassTag<B> evidence$24) {
        return this.appendedAll$extension0($this, xs, evidence$24);
    }

    public final <B, A> Object $plus$plus$extension1(Object $this, Object xs, ClassTag<B> evidence$25) {
        return this.appendedAll$extension1($this, xs, evidence$25);
    }

    public final <A1, A> boolean contains$extension(Object $this, A1 elem) {
        return this.exists$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$contains$1(elem, x$3)));
    }

    public final <B, A> Object patch$extension(Object $this, int from, IterableOnce<B> other, int replaced, ClassTag<B> evidence$26) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$26);
        int k = other.knownSize();
        if (k >= 0) {
            b.sizeHint(ScalaRunTime$.MODULE$.array_length($this) + k - replaced);
        }
        int chunk1 = from > 0 ? package$.MODULE$.min(from, ScalaRunTime$.MODULE$.array_length($this)) : 0;
        java.io.Serializable serializable = chunk1 > 0 ? b.addAll($this, 0, chunk1) : BoxedUnit.UNIT;
        b.$plus$plus$eq(other);
        int remaining = ScalaRunTime$.MODULE$.array_length($this) - chunk1 - replaced;
        java.io.Serializable serializable2 = remaining > 0 ? b.addAll($this, ScalaRunTime$.MODULE$.array_length($this) - remaining, remaining) : BoxedUnit.UNIT;
        return b.result();
    }

    public final <A1, A2, A> Tuple2<Object, Object> unzip$extension(Object $this, Function1<A, Tuple2<A1, A2>> asPair, ClassTag<A1> ct1, ClassTag<A2> ct2) {
        Object a1 = ct1.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a2 = ct2.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Tuple2<A1, A2> e = asPair.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            ScalaRunTime$.MODULE$.array_update(a1, i, e._1());
            ScalaRunTime$.MODULE$.array_update(a2, i, e._2());
        }
        return new Tuple2<Object, Object>(a1, a2);
    }

    public final <A1, A2, A3, A> Tuple3<Object, Object, Object> unzip3$extension(Object $this, Function1<A, Tuple3<A1, A2, A3>> asTriple, ClassTag<A1> ct1, ClassTag<A2> ct2, ClassTag<A3> ct3) {
        Object a1 = ct1.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a2 = ct2.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a3 = ct3.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Tuple3<A1, A2, A3> e = asTriple.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            ScalaRunTime$.MODULE$.array_update(a1, i, e._1());
            ScalaRunTime$.MODULE$.array_update(a2, i, e._2());
            ScalaRunTime$.MODULE$.array_update(a3, i, e._3());
        }
        return new Tuple3<Object, Object, Object>(a1, a2, a3);
    }

    public final <B, A> Object[] transpose$extension(Object $this, Function1<A, Object> asArray) {
        Object[] objectArray;
        Class<?> aClass = $this.getClass().getComponentType();
        ArrayBuilder.ofRef bb = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(aClass));
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            objectArray = bb.result();
        } else {
            ArrayBuilder[] bs = (ArrayBuilder[])this.map$extension(asArray.apply(ScalaRunTime$.MODULE$.array_apply($this, 0)), (Function1<Object, ArrayBuilder> & java.io.Serializable & Serializable)x -> ArrayOps$.mkRowBuilder$1(aClass), ClassTag$.MODULE$.apply(ArrayBuilder.class));
            boolean j = false;
            this.foreach$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)xs -> {
                ArrayOps$.$anonfun$transpose$2(bs, asArray, xs);
                return BoxedUnit.UNIT;
            });
            this.foreach$extension(bs, (Function1<ArrayBuilder, ArrayBuilder.ofRef> & java.io.Serializable & Serializable)b -> (ArrayBuilder.ofRef)bb.$plus$eq(b.result()));
            objectArray = bb.result();
        }
        return objectArray;
    }

    public final <U, A> void foreach$extension(Object $this, Function1<A, U> f) {
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            f.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
        }
    }

    public final <A> Object distinct$extension(Object $this) {
        return this.distinctBy$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    public final <B, A> Object distinctBy$extension(Object $this, Function1<A, B> f) {
        return ArrayBuilder$.MODULE$.make(this.elemTag$extension($this)).addAll((IterableOnce)this.iterator$extension($this).distinctBy(f)).result();
    }

    public final <B, A> Object padTo$extension(Object $this, int len, B elem, ClassTag<B> evidence$27) {
        int i;
        int newlen = package$.MODULE$.max(i, len);
        Object dest = Array$.MODULE$.copyAs($this, newlen, evidence$27);
        for (i = ScalaRunTime$.MODULE$.array_length($this); i < newlen; ++i) {
            ScalaRunTime$.MODULE$.array_update(dest, i, elem);
        }
        return dest;
    }

    public final <A> Range indices$extension(Object $this) {
        return Range$.MODULE$.apply(0, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <K, A> Map<K, Object> groupBy$extension(Object $this, Function1<A, K> f) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            Object elem = ScalaRunTime$.MODULE$.array_apply($this, i);
            K key = f.apply(elem);
            ArrayBuilder bldr = (ArrayBuilder)m.getOrElseUpdate(key, (Function0<ArrayBuilder> & java.io.Serializable & Serializable)() -> ArrayBuilder$.MODULE$.make(MODULE$.elemTag$extension($this)));
            bldr.$plus$eq(elem);
        }
        return m.mapValues((Function1<ArrayBuilder, Object> & java.io.Serializable & Serializable)x$4 -> x$4.result()).toMap(Predef$.MODULE$.$conforms());
    }

    public final <K, B, A> Map<K, Object> groupMap$extension(Object $this, Function1<A, K> key, Function1<A, B> f, ClassTag<B> evidence$28) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            Object elem = ScalaRunTime$.MODULE$.array_apply($this, i);
            K k = key.apply(elem);
            ArrayBuilder bldr = (ArrayBuilder)m.getOrElseUpdate(k, (Function0<ArrayBuilder> & java.io.Serializable & Serializable)() -> ArrayBuilder$.MODULE$.make(evidence$28));
            bldr.$plus$eq(f.apply(elem));
        }
        return m.mapValues((Function1<ArrayBuilder, Object> & java.io.Serializable & Serializable)x$5 -> x$5.result()).toMap(Predef$.MODULE$.$conforms());
    }

    public final <A> scala.collection.immutable.Seq<A> toSeq$extension(Object $this) {
        return this.toIndexedSeq$extension($this);
    }

    public final <A> scala.collection.immutable.IndexedSeq<A> toIndexedSeq$extension(Object $this) {
        return scala.collection.immutable.ArraySeq$.MODULE$.unsafeWrapArray(Array$.MODULE$.copyOf($this, ScalaRunTime$.MODULE$.array_length($this)));
    }

    public final <B, A> Object copyToArray$extension(Object $this, Object dest, int start, int len) {
        Array$.MODULE$.copy($this, 0, dest, start, package$.MODULE$.min(ScalaRunTime$.MODULE$.array_length($this), package$.MODULE$.min(ScalaRunTime$.MODULE$.array_length(dest) - start, len)));
        return dest;
    }

    public final <B, A> int copyToArray$default$3$extension(Object $this) {
        return Integer.MAX_VALUE;
    }

    public final <B, A> Object toArray$extension(Object $this, ClassTag<B> evidence$29) {
        return this.copyToArray$extension($this, evidence$29.newArray(ScalaRunTime$.MODULE$.array_length($this)), 0, this.copyToArray$default$3$extension($this));
    }

    public final <A> int count$extension(Object $this, Function1<A, Object> p) {
        int res = 0;
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            if (!BoxesRunTime.unboxToBoolean(p.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            ++res;
        }
        return res;
    }

    public final <B, A> boolean startsWith$extension0(Object $this, Object that) {
        return this.startsWith$extension1($this, that, 0);
    }

    public final <B, A> boolean startsWith$extension1(Object $this, Object that, int offset) {
        boolean bl;
        int thatl = ScalaRunTime$.MODULE$.array_length(that);
        if (thatl > ScalaRunTime$.MODULE$.array_length($this) - offset) {
            bl = false;
        } else {
            for (int i = 0; i < thatl; ++i) {
                if (BoxesRunTime.equals(ScalaRunTime$.MODULE$.array_apply($this, i + offset), ScalaRunTime$.MODULE$.array_apply(that, i))) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public final <B, A> boolean endsWith$extension0(Object $this, Object that) {
        boolean bl;
        int thatl = ScalaRunTime$.MODULE$.array_length(that);
        int off = ScalaRunTime$.MODULE$.array_length($this) - thatl;
        if (off < 0) {
            bl = false;
        } else {
            for (int i = 0; i < thatl; ++i) {
                if (BoxesRunTime.equals(ScalaRunTime$.MODULE$.array_apply($this, i + off), ScalaRunTime$.MODULE$.array_apply(that, i))) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public final <B, A> Object updated$extension(Object $this, int index, B elem, ClassTag<B> evidence$30) {
        if (index < 0 || index >= ScalaRunTime$.MODULE$.array_length($this)) {
            throw new IndexOutOfBoundsException();
        }
        Object dest = this.toArray$extension($this, evidence$30);
        ScalaRunTime$.MODULE$.array_update(dest, index, elem);
        return dest;
    }

    public final <A> IndexedSeqView<A> view$extension(Object $this) {
        return new ArrayOps.ArrayView($this);
    }

    public final <A> Object diff$extension(Object $this, Seq<? super A> that) {
        return ((ArraySeq)ArraySeq$.MODULE$.make($this).diff((Seq)that)).array();
    }

    public final <A> Object intersect$extension(Object $this, Seq<? super A> that) {
        return ((ArraySeq)ArraySeq$.MODULE$.make($this).intersect((Seq)that)).array();
    }

    public final <A> Iterator<Object> sliding$extension(Object $this, int size, int step) {
        return ArraySeq$.MODULE$.make($this).sliding(size, step).map((Function1<ArraySeq, Object> & java.io.Serializable & Serializable)x$6 -> x$6.array());
    }

    public final <A> int sliding$default$2$extension(Object $this) {
        return 1;
    }

    public final <A> Iterator<Object> combinations$extension(Object $this, int n) {
        return ArraySeq$.MODULE$.make($this).combinations(n).map((Function1<ArraySeq, Object> & java.io.Serializable & Serializable)x$7 -> x$7.array());
    }

    public final <A> Iterator<Object> permutations$extension(Object $this) {
        return ArraySeq$.MODULE$.make($this).permutations().map((Function1<ArraySeq, Object> & java.io.Serializable & Serializable)x$8 -> x$8.array());
    }

    public final <B, A> boolean startsWith$extension2(Object $this, IterableOnce<B> that, int offset) {
        return ArraySeq$.MODULE$.make($this).startsWith(that, offset);
    }

    public final <B, A> int startsWith$default$2$extension(Object $this) {
        return 0;
    }

    public final <B, A> boolean endsWith$extension1(Object $this, Iterable<B> that) {
        return ArraySeq$.MODULE$.make($this).endsWith(that);
    }

    public final <A> int hashCode$extension(Object $this) {
        return $this.hashCode();
    }

    public final <A> boolean equals$extension(Object $this, Object x$1) {
        Object object;
        Object object2 = x$1;
        boolean bl = object2 instanceof ArrayOps;
        return bl && BoxesRunTime.equals($this, object = x$1 == null ? null : ((ArrayOps)x$1).xs());
    }

    public static final /* synthetic */ boolean $anonfun$iterateUntilEmpty$1(Object x) {
        return ScalaRunTime$.MODULE$.array_length(x) != 0;
    }

    public static final /* synthetic */ boolean $anonfun$takeWhile$1(Function1 p$1, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$1.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$dropWhile$1(Function1 p$2, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$2.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$span$1(Function1 p$3, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$3.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$filterNot$1(Function1 p$4, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$4.apply(x));
    }

    private static final Object f$mZc$sp$1(boolean[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToBoolean(xs[i]));
        }
        return v;
    }

    private static final Object f$mBc$sp$1(byte[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToByte(xs[i]));
        }
        return v;
    }

    private static final Object f$mCc$sp$1(char[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToCharacter(xs[i]));
        }
        return v;
    }

    private static final Object f$mDc$sp$1(double[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToDouble(xs[i]));
        }
        return v;
    }

    private static final Object f$mFc$sp$1(float[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToFloat(xs[i]));
        }
        return v;
    }

    private static final Object f$mIc$sp$1(int[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToInteger(xs[i]));
        }
        return v;
    }

    private static final Object f$mJc$sp$1(long[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToLong(xs[i]));
        }
        return v;
    }

    private static final Object f$mSc$sp$1(short[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToShort(xs[i]));
        }
        return v;
    }

    private static final Object f$mVc$sp$1(BoxedUnit[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, xs[i]);
        }
        return v;
    }

    private static final Object f$2(Object xs, Function2 op, Object z) {
        int length = ScalaRunTime$.MODULE$.array_length(xs);
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, ScalaRunTime$.MODULE$.array_apply(xs, i));
        }
        return v;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mZc$sp$2(boolean[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToBoolean(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mBc$sp$2(byte[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToByte(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mCc$sp$2(char[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToCharacter(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mDc$sp$2(double[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToDouble(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mFc$sp$2(float[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToFloat(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mIc$sp$2(int[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToInteger(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mJc$sp$2(long[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToLong(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mSc$sp$2(short[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToShort(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mVc$sp$2(BoxedUnit[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(xs[i], v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$3(Object xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = ScalaRunTime$.MODULE$.array_length(xs) - 1; i >= 0; --i) {
            v = op.apply(ScalaRunTime$.MODULE$.array_apply(xs, i), v);
        }
        return var3_3;
    }

    private static final Object f$mZc$sp$3(boolean[] xs, Function2 op, Object z) {
        Object object;
        int length = xs.length - 1;
        if (length >= 0) {
            Boolean v = BoxesRunTime.boxToBoolean(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToBoolean(xs[i]));
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    private static final Object f$mBc$sp$3(byte[] xs, Function2 op, Object z) {
        Object object;
        int length = xs.length - 1;
        if (length >= 0) {
            Byte v = BoxesRunTime.boxToByte(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToByte(xs[i]));
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    private static final Object f$mCc$sp$3(char[] xs, Function2 op, Object z) {
        Object object;
        int length = xs.length - 1;
        if (length >= 0) {
            Character v = BoxesRunTime.boxToCharacter(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToCharacter(xs[i]));
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    private static final Object f$mDc$sp$3(double[] xs, Function2 op, Object z) {
        Object object;
        int length = xs.length - 1;
        if (length >= 0) {
            Double v = BoxesRunTime.boxToDouble(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToDouble(xs[i]));
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    private static final Object f$mFc$sp$3(float[] xs, Function2 op, Object z) {
        Object object;
        int length = xs.length - 1;
        if (length >= 0) {
            Float v = BoxesRunTime.boxToFloat(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToFloat(xs[i]));
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    private static final Object f$mIc$sp$3(int[] xs, Function2 op, Object z) {
        Object object;
        int length = xs.length - 1;
        if (length >= 0) {
            Integer v = BoxesRunTime.boxToInteger(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToInteger(xs[i]));
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    private static final Object f$mJc$sp$3(long[] xs, Function2 op, Object z) {
        Object object;
        int length = xs.length - 1;
        if (length >= 0) {
            Long v = BoxesRunTime.boxToLong(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToLong(xs[i]));
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    private static final Object f$mSc$sp$3(short[] xs, Function2 op, Object z) {
        Object object;
        int length = xs.length - 1;
        if (length >= 0) {
            Short v = BoxesRunTime.boxToShort(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToShort(xs[i]));
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    private static final Object f$mVc$sp$3(BoxedUnit[] xs, Function2 op, Object z) {
        Object object;
        int length = xs.length - 1;
        if (length >= 0) {
            BoxedUnit v = xs[length];
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, xs[i]);
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    private static final Object f$4(Object xs, Function2 op, Object z) {
        Object object;
        int length = ScalaRunTime$.MODULE$.array_length(xs) - 1;
        if (length >= 0) {
            Object v = ScalaRunTime$.MODULE$.array_apply(xs, length);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, ScalaRunTime$.MODULE$.array_apply(xs, i));
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    public static final /* synthetic */ int $anonfun$flatten$1(Object x0$1) {
        int n;
        Object object = x0$1;
        if (object instanceof IndexedSeq) {
            Object object2 = object;
            n = ((SeqOps)object2).size();
        } else {
            n = 0;
        }
        return n;
    }

    private static final Object d$1(Object x, BooleanRef matched$1) {
        matched$1.elem = false;
        return null;
    }

    private static final Object d$2(Object x, BooleanRef matched$2) {
        matched$2.elem = false;
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$contains$1(Object elem$1, Object x$3) {
        return BoxesRunTime.equals(x$3, elem$1);
    }

    private static final ArrayBuilder mkRowBuilder$1(Class aClass$1) {
        return ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(aClass$1.getComponentType()));
    }

    public static final /* synthetic */ void $anonfun$transpose$3(ArrayBuilder[] bs$1, IntRef i$1, Object x) {
        bs$1[i$1.elem].$plus$eq(x);
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$transpose$2(ArrayBuilder[] bs$1, Function1 asArray$1, Object xs) {
        IntRef i = IntRef.create(0);
        MODULE$.foreach$extension(asArray$1.apply(xs), (Function1<Object, Object> & java.io.Serializable & Serializable)x -> {
            ArrayOps$.$anonfun$transpose$3(bs$1, i, x);
            return BoxedUnit.UNIT;
        });
    }

    private ArrayOps$() {
        MODULE$ = this;
    }
}

