/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.RedBlackTree;
import scala.collection.immutable.RedBlackTree$BlackTree$;
import scala.collection.immutable.RedBlackTree$NList$;
import scala.collection.immutable.RedBlackTree$RedTree$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$;

    static {
        new RedBlackTree$();
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$1) {
        return this.lookup(tree, x, evidence$1) != null;
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$2) {
        RedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x, evidence$2);
        Option option = tree2 == null ? None$.MODULE$ : new Some<B>(tree2.value());
        return option;
    }

    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        block3: {
            while (true) {
                if (tree == null) {
                    tree2 = null;
                    break block3;
                }
                int cmp = ordering.compare(x, tree.key());
                if (cmp < 0) {
                    tree = tree.left();
                    continue;
                }
                if (cmp <= 0) break;
                tree = tree.right();
            }
            tree2 = tree;
        }
        return tree2;
    }

    public int count(RedBlackTree.Tree<?, ?> tree) {
        return tree == null ? 0 : tree.count();
    }

    public <A> int countInRange(RedBlackTree.Tree<A, ?> tree, Option<A> from2, Option<A> to2, Ordering<A> ordering) {
        int n;
        block6: {
            int n2;
            block7: {
                while (true) {
                    Option<A> option;
                    Option<A> option2;
                    if (tree == null) {
                        n = 0;
                        break block6;
                    }
                    Tuple2<Option<A>, Option<A>> tuple2 = new Tuple2<Option<A>, Option<A>>(from2, to2);
                    if (tuple2 != null) {
                        Option<A> option3 = tuple2._1();
                        Option<A> option4 = tuple2._2();
                        if (None$.MODULE$.equals(option3) && None$.MODULE$.equals(option4)) {
                            n2 = tree.count();
                            break block7;
                        }
                    }
                    if (tuple2 != null && (option2 = tuple2._1()) instanceof Some) {
                        Some some = (Some)option2;
                        Object lb = some.x();
                        if (ordering.lt(tree.key(), lb)) {
                            tree = tree.right();
                            continue;
                        }
                    }
                    if (tuple2 == null || !((option = tuple2._2()) instanceof Some)) break;
                    Some some = (Some)option;
                    Object ub = some.x();
                    if (!ordering.gteq(tree.key(), ub)) break;
                    tree = tree.left();
                }
                n2 = 1 + this.countInRange(tree.left(), from2, None$.MODULE$, ordering) + this.countInRange(tree.right(), None$.MODULE$, to2, ordering);
            }
            n = n2;
        }
        return n;
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$3) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$3));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$4) {
        return this.blacken(this.del(tree, k, evidence$4));
    }

    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree, Option<A> from2, Option<A> until2, Ordering<A> evidence$5) {
        Tuple2<Option<A>, Option<A>> tuple2;
        block6: {
            RedBlackTree.Tree<A, B> tree2;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            tuple2 = new Tuple2<Option<A>, Option<A>>(from2, until2);
                            if (tuple2 == null) break block2;
                            Option<A> option = tuple2._1();
                            Option<A> option2 = tuple2._2();
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Object from3 = some.x();
                            if (!(option2 instanceof Some)) break block2;
                            Some some2 = (Some)option2;
                            Object until3 = some2.x();
                            tree2 = this.range(tree, from3, until3, evidence$5);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Option<A> option = tuple2._1();
                        Option<A> option3 = tuple2._2();
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        Object from4 = some.x();
                        if (!None$.MODULE$.equals(option3)) break block4;
                        tree2 = this.from(tree, from4, evidence$5);
                        break block3;
                    }
                    if (tuple2 == null) break block5;
                    Option<A> option = tuple2._1();
                    Option<A> option4 = tuple2._2();
                    if (!None$.MODULE$.equals(option) || !(option4 instanceof Some)) break block5;
                    Some some = (Some)option4;
                    Object until4 = some.x();
                    tree2 = this.until(tree, until4, evidence$5);
                    break block3;
                }
                if (tuple2 == null) break block6;
                Option<A> option = tuple2._1();
                Option<A> option5 = tuple2._2();
                if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option5)) break block6;
                tree2 = tree;
            }
            return tree2;
        }
        throw new MatchError(tuple2);
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree, A from2, A until2, Ordering<A> evidence$6) {
        return this.blacken(this.doRange(tree, from2, until2, evidence$6));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree, A from2, Ordering<A> evidence$7) {
        return this.blacken(this.doFrom(tree, from2, evidence$7));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree, A to2, Ordering<A> evidence$8) {
        return this.blacken(this.doTo(tree, to2, evidence$8));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$9) {
        return this.blacken(this.doUntil(tree, key, evidence$9));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$10) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$11) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree, int from2, int until2, Ordering<A> evidence$12) {
        return this.blacken(this.doSlice(tree, from2, until2));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result2 = tree;
        while (result2.left() != null) {
            result2 = result2.left();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result2 = tree;
        while (result2.right() != null) {
            result2 = result2.right();
        }
        return var2_2;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        if (tree != null) {
            this._foreach(tree, f);
        }
    }

    private <A, B, U> void _foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreach(tree.left(), f);
            }
            f.apply(new Tuple2<A, B>(tree.key(), tree.value()));
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        if (tree != null) {
            this._foreachKey(tree, f);
        }
    }

    private <A, U> void _foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreachKey(tree.left(), f);
            }
            f.apply(tree.key());
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$13) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, evidence$13);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$14) {
        return new RedBlackTree.KeysIterator(tree, start, evidence$14);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$15) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, evidence$15);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            int count2;
            if (n < (count2 = this.count(tree.left()))) {
                tree = tree.left();
                continue;
            }
            if (n <= count2) break;
            n = n - count2 - 1;
            tree = tree.right();
        }
        return tree;
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree) {
        return tree == null || this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree);
    }

    private boolean isRedTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.RedTree;
    }

    public boolean scala$collection$immutable$RedBlackTree$$isBlackTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.BlackTree;
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        return t == null ? null : t.black();
    }

    private <A, B> RedBlackTree.Tree<A, B> mkTree(boolean isBlack, A k, B v, RedBlackTree.Tree<A, B> l, RedBlackTree.Tree<A, B> r) {
        return isBlack ? RedBlackTree$BlackTree$.MODULE$.apply(k, v, l, r) : RedBlackTree$RedTree$.MODULE$.apply(k, v, l, r);
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> scala$collection$immutable$RedBlackTree$$balanceLeft(boolean isBlack, A z, B zv, RedBlackTree.Tree<A, B1> l, RedBlackTree.Tree<A, B1> d) {
        return this.isRedTree(l) && this.isRedTree(l.left()) ? RedBlackTree$RedTree$.MODULE$.apply(l.key(), l.value(), RedBlackTree$BlackTree$.MODULE$.apply(l.left().key(), l.left().value(), l.left().left(), l.left().right()), RedBlackTree$BlackTree$.MODULE$.apply(z, zv, l.right(), d)) : (this.isRedTree(l) && this.isRedTree(l.right()) ? RedBlackTree$RedTree$.MODULE$.apply(l.right().key(), l.right().value(), RedBlackTree$BlackTree$.MODULE$.apply(l.key(), l.value(), l.left(), l.right().left()), RedBlackTree$BlackTree$.MODULE$.apply(z, zv, l.right().right(), d)) : this.mkTree(isBlack, z, zv, l, d));
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> scala$collection$immutable$RedBlackTree$$balanceRight(boolean isBlack, A x, B xv, RedBlackTree.Tree<A, B1> a, RedBlackTree.Tree<A, B1> r) {
        return this.isRedTree(r) && this.isRedTree(r.left()) ? RedBlackTree$RedTree$.MODULE$.apply(r.left().key(), r.left().value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, a, r.left().left()), RedBlackTree$BlackTree$.MODULE$.apply(r.key(), r.value(), r.left().right(), r.right())) : (this.isRedTree(r) && this.isRedTree(r.right()) ? RedBlackTree$RedTree$.MODULE$.apply(r.key(), r.value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, a, r.left()), RedBlackTree$BlackTree$.MODULE$.apply(r.right().key(), r.right().value(), r.right().left(), r.right().right())) : this.mkTree(isBlack, x, xv, a, r));
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering) {
        int cmp;
        return tree == null ? RedBlackTree$RedTree$.MODULE$.apply(k, v, null, null) : ((cmp = ordering.compare(k, tree.key())) < 0 ? this.scala$collection$immutable$RedBlackTree$$balanceLeft(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key(), tree.value(), this.upd(tree.left(), k, v, overwrite, ordering), tree.right()) : (cmp > 0 ? this.scala$collection$immutable$RedBlackTree$$balanceRight(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key(), tree.value(), tree.left(), this.upd(tree.right(), k, v, overwrite, ordering)) : (!overwrite && BoxesRunTime.equals(k, tree.key()) ? tree : this.mkTree(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), k, v, tree.left(), tree.right()))));
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> updNth(RedBlackTree.Tree<A, B> tree, int idx, A k, B1 v, boolean overwrite) {
        int rank;
        return tree == null ? RedBlackTree$RedTree$.MODULE$.apply(k, v, null, null) : (idx < (rank = this.count(tree.left()) + 1) ? this.scala$collection$immutable$RedBlackTree$$balanceLeft(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key(), tree.value(), this.updNth(tree.left(), idx, k, v, overwrite), tree.right()) : (idx > rank ? this.scala$collection$immutable$RedBlackTree$$balanceRight(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key(), tree.value(), tree.left(), this.updNth(tree.right(), idx - rank, k, v, overwrite)) : (overwrite ? this.mkTree(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), k, v, tree.left(), tree.right()) : tree)));
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering) {
        int cmp;
        return tree == null ? null : ((cmp = ordering.compare(k, tree.key())) < 0 ? this.delLeft$1(tree, k, ordering) : (cmp > 0 ? this.delRight$1(tree, k, ordering) : this.append$1(tree.left(), tree.right())));
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree, A from2, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from2)) {
            return this.doFrom(tree.right(), from2, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from2, ordering);
        return newLeft == tree.left() ? tree : (newLeft == null ? this.upd(tree.right(), tree.key(), tree.value(), false, ordering) : this.rebalance(tree, newLeft, tree.right()));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree, A to2, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(to2, tree.key())) {
            return this.doTo(tree.left(), to2, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTo(tree.right(), to2, ordering);
        return newRight == tree.right() ? tree : (newRight == null ? this.upd(tree.left(), tree.key(), tree.value(), false, ordering) : this.rebalance(tree, tree.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree, A until2, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lteq(until2, tree.key())) {
            return this.doUntil(tree.left(), until2, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until2, ordering);
        return newRight == tree.right() ? tree : (newRight == null ? this.upd(tree.left(), tree.key(), tree.value(), false, ordering) : this.rebalance(tree, tree.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree, A from2, A until2, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from2)) {
            return this.doRange(tree.right(), from2, until2, ordering);
        }
        if (ordering.lteq(until2, tree.key())) {
            return this.doRange(tree.left(), from2, until2, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from2, ordering);
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until2, ordering);
        return newLeft == tree.left() && newRight == tree.right() ? tree : (newLeft == null ? this.upd(newRight, tree.key(), tree.value(), false, ordering) : (newRight == null ? this.upd(newLeft, tree.key(), tree.value(), false, ordering) : this.rebalance(tree, newLeft, newRight)));
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree, int n) {
        if (n <= 0) {
            return tree;
        }
        if (n >= this.count(tree)) {
            return null;
        }
        int count2 = this.count(tree.left());
        if (n > count2) {
            return this.doDrop(tree.right(), n - count2 - 1);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree.left(), n);
        return newLeft == tree.left() ? tree : (newLeft == null ? this.updNth(tree.right(), n - count2 - 1, tree.key(), tree.value(), false) : this.rebalance(tree, newLeft, tree.right()));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree, int n) {
        if (n <= 0) {
            return null;
        }
        if (n >= this.count(tree)) {
            return tree;
        }
        int count2 = this.count(tree.left());
        if (n <= count2) {
            return this.doTake(tree.left(), n);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree.right(), n - count2 - 1);
        return newRight == tree.right() ? tree : (newRight == null ? this.updNth(tree.left(), n, tree.key(), tree.value(), false) : this.rebalance(tree, tree.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree, int from2, int until2) {
        if (tree == null) {
            return null;
        }
        int count2 = this.count(tree.left());
        if (from2 > count2) {
            return this.doSlice(tree.right(), from2 - count2 - 1, until2 - count2 - 1);
        }
        if (until2 <= count2) {
            return this.doSlice(tree.left(), from2, until2);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree.left(), from2);
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree.right(), until2 - count2 - 1);
        return newLeft == tree.left() && newRight == tree.right() ? tree : (newLeft == null ? this.updNth(newRight, from2 - count2 - 1, tree.key(), tree.value(), false) : (newRight == null ? this.updNth(newLeft, until2, tree.key(), tree.value(), false) : this.rebalance(tree, newLeft, newRight)));
    }

    private <A, B> Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> compareDepth(RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        return this.unzipBoth$1(left, right, null, null, 0);
    }

    private <A, B> RedBlackTree.Tree<A, B> rebalance(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> newLeft, RedBlackTree.Tree<A, B> newRight) {
        RedBlackTree.Tree<A, B> blkNewRight;
        RedBlackTree.Tree<A, B> blkNewLeft = this.blacken(newLeft);
        Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> tuple4 = this.compareDepth(blkNewLeft, blkNewRight = this.blacken(newRight));
        if (tuple4 != null) {
            RedBlackTree.Tree tree2;
            Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Boolean, Boolean, Integer> tuple42;
            RedBlackTree.NList<RedBlackTree.Tree<A, B>> zipper = tuple4._1();
            boolean levelled = BoxesRunTime.unboxToBoolean(tuple4._2());
            boolean leftMost = BoxesRunTime.unboxToBoolean(tuple4._3());
            int smallerDepth = BoxesRunTime.unboxToInt(tuple4._4());
            Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Boolean, Boolean, Integer> tuple43 = tuple42 = new Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Boolean, Boolean, Integer>(zipper, BoxesRunTime.boxToBoolean(levelled), BoxesRunTime.boxToBoolean(leftMost), BoxesRunTime.boxToInteger(smallerDepth));
            RedBlackTree.NList<RedBlackTree.Tree<A, B>> zipper2 = tuple43._1();
            boolean levelled2 = BoxesRunTime.unboxToBoolean(tuple43._2());
            boolean leftMost2 = BoxesRunTime.unboxToBoolean(tuple43._3());
            int smallerDepth2 = BoxesRunTime.unboxToInt(tuple43._4());
            if (levelled2) {
                tree2 = RedBlackTree$BlackTree$.MODULE$.apply(tree.key(), tree.value(), blkNewLeft, blkNewRight);
            } else {
                RedBlackTree.NList zipFrom = this.findDepth$1(zipper2, smallerDepth2);
                RedBlackTree.RedTree<A, B> union2 = leftMost2 ? RedBlackTree$RedTree$.MODULE$.apply(tree.key(), tree.value(), blkNewLeft, (RedBlackTree.Tree)zipFrom.head()) : RedBlackTree$RedTree$.MODULE$.apply(tree.key(), tree.value(), (RedBlackTree.Tree)zipFrom.head(), blkNewRight);
                RedBlackTree.Tree zippedTree = RedBlackTree$NList$.MODULE$.foldLeft(zipFrom.tail(), union2, new Serializable(leftMost2){
                    public static final long serialVersionUID = 0L;
                    private final boolean leftMost$1;

                    public final RedBlackTree.Tree<A, B> apply(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> node) {
                        return this.leftMost$1 ? RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$balanceLeft(RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$isBlackTree(node), node.key(), node.value(), tree, node.right()) : RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$balanceRight(RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$isBlackTree(node), node.key(), node.value(), node.left(), tree);
                    }
                    {
                        this.leftMost$1 = leftMost$1;
                    }
                });
                tree2 = zippedTree;
            }
            return tree2;
        }
        throw new MatchError(tuple4);
    }

    private final RedBlackTree.Tree balance$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        return this.isRedTree(tl) ? (this.isRedTree(tr) ? RedBlackTree$RedTree$.MODULE$.apply(x, xv, tl.black(), tr.black()) : (this.isRedTree(tl.left()) ? RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left().black(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl.right(), tr)) : (this.isRedTree(tl.right()) ? RedBlackTree$RedTree$.MODULE$.apply(tl.right().key(), tl.right().value(), RedBlackTree$BlackTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), tl.right().left()), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl.right().right(), tr)) : RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr)))) : (this.isRedTree(tr) ? (this.isRedTree(tr.right()) ? RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr.left()), tr.right().black()) : (this.isRedTree(tr.left()) ? RedBlackTree$RedTree$.MODULE$.apply(tr.left().key(), tr.left().value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr.left().left()), RedBlackTree$BlackTree$.MODULE$.apply(tr.key(), tr.value(), tr.left().right(), tr.right())) : RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr))) : RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr));
    }

    private final RedBlackTree.Tree subl$1(RedBlackTree.Tree t) {
        if (t instanceof RedBlackTree.BlackTree) {
            return t.red();
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"Defect: invariance violation; expected black, got ").append(t).toString());
    }

    private final RedBlackTree.Tree balLeft$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        block5: {
            RedBlackTree.Tree tree;
            block3: {
                block4: {
                    block2: {
                        if (!this.isRedTree(tl)) break block2;
                        tree = RedBlackTree$RedTree$.MODULE$.apply(x, xv, tl.black(), tr);
                        break block3;
                    }
                    if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr)) break block4;
                    tree = this.balance$1(x, xv, tl, tr.red());
                    break block3;
                }
                if (!this.isRedTree(tr) || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr.left())) break block5;
                tree = RedBlackTree$RedTree$.MODULE$.apply(tr.left().key(), tr.left().value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr.left().left()), this.balance$1(tr.key(), tr.value(), tr.left().right(), this.subl$1(tr.right())));
            }
            return tree;
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private final RedBlackTree.Tree balRight$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        block5: {
            RedBlackTree.Tree tree;
            block3: {
                block4: {
                    block2: {
                        if (!this.isRedTree(tr)) break block2;
                        tree = RedBlackTree$RedTree$.MODULE$.apply(x, xv, tl, tr.black());
                        break block3;
                    }
                    if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl)) break block4;
                    tree = this.balance$1(x, xv, tl.red(), tr);
                    break block3;
                }
                if (!this.isRedTree(tl) || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl.right())) break block5;
                tree = RedBlackTree$RedTree$.MODULE$.apply(tl.right().key(), tl.right().value(), this.balance$1(tl.key(), tl.value(), this.subl$1(tl.left()), tl.right().left()), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl.right().right(), tr));
            }
            return tree;
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private final RedBlackTree.Tree delLeft$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        return this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree$1.left()) ? this.balLeft$1(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$1, ordering$1), tree$1.right()) : RedBlackTree$RedTree$.MODULE$.apply(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$1, ordering$1), tree$1.right());
    }

    private final RedBlackTree.Tree delRight$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        return this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree$1.right()) ? this.balRight$1(tree$1.key(), tree$1.value(), tree$1.left(), this.del(tree$1.right(), k$1, ordering$1)) : RedBlackTree$RedTree$.MODULE$.apply(tree$1.key(), tree$1.value(), tree$1.left(), this.del(tree$1.right(), k$1, ordering$1));
    }

    private final RedBlackTree.Tree append$1(RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        block9: {
            RedBlackTree.Tree tree;
            block4: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block3: {
                                    if (tl != null) break block3;
                                    tree = tr;
                                    break block4;
                                }
                                if (tr != null) break block5;
                                tree = tl;
                                break block4;
                            }
                            if (!this.isRedTree(tl) || !this.isRedTree(tr)) break block6;
                            RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
                            tree = this.isRedTree(bc) ? RedBlackTree$RedTree$.MODULE$.apply(bc.key(), bc.value(), RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), bc.left()), RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), bc.right(), tr.right())) : RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), bc, tr.right()));
                            break block4;
                        }
                        if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl) || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr)) break block7;
                        RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
                        tree = this.isRedTree(bc) ? RedBlackTree$RedTree$.MODULE$.apply(bc.key(), bc.value(), RedBlackTree$BlackTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), bc.left()), RedBlackTree$BlackTree$.MODULE$.apply(tr.key(), tr.value(), bc.right(), tr.right())) : this.balLeft$1(tl.key(), tl.value(), tl.left(), RedBlackTree$BlackTree$.MODULE$.apply(tr.key(), tr.value(), bc, tr.right()));
                        break block4;
                    }
                    if (!this.isRedTree(tr)) break block8;
                    tree = RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), this.append$1(tl, tr.left()), tr.right());
                    break block4;
                }
                if (!this.isRedTree(tl)) break block9;
                tree = RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), this.append$1(tl.right(), tr));
            }
            return tree;
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"unmatched tree on append: ").append(tl).append((Object)", ").append(tr).toString());
    }

    private final RedBlackTree.NList unzip$1(RedBlackTree.NList zipper, boolean leftMost) {
        while (true) {
            RedBlackTree.Tree next2;
            RedBlackTree.Tree tree = next2 = leftMost ? ((RedBlackTree.Tree)zipper.head()).left() : ((RedBlackTree.Tree)zipper.head()).right();
            if (next2 == null) {
                return zipper;
            }
            zipper = RedBlackTree$NList$.MODULE$.cons(next2, zipper);
        }
    }

    private final Tuple4 unzipBoth$1(RedBlackTree.Tree left, RedBlackTree.Tree right, RedBlackTree.NList leftZipper, RedBlackTree.NList rightZipper, int smallerDepth) {
        block10: {
            Tuple4<RedBlackTree.NList, Boolean, Boolean, Integer> tuple4;
            block8: {
                block9: {
                    block7: {
                        while (true) {
                            if (this.scala$collection$immutable$RedBlackTree$$isBlackTree(left) && this.scala$collection$immutable$RedBlackTree$$isBlackTree(right)) {
                                ++smallerDepth;
                                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                                leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
                                right = right.left();
                                left = left.right();
                                continue;
                            }
                            if (this.isRedTree(left) && this.isRedTree(right)) {
                                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                                leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
                                right = right.left();
                                left = left.right();
                                continue;
                            }
                            if (this.isRedTree(right)) {
                                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                                right = right.left();
                                continue;
                            }
                            if (!this.isRedTree(left)) break;
                            leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
                            left = left.right();
                        }
                        if (left != null || right != null) break block7;
                        tuple4 = new Tuple4<RedBlackTree.NList, Boolean, Boolean, Integer>(null, BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(smallerDepth));
                        break block8;
                    }
                    if (left != null || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(right)) break block9;
                    boolean leftMost = true;
                    tuple4 = new Tuple4<RedBlackTree.NList, Boolean, Boolean, Integer>(this.unzip$1(RedBlackTree$NList$.MODULE$.cons(right, rightZipper), leftMost), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToBoolean(leftMost), BoxesRunTime.boxToInteger(smallerDepth));
                    break block8;
                }
                if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(left) || right != null) break block10;
                boolean leftMost = false;
                tuple4 = new Tuple4<RedBlackTree.NList, Boolean, Boolean, Integer>(this.unzip$1(RedBlackTree$NList$.MODULE$.cons(left, leftZipper), leftMost), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToBoolean(leftMost), BoxesRunTime.boxToInteger(smallerDepth));
            }
            return tuple4;
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"unmatched trees in unzip: ").append(left).append((Object)", ").append(right).toString());
    }

    private final RedBlackTree.NList findDepth$1(RedBlackTree.NList zipper, int depth) {
        while (true) {
            if (zipper == null) {
                throw package$.MODULE$.error("Defect: unexpected empty zipper while computing range");
            }
            if (this.scala$collection$immutable$RedBlackTree$$isBlackTree((RedBlackTree.Tree)zipper.head())) {
                if (depth == 1) {
                    return zipper;
                }
                --depth;
                zipper = zipper.tail();
                continue;
            }
            zipper = zipper.tail();
        }
    }

    private RedBlackTree$() {
        MODULE$ = this;
    }
}

