/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Transaction;
import org.rocksdb.TransactionDBOptions;
import org.rocksdb.TransactionOptions;
import org.rocksdb.TransactionalDB;
import org.rocksdb.WriteOptions;

public class TransactionDB
extends RocksDB
implements TransactionalDB<TransactionOptions> {
    private TransactionDBOptions transactionDbOptions_;

    private TransactionDB(long l) {
        super(l);
    }

    public static TransactionDB open(Options options, TransactionDBOptions transactionDBOptions, String string) throws RocksDBException {
        TransactionDB transactionDB = new TransactionDB(TransactionDB.open(options.nativeHandle_, transactionDBOptions.nativeHandle_, string));
        transactionDB.storeOptionsInstance(options);
        transactionDB.storeTransactionDbOptions(transactionDBOptions);
        return transactionDB;
    }

    public static TransactionDB open(DBOptions dBOptions, TransactionDBOptions transactionDBOptions, String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        Object object;
        byte[][] byArrayArray = new byte[list.size()][];
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            byArrayArray[i] = ((ColumnFamilyDescriptor)object).columnFamilyName();
            lArray[i] = ((ColumnFamilyDescriptor)object).columnFamilyOptions().nativeHandle_;
        }
        long[] lArray2 = TransactionDB.open(dBOptions.nativeHandle_, transactionDBOptions.nativeHandle_, string, byArrayArray, lArray);
        object = new TransactionDB(lArray2[0]);
        ((RocksDB)object).storeOptionsInstance(dBOptions);
        super.storeTransactionDbOptions(transactionDBOptions);
        for (int i = 1; i < lArray2.length; ++i) {
            list2.add(new ColumnFamilyHandle((RocksDB)object, lArray2[i]));
        }
        return object;
    }

    @Override
    public void closeE() throws RocksDBException {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                TransactionDB.closeDatabase(this.nativeHandle_);
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    @Override
    public void close() {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                TransactionDB.closeDatabase(this.nativeHandle_);
            }
            catch (RocksDBException rocksDBException) {
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions) {
        return new Transaction(this, this.beginTransaction(this.nativeHandle_, writeOptions.nativeHandle_));
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, TransactionOptions transactionOptions) {
        return new Transaction(this, this.beginTransaction(this.nativeHandle_, writeOptions.nativeHandle_, transactionOptions.nativeHandle_));
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, Transaction transaction) {
        long l = this.beginTransaction_withOld(this.nativeHandle_, writeOptions.nativeHandle_, transaction.nativeHandle_);
        assert (l == transaction.nativeHandle_);
        return transaction;
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, TransactionOptions transactionOptions, Transaction transaction) {
        long l = this.beginTransaction_withOld(this.nativeHandle_, writeOptions.nativeHandle_, transactionOptions.nativeHandle_, transaction.nativeHandle_);
        assert (l == transaction.nativeHandle_);
        return transaction;
    }

    public Transaction getTransactionByName(String string) {
        long l = this.getTransactionByName(this.nativeHandle_, string);
        if (l == 0L) {
            return null;
        }
        Transaction transaction = new Transaction(this, l);
        transaction.disOwnNativeHandle();
        return transaction;
    }

    public List<Transaction> getAllPreparedTransactions() {
        long[] lArray = this.getAllPreparedTransactions(this.nativeHandle_);
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>();
        for (long l : lArray) {
            Transaction transaction = new Transaction(this, l);
            transaction.disOwnNativeHandle();
            arrayList.add(transaction);
        }
        return arrayList;
    }

    public Map<Long, KeyLockInfo> getLockStatusData() {
        return this.getLockStatusData(this.nativeHandle_);
    }

    private DeadlockInfo newDeadlockInfo(long l, long l2, String string, boolean bl) {
        return new DeadlockInfo(l, l2, string, bl);
    }

    public DeadlockPath[] getDeadlockInfoBuffer() {
        return this.getDeadlockInfoBuffer(this.nativeHandle_);
    }

    public void setDeadlockInfoBufferSize(int n) {
        this.setDeadlockInfoBufferSize(this.nativeHandle_, n);
    }

    private void storeTransactionDbOptions(TransactionDBOptions transactionDBOptions) {
        this.transactionDbOptions_ = transactionDBOptions;
    }

    @Override
    protected final native void disposeInternal(long var1);

    private static native long open(long var0, long var2, String var4) throws RocksDBException;

    private static native long[] open(long var0, long var2, String var4, byte[][] var5, long[] var6);

    private static native void closeDatabase(long var0) throws RocksDBException;

    private native long beginTransaction(long var1, long var3);

    private native long beginTransaction(long var1, long var3, long var5);

    private native long beginTransaction_withOld(long var1, long var3, long var5);

    private native long beginTransaction_withOld(long var1, long var3, long var5, long var7);

    private native long getTransactionByName(long var1, String var3);

    private native long[] getAllPreparedTransactions(long var1);

    private native Map<Long, KeyLockInfo> getLockStatusData(long var1);

    private native DeadlockPath[] getDeadlockInfoBuffer(long var1);

    private native void setDeadlockInfoBufferSize(long var1, int var3);

    public static class DeadlockPath {
        final DeadlockInfo[] path;
        final boolean limitExceeded;

        public DeadlockPath(DeadlockInfo[] deadlockInfoArray, boolean bl) {
            this.path = deadlockInfoArray;
            this.limitExceeded = bl;
        }

        public boolean isEmpty() {
            return this.path.length == 0 && !this.limitExceeded;
        }
    }

    public static class DeadlockInfo {
        private final long transactionID;
        private final long columnFamilyId;
        private final String waitingKey;
        private final boolean exclusive;

        private DeadlockInfo(long l, long l2, String string, boolean bl) {
            this.transactionID = l;
            this.columnFamilyId = l2;
            this.waitingKey = string;
            this.exclusive = bl;
        }

        public long getTransactionID() {
            return this.transactionID;
        }

        public long getColumnFamilyId() {
            return this.columnFamilyId;
        }

        public String getWaitingKey() {
            return this.waitingKey;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }
    }

    public static class KeyLockInfo {
        private final String key;
        private final long[] transactionIDs;
        private final boolean exclusive;

        public KeyLockInfo(String string, long[] lArray, boolean bl) {
            this.key = string;
            this.transactionIDs = lArray;
            this.exclusive = bl;
        }

        public String getKey() {
            return this.key;
        }

        public long[] getTransactionIDs() {
            return this.transactionIDs;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }
    }
}

