/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.DBOptions;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.RocksObject;

public abstract class Logger
extends RocksObject {
    public Logger(Options options) {
        this.createNewLoggerOptions(options.nativeHandle_);
    }

    public Logger(DBOptions dBOptions) {
        this.createNewLoggerDbOptions(dBOptions.nativeHandle_);
    }

    public void setInfoLogLevel(InfoLogLevel infoLogLevel) {
        this.setInfoLogLevel(this.nativeHandle_, infoLogLevel.getValue());
    }

    public InfoLogLevel infoLogLevel() {
        return InfoLogLevel.getInfoLogLevel(this.infoLogLevel(this.nativeHandle_));
    }

    protected abstract void log(InfoLogLevel var1, String var2);

    @Override
    protected void disposeInternal() {
        assert (this.isInitialized());
        this.disposeInternal(this.nativeHandle_);
    }

    protected native void createNewLoggerOptions(long var1);

    protected native void createNewLoggerDbOptions(long var1);

    protected native void setInfoLogLevel(long var1, byte var3);

    protected native byte infoLogLevel(long var1);

    private native void disposeInternal(long var1);
}

