/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.rocksdb.util.Environment;

public class NativeLibraryLoader {
    private static final NativeLibraryLoader instance = new NativeLibraryLoader();
    private static final String sharedLibraryName = Environment.getJniLibraryName("rocksdb");
    private static final String tempFilePrefix = "librocksdbjni";
    private static final String tempFileSuffix = "." + Environment.getJniLibraryExtension();

    public static NativeLibraryLoader getInstance() {
        return instance;
    }

    public void loadLibraryFromJar(String string) throws IOException {
        File file = string == null || string.equals("") ? File.createTempFile(tempFilePrefix, tempFileSuffix) : new File(string, sharedLibraryName);
        if (!file.exists()) {
            throw new RuntimeException("File " + file.getAbsolutePath() + " does not exist.");
        }
        file.deleteOnExit();
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(sharedLibraryName);){
            if (inputStream == null) {
                throw new RuntimeException(sharedLibraryName + " was not found inside JAR.");
            }
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(file.getAbsolutePath());
    }

    private NativeLibraryLoader() {
    }
}

