/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.DBOptionsInterface;
import org.rocksdb.RateLimiterConfig;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;
import org.rocksdb.Statistics;

public class DBOptions
extends RocksObject
implements DBOptionsInterface {
    static final int DEFAULT_NUM_SHARD_BITS = -1;
    int numShardBits_ = -1;
    RateLimiterConfig rateLimiterConfig_;

    public DBOptions() {
        this.newDBOptions();
    }

    @Override
    public DBOptions setCreateIfMissing(boolean bl) {
        assert (this.isInitialized());
        this.setCreateIfMissing(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean createIfMissing() {
        assert (this.isInitialized());
        return this.createIfMissing(this.nativeHandle_);
    }

    @Override
    public DBOptions setCreateMissingColumnFamilies(boolean bl) {
        assert (this.isInitialized());
        this.setCreateMissingColumnFamilies(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean createMissingColumnFamilies() {
        assert (this.isInitialized());
        return this.createMissingColumnFamilies(this.nativeHandle_);
    }

    @Override
    public DBOptions setErrorIfExists(boolean bl) {
        assert (this.isInitialized());
        this.setErrorIfExists(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean errorIfExists() {
        assert (this.isInitialized());
        return this.errorIfExists(this.nativeHandle_);
    }

    @Override
    public DBOptions setParanoidChecks(boolean bl) {
        assert (this.isInitialized());
        this.setParanoidChecks(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean paranoidChecks() {
        assert (this.isInitialized());
        return this.paranoidChecks(this.nativeHandle_);
    }

    @Override
    public DBOptions setRateLimiterConfig(RateLimiterConfig rateLimiterConfig) {
        this.rateLimiterConfig_ = rateLimiterConfig;
        this.setRateLimiter(this.nativeHandle_, rateLimiterConfig.newRateLimiterHandle());
        return this;
    }

    @Override
    public DBOptions setMaxOpenFiles(int n) {
        assert (this.isInitialized());
        this.setMaxOpenFiles(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxOpenFiles() {
        assert (this.isInitialized());
        return this.maxOpenFiles(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxTotalWalSize(long l) {
        assert (this.isInitialized());
        this.setMaxTotalWalSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxTotalWalSize() {
        assert (this.isInitialized());
        return this.maxTotalWalSize(this.nativeHandle_);
    }

    @Override
    public DBOptions createStatistics() {
        assert (this.isInitialized());
        this.createStatistics(this.nativeHandle_);
        return this;
    }

    @Override
    public Statistics statisticsPtr() {
        assert (this.isInitialized());
        long l = this.statisticsPtr(this.nativeHandle_);
        if (l == 0L) {
            this.createStatistics();
            l = this.statisticsPtr(this.nativeHandle_);
        }
        return new Statistics(l);
    }

    @Override
    public DBOptions setDisableDataSync(boolean bl) {
        assert (this.isInitialized());
        this.setDisableDataSync(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean disableDataSync() {
        assert (this.isInitialized());
        return this.disableDataSync(this.nativeHandle_);
    }

    @Override
    public DBOptions setUseFsync(boolean bl) {
        assert (this.isInitialized());
        this.setUseFsync(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean useFsync() {
        assert (this.isInitialized());
        return this.useFsync(this.nativeHandle_);
    }

    @Override
    public DBOptions setDbLogDir(String string) {
        assert (this.isInitialized());
        this.setDbLogDir(this.nativeHandle_, string);
        return this;
    }

    @Override
    public String dbLogDir() {
        assert (this.isInitialized());
        return this.dbLogDir(this.nativeHandle_);
    }

    @Override
    public DBOptions setWalDir(String string) {
        assert (this.isInitialized());
        this.setWalDir(this.nativeHandle_, string);
        return this;
    }

    @Override
    public String walDir() {
        assert (this.isInitialized());
        return this.walDir(this.nativeHandle_);
    }

    @Override
    public DBOptions setDeleteObsoleteFilesPeriodMicros(long l) {
        assert (this.isInitialized());
        this.setDeleteObsoleteFilesPeriodMicros(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long deleteObsoleteFilesPeriodMicros() {
        assert (this.isInitialized());
        return this.deleteObsoleteFilesPeriodMicros(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxBackgroundCompactions(int n) {
        assert (this.isInitialized());
        this.setMaxBackgroundCompactions(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxBackgroundCompactions() {
        assert (this.isInitialized());
        return this.maxBackgroundCompactions(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxBackgroundFlushes(int n) {
        assert (this.isInitialized());
        this.setMaxBackgroundFlushes(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxBackgroundFlushes() {
        assert (this.isInitialized());
        return this.maxBackgroundFlushes(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxLogFileSize(long l) throws RocksDBException {
        assert (this.isInitialized());
        this.setMaxLogFileSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxLogFileSize() {
        assert (this.isInitialized());
        return this.maxLogFileSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setLogFileTimeToRoll(long l) throws RocksDBException {
        assert (this.isInitialized());
        this.setLogFileTimeToRoll(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long logFileTimeToRoll() {
        assert (this.isInitialized());
        return this.logFileTimeToRoll(this.nativeHandle_);
    }

    @Override
    public DBOptions setKeepLogFileNum(long l) throws RocksDBException {
        assert (this.isInitialized());
        this.setKeepLogFileNum(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long keepLogFileNum() {
        assert (this.isInitialized());
        return this.keepLogFileNum(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxManifestFileSize(long l) {
        assert (this.isInitialized());
        this.setMaxManifestFileSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxManifestFileSize() {
        assert (this.isInitialized());
        return this.maxManifestFileSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setTableCacheNumshardbits(int n) {
        assert (this.isInitialized());
        this.setTableCacheNumshardbits(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int tableCacheNumshardbits() {
        assert (this.isInitialized());
        return this.tableCacheNumshardbits(this.nativeHandle_);
    }

    @Override
    public DBOptions setTableCacheRemoveScanCountLimit(int n) {
        assert (this.isInitialized());
        this.setTableCacheRemoveScanCountLimit(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int tableCacheRemoveScanCountLimit() {
        assert (this.isInitialized());
        return this.tableCacheRemoveScanCountLimit(this.nativeHandle_);
    }

    @Override
    public DBOptions setWalTtlSeconds(long l) {
        assert (this.isInitialized());
        this.setWalTtlSeconds(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long walTtlSeconds() {
        assert (this.isInitialized());
        return this.walTtlSeconds(this.nativeHandle_);
    }

    @Override
    public DBOptions setWalSizeLimitMB(long l) {
        assert (this.isInitialized());
        this.setWalSizeLimitMB(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long walSizeLimitMB() {
        assert (this.isInitialized());
        return this.walSizeLimitMB(this.nativeHandle_);
    }

    @Override
    public DBOptions setManifestPreallocationSize(long l) throws RocksDBException {
        assert (this.isInitialized());
        this.setManifestPreallocationSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long manifestPreallocationSize() {
        assert (this.isInitialized());
        return this.manifestPreallocationSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setAllowOsBuffer(boolean bl) {
        assert (this.isInitialized());
        this.setAllowOsBuffer(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowOsBuffer() {
        assert (this.isInitialized());
        return this.allowOsBuffer(this.nativeHandle_);
    }

    @Override
    public DBOptions setAllowMmapReads(boolean bl) {
        assert (this.isInitialized());
        this.setAllowMmapReads(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowMmapReads() {
        assert (this.isInitialized());
        return this.allowMmapReads(this.nativeHandle_);
    }

    @Override
    public DBOptions setAllowMmapWrites(boolean bl) {
        assert (this.isInitialized());
        this.setAllowMmapWrites(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowMmapWrites() {
        assert (this.isInitialized());
        return this.allowMmapWrites(this.nativeHandle_);
    }

    @Override
    public DBOptions setIsFdCloseOnExec(boolean bl) {
        assert (this.isInitialized());
        this.setIsFdCloseOnExec(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean isFdCloseOnExec() {
        assert (this.isInitialized());
        return this.isFdCloseOnExec(this.nativeHandle_);
    }

    @Override
    public DBOptions setSkipLogErrorOnRecovery(boolean bl) {
        assert (this.isInitialized());
        this.setSkipLogErrorOnRecovery(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean skipLogErrorOnRecovery() {
        assert (this.isInitialized());
        return this.skipLogErrorOnRecovery(this.nativeHandle_);
    }

    @Override
    public DBOptions setStatsDumpPeriodSec(int n) {
        assert (this.isInitialized());
        this.setStatsDumpPeriodSec(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int statsDumpPeriodSec() {
        assert (this.isInitialized());
        return this.statsDumpPeriodSec(this.nativeHandle_);
    }

    @Override
    public DBOptions setAdviseRandomOnOpen(boolean bl) {
        assert (this.isInitialized());
        this.setAdviseRandomOnOpen(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean adviseRandomOnOpen() {
        return this.adviseRandomOnOpen(this.nativeHandle_);
    }

    @Override
    public DBOptions setUseAdaptiveMutex(boolean bl) {
        assert (this.isInitialized());
        this.setUseAdaptiveMutex(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean useAdaptiveMutex() {
        assert (this.isInitialized());
        return this.useAdaptiveMutex(this.nativeHandle_);
    }

    @Override
    public DBOptions setBytesPerSync(long l) {
        assert (this.isInitialized());
        this.setBytesPerSync(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long bytesPerSync() {
        return this.bytesPerSync(this.nativeHandle_);
    }

    @Override
    protected void disposeInternal() {
        assert (this.isInitialized());
        this.disposeInternal(this.nativeHandle_);
    }

    private native void newDBOptions();

    private native void disposeInternal(long var1);

    private native void setCreateIfMissing(long var1, boolean var3);

    private native boolean createIfMissing(long var1);

    private native void setCreateMissingColumnFamilies(long var1, boolean var3);

    private native boolean createMissingColumnFamilies(long var1);

    private native void setErrorIfExists(long var1, boolean var3);

    private native boolean errorIfExists(long var1);

    private native void setParanoidChecks(long var1, boolean var3);

    private native boolean paranoidChecks(long var1);

    private native void setRateLimiter(long var1, long var3);

    private native void setMaxOpenFiles(long var1, int var3);

    private native int maxOpenFiles(long var1);

    private native void setMaxTotalWalSize(long var1, long var3);

    private native long maxTotalWalSize(long var1);

    private native void createStatistics(long var1);

    private native long statisticsPtr(long var1);

    private native void setDisableDataSync(long var1, boolean var3);

    private native boolean disableDataSync(long var1);

    private native boolean useFsync(long var1);

    private native void setUseFsync(long var1, boolean var3);

    private native void setDbLogDir(long var1, String var3);

    private native String dbLogDir(long var1);

    private native void setWalDir(long var1, String var3);

    private native String walDir(long var1);

    private native void setDeleteObsoleteFilesPeriodMicros(long var1, long var3);

    private native long deleteObsoleteFilesPeriodMicros(long var1);

    private native void setMaxBackgroundCompactions(long var1, int var3);

    private native int maxBackgroundCompactions(long var1);

    private native void setMaxBackgroundFlushes(long var1, int var3);

    private native int maxBackgroundFlushes(long var1);

    private native void setMaxLogFileSize(long var1, long var3) throws RocksDBException;

    private native long maxLogFileSize(long var1);

    private native void setLogFileTimeToRoll(long var1, long var3) throws RocksDBException;

    private native long logFileTimeToRoll(long var1);

    private native void setKeepLogFileNum(long var1, long var3) throws RocksDBException;

    private native long keepLogFileNum(long var1);

    private native void setMaxManifestFileSize(long var1, long var3);

    private native long maxManifestFileSize(long var1);

    private native void setTableCacheNumshardbits(long var1, int var3);

    private native int tableCacheNumshardbits(long var1);

    private native void setTableCacheRemoveScanCountLimit(long var1, int var3);

    private native int tableCacheRemoveScanCountLimit(long var1);

    private native void setWalTtlSeconds(long var1, long var3);

    private native long walTtlSeconds(long var1);

    private native void setWalSizeLimitMB(long var1, long var3);

    private native long walSizeLimitMB(long var1);

    private native void setManifestPreallocationSize(long var1, long var3) throws RocksDBException;

    private native long manifestPreallocationSize(long var1);

    private native void setAllowOsBuffer(long var1, boolean var3);

    private native boolean allowOsBuffer(long var1);

    private native void setAllowMmapReads(long var1, boolean var3);

    private native boolean allowMmapReads(long var1);

    private native void setAllowMmapWrites(long var1, boolean var3);

    private native boolean allowMmapWrites(long var1);

    private native void setIsFdCloseOnExec(long var1, boolean var3);

    private native boolean isFdCloseOnExec(long var1);

    private native void setSkipLogErrorOnRecovery(long var1, boolean var3);

    private native boolean skipLogErrorOnRecovery(long var1);

    private native void setStatsDumpPeriodSec(long var1, int var3);

    private native int statsDumpPeriodSec(long var1);

    private native void setAdviseRandomOnOpen(long var1, boolean var3);

    private native boolean adviseRandomOnOpen(long var1);

    private native void setUseAdaptiveMutex(long var1, boolean var3);

    private native boolean useAdaptiveMutex(long var1);

    private native void setBytesPerSync(long var1, long var3);

    private native long bytesPerSync(long var1);

    static {
        RocksDB.loadLibrary();
    }
}

