/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb.util;

public class Environment {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static String ARCH = System.getProperty("os.arch").toLowerCase();

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") >= 0;
    }

    public static boolean is64Bit() {
        return ARCH.indexOf("64") > 0;
    }

    public static String getSharedLibraryName(String string) {
        if (Environment.isUnix()) {
            return String.format("lib%sjni.so", string);
        }
        if (Environment.isMac()) {
            return String.format("lib%sjni.dylib", string);
        }
        throw new UnsupportedOperationException();
    }

    public static String getJniLibraryName(String string) {
        if (Environment.isUnix()) {
            String string2 = Environment.is64Bit() ? "64" : "32";
            return String.format("lib%sjni-linux%s.so", string, string2);
        }
        if (Environment.isMac()) {
            return String.format("lib%sjni-osx.jnilib", string);
        }
        throw new UnsupportedOperationException();
    }

    public static String getJniLibraryExtension() {
        return Environment.isMac() ? ".jnilib" : ".so";
    }
}

