/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.Filter;
import org.rocksdb.MemTableConfig;
import org.rocksdb.RocksEnv;
import org.rocksdb.RocksObject;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;

public class Options
extends RocksObject {
    static final long DEFAULT_CACHE_SIZE = 0x800000L;
    static final int DEFAULT_PLAIN_TABLE_BLOOM_BITS_PER_KEY = 10;
    static final double DEFAULT_PLAIN_TABLE_HASH_TABLE_RATIO = 0.75;
    static final int DEFAULT_PLAIN_TABLE_INDEX_SPARSENESS = 16;
    long cacheSize_ = 0x800000L;
    Filter filter_;
    RocksEnv env_;

    public Options() {
        this.newOptions();
        this.env_ = RocksEnv.getDefault();
    }

    public Options setCreateIfMissing(boolean bl) {
        assert (this.isInitialized());
        this.setCreateIfMissing(this.nativeHandle_, bl);
        return this;
    }

    public Options setEnv(RocksEnv rocksEnv) {
        assert (this.isInitialized());
        this.setEnv(this.nativeHandle_, rocksEnv.nativeHandle_);
        this.env_ = rocksEnv;
        return this;
    }

    private native void setEnv(long var1, long var3);

    public RocksEnv getEnv() {
        return this.env_;
    }

    private native long getEnvHandle(long var1);

    public boolean createIfMissing() {
        assert (this.isInitialized());
        return this.createIfMissing(this.nativeHandle_);
    }

    public Options setWriteBufferSize(long l) {
        assert (this.isInitialized());
        this.setWriteBufferSize(this.nativeHandle_, l);
        return this;
    }

    public long writeBufferSize() {
        assert (this.isInitialized());
        return this.writeBufferSize(this.nativeHandle_);
    }

    public Options setMaxWriteBufferNumber(int n) {
        assert (this.isInitialized());
        this.setMaxWriteBufferNumber(this.nativeHandle_, n);
        return this;
    }

    public int maxWriteBufferNumber() {
        assert (this.isInitialized());
        return this.maxWriteBufferNumber(this.nativeHandle_);
    }

    public Options setBlockSize(long l) {
        assert (this.isInitialized());
        this.setBlockSize(this.nativeHandle_, l);
        return this;
    }

    public long blockSize() {
        assert (this.isInitialized());
        return this.blockSize(this.nativeHandle_);
    }

    public Options setFilter(Filter filter) {
        assert (this.isInitialized());
        this.setFilterHandle(this.nativeHandle_, filter.nativeHandle_);
        this.filter_ = filter;
        return this;
    }

    private native void setFilterHandle(long var1, long var3);

    public Options setDisableSeekCompaction(boolean bl) {
        assert (this.isInitialized());
        this.setDisableSeekCompaction(this.nativeHandle_, bl);
        return this;
    }

    public boolean disableSeekCompaction() {
        assert (this.isInitialized());
        return this.disableSeekCompaction(this.nativeHandle_);
    }

    public Options setCacheSize(long l) {
        this.cacheSize_ = l;
        return this;
    }

    public long cacheSize() {
        return this.cacheSize_;
    }

    public boolean errorIfExists() {
        assert (this.isInitialized());
        return this.errorIfExists(this.nativeHandle_);
    }

    private native boolean errorIfExists(long var1);

    public Options setErrorIfExists(boolean bl) {
        assert (this.isInitialized());
        this.setErrorIfExists(this.nativeHandle_, bl);
        return this;
    }

    private native void setErrorIfExists(long var1, boolean var3);

    public boolean paranoidChecks() {
        assert (this.isInitialized());
        return this.paranoidChecks(this.nativeHandle_);
    }

    private native boolean paranoidChecks(long var1);

    public Options setParanoidChecks(boolean bl) {
        assert (this.isInitialized());
        this.setParanoidChecks(this.nativeHandle_, bl);
        return this;
    }

    private native void setParanoidChecks(long var1, boolean var3);

    public int maxOpenFiles() {
        assert (this.isInitialized());
        return this.maxOpenFiles(this.nativeHandle_);
    }

    private native int maxOpenFiles(long var1);

    public Options setMaxOpenFiles(int n) {
        assert (this.isInitialized());
        this.setMaxOpenFiles(this.nativeHandle_, n);
        return this;
    }

    private native void setMaxOpenFiles(long var1, int var3);

    public boolean disableDataSync() {
        assert (this.isInitialized());
        return this.disableDataSync(this.nativeHandle_);
    }

    private native boolean disableDataSync(long var1);

    public Options setDisableDataSync(boolean bl) {
        assert (this.isInitialized());
        this.setDisableDataSync(this.nativeHandle_, bl);
        return this;
    }

    private native void setDisableDataSync(long var1, boolean var3);

    public boolean useFsync() {
        assert (this.isInitialized());
        return this.useFsync(this.nativeHandle_);
    }

    private native boolean useFsync(long var1);

    public Options setUseFsync(boolean bl) {
        assert (this.isInitialized());
        this.setUseFsync(this.nativeHandle_, bl);
        return this;
    }

    private native void setUseFsync(long var1, boolean var3);

    public int dbStatsLogInterval() {
        assert (this.isInitialized());
        return this.dbStatsLogInterval(this.nativeHandle_);
    }

    private native int dbStatsLogInterval(long var1);

    public Options setDbStatsLogInterval(int n) {
        assert (this.isInitialized());
        this.setDbStatsLogInterval(this.nativeHandle_, n);
        return this;
    }

    private native void setDbStatsLogInterval(long var1, int var3);

    public String dbLogDir() {
        assert (this.isInitialized());
        return this.dbLogDir(this.nativeHandle_);
    }

    private native String dbLogDir(long var1);

    public Options setDbLogDir(String string) {
        assert (this.isInitialized());
        this.setDbLogDir(this.nativeHandle_, string);
        return this;
    }

    private native void setDbLogDir(long var1, String var3);

    public String walDir() {
        assert (this.isInitialized());
        return this.walDir(this.nativeHandle_);
    }

    private native String walDir(long var1);

    public Options setWalDir(String string) {
        assert (this.isInitialized());
        this.setWalDir(this.nativeHandle_, string);
        return this;
    }

    private native void setWalDir(long var1, String var3);

    public long deleteObsoleteFilesPeriodMicros() {
        assert (this.isInitialized());
        return this.deleteObsoleteFilesPeriodMicros(this.nativeHandle_);
    }

    private native long deleteObsoleteFilesPeriodMicros(long var1);

    public Options setDeleteObsoleteFilesPeriodMicros(long l) {
        assert (this.isInitialized());
        this.setDeleteObsoleteFilesPeriodMicros(this.nativeHandle_, l);
        return this;
    }

    private native void setDeleteObsoleteFilesPeriodMicros(long var1, long var3);

    public int maxBackgroundCompactions() {
        assert (this.isInitialized());
        return this.maxBackgroundCompactions(this.nativeHandle_);
    }

    public Options createStatistics() {
        assert (this.isInitialized());
        this.createStatistics(this.nativeHandle_);
        return this;
    }

    public Statistics statisticsPtr() {
        assert (this.isInitialized());
        long l = this.statisticsPtr(this.nativeHandle_);
        if (l == 0L) {
            this.createStatistics();
            l = this.statisticsPtr(this.nativeHandle_);
        }
        return new Statistics(l);
    }

    public Options setMaxBackgroundCompactions(int n) {
        assert (this.isInitialized());
        this.setMaxBackgroundCompactions(this.nativeHandle_, n);
        return this;
    }

    public int maxBackgroundFlushes() {
        assert (this.isInitialized());
        return this.maxBackgroundFlushes(this.nativeHandle_);
    }

    private native int maxBackgroundFlushes(long var1);

    public Options setMaxBackgroundFlushes(int n) {
        assert (this.isInitialized());
        this.setMaxBackgroundFlushes(this.nativeHandle_, n);
        return this;
    }

    private native void setMaxBackgroundFlushes(long var1, int var3);

    public long maxLogFileSize() {
        assert (this.isInitialized());
        return this.maxLogFileSize(this.nativeHandle_);
    }

    private native long maxLogFileSize(long var1);

    public Options setMaxLogFileSize(long l) {
        assert (this.isInitialized());
        this.setMaxLogFileSize(this.nativeHandle_, l);
        return this;
    }

    private native void setMaxLogFileSize(long var1, long var3);

    public long logFileTimeToRoll() {
        assert (this.isInitialized());
        return this.logFileTimeToRoll(this.nativeHandle_);
    }

    private native long logFileTimeToRoll(long var1);

    public Options setLogFileTimeToRoll(long l) {
        assert (this.isInitialized());
        this.setLogFileTimeToRoll(this.nativeHandle_, l);
        return this;
    }

    private native void setLogFileTimeToRoll(long var1, long var3);

    public long keepLogFileNum() {
        assert (this.isInitialized());
        return this.keepLogFileNum(this.nativeHandle_);
    }

    private native long keepLogFileNum(long var1);

    public Options setKeepLogFileNum(long l) {
        assert (this.isInitialized());
        this.setKeepLogFileNum(this.nativeHandle_, l);
        return this;
    }

    private native void setKeepLogFileNum(long var1, long var3);

    public long maxManifestFileSize() {
        assert (this.isInitialized());
        return this.maxManifestFileSize(this.nativeHandle_);
    }

    private native long maxManifestFileSize(long var1);

    public Options setMaxManifestFileSize(long l) {
        assert (this.isInitialized());
        this.setMaxManifestFileSize(this.nativeHandle_, l);
        return this;
    }

    private native void setMaxManifestFileSize(long var1, long var3);

    public int tableCacheNumshardbits() {
        assert (this.isInitialized());
        return this.tableCacheNumshardbits(this.nativeHandle_);
    }

    private native int tableCacheNumshardbits(long var1);

    public Options setTableCacheNumshardbits(int n) {
        assert (this.isInitialized());
        this.setTableCacheNumshardbits(this.nativeHandle_, n);
        return this;
    }

    private native void setTableCacheNumshardbits(long var1, int var3);

    public int tableCacheRemoveScanCountLimit() {
        assert (this.isInitialized());
        return this.tableCacheRemoveScanCountLimit(this.nativeHandle_);
    }

    private native int tableCacheRemoveScanCountLimit(long var1);

    public Options setTableCacheRemoveScanCountLimit(int n) {
        assert (this.isInitialized());
        this.setTableCacheRemoveScanCountLimit(this.nativeHandle_, n);
        return this;
    }

    private native void setTableCacheRemoveScanCountLimit(long var1, int var3);

    public long walTtlSeconds() {
        assert (this.isInitialized());
        return this.walTtlSeconds(this.nativeHandle_);
    }

    private native long walTtlSeconds(long var1);

    public Options setWalTtlSeconds(long l) {
        assert (this.isInitialized());
        this.setWalTtlSeconds(this.nativeHandle_, l);
        return this;
    }

    private native void setWalTtlSeconds(long var1, long var3);

    public long walSizeLimitMB() {
        assert (this.isInitialized());
        return this.walSizeLimitMB(this.nativeHandle_);
    }

    private native long walSizeLimitMB(long var1);

    public Options setWalSizeLimitMB(long l) {
        assert (this.isInitialized());
        this.setWalSizeLimitMB(this.nativeHandle_, l);
        return this;
    }

    private native void setWalSizeLimitMB(long var1, long var3);

    public long manifestPreallocationSize() {
        assert (this.isInitialized());
        return this.manifestPreallocationSize(this.nativeHandle_);
    }

    private native long manifestPreallocationSize(long var1);

    public Options setManifestPreallocationSize(long l) {
        assert (this.isInitialized());
        this.setManifestPreallocationSize(this.nativeHandle_, l);
        return this;
    }

    private native void setManifestPreallocationSize(long var1, long var3);

    public boolean allowOsBuffer() {
        assert (this.isInitialized());
        return this.allowOsBuffer(this.nativeHandle_);
    }

    private native boolean allowOsBuffer(long var1);

    public Options setAllowOsBuffer(boolean bl) {
        assert (this.isInitialized());
        this.setAllowOsBuffer(this.nativeHandle_, bl);
        return this;
    }

    private native void setAllowOsBuffer(long var1, boolean var3);

    public boolean allowMmapReads() {
        assert (this.isInitialized());
        return this.allowMmapReads(this.nativeHandle_);
    }

    private native boolean allowMmapReads(long var1);

    public Options setAllowMmapReads(boolean bl) {
        assert (this.isInitialized());
        this.setAllowMmapReads(this.nativeHandle_, bl);
        return this;
    }

    private native void setAllowMmapReads(long var1, boolean var3);

    public boolean allowMmapWrites() {
        assert (this.isInitialized());
        return this.allowMmapWrites(this.nativeHandle_);
    }

    private native boolean allowMmapWrites(long var1);

    public Options setAllowMmapWrites(boolean bl) {
        assert (this.isInitialized());
        this.setAllowMmapWrites(this.nativeHandle_, bl);
        return this;
    }

    private native void setAllowMmapWrites(long var1, boolean var3);

    public boolean isFdCloseOnExec() {
        assert (this.isInitialized());
        return this.isFdCloseOnExec(this.nativeHandle_);
    }

    private native boolean isFdCloseOnExec(long var1);

    public Options setIsFdCloseOnExec(boolean bl) {
        assert (this.isInitialized());
        this.setIsFdCloseOnExec(this.nativeHandle_, bl);
        return this;
    }

    private native void setIsFdCloseOnExec(long var1, boolean var3);

    public boolean skipLogErrorOnRecovery() {
        assert (this.isInitialized());
        return this.skipLogErrorOnRecovery(this.nativeHandle_);
    }

    private native boolean skipLogErrorOnRecovery(long var1);

    public Options setSkipLogErrorOnRecovery(boolean bl) {
        assert (this.isInitialized());
        this.setSkipLogErrorOnRecovery(this.nativeHandle_, bl);
        return this;
    }

    private native void setSkipLogErrorOnRecovery(long var1, boolean var3);

    public int statsDumpPeriodSec() {
        assert (this.isInitialized());
        return this.statsDumpPeriodSec(this.nativeHandle_);
    }

    private native int statsDumpPeriodSec(long var1);

    public Options setStatsDumpPeriodSec(int n) {
        assert (this.isInitialized());
        this.setStatsDumpPeriodSec(this.nativeHandle_, n);
        return this;
    }

    private native void setStatsDumpPeriodSec(long var1, int var3);

    public boolean adviseRandomOnOpen() {
        return this.adviseRandomOnOpen(this.nativeHandle_);
    }

    private native boolean adviseRandomOnOpen(long var1);

    public Options setAdviseRandomOnOpen(boolean bl) {
        assert (this.isInitialized());
        this.setAdviseRandomOnOpen(this.nativeHandle_, bl);
        return this;
    }

    private native void setAdviseRandomOnOpen(long var1, boolean var3);

    public boolean useAdaptiveMutex() {
        assert (this.isInitialized());
        return this.useAdaptiveMutex(this.nativeHandle_);
    }

    private native boolean useAdaptiveMutex(long var1);

    public Options setUseAdaptiveMutex(boolean bl) {
        assert (this.isInitialized());
        this.setUseAdaptiveMutex(this.nativeHandle_, bl);
        return this;
    }

    private native void setUseAdaptiveMutex(long var1, boolean var3);

    public long bytesPerSync() {
        return this.bytesPerSync(this.nativeHandle_);
    }

    private native long bytesPerSync(long var1);

    public Options setBytesPerSync(long l) {
        assert (this.isInitialized());
        this.setBytesPerSync(this.nativeHandle_, l);
        return this;
    }

    private native void setBytesPerSync(long var1, long var3);

    public boolean allowThreadLocal() {
        assert (this.isInitialized());
        return this.allowThreadLocal(this.nativeHandle_);
    }

    private native boolean allowThreadLocal(long var1);

    public Options setAllowThreadLocal(boolean bl) {
        assert (this.isInitialized());
        this.setAllowThreadLocal(this.nativeHandle_, bl);
        return this;
    }

    private native void setAllowThreadLocal(long var1, boolean var3);

    public Options setMemTableConfig(MemTableConfig memTableConfig) {
        this.setMemTableFactory(this.nativeHandle_, memTableConfig.newMemTableFactoryHandle());
        return this;
    }

    public String memTableFactoryName() {
        assert (this.isInitialized());
        return this.memTableFactoryName(this.nativeHandle_);
    }

    public Options setTableFormatConfig(TableFormatConfig tableFormatConfig) {
        this.setTableFactory(this.nativeHandle_, tableFormatConfig.newTableFactoryHandle());
        return this;
    }

    public String tableFactoryName() {
        assert (this.isInitialized());
        return this.tableFactoryName(this.nativeHandle_);
    }

    public Options useFixedLengthPrefixExtractor(int n) {
        assert (this.isInitialized());
        this.useFixedLengthPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    public int blockRestartInterval() {
        return this.blockRestartInterval(this.nativeHandle_);
    }

    private native int blockRestartInterval(long var1);

    public Options setBlockRestartInterval(int n) {
        this.setBlockRestartInterval(this.nativeHandle_, n);
        return this;
    }

    private native void setBlockRestartInterval(long var1, int var3);

    public boolean wholeKeyFiltering() {
        return this.wholeKeyFiltering(this.nativeHandle_);
    }

    private native boolean wholeKeyFiltering(long var1);

    public Options setWholeKeyFiltering(boolean bl) {
        this.setWholeKeyFiltering(this.nativeHandle_, bl);
        return this;
    }

    private native void setWholeKeyFiltering(long var1, boolean var3);

    public int numLevels() {
        return this.numLevels(this.nativeHandle_);
    }

    private native int numLevels(long var1);

    public Options setNumLevels(int n) {
        this.setNumLevels(this.nativeHandle_, n);
        return this;
    }

    private native void setNumLevels(long var1, int var3);

    public int levelZeroFileNumCompactionTrigger() {
        return this.levelZeroFileNumCompactionTrigger(this.nativeHandle_);
    }

    private native int levelZeroFileNumCompactionTrigger(long var1);

    public Options setLevelZeroFileNumCompactionTrigger(int n) {
        this.setLevelZeroFileNumCompactionTrigger(this.nativeHandle_, n);
        return this;
    }

    private native void setLevelZeroFileNumCompactionTrigger(long var1, int var3);

    public int levelZeroSlowdownWritesTrigger() {
        return this.levelZeroSlowdownWritesTrigger(this.nativeHandle_);
    }

    private native int levelZeroSlowdownWritesTrigger(long var1);

    public Options setLevelZeroSlowdownWritesTrigger(int n) {
        this.setLevelZeroSlowdownWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    private native void setLevelZeroSlowdownWritesTrigger(long var1, int var3);

    public int levelZeroStopWritesTrigger() {
        return this.levelZeroStopWritesTrigger(this.nativeHandle_);
    }

    private native int levelZeroStopWritesTrigger(long var1);

    public Options setLevelZeroStopWritesTrigger(int n) {
        this.setLevelZeroStopWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    private native void setLevelZeroStopWritesTrigger(long var1, int var3);

    public int maxMemCompactionLevel() {
        return this.maxMemCompactionLevel(this.nativeHandle_);
    }

    private native int maxMemCompactionLevel(long var1);

    public Options setMaxMemCompactionLevel(int n) {
        this.setMaxMemCompactionLevel(this.nativeHandle_, n);
        return this;
    }

    private native void setMaxMemCompactionLevel(long var1, int var3);

    public int targetFileSizeBase() {
        return this.targetFileSizeBase(this.nativeHandle_);
    }

    private native int targetFileSizeBase(long var1);

    public Options setTargetFileSizeBase(int n) {
        this.setTargetFileSizeBase(this.nativeHandle_, n);
        return this;
    }

    private native void setTargetFileSizeBase(long var1, int var3);

    public int targetFileSizeMultiplier() {
        return this.targetFileSizeMultiplier(this.nativeHandle_);
    }

    private native int targetFileSizeMultiplier(long var1);

    public Options setTargetFileSizeMultiplier(int n) {
        this.setTargetFileSizeMultiplier(this.nativeHandle_, n);
        return this;
    }

    private native void setTargetFileSizeMultiplier(long var1, int var3);

    public long maxBytesForLevelBase() {
        return this.maxBytesForLevelBase(this.nativeHandle_);
    }

    private native long maxBytesForLevelBase(long var1);

    public Options setMaxBytesForLevelBase(long l) {
        this.setMaxBytesForLevelBase(this.nativeHandle_, l);
        return this;
    }

    private native void setMaxBytesForLevelBase(long var1, long var3);

    public int maxBytesForLevelMultiplier() {
        return this.maxBytesForLevelMultiplier(this.nativeHandle_);
    }

    private native int maxBytesForLevelMultiplier(long var1);

    public Options setMaxBytesForLevelMultiplier(int n) {
        this.setMaxBytesForLevelMultiplier(this.nativeHandle_, n);
        return this;
    }

    private native void setMaxBytesForLevelMultiplier(long var1, int var3);

    public int expandedCompactionFactor() {
        return this.expandedCompactionFactor(this.nativeHandle_);
    }

    private native int expandedCompactionFactor(long var1);

    public Options setExpandedCompactionFactor(int n) {
        this.setExpandedCompactionFactor(this.nativeHandle_, n);
        return this;
    }

    private native void setExpandedCompactionFactor(long var1, int var3);

    public int sourceCompactionFactor() {
        return this.sourceCompactionFactor(this.nativeHandle_);
    }

    private native int sourceCompactionFactor(long var1);

    public Options setSourceCompactionFactor(int n) {
        this.setSourceCompactionFactor(this.nativeHandle_, n);
        return this;
    }

    private native void setSourceCompactionFactor(long var1, int var3);

    public int maxGrandparentOverlapFactor() {
        return this.maxGrandparentOverlapFactor(this.nativeHandle_);
    }

    private native int maxGrandparentOverlapFactor(long var1);

    public Options setMaxGrandparentOverlapFactor(int n) {
        this.setMaxGrandparentOverlapFactor(this.nativeHandle_, n);
        return this;
    }

    private native void setMaxGrandparentOverlapFactor(long var1, int var3);

    public double softRateLimit() {
        return this.softRateLimit(this.nativeHandle_);
    }

    private native double softRateLimit(long var1);

    public Options setSoftRateLimit(double d) {
        this.setSoftRateLimit(this.nativeHandle_, d);
        return this;
    }

    private native void setSoftRateLimit(long var1, double var3);

    public double hardRateLimit() {
        return this.hardRateLimit(this.nativeHandle_);
    }

    private native double hardRateLimit(long var1);

    public Options setHardRateLimit(double d) {
        this.setHardRateLimit(this.nativeHandle_, d);
        return this;
    }

    private native void setHardRateLimit(long var1, double var3);

    public int rateLimitDelayMaxMilliseconds() {
        return this.rateLimitDelayMaxMilliseconds(this.nativeHandle_);
    }

    private native int rateLimitDelayMaxMilliseconds(long var1);

    public Options setRateLimitDelayMaxMilliseconds(int n) {
        this.setRateLimitDelayMaxMilliseconds(this.nativeHandle_, n);
        return this;
    }

    private native void setRateLimitDelayMaxMilliseconds(long var1, int var3);

    public boolean noBlockCache() {
        return this.noBlockCache(this.nativeHandle_);
    }

    private native boolean noBlockCache(long var1);

    public Options setNoBlockCache(boolean bl) {
        this.setNoBlockCache(this.nativeHandle_, bl);
        return this;
    }

    private native void setNoBlockCache(long var1, boolean var3);

    public long arenaBlockSize() {
        return this.arenaBlockSize(this.nativeHandle_);
    }

    private native long arenaBlockSize(long var1);

    public Options setArenaBlockSize(long l) {
        this.setArenaBlockSize(this.nativeHandle_, l);
        return this;
    }

    private native void setArenaBlockSize(long var1, long var3);

    public boolean disableAutoCompactions() {
        return this.disableAutoCompactions(this.nativeHandle_);
    }

    private native boolean disableAutoCompactions(long var1);

    public Options setDisableAutoCompactions(boolean bl) {
        this.setDisableAutoCompactions(this.nativeHandle_, bl);
        return this;
    }

    private native void setDisableAutoCompactions(long var1, boolean var3);

    public boolean purgeRedundantKvsWhileFlush() {
        return this.purgeRedundantKvsWhileFlush(this.nativeHandle_);
    }

    private native boolean purgeRedundantKvsWhileFlush(long var1);

    public Options setPurgeRedundantKvsWhileFlush(boolean bl) {
        this.setPurgeRedundantKvsWhileFlush(this.nativeHandle_, bl);
        return this;
    }

    private native void setPurgeRedundantKvsWhileFlush(long var1, boolean var3);

    public int blockSizeDeviation() {
        return this.blockSizeDeviation(this.nativeHandle_);
    }

    private native int blockSizeDeviation(long var1);

    public Options setBlockSizeDeviation(int n) {
        this.setBlockSizeDeviation(this.nativeHandle_, n);
        return this;
    }

    private native void setBlockSizeDeviation(long var1, int var3);

    public boolean verifyChecksumsInCompaction() {
        return this.verifyChecksumsInCompaction(this.nativeHandle_);
    }

    private native boolean verifyChecksumsInCompaction(long var1);

    public Options setVerifyChecksumsInCompaction(boolean bl) {
        this.setVerifyChecksumsInCompaction(this.nativeHandle_, bl);
        return this;
    }

    private native void setVerifyChecksumsInCompaction(long var1, boolean var3);

    public boolean filterDeletes() {
        return this.filterDeletes(this.nativeHandle_);
    }

    private native boolean filterDeletes(long var1);

    public Options setFilterDeletes(boolean bl) {
        this.setFilterDeletes(this.nativeHandle_, bl);
        return this;
    }

    private native void setFilterDeletes(long var1, boolean var3);

    public long maxSequentialSkipInIterations() {
        return this.maxSequentialSkipInIterations(this.nativeHandle_);
    }

    private native long maxSequentialSkipInIterations(long var1);

    public Options setMaxSequentialSkipInIterations(long l) {
        this.setMaxSequentialSkipInIterations(this.nativeHandle_, l);
        return this;
    }

    private native void setMaxSequentialSkipInIterations(long var1, long var3);

    public boolean inplaceUpdateSupport() {
        return this.inplaceUpdateSupport(this.nativeHandle_);
    }

    private native boolean inplaceUpdateSupport(long var1);

    public Options setInplaceUpdateSupport(boolean bl) {
        this.setInplaceUpdateSupport(this.nativeHandle_, bl);
        return this;
    }

    private native void setInplaceUpdateSupport(long var1, boolean var3);

    public long inplaceUpdateNumLocks() {
        return this.inplaceUpdateNumLocks(this.nativeHandle_);
    }

    private native long inplaceUpdateNumLocks(long var1);

    public Options setInplaceUpdateNumLocks(long l) {
        this.setInplaceUpdateNumLocks(this.nativeHandle_, l);
        return this;
    }

    private native void setInplaceUpdateNumLocks(long var1, long var3);

    public int memtablePrefixBloomBits() {
        return this.memtablePrefixBloomBits(this.nativeHandle_);
    }

    private native int memtablePrefixBloomBits(long var1);

    public Options setMemtablePrefixBloomBits(int n) {
        this.setMemtablePrefixBloomBits(this.nativeHandle_, n);
        return this;
    }

    private native void setMemtablePrefixBloomBits(long var1, int var3);

    public int memtablePrefixBloomProbes() {
        return this.memtablePrefixBloomProbes(this.nativeHandle_);
    }

    private native int memtablePrefixBloomProbes(long var1);

    public Options setMemtablePrefixBloomProbes(int n) {
        this.setMemtablePrefixBloomProbes(this.nativeHandle_, n);
        return this;
    }

    private native void setMemtablePrefixBloomProbes(long var1, int var3);

    public int bloomLocality() {
        return this.bloomLocality(this.nativeHandle_);
    }

    private native int bloomLocality(long var1);

    public Options setBloomLocality(int n) {
        this.setBloomLocality(this.nativeHandle_, n);
        return this;
    }

    private native void setBloomLocality(long var1, int var3);

    public long maxSuccessiveMerges() {
        return this.maxSuccessiveMerges(this.nativeHandle_);
    }

    private native long maxSuccessiveMerges(long var1);

    public Options setMaxSuccessiveMerges(long l) {
        this.setMaxSuccessiveMerges(this.nativeHandle_, l);
        return this;
    }

    private native void setMaxSuccessiveMerges(long var1, long var3);

    public int minWriteBufferNumberToMerge() {
        return this.minWriteBufferNumberToMerge(this.nativeHandle_);
    }

    private native int minWriteBufferNumberToMerge(long var1);

    public Options setMinWriteBufferNumberToMerge(int n) {
        this.setMinWriteBufferNumberToMerge(this.nativeHandle_, n);
        return this;
    }

    private native void setMinWriteBufferNumberToMerge(long var1, int var3);

    public int minPartialMergeOperands() {
        return this.minPartialMergeOperands(this.nativeHandle_);
    }

    private native int minPartialMergeOperands(long var1);

    public Options setMinPartialMergeOperands(int n) {
        this.setMinPartialMergeOperands(this.nativeHandle_, n);
        return this;
    }

    private native void setMinPartialMergeOperands(long var1, int var3);

    @Override
    protected void disposeInternal() {
        assert (this.isInitialized());
        this.disposeInternal(this.nativeHandle_);
    }

    private native void newOptions();

    private native void disposeInternal(long var1);

    private native void setCreateIfMissing(long var1, boolean var3);

    private native boolean createIfMissing(long var1);

    private native void setWriteBufferSize(long var1, long var3);

    private native long writeBufferSize(long var1);

    private native void setMaxWriteBufferNumber(long var1, int var3);

    private native int maxWriteBufferNumber(long var1);

    private native void setBlockSize(long var1, long var3);

    private native long blockSize(long var1);

    private native void setDisableSeekCompaction(long var1, boolean var3);

    private native boolean disableSeekCompaction(long var1);

    private native void setMaxBackgroundCompactions(long var1, int var3);

    private native int maxBackgroundCompactions(long var1);

    private native void createStatistics(long var1);

    private native long statisticsPtr(long var1);

    private native void setMemTableFactory(long var1, long var3);

    private native String memTableFactoryName(long var1);

    private native void setTableFactory(long var1, long var3);

    private native String tableFactoryName(long var1);

    private native void useFixedLengthPrefixExtractor(long var1, int var3);
}

