/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.ByteBuffer;
import org.rocksdb.AbstractSlice;

public class DirectSlice
extends AbstractSlice<ByteBuffer> {
    public static final DirectSlice NONE = new DirectSlice();

    DirectSlice() {
        this.disOwnNativeHandle();
    }

    public DirectSlice(String string) {
        this.createNewSliceFromString(string);
    }

    public DirectSlice(ByteBuffer byteBuffer, int n) {
        assert (byteBuffer.isDirect());
        this.createNewDirectSlice0(byteBuffer, n);
    }

    public DirectSlice(ByteBuffer byteBuffer) {
        assert (byteBuffer.isDirect());
        this.createNewDirectSlice1(byteBuffer);
    }

    public byte get(int n) {
        assert (this.isInitialized());
        return this.get0(this.nativeHandle_, n);
    }

    public void clear() {
        assert (this.isInitialized());
        this.clear0(this.nativeHandle_);
    }

    public void removePrefix(int n) {
        assert (this.isInitialized());
        this.removePrefix0(this.nativeHandle_, n);
    }

    private native void createNewDirectSlice0(ByteBuffer var1, int var2);

    private native void createNewDirectSlice1(ByteBuffer var1);

    @Override
    protected final native ByteBuffer data0(long var1);

    private native byte get0(long var1, int var3);

    private native void clear0(long var1);

    private native void removePrefix0(long var1, int var3);
}

