/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.UnsupportedEncodingException;
import org.rocksdb.RocksDB;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchInternal;

public class WriteBatchTest {
    public static void main(String[] stringArray) {
        System.out.println("Testing WriteBatchTest.Empty ===");
        WriteBatchTest.Empty();
        System.out.println("Testing WriteBatchTest.Multiple ===");
        WriteBatchTest.Multiple();
        System.out.println("Testing WriteBatchTest.Append ===");
        WriteBatchTest.Append();
        System.out.println("Testing WriteBatchTest.Blob ===");
        WriteBatchTest.Blob();
        System.out.println("Passed all WriteBatchTest!");
    }

    static void Empty() {
        WriteBatch writeBatch = new WriteBatch();
        assert (writeBatch.count() == 0);
    }

    static void Multiple() {
        block5: {
            try {
                WriteBatch writeBatch = new WriteBatch();
                writeBatch.put("foo".getBytes("US-ASCII"), "bar".getBytes("US-ASCII"));
                writeBatch.remove("box".getBytes("US-ASCII"));
                writeBatch.put("baz".getBytes("US-ASCII"), "boo".getBytes("US-ASCII"));
                WriteBatchInternal.setSequence(writeBatch, 100L);
                assert (100L == WriteBatchInternal.sequence(writeBatch));
                assert (3 == writeBatch.count());
                assert (new String("Put(baz, boo)@102Delete(box)@101Put(foo, bar)@100").equals(new String(WriteBatchTest.getContents(writeBatch), "US-ASCII")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println(unsupportedEncodingException);
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    static void Append() {
        block10: {
            WriteBatch writeBatch = new WriteBatch();
            WriteBatch writeBatch2 = new WriteBatch();
            WriteBatchInternal.setSequence(writeBatch, 200L);
            WriteBatchInternal.setSequence(writeBatch2, 300L);
            WriteBatchInternal.append(writeBatch, writeBatch2);
            assert (WriteBatchTest.getContents(writeBatch).length == 0);
            assert (writeBatch.count() == 0);
            try {
                writeBatch2.put("a".getBytes("US-ASCII"), "va".getBytes("US-ASCII"));
                WriteBatchInternal.append(writeBatch, writeBatch2);
                assert ("Put(a, va)@200".equals(new String(WriteBatchTest.getContents(writeBatch), "US-ASCII")));
                assert (1 == writeBatch.count());
                writeBatch2.clear();
                writeBatch2.put("b".getBytes("US-ASCII"), "vb".getBytes("US-ASCII"));
                WriteBatchInternal.append(writeBatch, writeBatch2);
                assert (new String("Put(a, va)@200Put(b, vb)@201").equals(new String(WriteBatchTest.getContents(writeBatch), "US-ASCII")));
                assert (2 == writeBatch.count());
                writeBatch2.remove("foo".getBytes("US-ASCII"));
                WriteBatchInternal.append(writeBatch, writeBatch2);
                assert (new String("Put(a, va)@200Put(b, vb)@202Put(b, vb)@201Delete(foo)@203").equals(new String(WriteBatchTest.getContents(writeBatch), "US-ASCII")));
                assert (4 == writeBatch.count());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println(unsupportedEncodingException);
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
    }

    static void Blob() {
        block4: {
            WriteBatch writeBatch = new WriteBatch();
            try {
                writeBatch.put("k1".getBytes("US-ASCII"), "v1".getBytes("US-ASCII"));
                writeBatch.put("k2".getBytes("US-ASCII"), "v2".getBytes("US-ASCII"));
                writeBatch.put("k3".getBytes("US-ASCII"), "v3".getBytes("US-ASCII"));
                writeBatch.putLogData("blob1".getBytes("US-ASCII"));
                writeBatch.remove("k2".getBytes("US-ASCII"));
                writeBatch.putLogData("blob2".getBytes("US-ASCII"));
                writeBatch.merge("foo".getBytes("US-ASCII"), "bar".getBytes("US-ASCII"));
                assert (5 == writeBatch.count());
                assert (new String("Merge(foo, bar)@4Put(k1, v1)@0Delete(k2)@3Put(k2, v2)@1Put(k3, v3)@2").equals(new String(WriteBatchTest.getContents(writeBatch), "US-ASCII")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println(unsupportedEncodingException);
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    static native byte[] getContents(WriteBatch var0);

    static {
        RocksDB.loadLibrary();
    }
}

