/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._io;

import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyBuffer;
import org.python.core.PyByteArray;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.buffer.SimpleStringBuffer;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._io.Closer;
import org.python.modules._io.PyIOBase$PyExposer;
import org.python.modules._io.PyIOBaseDerived;
import org.python.modules._io._io;

@ExposedType(name="_io._IOBase", doc="The abstract base class for all I/O classes, acting on streams of\nbytes. There is no public constructor.\n\nThis class provides dummy implementations for many methods that\nderived classes can override selectively; the default implementations\nrepresent a file that cannot be read, written or seeked.\n\nEven though IOBase does not declare read, readinto, or write because\ntheir signatures will vary, implementations and clients should\nconsider those methods part of the interface. Also, implementations\nmay raise a IOError when operations they do not support are called.\n\nThe basic type used for binary data read from or written to a file is\nbytes. bytearrays are accepted too, and in some cases (such as\nreadinto) needed. Text I/O classes work with str data.\n\nNote that calling any method (even inquiries) on a closed stream is\nundefined. Implementations may raise IOError in this case.\n\nIOBase (and its subclasses) support the iterator protocol, meaning\nthat an IOBase object can be iterated over yielding the lines in a\nstream.\n\nIOBase also supports the :keyword:`with` statement. In this example,\nfp is closed after the suite of the with statement is complete:\n\nwith open('spam.txt', 'r') as fp:\n    fp.write('Spam and eggs!')\n")
public class PyIOBase
extends PyObject {
    public static final PyType TYPE;
    private Closer<PyIOBase> closer;
    protected PyStringMap __dict__ = new PyStringMap();
    protected boolean __closed;
    public static final String seek_doc = "Change stream position.\n\nChange the stream position to byte offset offset. offset is\ninterpreted relative to the position indicated by whence.  Values\nfor whence are:\n\n* 0 -- start of stream (the default); offset should be zero or positive\n* 1 -- current stream position; offset may be negative\n* 2 -- end of stream; offset is usually negative\n\nReturn the new absolute position.";
    public static final String tell_doc = "Return current stream position.";
    public static final String truncate_doc = "Truncate file to size bytes.\n\nFile pointer is left unchanged.  Size defaults to the current IO\nposition as reported by tell().  Returns the new size.";
    public static final String flush_doc = "Flush write buffers, if applicable.\n\nThis is not implemented for read-only and non-blocking streams.";
    public static final String close_doc = "Flush and close the IO object.\n\nThis method has no effect if the file is already closed.";
    public static final String closed_doc = "True if the stream is closed.\n";
    public static final String seekable_doc = "Return whether object supports random access.\n\nIf False, seek(), tell() and truncate() will raise IOError.\nThis method may need to do a test seek().";
    public static final String readable_doc = "Return whether object was opened for reading.\n\nIf False, read() will raise IOError.";
    public static final String writable_doc = "Return whether object was opened for writing.\n\nIf False, read() will raise IOError.";
    public static final String fileno_doc = "Returns underlying file descriptor if one exists.\n\nAn IOError is raised if the IO object does not use a file descriptor.\n";
    public static final String isatty_doc = "Return whether this is an 'interactive' stream.\n\nReturn False if it can't be determined.\n";
    public static final String readline_doc = "Read and return a line from the stream.\n\nIf limit is specified, at most limit bytes will be read.\n\nThe line terminator is always b'\n' for binary files; for text\nfiles, the newlines argument to open can be used to select the line\nterminator(s) recognized.\n";
    public static final String readlines_doc = "Return a list of lines from the stream.\n\nhint can be specified to control the number of lines read: no more\nlines will be read if the total size (in bytes/characters) of all\nlines so far exceeds hint.";
    public static final String writelines_doc = "Write a list of lines to the stream. Line separators are not added,\nso it is usual for each of the lines provided to have a line separator\nat the end.";
    static final String doc = "The abstract base class for all I/O classes, acting on streams of\nbytes. There is no public constructor.\n\nThis class provides dummy implementations for many methods that\nderived classes can override selectively; the default implementations\nrepresent a file that cannot be read, written or seeked.\n\nEven though IOBase does not declare read, readinto, or write because\ntheir signatures will vary, implementations and clients should\nconsider those methods part of the interface. Also, implementations\nmay raise a IOError when operations they do not support are called.\n\nThe basic type used for binary data read from or written to a file is\nbytes. bytearrays are accepted too, and in some cases (such as\nreadinto) needed. Text I/O classes work with str data.\n\nNote that calling any method (even inquiries) on a closed stream is\nundefined. Implementations may raise IOError in this case.\n\nIOBase (and its subclasses) support the iterator protocol, meaning\nthat an IOBase object can be iterated over yielding the lines in a\nstream.\n\nIOBase also supports the :keyword:`with` statement. In this example,\nfp is closed after the suite of the with statement is complete:\n\nwith open('spam.txt', 'r') as fp:\n    fp.write('Spam and eggs!')\n";

    protected PyIOBase() {
        this(TYPE);
    }

    protected PyIOBase(PyType subtype) {
        super(subtype);
        this.closer = new Closer<PyIOBase>(this, Py.getSystemState());
    }

    @Override
    public PyStringMap fastGetDict() {
        return this.__dict__;
    }

    @ExposedNew
    static PyObject _IOBase___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (new_.for_type == subtype) {
            return new PyIOBase();
        }
        return new PyIOBaseDerived(subtype);
    }

    protected PyException unsupported(String op) {
        String fmt = "%s.%s() not supported";
        String msg = String.format(fmt, this.getType().fastGetName(), op);
        return _io.UnsupportedOperation(msg);
    }

    final void _IOBase__unsupported(String name) {
        throw this.unsupported(name);
    }

    public long seek(long pos, int whence) {
        return this._IOBase_seek(pos, whence);
    }

    public final long seek(long pos) {
        return this.seek(pos, 0);
    }

    final long _IOBase_seek(long pos, int whence) {
        throw this.unsupported("seek");
    }

    public long tell() {
        return this._IOBase_tell();
    }

    final long _IOBase_tell() {
        return this.seek(0L, 1);
    }

    public long truncate(long size) {
        return this._IOBase_truncate(null);
    }

    public long truncate() {
        return this._IOBase_truncate(null);
    }

    final long _IOBase_truncate(PyObject size) {
        throw this.unsupported("truncate");
    }

    public void flush() {
        this._IOBase_flush();
    }

    final void _IOBase_flush() {
        this._checkClosed();
    }

    public final void closed_readonly(boolean value) {
        this.readonlyAttributeError("closed");
    }

    public void close() {
        this._IOBase_close();
    }

    final void _IOBase_close() {
        if (!this.__closed) {
            try {
                this.closer.dismiss();
                this.invoke("flush");
            }
            finally {
                this.__closed = true;
            }
        }
    }

    public boolean seekable() throws PyException {
        return this._IOBase_seekable();
    }

    final boolean _IOBase_seekable() throws PyException {
        return false;
    }

    public void _checkSeekable(String msg) {
        this._IOBase__checkSeekable(msg);
    }

    public final void _checkSeekable() {
        this._checkSeekable(null);
    }

    final void _IOBase__checkSeekable(String msg) {
        if (!this.invoke("seekable").__nonzero__()) {
            throw PyIOBase.tailoredIOError(msg, "seek");
        }
    }

    public boolean readable() throws PyException {
        return this._IOBase_readable();
    }

    final boolean _IOBase_readable() throws PyException {
        return false;
    }

    public void _checkReadable(String msg) {
        this._IOBase__checkReadable(msg);
    }

    public final void _checkReadable() {
        this._checkReadable(null);
    }

    final void _IOBase__checkReadable(String msg) {
        if (!this.invoke("readable").__nonzero__()) {
            throw PyIOBase.tailoredIOError(msg, "read");
        }
    }

    public boolean writable() throws PyException {
        return this._IOBase_writable();
    }

    final boolean _IOBase_writable() throws PyException {
        return false;
    }

    public void _checkWritable(String msg) throws PyException {
        this._IOBase__checkWritable(msg);
    }

    public final void _checkWritable() throws PyException {
        this._checkWritable(null);
    }

    final void _IOBase__checkWritable(String msg) throws PyException {
        if (!this.invoke("writable").__nonzero__()) {
            throw PyIOBase.tailoredIOError(msg, "writ");
        }
    }

    public final boolean closed() {
        return this.__closed;
    }

    public void _checkClosed(String msg) throws PyException {
        this._IOBase__checkClosed(msg);
    }

    public final void _checkClosed() throws PyException {
        this._checkClosed(null);
    }

    final void _IOBase__checkClosed(String msg) throws PyException {
        if (this.closed()) {
            throw Py.ValueError(msg != null ? msg : "I/O operation on closed file");
        }
    }

    public PyObject __enter__() {
        return this._IOBase___enter__();
    }

    final PyObject _IOBase___enter__() {
        this._checkClosed();
        return this;
    }

    public boolean __exit__(PyObject type, PyObject value, PyObject traceback) {
        return this._IOBase___exit__(type, value, traceback);
    }

    final boolean _IOBase___exit__(PyObject type, PyObject value, PyObject traceback) {
        this.invoke("close");
        return false;
    }

    public PyObject fileno() {
        return this._IOBase_fileno();
    }

    final PyObject _IOBase_fileno() {
        throw this.unsupported("fileno");
    }

    public boolean isatty() {
        return this._IOBase_isatty();
    }

    final boolean _IOBase_isatty() {
        this._checkClosed();
        return false;
    }

    public PyObject readline(int limit) {
        return this._readline(limit);
    }

    public PyObject readline() {
        return this._readline(-1);
    }

    final PyObject _IOBase_readline(PyObject limit) {
        if (limit == null || limit == Py.None) {
            return this._readline(-1);
        }
        if (limit.isIndex()) {
            return this._readline(limit.asInt());
        }
        throw PyIOBase.tailoredTypeError("integer limit", limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PyObject _readline(int limit) {
        int remainingLimit;
        PyObject peekMethod = this.__findattr__("peek");
        PyObject readMethod = this.__getattr__("read");
        int n = remainingLimit = limit >= 0 ? limit : Integer.MAX_VALUE;
        if (peekMethod != null) {
            PyList list = null;
            PyObject curr = Py.EmptyString;
            while (remainingLimit > 0) {
                PyObject peekResult;
                if (((PyObject)curr).__nonzero__()) {
                    if (list == null) {
                        list = new PyList();
                    }
                    list.add(curr);
                }
                if ((peekResult = peekMethod.__call__(Py.One)).__nonzero__()) {
                    PyBuffer peekBuffer = PyIOBase.readablePyBuffer(peekResult);
                    try {
                        int p = 0;
                        int nr = peekBuffer.getLen();
                        if (nr > remainingLimit) {
                            nr = remainingLimit;
                        }
                        while (p < nr) {
                            if (peekBuffer.byteAt(p++) != 10) continue;
                            remainingLimit = p;
                            break;
                        }
                        curr = readMethod.__call__(Py.newInteger(p));
                        remainingLimit -= p;
                        continue;
                    }
                    finally {
                        peekBuffer.release();
                        continue;
                    }
                }
                curr = Py.EmptyString;
                remainingLimit = 0;
            }
            if (list == null) {
                return curr;
            }
            if (((PyObject)curr).__nonzero__()) {
                list.add(curr);
            }
            return Py.EmptyString.join(list);
        }
        PyByteArray res = new PyByteArray();
        while (--remainingLimit >= 0) {
            PyObject curr = readMethod.__call__(Py.One);
            if (curr.__nonzero__()) {
                if (curr instanceof PyString) {
                    char c = ((PyString)curr).getString().charAt(0);
                    if (c == '\n') {
                        remainingLimit = 0;
                    }
                    res.append((byte)c);
                    continue;
                }
                String fmt = "read() should have returned a bytes object, not '%.200s'";
                throw Py.IOError(String.format(fmt, curr.getType().fastGetName()));
            }
            remainingLimit = 0;
        }
        return res.__str__();
    }

    @Override
    public PyObject __iter__() {
        this._checkClosed();
        return this;
    }

    @Override
    public PyObject __iternext__() {
        PyObject line = this.invoke("readline");
        return !line.__nonzero__() ? null : line;
    }

    public PyObject next() throws PyException {
        return this._IOBase_next();
    }

    final PyObject _IOBase_next() throws PyException {
        PyObject line = this.invoke("readline");
        if (!line.__nonzero__()) {
            throw Py.StopIteration("");
        }
        return line;
    }

    public PyObject readlines(PyObject hint) {
        return this._IOBase_readlines(hint);
    }

    final PyObject _IOBase_readlines(PyObject hint) {
        int h = 0;
        if (hint == null || hint == Py.None) {
            return new PyList(this);
        }
        if (!hint.isIndex()) {
            throw PyIOBase.tailoredTypeError("integer or None", hint);
        }
        h = hint.asIndex();
        if (h <= 0) {
            return new PyList(this);
        }
        int n = 0;
        PyList lines = new PyList();
        for (PyObject line : this.asIterable()) {
            lines.append(line);
            if ((n += line.__len__()) < h) continue;
            break;
        }
        return lines;
    }

    public void writelines(PyObject lines) {
        this._IOBase_writelines(lines);
    }

    final void _IOBase_writelines(PyObject lines) {
        this._checkClosed();
        PyObject writeMethod = this.__getattr__("write");
        for (PyObject line : lines.asIterable()) {
            writeMethod.__call__(line);
        }
    }

    protected void finalize() throws Throwable {
        this.closer.dismiss();
        this.invoke("close");
        super.finalize();
    }

    private static PyException tailoredIOError(String msg, String oper) {
        if (msg == null) {
            return Py.IOError("File or stream is not " + oper + "able.");
        }
        return Py.IOError(msg);
    }

    protected static PyBuffer readablePyBuffer(PyObject obj) throws PyException {
        String s;
        if (obj instanceof BufferProtocol) {
            try {
                return ((BufferProtocol)((Object)obj)).getBuffer(0);
            }
            catch (PyException pye) {
                if (pye.match(Py.BufferError)) {
                    throw Py.TypeError(String.format("(BufferError) %s", pye.getMessage()));
                }
                throw pye;
            }
        }
        if (obj instanceof PyUnicode) {
            s = ((PyUnicode)obj).encode();
        } else if (obj instanceof PyArray) {
            s = ((PyArray)obj).tostring();
        } else {
            throw PyIOBase.tailoredTypeError("read-write buffer", obj);
        }
        return new SimpleStringBuffer(0, s);
    }

    protected static PyBuffer writablePyBuffer(PyObject obj) throws PyException {
        if (obj instanceof BufferProtocol) {
            try {
                return ((BufferProtocol)((Object)obj)).getBuffer(1);
            }
            catch (PyException pye) {
                if (pye.match(Py.BufferError)) {
                    throw Py.TypeError(String.format("(BufferError) %s", pye.getMessage()));
                }
                throw pye;
            }
        }
        throw PyIOBase.tailoredTypeError("read-write buffer", obj);
    }

    protected static PyException tailoredTypeError(String type, PyObject arg) {
        return Py.TypeError(String.format("%s argument expected, got %.100s.", type, arg.getType().fastGetName()));
    }

    static {
        PyType.addBuilder(PyIOBase.class, new PyIOBase$PyExposer());
        TYPE = PyType.fromClass(PyIOBase.class);
    }
}

