/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.codec.protobuf;

import java.util.List;
import org.python.google.protobuf.nano.MessageNano;
import org.python.netty.buffer.ByteBuf;
import org.python.netty.channel.ChannelHandler;
import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.handler.codec.MessageToMessageDecoder;
import org.python.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ProtobufDecoderNano
extends MessageToMessageDecoder<ByteBuf> {
    private final Class<? extends MessageNano> clazz;

    public ProtobufDecoderNano(Class<? extends MessageNano> clazz) {
        this.clazz = ObjectUtil.checkNotNull(clazz, "You must provide a Class");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg2, List<Object> out) throws Exception {
        int offset;
        byte[] array;
        int length = msg2.readableBytes();
        if (msg2.hasArray()) {
            array = msg2.array();
            offset = msg2.arrayOffset() + msg2.readerIndex();
        } else {
            array = new byte[length];
            msg2.getBytes(msg2.readerIndex(), array, 0, length);
            offset = 0;
        }
        MessageNano prototype = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        out.add(MessageNano.mergeFrom((MessageNano)prototype, (byte[])array, (int)offset, (int)length));
    }
}

