/*
 * Decompiled with CFR 0.152.
 */
package org.python.jsr223;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Arrays;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import junit.framework.TestCase;
import org.junit.Assert;
import org.python.core.Options;
import org.python.core.PyString;

public class ScriptEngineTest
extends TestCase {
    public void testEvalString() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        ScriptContext context = pythonEngine.getContext();
        context.setAttribute("javax.script.filename", "sample.py", 100);
        ScriptEngineTest.assertNull((Object)pythonEngine.eval("x = 5"));
        ScriptEngineTest.assertEquals((Object)5, (Object)pythonEngine.eval("x"));
        ScriptEngineTest.assertEquals((Object)"sample.py", (Object)pythonEngine.eval("__file__"));
        pythonEngine.eval("import sys");
        ScriptEngineTest.assertEquals(Arrays.asList("sample.py"), (Object)pythonEngine.eval("sys.argv"));
    }

    public void testEvalStringArgv() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        ScriptContext context = pythonEngine.getContext();
        context.setAttribute("javax.script.filename", "sample.py", 100);
        context.setAttribute("javax.script.argv", new String[]{"foo", "bar"}, 100);
        ScriptEngineTest.assertNull((Object)pythonEngine.eval("x = 5"));
        ScriptEngineTest.assertEquals((Object)5, (Object)pythonEngine.eval("x"));
        ScriptEngineTest.assertEquals((Object)"sample.py", (Object)pythonEngine.eval("__file__"));
        pythonEngine.eval("import sys");
        ScriptEngineTest.assertEquals(Arrays.asList("sample.py", "foo", "bar"), (Object)pythonEngine.eval("sys.argv"));
    }

    public void testEvalStringNoFilenameWithArgv() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        ScriptContext context = pythonEngine.getContext();
        context.setAttribute("javax.script.argv", new String[]{"foo", "bar"}, 100);
        ScriptEngineTest.assertNull((Object)pythonEngine.eval("x = 5"));
        ScriptEngineTest.assertEquals((Object)5, (Object)pythonEngine.eval("x"));
        boolean gotExpectedException = false;
        try {
            pythonEngine.eval("__file__");
        }
        catch (ScriptException e) {
            ScriptEngineTest.assertTrue((boolean)e.getMessage().startsWith("NameError: "));
            gotExpectedException = true;
        }
        if (!gotExpectedException) {
            ScriptEngineTest.fail((String)"Excepted __file__ to be undefined");
        }
        pythonEngine.eval("import sys");
        ScriptEngineTest.assertEquals(Arrays.asList("foo", "bar"), (Object)pythonEngine.eval("sys.argv"));
    }

    public void testSyntaxError() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        try {
            pythonEngine.eval("5q");
        }
        catch (ScriptException e) {
            ScriptEngineTest.assertEquals((int)e.getColumnNumber(), (int)1);
            ScriptEngineTest.assertEquals((int)e.getLineNumber(), (int)1);
            ScriptEngineTest.assertTrue((boolean)e.getMessage().startsWith("SyntaxError: "));
            return;
        }
        ScriptEngineTest.assertTrue((String)"Expected a ScriptException", (boolean)false);
    }

    public void testPythonException() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        try {
            pythonEngine.eval("pass\ndel undefined");
        }
        catch (ScriptException e) {
            ScriptEngineTest.assertEquals((int)e.getLineNumber(), (int)2);
            ScriptEngineTest.assertTrue((boolean)e.getMessage().startsWith("NameError: "));
            return;
        }
        ScriptEngineTest.assertTrue((String)"Expected a ScriptException", (boolean)false);
    }

    public void testScriptFilename() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute("javax.script.filename", "sample.py", 100);
        try {
            pythonEngine.eval("foo", (ScriptContext)scriptContext);
        }
        catch (ScriptException e) {
            ScriptEngineTest.assertEquals((String)"sample.py", (String)e.getFileName());
            return;
        }
        ScriptEngineTest.assertTrue((String)"Expected a ScriptException", (boolean)false);
    }

    public void testCompileEvalString() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        ScriptContext context = pythonEngine.getContext();
        context.setAttribute("javax.script.filename", "sample.py", 100);
        CompiledScript five = ((Compilable)((Object)pythonEngine)).compile("5");
        ScriptEngineTest.assertEquals((Object)5, (Object)five.eval());
        ScriptEngineTest.assertEquals((Object)"sample.py", (Object)pythonEngine.eval("__file__"));
        pythonEngine.eval("import sys");
        ScriptEngineTest.assertEquals(Arrays.asList("sample.py"), (Object)pythonEngine.eval("sys.argv"));
    }

    public void testEvalReader() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        ScriptContext context = pythonEngine.getContext();
        context.setAttribute("javax.script.filename", "sample.py", 100);
        ScriptEngineTest.assertNull((Object)pythonEngine.eval(new StringReader("x = 5")));
        ScriptEngineTest.assertEquals((Object)5, (Object)pythonEngine.eval(new StringReader("x")));
        ScriptEngineTest.assertEquals((Object)"sample.py", (Object)pythonEngine.eval("__file__"));
        pythonEngine.eval("import sys");
        ScriptEngineTest.assertEquals(Arrays.asList("sample.py"), (Object)pythonEngine.eval("sys.argv"));
    }

    public void testCompileEvalReader() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        ScriptContext context = pythonEngine.getContext();
        context.setAttribute("javax.script.filename", "sample.py", 100);
        CompiledScript five = ((Compilable)((Object)pythonEngine)).compile(new StringReader("5"));
        ScriptEngineTest.assertEquals((Object)5, (Object)five.eval());
        ScriptEngineTest.assertEquals((Object)"sample.py", (Object)pythonEngine.eval("__file__"));
        pythonEngine.eval("import sys");
        ScriptEngineTest.assertEquals(Arrays.asList("sample.py"), (Object)pythonEngine.eval("sys.argv"));
    }

    public void testBindings() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        pythonEngine.put("a", 42);
        ScriptEngineTest.assertEquals((Object)42, (Object)pythonEngine.eval("a"));
        ScriptEngineTest.assertNull((Object)pythonEngine.eval("x = 5"));
        ScriptEngineTest.assertEquals((Object)5, (Object)pythonEngine.get("x"));
        ScriptEngineTest.assertNull((Object)pythonEngine.eval("del x"));
        ScriptEngineTest.assertNull((Object)pythonEngine.get("x"));
    }

    public void testThreadLocalBindings() throws ScriptException, InterruptedException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        pythonEngine.put("a", 42);
        pythonEngine.put("x", 15);
        ThreadLocalBindingsTest test = new ThreadLocalBindingsTest(pythonEngine);
        Thread thread2 = new Thread(test);
        thread2.run();
        thread2.join();
        ScriptEngineTest.assertNull((Object)test.exception);
        ScriptEngineTest.assertEquals((Object)-7, (Object)test.x);
        ScriptEngineTest.assertEquals((Object)15, (Object)pythonEngine.get("x"));
        ScriptEngineTest.assertNull((Object)pythonEngine.eval("del x"));
        ScriptEngineTest.assertNull((Object)pythonEngine.get("x"));
    }

    public void testInvoke() throws ScriptException, NoSuchMethodException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        Invocable invocableEngine = (Invocable)((Object)pythonEngine);
        ScriptEngineTest.assertNull((Object)pythonEngine.eval("def f(x): return abs(x)"));
        ScriptEngineTest.assertEquals((Object)5, (Object)invocableEngine.invokeFunction("f", -5));
        ScriptEngineTest.assertEquals((Object)"spam", (Object)invocableEngine.invokeMethod(new PyString("  spam  "), "strip", new Object[0]));
        ScriptEngineTest.assertEquals((Object)"spam", (Object)invocableEngine.invokeMethod("  spam  ", "strip", new Object[0]));
    }

    public void testInvokeFunctionNoSuchMethod() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        Invocable invocableEngine = (Invocable)((Object)manager.getEngineByName("python"));
        try {
            invocableEngine.invokeFunction("undefined", new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        ScriptEngineTest.assertTrue((String)"Expected a NoSuchMethodException", (boolean)false);
    }

    public void testInvokeMethodNoSuchMethod() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        Invocable invocableEngine = (Invocable)((Object)manager.getEngineByName("python"));
        try {
            invocableEngine.invokeMethod("eggs", "undefined", new Object[0]);
            ScriptEngineTest.fail((String)"Expected a NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            ScriptEngineTest.assertEquals((String)"undefined", (String)e.getMessage());
        }
    }

    public void testGetInterface() throws ScriptException, IOException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        Invocable invocableEngine = (Invocable)((Object)pythonEngine);
        ScriptEngineTest.assertNull((Object)pythonEngine.eval("def read(cb): return 1"));
        Readable readable = invocableEngine.getInterface(Readable.class);
        ScriptEngineTest.assertEquals((int)1, (int)readable.read(null));
        ScriptEngineTest.assertNull((Object)pythonEngine.eval("class C(object):\n    def read(self, cb): return 2\nc = C()"));
        readable = invocableEngine.getInterface(pythonEngine.get("c"), Readable.class);
        ScriptEngineTest.assertEquals((int)2, (int)readable.read(null));
    }

    public void testInvokeMethodNoSuchArgs() throws ScriptException, NoSuchMethodException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        Invocable invocableEngine = (Invocable)((Object)pythonEngine);
        Object newStringCapitalize = invocableEngine.invokeMethod("test", "capitalize", new Object[0]);
        ScriptEngineTest.assertEquals((Object)newStringCapitalize, (Object)"Test");
    }

    public void testPdb() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        String pdbString = "from pdb import set_trace; set_trace()";
        try {
            pythonEngine.eval(pdbString);
            ScriptEngineTest.fail((String)"bdb.BdbQuit expected");
        }
        catch (ScriptException e) {
            ScriptEngineTest.assertTrue((boolean)e.getMessage().startsWith("bdb.BdbQuit"));
        }
    }

    public void testScope_repr() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        pythonEngine.eval("a = 4");
        pythonEngine.eval("b = 'hi'");
        String repr = (String)pythonEngine.eval("repr(locals())");
        Assert.assertTrue((boolean)repr.contains("'a': 4"));
        Assert.assertTrue((boolean)repr.contains("'b': u'hi'"));
    }

    public void testScope_iter() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        pythonEngine.eval("a = 4");
        pythonEngine.eval("b = 'hi'");
        ScriptEngineTest.assertEquals((Object)"['__builtins__', 'a', 'b']", (Object)pythonEngine.eval("repr(sorted((item for item in locals())))"));
    }

    public void testScope_lookup() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        pythonEngine.eval("a = 4");
        pythonEngine.eval("b = 'hi'");
        pythonEngine.eval("var_a = locals()['a']");
        pythonEngine.eval("arepr = repr(var_a)");
        ScriptEngineTest.assertEquals((Object)"4", (Object)pythonEngine.get("arepr"));
    }

    public void testIssue1681() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        pythonEngine.eval("from org.python.jsr223 import PythonCallable\nclass MyPythonCallable(PythonCallable):\n    def getAString(self): return 'a string'\n\nresult = MyPythonCallable().getAString()\ntest = MyPythonCallable()\nresult2 = test.getAString()");
        ScriptEngineTest.assertEquals((Object)"a string", (Object)pythonEngine.get("result"));
        ScriptEngineTest.assertEquals((Object)"a string", (Object)pythonEngine.get("result2"));
    }

    public void testIssue1698() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        pythonEngine.eval("import warnings");
        pythonEngine.eval("warnings.warn('test')");
    }

    public void testSiteImportedByDefault() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        pythonEngine.eval("import sys");
        pythonEngine.eval("'site' in sys.modules");
    }

    public void testSiteCanBeNotImported() throws ScriptException {
        try {
            Options.importSite = false;
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine pythonEngine = manager.getEngineByName("python");
            pythonEngine.eval("import sys");
            pythonEngine.eval("'site' not in sys.modules");
        }
        finally {
            Options.importSite = true;
        }
    }

    public void testIssue2090() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        pythonEngine.eval("a = 10L\nb = a-1");
        Object r = pythonEngine.get("b");
        ScriptEngineTest.assertEquals((Object)new BigInteger("9"), (Object)r);
    }

    class ThreadLocalBindingsTest
    implements Runnable {
        ScriptEngine engine;
        Object x;
        Throwable exception;

        public ThreadLocalBindingsTest(ScriptEngine engine) {
            this.engine = engine;
        }

        @Override
        public void run() {
            try {
                Bindings bindings = this.engine.createBindings();
                junit.framework.Assert.assertNull((Object)this.engine.eval("try: a\nexcept NameError: pass\nelse: raise Exception('a is defined', a)", bindings));
                bindings.put("x", (Object)-7);
                this.x = this.engine.eval("x", bindings);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.exception = e;
            }
        }
    }
}

