/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.channel;

import org.python.netty.buffer.ByteBuf;
import org.python.netty.buffer.ByteBufAllocator;
import org.python.netty.channel.ChannelConfig;
import org.python.netty.channel.MaxMessagesRecvByteBufAllocator;
import org.python.netty.channel.RecvByteBufAllocator;

public abstract class DefaultMaxMessagesRecvByteBufAllocator
implements MaxMessagesRecvByteBufAllocator {
    private volatile int maxMessagesPerRead;

    public DefaultMaxMessagesRecvByteBufAllocator() {
        this(1);
    }

    public DefaultMaxMessagesRecvByteBufAllocator(int maxMessagesPerRead) {
        this.maxMessagesPerRead(maxMessagesPerRead);
    }

    @Override
    public int maxMessagesPerRead() {
        return this.maxMessagesPerRead;
    }

    @Override
    public MaxMessagesRecvByteBufAllocator maxMessagesPerRead(int maxMessagesPerRead) {
        if (maxMessagesPerRead <= 0) {
            throw new IllegalArgumentException("maxMessagesPerRead: " + maxMessagesPerRead + " (expected: > 0)");
        }
        this.maxMessagesPerRead = maxMessagesPerRead;
        return this;
    }

    public abstract class MaxMessageHandle
    implements RecvByteBufAllocator.Handle {
        private ChannelConfig config;
        private int maxMessagePerRead;
        private int totalMessages;
        private int totalBytesRead;
        private int attemptedBytesRead;
        private int lastBytesRead;

        @Override
        public void reset(ChannelConfig config) {
            this.config = config;
            this.maxMessagePerRead = DefaultMaxMessagesRecvByteBufAllocator.this.maxMessagesPerRead();
            this.totalBytesRead = 0;
            this.totalMessages = 0;
        }

        @Override
        public ByteBuf allocate(ByteBufAllocator alloc) {
            return alloc.ioBuffer(this.guess());
        }

        @Override
        public final void incMessagesRead(int amt) {
            this.totalMessages += amt;
        }

        @Override
        public final void lastBytesRead(int bytes) {
            this.lastBytesRead = bytes;
            this.totalBytesRead += bytes;
            if (this.totalBytesRead < 0) {
                this.totalBytesRead = Integer.MAX_VALUE;
            }
        }

        @Override
        public final int lastBytesRead() {
            return this.lastBytesRead;
        }

        @Override
        public boolean continueReading() {
            return this.config.isAutoRead() && this.attemptedBytesRead == this.lastBytesRead && this.totalMessages < this.maxMessagePerRead && this.totalBytesRead < Integer.MAX_VALUE;
        }

        @Override
        public void readComplete() {
        }

        @Override
        public int attemptedBytesRead() {
            return this.attemptedBytesRead;
        }

        @Override
        public void attemptedBytesRead(int bytes) {
            this.attemptedBytesRead = bytes;
        }

        protected final int totalBytesRead() {
            return this.totalBytesRead;
        }
    }
}

