/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.python.bouncycastle.crypto.tls.DTLSHandshakeRetransmit;
import org.python.bouncycastle.crypto.tls.DTLSReassembler;
import org.python.bouncycastle.crypto.tls.DTLSRecordLayer;
import org.python.bouncycastle.crypto.tls.DeferredHash;
import org.python.bouncycastle.crypto.tls.TlsContext;
import org.python.bouncycastle.crypto.tls.TlsFatalAlert;
import org.python.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.python.bouncycastle.crypto.tls.TlsUtils;
import org.python.bouncycastle.util.Integers;

class DTLSReliableHandshake {
    private static final int MAX_RECEIVE_AHEAD = 10;
    private final DTLSRecordLayer recordLayer;
    private TlsHandshakeHash handshakeHash;
    private Hashtable currentInboundFlight = new Hashtable();
    private Hashtable previousInboundFlight = null;
    private Vector outboundFlight = new Vector();
    private boolean sending = true;
    private int message_seq = 0;
    private int next_receive_seq = 0;

    DTLSReliableHandshake(TlsContext tlsContext, DTLSRecordLayer dTLSRecordLayer) {
        this.recordLayer = dTLSRecordLayer;
        this.handshakeHash = new DeferredHash();
        this.handshakeHash.init(tlsContext);
    }

    void notifyHelloComplete() {
        this.handshakeHash = this.handshakeHash.notifyPRFDetermined();
    }

    TlsHandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    TlsHandshakeHash prepareToFinish() {
        TlsHandshakeHash tlsHandshakeHash = this.handshakeHash;
        this.handshakeHash = this.handshakeHash.stopTracking();
        return tlsHandshakeHash;
    }

    void sendMessage(short s, byte[] byArray) throws IOException {
        TlsUtils.checkUint24(byArray.length);
        if (!this.sending) {
            this.checkInboundFlight();
            this.sending = true;
            this.outboundFlight.removeAllElements();
        }
        Message message = new Message(this.message_seq++, s, byArray);
        this.outboundFlight.addElement(message);
        this.writeMessage(message);
        this.updateHandshakeMessagesDigest(message);
    }

    byte[] receiveMessageBody(short s) throws IOException {
        Message message = this.receiveMessage();
        if (message.getType() != s) {
            throw new TlsFatalAlert(10);
        }
        return message.getBody();
    }

    Message receiveMessage() throws IOException {
        byte[] byArray;
        Object object;
        if (this.sending) {
            this.sending = false;
            this.prepareInboundFlight();
        }
        if ((object = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(this.next_receive_seq))) != null && (byArray = ((DTLSReassembler)object).getBodyIfComplete()) != null) {
            this.previousInboundFlight = null;
            return this.updateHandshakeMessagesDigest(new Message(this.next_receive_seq++, ((DTLSReassembler)object).getMsgType(), byArray));
        }
        object = null;
        int n = 1000;
        while (true) {
            int n2 = this.recordLayer.getReceiveLimit();
            if (object == null || ((DTLSReassembler)object).length < n2) {
                object = new byte[n2];
            }
            try {
                int n3;
                while ((n3 = this.recordLayer.receive((byte[])object, 0, n2, n)) >= 0) {
                    byte[] byArray2;
                    DTLSReassembler dTLSReassembler;
                    int n4;
                    int n5;
                    if (n3 < 12 || n3 != (n5 = TlsUtils.readUint24((byte[])object, 9)) + 12 || (n4 = TlsUtils.readUint16((byte[])object, 4)) > this.next_receive_seq + 10) continue;
                    short s = TlsUtils.readUint8((byte[])object, 0);
                    int n6 = TlsUtils.readUint24((byte[])object, 1);
                    int n7 = TlsUtils.readUint24((byte[])object, 6);
                    if (n7 + n5 > n6) continue;
                    if (n4 < this.next_receive_seq) {
                        if (this.previousInboundFlight == null || (dTLSReassembler = (DTLSReassembler)this.previousInboundFlight.get(Integers.valueOf(n4))) == null) continue;
                        dTLSReassembler.contributeFragment(s, n6, (byte[])object, 12, n7, n5);
                        if (!DTLSReliableHandshake.checkAll(this.previousInboundFlight)) continue;
                        this.resendOutboundFlight();
                        n = Math.min(n * 2, 60000);
                        DTLSReliableHandshake.resetAll(this.previousInboundFlight);
                        continue;
                    }
                    dTLSReassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(n4));
                    if (dTLSReassembler == null) {
                        dTLSReassembler = new DTLSReassembler(s, n6);
                        this.currentInboundFlight.put(Integers.valueOf(n4), dTLSReassembler);
                    }
                    dTLSReassembler.contributeFragment(s, n6, (byte[])object, 12, n7, n5);
                    if (n4 != this.next_receive_seq || (byArray2 = dTLSReassembler.getBodyIfComplete()) == null) continue;
                    this.previousInboundFlight = null;
                    return this.updateHandshakeMessagesDigest(new Message(this.next_receive_seq++, dTLSReassembler.getMsgType(), byArray2));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.resendOutboundFlight();
            n = Math.min(n * 2, 60000);
        }
    }

    void finish() {
        DTLSHandshakeRetransmit dTLSHandshakeRetransmit = null;
        if (!this.sending) {
            this.checkInboundFlight();
        } else if (this.currentInboundFlight != null) {
            dTLSHandshakeRetransmit = new DTLSHandshakeRetransmit(){

                public void receivedHandshakeRecord(int n, byte[] byArray, int n2, int n3) throws IOException {
                    int n4;
                    if (n3 < 12) {
                        return;
                    }
                    int n5 = TlsUtils.readUint24(byArray, n2 + 9);
                    if (n3 != n5 + 12) {
                        return;
                    }
                    int n6 = TlsUtils.readUint16(byArray, n2 + 4);
                    if (n6 >= DTLSReliableHandshake.this.next_receive_seq) {
                        return;
                    }
                    short s = TlsUtils.readUint8(byArray, n2);
                    int n7 = n4 = s == 20 ? 1 : 0;
                    if (n != n4) {
                        return;
                    }
                    int n8 = TlsUtils.readUint24(byArray, n2 + 1);
                    int n9 = TlsUtils.readUint24(byArray, n2 + 6);
                    if (n9 + n5 > n8) {
                        return;
                    }
                    DTLSReassembler dTLSReassembler = (DTLSReassembler)DTLSReliableHandshake.this.currentInboundFlight.get(Integers.valueOf(n6));
                    if (dTLSReassembler != null) {
                        dTLSReassembler.contributeFragment(s, n8, byArray, n2 + 12, n9, n5);
                        if (DTLSReliableHandshake.checkAll(DTLSReliableHandshake.this.currentInboundFlight)) {
                            DTLSReliableHandshake.this.resendOutboundFlight();
                            DTLSReliableHandshake.resetAll(DTLSReliableHandshake.this.currentInboundFlight);
                        }
                    }
                }
            };
        }
        this.recordLayer.handshakeSuccessful(dTLSHandshakeRetransmit);
    }

    void resetHandshakeMessagesDigest() {
        this.handshakeHash.reset();
    }

    private void checkInboundFlight() {
        Enumeration enumeration = this.currentInboundFlight.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (n < this.next_receive_seq) continue;
        }
    }

    private void prepareInboundFlight() {
        DTLSReliableHandshake.resetAll(this.currentInboundFlight);
        this.previousInboundFlight = this.currentInboundFlight;
        this.currentInboundFlight = new Hashtable();
    }

    private void resendOutboundFlight() throws IOException {
        this.recordLayer.resetWriteEpoch();
        for (int i = 0; i < this.outboundFlight.size(); ++i) {
            this.writeMessage((Message)this.outboundFlight.elementAt(i));
        }
    }

    private Message updateHandshakeMessagesDigest(Message message) throws IOException {
        if (message.getType() != 0) {
            byte[] byArray = message.getBody();
            byte[] byArray2 = new byte[12];
            TlsUtils.writeUint8(message.getType(), byArray2, 0);
            TlsUtils.writeUint24(byArray.length, byArray2, 1);
            TlsUtils.writeUint16(message.getSeq(), byArray2, 4);
            TlsUtils.writeUint24(0, byArray2, 6);
            TlsUtils.writeUint24(byArray.length, byArray2, 9);
            this.handshakeHash.update(byArray2, 0, byArray2.length);
            this.handshakeHash.update(byArray, 0, byArray.length);
        }
        return message;
    }

    private void writeMessage(Message message) throws IOException {
        int n;
        int n2 = this.recordLayer.getSendLimit();
        int n3 = n2 - 12;
        if (n3 < 1) {
            throw new TlsFatalAlert(80);
        }
        int n4 = message.getBody().length;
        int n5 = 0;
        do {
            n = Math.min(n4 - n5, n3);
            this.writeHandshakeFragment(message, n5, n);
        } while ((n5 += n) < n4);
    }

    private void writeHandshakeFragment(Message message, int n, int n2) throws IOException {
        RecordLayerBuffer recordLayerBuffer = new RecordLayerBuffer(12 + n2);
        TlsUtils.writeUint8(message.getType(), (OutputStream)recordLayerBuffer);
        TlsUtils.writeUint24(message.getBody().length, recordLayerBuffer);
        TlsUtils.writeUint16(message.getSeq(), recordLayerBuffer);
        TlsUtils.writeUint24(n, recordLayerBuffer);
        TlsUtils.writeUint24(n2, recordLayerBuffer);
        recordLayerBuffer.write(message.getBody(), n, n2);
        recordLayerBuffer.sendToRecordLayer(this.recordLayer);
    }

    private static boolean checkAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (((DTLSReassembler)enumeration.nextElement()).getBodyIfComplete() != null) continue;
            return false;
        }
        return true;
    }

    private static void resetAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((DTLSReassembler)enumeration.nextElement()).reset();
        }
    }

    static class Message {
        private final int message_seq;
        private final short msg_type;
        private final byte[] body;

        private Message(int n, short s, byte[] byArray) {
            this.message_seq = n;
            this.msg_type = s;
            this.body = byArray;
        }

        public int getSeq() {
            return this.message_seq;
        }

        public short getType() {
            return this.msg_type;
        }

        public byte[] getBody() {
            return this.body;
        }
    }

    static class RecordLayerBuffer
    extends ByteArrayOutputStream {
        RecordLayerBuffer(int n) {
            super(n);
        }

        void sendToRecordLayer(DTLSRecordLayer dTLSRecordLayer) throws IOException {
            dTLSRecordLayer.send(this.buf, 0, this.count);
            this.buf = null;
        }
    }
}

