/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.constantine.Constant;
import org.python.constantine.ConstantSet;
import org.python.constantine.platform.Errno;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.imp;
import org.python.posix.util.Platform;

public class errno
implements ClassDictInit {
    public static final PyString __doc__ = Py.newString("This module makes available standard errno system symbols.\n\nThe value of each symbol is the corresponding integer value,\ne.g., on most systems, errno.ENOENT equals the integer 2.\n\nThe dictionary errno.errorcode maps numeric codes to symbol names,\ne.g., errno.errorcode[2] could be the string 'ENOENT'.\n\nSymbols that are not relevant to the underlying system are not defined.\n\nTo map error codes to error messages, use the function os.strerror(),\ne.g. os.strerror(2) could return 'No such file or directory'.");
    public static final PyObject errorcode = new PyDictionary();

    public static void classDictInit(PyObject dict) {
        if (Platform.IS_WINDOWS) {
            errno.initWindows(dict);
        } else {
            errno.initPosix(dict);
        }
        errno.addCode(dict, "ESOCKISBLOCKING", 20000, "Socket is in blocking mode");
        errno.addCode(dict, "EGETADDRINFOFAILED", 20001, "getaddrinfo failed");
        dict.__setitem__("classDictInit", null);
    }

    private static void initWindows(PyObject dict) {
        ConstantSet winErrnos = ConstantSet.getConstantSet("Errno");
        ConstantSet lastErrors = ConstantSet.getConstantSet("LastError");
        for (Errno errno2 : Errno.values()) {
            String errno3 = errno2.name();
            Constant errnoName = winErrnos.getConstant(errno3);
            if (errnoName == null && (errnoName = lastErrors.getConstant("WSA" + errno3)) == null) continue;
            errno.addCode(dict, errno3, errnoName.value(), errnoName.toString());
        }
        for (Constant constant : lastErrors) {
            if (!constant.name().startsWith("WSA")) continue;
            errno.addCode(dict, constant.name(), constant.value(), constant.toString());
        }
    }

    private static void initPosix(PyObject dict) {
        for (Constant constant : ConstantSet.getConstantSet("Errno")) {
            errno.addCode(dict, constant.name(), constant.value(), constant.toString());
        }
    }

    private static void addCode(PyObject dict, String name, int code, String message) {
        PyString nameObj = Py.newString(name);
        PyInteger codeObj = Py.newInteger(code);
        dict.__setitem__(nameObj, (PyObject)codeObj);
        errorcode.__setitem__(codeObj, (PyObject)nameObj);
    }

    @Deprecated
    public static PyObject strerror(PyObject code) {
        Py.warning(Py.DeprecationWarning, "The errno.strerror function is deprecated, use os.strerror.");
        return imp.load("os").__getattr__("strerror").__call__(code);
    }
}

