/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StaticFetch
extends Fetch {
    protected List<PyObject> results = new LinkedList<PyObject>();
    protected List<PyObject> descriptions = new LinkedList<PyObject>();

    public StaticFetch(DataHandler datahandler) {
        super(datahandler);
    }

    @Override
    public void add(ResultSet resultSet) {
        this.add(resultSet, null);
    }

    @Override
    public void add(ResultSet resultSet, Set<Integer> skipCols) {
        try {
            if (resultSet != null && resultSet.getMetaData() != null) {
                PyObject metadata = this.createDescription(resultSet.getMetaData());
                PyList result = this.createResults(resultSet, skipCols, metadata);
                this.results.add(result);
                this.descriptions.add(metadata);
                this.rowcount = this.results.get(0).__len__();
                this.description = this.descriptions.get(0);
                this.rownumber = 0;
            }
        }
        catch (PyException e) {
            throw e;
        }
        catch (Throwable e) {
            throw zxJDBC.makeException(e);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void add(CallableStatement callableStatement, Procedure procedure, PyObject params) {
        try {
            PyObject result = this.createResults(callableStatement, procedure, params);
            if (result.__len__() > 0) {
                this.results.add(result);
                this.descriptions.add(this.createDescription(procedure));
                this.rowcount = this.results.get(0).__len__();
                this.description = this.descriptions.get(0);
                this.rownumber = 0;
            }
        }
        catch (PyException e) {
            throw e;
        }
        catch (Throwable e) {
            throw zxJDBC.makeException(e);
        }
    }

    @Override
    public PyObject fetchall() {
        return this.fetchmany(this.rowcount);
    }

    @Override
    public PyObject fetchmany(int size) {
        if (this.results == null || this.results.size() == 0) {
            throw zxJDBC.makeException(zxJDBC.DatabaseError, "no results");
        }
        PyObject res = new PyList();
        PyObject current = this.results.get(0);
        if (size <= 0) {
            size = this.rowcount;
        }
        if (this.rownumber < this.rowcount) {
            res = current.__getslice__(Py.newInteger(this.rownumber), Py.newInteger(this.rownumber + size), Py.One);
            this.rownumber += size;
        }
        return res;
    }

    @Override
    public void scroll(int value, String mode) {
        int pos;
        if ("relative".equals(mode)) {
            pos = this.rownumber + value;
        } else if ("absolute".equals(mode)) {
            pos = value;
        } else {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "invalid cursor scroll mode [" + mode + "]");
        }
        if (pos < 0 || pos >= this.rowcount) {
            throw zxJDBC.makeException(Py.IndexError, "cursor index [" + pos + "] out of range");
        }
        this.rownumber = pos;
    }

    @Override
    public PyObject nextset() {
        PyObject next = Py.None;
        if (this.results != null && this.results.size() > 1) {
            this.results.remove(0);
            this.descriptions.remove(0);
            next = this.results.get(0);
            this.description = this.descriptions.get(0);
            this.rowcount = next.__len__();
            this.rownumber = 0;
        }
        return next == Py.None ? Py.None : Py.One;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.rownumber = -1;
        this.results.clear();
    }
}

