/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.DynamicFetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.StaticFetch;
import com.ziclix.python.sql.WarningEvent;
import com.ziclix.python.sql.WarningListener;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public abstract class Fetch {
    protected int rowcount = -1;
    protected int rownumber = -1;
    private DataHandler datahandler;
    protected PyObject description = Py.None;
    private List listeners;

    protected Fetch(DataHandler datahandler) {
        this.datahandler = datahandler;
        this.listeners = new ArrayList(3);
    }

    public static Fetch newFetch(DataHandler datahandler, boolean dynamic) {
        if (dynamic) {
            return new DynamicFetch(datahandler);
        }
        return new StaticFetch(datahandler);
    }

    public int getRowCount() {
        return this.rowcount;
    }

    public PyObject getDescription() {
        return this.description;
    }

    public abstract void add(ResultSet var1);

    public abstract void add(ResultSet var1, Set var2);

    public abstract void add(CallableStatement var1, Procedure var2, PyObject var3);

    public PyObject fetchone() {
        PyObject sequence = this.fetchmany(1);
        if (sequence.__len__() == 1) {
            return sequence.__getitem__(0);
        }
        return Py.None;
    }

    public abstract PyObject fetchall();

    public abstract PyObject fetchmany(int var1);

    public abstract PyObject nextset();

    public abstract void scroll(int var1, String var2);

    public void close() throws SQLException {
        this.listeners.clear();
    }

    protected PyObject createDescription(ResultSetMetaData meta) throws SQLException {
        PyList metadata = new PyList();
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            PyObject[] a = new PyObject[7];
            a[0] = Py.newString(meta.getColumnLabel(i));
            a[1] = Py.newInteger(meta.getColumnType(i));
            a[2] = Py.newInteger(meta.getColumnDisplaySize(i));
            a[3] = Py.None;
            switch (meta.getColumnType(i)) {
                case -7: 
                case -5: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    a[4] = Py.newInteger(meta.getPrecision(i));
                    a[5] = Py.newInteger(meta.getScale(i));
                    break;
                }
                default: {
                    a[4] = Py.None;
                    a[5] = Py.None;
                }
            }
            a[6] = Py.newInteger(meta.isNullable(i));
            metadata.append(new PyTuple(a));
        }
        return metadata;
    }

    protected PyObject createDescription(Procedure procedure) throws SQLException {
        PyList metadata = new PyList();
        int len = procedure.columns.__len__();
        for (int i = 0; i < len; ++i) {
            PyObject column = procedure.columns.__getitem__(i);
            int colType = column.__getitem__(4).asInt();
            switch (colType) {
                case 5: {
                    PyObject[] a = new PyObject[7];
                    a[0] = column.__getitem__(3);
                    a[1] = column.__getitem__(5);
                    a[2] = Py.newInteger(-1);
                    a[3] = column.__getitem__(8);
                    switch (a[1].asInt()) {
                        case -7: 
                        case -5: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 8: {
                            a[4] = column.__getitem__(7);
                            a[5] = column.__getitem__(9);
                            break;
                        }
                        default: {
                            a[4] = Py.None;
                            a[5] = Py.None;
                        }
                    }
                    int nullable = column.__getitem__(11).asInt();
                    a[6] = nullable == 1 ? Py.One : Py.Zero;
                    metadata.append(new PyTuple(a));
                }
            }
        }
        return metadata;
    }

    protected PyObject createResults(CallableStatement callableStatement, Procedure procedure, PyObject params) throws SQLException {
        PyList results = new PyList();
        int j = 0;
        int len = procedure.columns.__len__();
        block5: for (int i = 0; i < len; ++i) {
            PyObject obj = Py.None;
            PyObject column = procedure.columns.__getitem__(i);
            int colType = column.__getitem__(4).asInt();
            int dataType = column.__getitem__(5).asInt();
            switch (colType) {
                case 1: {
                    ++j;
                    continue block5;
                }
                case 2: 
                case 4: {
                    obj = this.datahandler.getPyObject(callableStatement, i + 1, dataType);
                    params.__setitem__(j++, obj);
                    continue block5;
                }
                case 5: {
                    obj = this.datahandler.getPyObject(callableStatement, i + 1, dataType);
                    Object rs = obj.__tojava__(ResultSet.class);
                    if (rs == Py.NoConversion) {
                        results.append(obj);
                        continue block5;
                    }
                    this.add((ResultSet)rs);
                }
            }
        }
        if (results.__len__() == 0) {
            return results;
        }
        PyList ret = new PyList();
        ret.append(PyTuple.fromIterable(results));
        return ret;
    }

    protected PyList createResults(ResultSet set, Set skipCols, PyObject metaData) throws SQLException {
        PyList res = new PyList();
        while (set.next()) {
            PyTuple tuple = this.createResult(set, skipCols, metaData);
            res.append(tuple);
        }
        return res;
    }

    protected PyTuple createResult(ResultSet set, Set skipCols, PyObject metaData) throws SQLException {
        int descriptionLength = metaData.__len__();
        PyObject[] row = new PyObject[descriptionLength];
        for (int i = 0; i < descriptionLength; ++i) {
            if (skipCols != null && skipCols.contains(new Integer(i + 1))) {
                row[i] = Py.None;
                continue;
            }
            int type = ((PyInteger)metaData.__getitem__(i).__getitem__(1)).getValue();
            row[i] = this.datahandler.getPyObject(set, i + 1, type);
        }
        SQLWarning warning = set.getWarnings();
        if (warning != null) {
            this.fireWarning(warning);
        }
        PyTuple tuple = new PyTuple(row);
        return tuple;
    }

    protected void fireWarning(SQLWarning warning) {
        WarningEvent event = new WarningEvent(this, warning);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            try {
                ((WarningListener)this.listeners.get(i)).warning(event);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void addWarningListener(WarningListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeWarningListener(WarningListener listener) {
        return this.listeners.remove(listener);
    }
}

