/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._threading;

import org.python.core.ContextManager;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._threading.Condition$PyExposer;
import org.python.modules._threading.Lock;

@ExposedType(name="_threading.Condition")
public class Condition
extends PyObject
implements ContextManager,
Traverseproc {
    public static final PyType TYPE;
    private final Lock _lock;
    private final java.util.concurrent.locks.Condition _condition;

    public Condition() {
        this(new Lock());
    }

    public Condition(Lock lock) {
        this._lock = lock;
        this._condition = lock._lock.newCondition();
    }

    @ExposedNew
    static final PyObject Condition___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        int nargs = args.length;
        if (nargs == 1) {
            return new Condition((Lock)args[0]);
        }
        return new Condition();
    }

    public boolean acquire() {
        return this.Condition_acquire(true);
    }

    public boolean acquire(boolean blocking) {
        return this.Condition_acquire(blocking);
    }

    final boolean Condition_acquire(boolean blocking) {
        return this._lock.acquire(blocking);
    }

    @Override
    public PyObject __enter__(ThreadState ts) {
        this._lock.acquire();
        return this;
    }

    final PyObject Condition___enter__() {
        this.Condition_acquire(true);
        return this;
    }

    public void release() {
        this.Condition_release();
    }

    final void Condition_release() {
        this._lock.release();
    }

    @Override
    public boolean __exit__(ThreadState ts, PyException exception) {
        this._lock.release();
        return false;
    }

    final boolean Condition___exit__(PyObject type, PyObject value, PyObject traceback) {
        this.Condition_release();
        return false;
    }

    public void wait$(PyObject timeout) throws InterruptedException {
        this.Condition_wait(timeout);
    }

    final void Condition_wait(PyObject timeout) throws InterruptedException {
        try {
            if (timeout == Py.None) {
                this._condition.await();
            } else {
                long nanos = (long)(timeout.asDouble() * 1.0E9);
                this._condition.awaitNanos(nanos);
            }
        }
        catch (IllegalMonitorStateException ex) {
            throw Py.RuntimeError("cannot wait on un-acquired lock");
        }
    }

    public void notify$() {
        this.Condition_notify();
    }

    final void Condition_notify() {
        try {
            this._condition.signal();
        }
        catch (IllegalMonitorStateException ex) {
            throw Py.RuntimeError("cannot notify on un-acquired lock");
        }
    }

    public void notifyAll$() {
        this.Condition_notifyAll();
    }

    final void Condition_notifyAll() {
        try {
            this._condition.signalAll();
        }
        catch (IllegalMonitorStateException ex) {
            throw Py.RuntimeError("cannot notify on un-acquired lock");
        }
    }

    final void Condition_notify_all() {
        this._condition.signalAll();
    }

    public boolean _is_owned() {
        return this.Condition__is_owned();
    }

    final boolean Condition__is_owned() {
        return this._lock._lock.isHeldByCurrentThread();
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this._lock != null ? visit.visit(this._lock, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && this._lock == ob;
    }

    static {
        PyType.addBuilder(Condition.class, new Condition$PyExposer());
        TYPE = PyType.fromClass(Condition.class);
    }
}

