/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.util.internal;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.python.netty.util.internal.ObjectUtil;
import org.python.netty.util.internal.PriorityQueueNode;

public final class PriorityQueue<T extends PriorityQueueNode<T>>
extends AbstractQueue<T>
implements Queue<T> {
    private static final PriorityQueueNode[] EMPTY_QUEUE = new PriorityQueueNode[0];
    private T[] queue;
    private int size;

    public PriorityQueue() {
        this(8);
    }

    public PriorityQueue(int initialSize) {
        this.queue = initialSize != 0 ? new PriorityQueueNode[initialSize] : EMPTY_QUEUE;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof PriorityQueueNode)) {
            return false;
        }
        PriorityQueueNode node = (PriorityQueueNode)o;
        int i = node.priorityQueueIndex();
        return i >= 0 && i < this.size && node.equals(this.queue[i]);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            T node = this.queue[i];
            if (node == null) continue;
            node.priorityQueueIndex(-1);
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean offer(T e) {
        ObjectUtil.checkNotNull(e, "e");
        if (e.priorityQueueIndex() != -1) {
            throw new IllegalArgumentException("e.priorityQueueIndex(): " + e.priorityQueueIndex() + " (expected: " + -1 + ")");
        }
        if (this.size >= this.queue.length) {
            this.queue = (PriorityQueueNode[])Arrays.copyOf(this.queue, this.queue.length + (this.queue.length < 64 ? this.queue.length + 2 : this.queue.length >>> 1));
        }
        this.bubbleUp(this.size++, e);
        return true;
    }

    @Override
    public T poll() {
        if (this.size == 0) {
            return null;
        }
        T result2 = this.queue[0];
        result2.priorityQueueIndex(-1);
        T last = this.queue[--this.size];
        this.queue[this.size] = null;
        if (this.size != 0) {
            this.bubbleDown(0, last);
        }
        return result2;
    }

    @Override
    public T peek() {
        return this.size == 0 ? null : (T)this.queue[0];
    }

    @Override
    public boolean remove(Object o) {
        if (!this.contains(o)) {
            return false;
        }
        PriorityQueueNode node = (PriorityQueueNode)o;
        int i = node.priorityQueueIndex();
        node.priorityQueueIndex(-1);
        if (--this.size == 0 || this.size == i) {
            this.queue[i] = null;
            return true;
        }
        T moved = this.queue[i] = this.queue[this.size];
        this.queue[this.size] = null;
        if (node.compareTo(moved) < 0) {
            this.bubbleDown(i, moved);
        } else {
            this.bubbleUp(i, moved);
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public <X> X[] toArray(X[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.queue, this.size, a.getClass());
        }
        System.arraycopy(this.queue, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public Iterator<T> iterator() {
        return new PriorityQueueIterator();
    }

    private void bubbleDown(int k, T node) {
        int half = this.size >>> 1;
        while (k < half) {
            int iChild = (k << 1) + 1;
            T child = this.queue[iChild];
            int rightChild = iChild + 1;
            if (rightChild < this.size && child.compareTo(this.queue[rightChild]) > 0) {
                iChild = rightChild;
                child = this.queue[iChild];
            }
            if (node.compareTo(child) <= 0) break;
            this.queue[k] = child;
            child.priorityQueueIndex(k);
            k = iChild;
        }
        this.queue[k] = node;
        node.priorityQueueIndex(k);
    }

    private void bubbleUp(int k, T node) {
        int iParent;
        T parent;
        while (k > 0 && node.compareTo(parent = this.queue[iParent = k - 1 >>> 1]) < 0) {
            this.queue[k] = parent;
            parent.priorityQueueIndex(k);
            k = iParent;
        }
        this.queue[k] = node;
        node.priorityQueueIndex(k);
    }

    private final class PriorityQueueIterator
    implements Iterator<T> {
        private int index;

        private PriorityQueueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < PriorityQueue.this.size;
        }

        @Override
        public T next() {
            if (this.index >= PriorityQueue.this.size) {
                throw new NoSuchElementException();
            }
            return PriorityQueue.this.queue[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

