/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.text.ParsePosition;
import org.python.icu.text.NFRule;
import org.python.icu.text.NFRuleSet;
import org.python.icu.text.NFSubstitution;

class ModulusSubstitution
extends NFSubstitution {
    double divisor;
    private final NFRule ruleToUse;

    ModulusSubstitution(int pos, double divisor, NFRule rulePredecessor, NFRuleSet ruleSet, String description) {
        super(pos, ruleSet, description);
        this.divisor = divisor;
        if (divisor == 0.0) {
            throw new IllegalStateException("Substitution with bad divisor (" + divisor + ") " + description.substring(0, pos) + " | " + description.substring(pos));
        }
        this.ruleToUse = description.equals(">>>") ? rulePredecessor : null;
    }

    public void setDivisor(int radix, int exponent) {
        this.divisor = Math.pow(radix, exponent);
        if (this.divisor == 0.0) {
            throw new IllegalStateException("Substitution with bad divisor");
        }
    }

    public boolean equals(Object that) {
        if (super.equals(that)) {
            ModulusSubstitution that2 = (ModulusSubstitution)that;
            return this.divisor == that2.divisor;
        }
        return false;
    }

    public void doSubstitution(long number, StringBuffer toInsertInto, int position, int recursionCount) {
        if (this.ruleToUse == null) {
            super.doSubstitution(number, toInsertInto, position, recursionCount);
        } else {
            long numberToFormat = this.transformNumber(number);
            this.ruleToUse.doFormat(numberToFormat, toInsertInto, position + this.pos, recursionCount);
        }
    }

    public void doSubstitution(double number, StringBuffer toInsertInto, int position, int recursionCount) {
        if (this.ruleToUse == null) {
            super.doSubstitution(number, toInsertInto, position, recursionCount);
        } else {
            double numberToFormat = this.transformNumber(number);
            this.ruleToUse.doFormat(numberToFormat, toInsertInto, position + this.pos, recursionCount);
        }
    }

    public long transformNumber(long number) {
        return (long)Math.floor((double)number % this.divisor);
    }

    public double transformNumber(double number) {
        return Math.floor(number % this.divisor);
    }

    public Number doParse(String text2, ParsePosition parsePosition, double baseValue, double upperBound, boolean lenientParse) {
        if (this.ruleToUse == null) {
            return super.doParse(text2, parsePosition, baseValue, upperBound, lenientParse);
        }
        Number tempResult = this.ruleToUse.doParse(text2, parsePosition, false, upperBound);
        if (parsePosition.getIndex() != 0) {
            double result2 = tempResult.doubleValue();
            if ((result2 = this.composeRuleValue(result2, baseValue)) == (double)((long)result2)) {
                return (long)result2;
            }
            return new Double(result2);
        }
        return tempResult;
    }

    public double composeRuleValue(double newRuleValue, double oldRuleValue) {
        return oldRuleValue - oldRuleValue % this.divisor + newRuleValue;
    }

    public double calcUpperBound(double oldUpperBound) {
        return this.divisor;
    }

    public boolean isModulusSubstitution() {
        return true;
    }

    char tokenChar() {
        return '>';
    }
}

