/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.python.icu.impl.ICUCache;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.PatternTokenizer;
import org.python.icu.impl.SimpleCache;
import org.python.icu.impl.SimpleFormatterImpl;
import org.python.icu.impl.UResource;
import org.python.icu.text.DateFormat;
import org.python.icu.text.DecimalFormatSymbols;
import org.python.icu.text.SimpleDateFormat;
import org.python.icu.text.UnicodeSet;
import org.python.icu.util.Calendar;
import org.python.icu.util.Freezable;
import org.python.icu.util.ICUCloneNotSupportedException;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

public class DateTimePatternGenerator
implements Freezable<DateTimePatternGenerator>,
Cloneable {
    private static final boolean DEBUG = false;
    private static final String[] LAST_RESORT_ALLOWED_HOUR_FORMAT = new String[]{"H"};
    static final Map<String, String[]> LOCALE_TO_ALLOWED_HOUR;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int QUARTER = 2;
    public static final int MONTH = 3;
    public static final int WEEK_OF_YEAR = 4;
    public static final int WEEK_OF_MONTH = 5;
    public static final int WEEKDAY = 6;
    public static final int DAY = 7;
    public static final int DAY_OF_YEAR = 8;
    public static final int DAY_OF_WEEK_IN_MONTH = 9;
    public static final int DAYPERIOD = 10;
    public static final int HOUR = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int FRACTIONAL_SECOND = 14;
    public static final int ZONE = 15;
    @Deprecated
    public static final int TYPE_LIMIT = 16;
    public static final int MATCH_NO_OPTIONS = 0;
    public static final int MATCH_HOUR_FIELD_LENGTH = 2048;
    @Deprecated
    public static final int MATCH_MINUTE_FIELD_LENGTH = 4096;
    @Deprecated
    public static final int MATCH_SECOND_FIELD_LENGTH = 8192;
    public static final int MATCH_ALL_FIELDS_LENGTH = 65535;
    private TreeMap<DateTimeMatcher, PatternWithSkeletonFlag> skeleton2pattern = new TreeMap();
    private TreeMap<String, PatternWithSkeletonFlag> basePattern_pattern = new TreeMap();
    private String decimal = "?";
    private String dateTimeFormat = "{1} {0}";
    private String[] appendItemFormats = new String[16];
    private String[] appendItemNames = new String[16];
    private char defaultHourFormatChar = (char)72;
    private volatile boolean frozen = false;
    private transient DateTimeMatcher current = new DateTimeMatcher();
    private transient FormatParser fp = new FormatParser();
    private transient DistanceInfo _distanceInfo = new DistanceInfo();
    private String[] allowedHourFormats;
    private static final int FRACTIONAL_MASK = 16384;
    private static final int SECOND_AND_FRACTIONAL_MASK = 24576;
    private static ICUCache<String, DateTimePatternGenerator> DTPNG_CACHE;
    private static final String[] CLDR_FIELD_APPEND;
    private static final String[] CLDR_FIELD_NAME;
    private static final String[] FIELD_NAME;
    private static final String[] CANONICAL_ITEMS;
    private static final Set<String> CANONICAL_SET;
    private Set<String> cldrAvailableFormatKeys = new HashSet<String>(20);
    private static final int DATE_MASK = 1023;
    private static final int TIME_MASK = 64512;
    private static final int DELTA = 16;
    private static final int NUMERIC = 256;
    private static final int NONE = 0;
    private static final int NARROW = -257;
    private static final int SHORT = -258;
    private static final int LONG = -259;
    private static final int EXTRA_FIELD = 65536;
    private static final int MISSING_FIELD = 4096;
    private static final int[][] types;

    public static DateTimePatternGenerator getEmptyInstance() {
        DateTimePatternGenerator instance = new DateTimePatternGenerator();
        instance.addCanonicalItems();
        instance.fillInMissing();
        return instance;
    }

    protected DateTimePatternGenerator() {
    }

    public static DateTimePatternGenerator getInstance() {
        return DateTimePatternGenerator.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public static DateTimePatternGenerator getInstance(ULocale uLocale) {
        return DateTimePatternGenerator.getFrozenInstance(uLocale).cloneAsThawed();
    }

    public static DateTimePatternGenerator getInstance(Locale locale2) {
        return DateTimePatternGenerator.getInstance(ULocale.forLocale(locale2));
    }

    @Deprecated
    public static DateTimePatternGenerator getFrozenInstance(ULocale uLocale) {
        String localeKey = uLocale.toString();
        DateTimePatternGenerator result2 = DTPNG_CACHE.get(localeKey);
        if (result2 != null) {
            return result2;
        }
        result2 = new DateTimePatternGenerator();
        result2.initData(uLocale);
        result2.freeze();
        DTPNG_CACHE.put(localeKey, result2);
        return result2;
    }

    private void initData(ULocale uLocale) {
        PatternInfo returnInfo = new PatternInfo();
        this.addCanonicalItems();
        this.addICUPatterns(returnInfo, uLocale);
        this.addCLDRData(returnInfo, uLocale);
        this.setDateTimeFromCalendar(uLocale);
        this.setDecimalSymbols(uLocale);
        this.getAllowedHourFormats(uLocale);
        this.fillInMissing();
    }

    private void addICUPatterns(PatternInfo returnInfo, ULocale uLocale) {
        for (int i = 0; i <= 3; ++i) {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(i, uLocale);
            this.addPattern(df.toPattern(), false, returnInfo);
            df = (SimpleDateFormat)DateFormat.getTimeInstance(i, uLocale);
            this.addPattern(df.toPattern(), false, returnInfo);
            if (i != 3) continue;
            this.consumeShortTimePattern(df.toPattern(), returnInfo);
        }
    }

    private String getCalendarTypeToUse(ULocale uLocale) {
        String calendarTypeToUse = uLocale.getKeywordValue("calendar");
        if (calendarTypeToUse == null) {
            String[] preferredCalendarTypes = Calendar.getKeywordValuesForLocale("calendar", uLocale, true);
            calendarTypeToUse = preferredCalendarTypes[0];
        }
        if (calendarTypeToUse == null) {
            calendarTypeToUse = "gregorian";
        }
        return calendarTypeToUse;
    }

    private void consumeShortTimePattern(String shortTimePattern, PatternInfo returnInfo) {
        FormatParser fp = new FormatParser();
        fp.set(shortTimePattern);
        List<Object> items = fp.getItems();
        for (int idx = 0; idx < items.size(); ++idx) {
            VariableField fld;
            Object item = items.get(idx);
            if (!(item instanceof VariableField) || (fld = (VariableField)item).getType() != 11) continue;
            this.defaultHourFormatChar = fld.toString().charAt(0);
            break;
        }
        this.hackTimes(returnInfo, shortTimePattern);
    }

    private void fillInMissing() {
        for (int i = 0; i < 16; ++i) {
            if (this.getAppendItemFormat(i) == null) {
                this.setAppendItemFormat(i, "{0} \u251c{2}: {1}\u2524");
            }
            if (this.getAppendItemName(i) != null) continue;
            this.setAppendItemName(i, "F" + i);
        }
    }

    private void addCLDRData(PatternInfo returnInfo, ULocale uLocale) {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt58b", uLocale);
        String calendarTypeToUse = this.getCalendarTypeToUse(uLocale);
        AppendItemFormatsSink appendItemFormatsSink = new AppendItemFormatsSink();
        try {
            rb.getAllItemsWithFallback("calendar/" + calendarTypeToUse + "/appendItems", appendItemFormatsSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        AppendItemNamesSink appendItemNamesSink = new AppendItemNamesSink();
        try {
            rb.getAllItemsWithFallback("fields", appendItemNamesSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        AvailableFormatsSink availableFormatsSink = new AvailableFormatsSink(returnInfo);
        try {
            rb.getAllItemsWithFallback("calendar/" + calendarTypeToUse + "/availableFormats", availableFormatsSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private void setDateTimeFromCalendar(ULocale uLocale) {
        String dateTimeFormat = Calendar.getDateTimePattern(Calendar.getInstance(uLocale), uLocale, 2);
        this.setDateTimeFormat(dateTimeFormat);
    }

    private void setDecimalSymbols(ULocale uLocale) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(uLocale);
        this.setDecimal(String.valueOf(dfs.getDecimalSeparator()));
    }

    private void getAllowedHourFormats(ULocale uLocale) {
        String langCountry;
        String[] list;
        ULocale max = ULocale.addLikelySubtags(uLocale);
        String country = max.getCountry();
        if (country.isEmpty()) {
            country = "001";
        }
        if ((list = LOCALE_TO_ALLOWED_HOUR.get(langCountry = max.getLanguage() + "_" + country)) == null && (list = LOCALE_TO_ALLOWED_HOUR.get(country)) == null) {
            list = LAST_RESORT_ALLOWED_HOUR_FORMAT;
        }
        this.allowedHourFormats = list;
    }

    @Deprecated
    public char getDefaultHourFormatChar() {
        return this.defaultHourFormatChar;
    }

    @Deprecated
    public void setDefaultHourFormatChar(char defaultHourFormatChar) {
        this.defaultHourFormatChar = defaultHourFormatChar;
    }

    private void hackTimes(PatternInfo returnInfo, String shortTimePattern) {
        this.fp.set(shortTimePattern);
        StringBuilder mmss = new StringBuilder();
        boolean gotMm = false;
        for (int i = 0; i < this.fp.items.size(); ++i) {
            Object item = this.fp.items.get(i);
            if (item instanceof String) {
                if (!gotMm) continue;
                mmss.append(this.fp.quoteLiteral(item.toString()));
                continue;
            }
            char ch = item.toString().charAt(0);
            if (ch == 'm') {
                gotMm = true;
                mmss.append(item);
                continue;
            }
            if (ch == 's') {
                if (!gotMm) break;
                mmss.append(item);
                this.addPattern(mmss.toString(), false, returnInfo);
                break;
            }
            if (gotMm || ch == 'z' || ch == 'Z' || ch == 'v' || ch == 'V') break;
        }
        BitSet variables = new BitSet();
        BitSet nuke = new BitSet();
        for (int i = 0; i < this.fp.items.size(); ++i) {
            Object item = this.fp.items.get(i);
            if (!(item instanceof VariableField)) continue;
            variables.set(i);
            char ch = item.toString().charAt(0);
            if (ch != 's' && ch != 'S') continue;
            nuke.set(i);
            for (int j = i - 1; j >= 0 && !variables.get(j); ++j) {
                nuke.set(i);
            }
        }
        String hhmm = DateTimePatternGenerator.getFilteredPattern(this.fp, nuke);
        this.addPattern(hhmm, false, returnInfo);
    }

    private static String getFilteredPattern(FormatParser fp, BitSet nuke) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < fp.items.size(); ++i) {
            if (nuke.get(i)) continue;
            Object item = fp.items.get(i);
            if (item instanceof String) {
                result2.append(fp.quoteLiteral(item.toString()));
                continue;
            }
            result2.append(item.toString());
        }
        return result2.toString();
    }

    @Deprecated
    public static int getAppendFormatNumber(UResource.Key key) {
        for (int i = 0; i < CLDR_FIELD_APPEND.length; ++i) {
            if (!key.contentEquals(CLDR_FIELD_APPEND[i])) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public static int getAppendFormatNumber(String string2) {
        for (int i = 0; i < CLDR_FIELD_APPEND.length; ++i) {
            if (!CLDR_FIELD_APPEND[i].equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private static int getCLDRFieldNumber(UResource.Key key) {
        for (int i = 0; i < CLDR_FIELD_NAME.length; ++i) {
            if (!key.contentEquals(CLDR_FIELD_NAME[i])) continue;
            return i;
        }
        return -1;
    }

    public String getBestPattern(String skeleton) {
        return this.getBestPattern(skeleton, null, 0);
    }

    public String getBestPattern(String skeleton, int options) {
        return this.getBestPattern(skeleton, null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBestPattern(String skeleton, DateTimeMatcher skipMatcher, int options) {
        String timePattern;
        String datePattern;
        EnumSet<DTPGflags> flags = EnumSet.noneOf(DTPGflags.class);
        StringBuilder skeletonCopy = new StringBuilder(skeleton);
        boolean inQuoted = false;
        for (int patPos = 0; patPos < skeleton.length(); ++patPos) {
            char patChr = skeleton.charAt(patPos);
            if (patChr == '\'') {
                inQuoted = !inQuoted;
                continue;
            }
            if (inQuoted) continue;
            if (patChr == 'j') {
                skeletonCopy.setCharAt(patPos, this.defaultHourFormatChar);
                continue;
            }
            if (patChr == 'C') {
                String preferred = this.allowedHourFormats[0];
                skeletonCopy.setCharAt(patPos, preferred.charAt(0));
                DTPGflags alt = DTPGflags.getFlag(preferred);
                if (alt == null) continue;
                flags.add(alt);
                continue;
            }
            if (patChr != 'J') continue;
            skeletonCopy.setCharAt(patPos, 'H');
            flags.add(DTPGflags.SKELETON_USES_CAP_J);
        }
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(skeletonCopy.toString(), this.fp, false);
            PatternWithMatcher bestWithMatcher = this.getBestRaw(this.current, -1, this._distanceInfo, skipMatcher);
            if (this._distanceInfo.missingFieldMask == 0 && this._distanceInfo.extraFieldMask == 0) {
                return this.adjustFieldTypes(bestWithMatcher, this.current, flags, options);
            }
            int neededFields = this.current.getFieldMask();
            datePattern = this.getBestAppending(this.current, neededFields & 0x3FF, this._distanceInfo, skipMatcher, flags, options);
            timePattern = this.getBestAppending(this.current, neededFields & 0xFC00, this._distanceInfo, skipMatcher, flags, options);
        }
        if (datePattern == null) {
            return timePattern == null ? "" : timePattern;
        }
        if (timePattern == null) {
            return datePattern;
        }
        return SimpleFormatterImpl.formatRawPattern(this.getDateTimeFormat(), 2, 2, timePattern, datePattern);
    }

    public DateTimePatternGenerator addPattern(String pattern, boolean override, PatternInfo returnInfo) {
        return this.addPatternWithSkeleton(pattern, null, override, returnInfo);
    }

    @Deprecated
    public DateTimePatternGenerator addPatternWithSkeleton(String pattern, String skeletonToUse, boolean override, PatternInfo returnInfo) {
        PatternWithSkeletonFlag previousValue;
        this.checkFrozen();
        DateTimeMatcher matcher = skeletonToUse == null ? new DateTimeMatcher().set(pattern, this.fp, false) : new DateTimeMatcher().set(skeletonToUse, this.fp, false);
        String basePattern = matcher.getBasePattern();
        PatternWithSkeletonFlag previousPatternWithSameBase = this.basePattern_pattern.get(basePattern);
        if (previousPatternWithSameBase != null && (!previousPatternWithSameBase.skeletonWasSpecified || skeletonToUse != null && !override)) {
            returnInfo.status = 1;
            returnInfo.conflictingPattern = previousPatternWithSameBase.pattern;
            if (!override) {
                return this;
            }
        }
        if ((previousValue = this.skeleton2pattern.get(matcher)) != null) {
            returnInfo.status = 2;
            returnInfo.conflictingPattern = previousValue.pattern;
            if (!override || skeletonToUse != null && previousValue.skeletonWasSpecified) {
                return this;
            }
        }
        returnInfo.status = 0;
        returnInfo.conflictingPattern = "";
        PatternWithSkeletonFlag patWithSkelFlag = new PatternWithSkeletonFlag(pattern, skeletonToUse != null);
        this.skeleton2pattern.put(matcher, patWithSkelFlag);
        this.basePattern_pattern.put(basePattern, patWithSkelFlag);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSkeleton(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, false);
            return this.current.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getSkeletonAllowingDuplicates(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, true);
            return this.current.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getCanonicalSkeletonAllowingDuplicates(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, true);
            return this.current.toCanonicalString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseSkeleton(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, false);
            return this.current.getBasePattern();
        }
    }

    public Map<String, String> getSkeletons(Map<String, String> result2) {
        if (result2 == null) {
            result2 = new LinkedHashMap<String, String>();
        }
        for (DateTimeMatcher item : this.skeleton2pattern.keySet()) {
            PatternWithSkeletonFlag patternWithSkelFlag = this.skeleton2pattern.get(item);
            String pattern = patternWithSkelFlag.pattern;
            if (CANONICAL_SET.contains(pattern)) continue;
            result2.put(item.toString(), pattern);
        }
        return result2;
    }

    public Set<String> getBaseSkeletons(Set<String> result2) {
        if (result2 == null) {
            result2 = new HashSet<String>();
        }
        result2.addAll(this.basePattern_pattern.keySet());
        return result2;
    }

    public String replaceFieldTypes(String pattern, String skeleton) {
        return this.replaceFieldTypes(pattern, skeleton, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String replaceFieldTypes(String pattern, String skeleton, int options) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            PatternWithMatcher patternNoMatcher = new PatternWithMatcher(pattern, null);
            return this.adjustFieldTypes(patternNoMatcher, this.current.set(skeleton, this.fp, false), EnumSet.noneOf(DTPGflags.class), options);
        }
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.checkFrozen();
        this.dateTimeFormat = dateTimeFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDecimal(String decimal2) {
        this.checkFrozen();
        this.decimal = decimal2;
    }

    public String getDecimal() {
        return this.decimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Collection<String> getRedundants(Collection<String> output) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            if (output == null) {
                output = new LinkedHashSet<String>();
            }
            for (DateTimeMatcher cur : this.skeleton2pattern.keySet()) {
                String trial;
                PatternWithSkeletonFlag patternWithSkelFlag = this.skeleton2pattern.get(cur);
                String pattern = patternWithSkelFlag.pattern;
                if (CANONICAL_SET.contains(pattern) || !(trial = this.getBestPattern(cur.toString(), cur, 0)).equals(pattern)) continue;
                output.add(pattern);
            }
            return output;
        }
    }

    public void setAppendItemFormat(int field, String value) {
        this.checkFrozen();
        this.appendItemFormats[field] = value;
    }

    public String getAppendItemFormat(int field) {
        return this.appendItemFormats[field];
    }

    public void setAppendItemName(int field, String value) {
        this.checkFrozen();
        this.appendItemNames[field] = value;
    }

    public String getAppendItemName(int field) {
        return this.appendItemNames[field];
    }

    @Deprecated
    public static boolean isSingleField(String skeleton) {
        char first = skeleton.charAt(0);
        for (int i = 1; i < skeleton.length(); ++i) {
            if (skeleton.charAt(i) == first) continue;
            return false;
        }
        return true;
    }

    private void setAvailableFormat(String key) {
        this.checkFrozen();
        this.cldrAvailableFormatKeys.add(key);
    }

    private boolean isAvailableFormatSet(String key) {
        return this.cldrAvailableFormatKeys.contains(key);
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public DateTimePatternGenerator freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    public DateTimePatternGenerator cloneAsThawed() {
        DateTimePatternGenerator result2 = (DateTimePatternGenerator)this.clone();
        this.frozen = false;
        return result2;
    }

    public Object clone() {
        try {
            DateTimePatternGenerator result2 = (DateTimePatternGenerator)super.clone();
            result2.skeleton2pattern = (TreeMap)this.skeleton2pattern.clone();
            result2.basePattern_pattern = (TreeMap)this.basePattern_pattern.clone();
            result2.appendItemFormats = (String[])this.appendItemFormats.clone();
            result2.appendItemNames = (String[])this.appendItemNames.clone();
            result2.current = new DateTimeMatcher();
            result2.fp = new FormatParser();
            result2._distanceInfo = new DistanceInfo();
            result2.frozen = false;
            return result2;
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException("Internal Error", e);
        }
    }

    @Deprecated
    public boolean skeletonsAreSimilar(String id, String skeleton) {
        if (id.equals(skeleton)) {
            return true;
        }
        TreeSet<String> parser1 = this.getSet(id);
        TreeSet<String> parser2 = this.getSet(skeleton);
        if (parser1.size() != parser2.size()) {
            return false;
        }
        Iterator<String> it2 = parser2.iterator();
        for (String item : parser1) {
            String item2;
            int index2;
            int index1 = DateTimePatternGenerator.getCanonicalIndex(item, false);
            if (types[index1][1] == types[index2 = DateTimePatternGenerator.getCanonicalIndex(item2 = it2.next(), false)][1]) continue;
            return false;
        }
        return true;
    }

    private TreeSet<String> getSet(String id) {
        List<Object> items = this.fp.set(id).getItems();
        TreeSet<String> result2 = new TreeSet<String>();
        for (Object obj : items) {
            String item = obj.toString();
            if (item.startsWith("G") || item.startsWith("a")) continue;
            result2.add(item);
        }
        return result2;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
    }

    private String getBestAppending(DateTimeMatcher source, int missingFields, DistanceInfo distInfo, DateTimeMatcher skipMatcher, EnumSet<DTPGflags> flags, int options) {
        String resultPattern = null;
        if (missingFields != 0) {
            PatternWithMatcher resultPatternWithMatcher = this.getBestRaw(source, missingFields, distInfo, skipMatcher);
            resultPattern = this.adjustFieldTypes(resultPatternWithMatcher, source, flags, options);
            while (distInfo.missingFieldMask != 0) {
                if ((distInfo.missingFieldMask & 0x6000) == 16384 && (missingFields & 0x6000) == 24576) {
                    resultPatternWithMatcher.pattern = resultPattern;
                    flags = EnumSet.copyOf(flags);
                    flags.add(DTPGflags.FIX_FRACTIONAL_SECONDS);
                    resultPattern = this.adjustFieldTypes(resultPatternWithMatcher, source, flags, options);
                    distInfo.missingFieldMask &= 0xFFFFBFFF;
                    continue;
                }
                int startingMask = distInfo.missingFieldMask;
                PatternWithMatcher tempWithMatcher = this.getBestRaw(source, distInfo.missingFieldMask, distInfo, skipMatcher);
                String temp = this.adjustFieldTypes(tempWithMatcher, source, flags, options);
                int foundMask = startingMask & ~distInfo.missingFieldMask;
                int topField = this.getTopBitNumber(foundMask);
                resultPattern = SimpleFormatterImpl.formatRawPattern(this.getAppendFormat(topField), 2, 3, resultPattern, temp, this.getAppendName(topField));
            }
        }
        return resultPattern;
    }

    private String getAppendName(int foundMask) {
        return "'" + this.appendItemNames[foundMask] + "'";
    }

    private String getAppendFormat(int foundMask) {
        return this.appendItemFormats[foundMask];
    }

    private int getTopBitNumber(int foundMask) {
        int i = 0;
        while (foundMask != 0) {
            foundMask >>>= 1;
            ++i;
        }
        return i - 1;
    }

    private void addCanonicalItems() {
        PatternInfo patternInfo = new PatternInfo();
        for (int i = 0; i < CANONICAL_ITEMS.length; ++i) {
            this.addPattern(String.valueOf(CANONICAL_ITEMS[i]), false, patternInfo);
        }
    }

    private PatternWithMatcher getBestRaw(DateTimeMatcher source, int includeMask, DistanceInfo missingFields, DateTimeMatcher skipMatcher) {
        int bestDistance = Integer.MAX_VALUE;
        PatternWithMatcher bestPatternWithMatcher = new PatternWithMatcher("", null);
        DistanceInfo tempInfo = new DistanceInfo();
        for (DateTimeMatcher trial : this.skeleton2pattern.keySet()) {
            int distance;
            if (trial.equals(skipMatcher) || (distance = source.getDistance(trial, includeMask, tempInfo)) >= bestDistance) continue;
            bestDistance = distance;
            PatternWithSkeletonFlag patternWithSkelFlag = this.skeleton2pattern.get(trial);
            bestPatternWithMatcher.pattern = patternWithSkelFlag.pattern;
            bestPatternWithMatcher.matcherWithSkeleton = patternWithSkelFlag.skeletonWasSpecified ? trial : null;
            missingFields.setTo(tempInfo);
            if (distance != 0) continue;
            break;
        }
        return bestPatternWithMatcher;
    }

    private String adjustFieldTypes(PatternWithMatcher patternWithMatcher, DateTimeMatcher inputRequest, EnumSet<DTPGflags> flags, int options) {
        this.fp.set(patternWithMatcher.pattern);
        StringBuilder newPattern = new StringBuilder();
        for (Object item : this.fp.getItems()) {
            if (item instanceof String) {
                newPattern.append(this.fp.quoteLiteral((String)item));
                continue;
            }
            VariableField variableField = (VariableField)item;
            StringBuilder fieldBuilder = new StringBuilder(variableField.toString());
            int type = variableField.getType();
            if (type == 10 && !flags.isEmpty()) {
                char c;
                char c2 = flags.contains((Object)DTPGflags.SKELETON_USES_b) ? (char)'b' : (c = flags.contains((Object)DTPGflags.SKELETON_USES_B) ? (char)'B' : '0');
                if (c != '0') {
                    int len = fieldBuilder.length();
                    fieldBuilder.setLength(0);
                    for (int i = len; i > 0; --i) {
                        fieldBuilder.append(c);
                    }
                }
            }
            if (flags.contains((Object)DTPGflags.FIX_FRACTIONAL_SECONDS) && type == 13) {
                fieldBuilder.append(this.decimal);
                inputRequest.original.appendFieldTo(14, fieldBuilder);
            } else if (inputRequest.type[type] != 0) {
                char c;
                char reqFieldChar = inputRequest.original.getFieldChar(type);
                int reqFieldLen = inputRequest.original.getFieldLength(type);
                if (reqFieldChar == 'E' && reqFieldLen < 3) {
                    reqFieldLen = 3;
                }
                int adjFieldLen = reqFieldLen;
                DateTimeMatcher matcherWithSkeleton = patternWithMatcher.matcherWithSkeleton;
                if (type == 11 && (options & 0x800) == 0 || type == 12 && (options & 0x1000) == 0 || type == 13 && (options & 0x2000) == 0) {
                    adjFieldLen = fieldBuilder.length();
                } else if (matcherWithSkeleton != null) {
                    int skelFieldLen = matcherWithSkeleton.original.getFieldLength(type);
                    boolean patFieldIsNumeric = variableField.isNumeric();
                    boolean skelFieldIsNumeric = matcherWithSkeleton.fieldIsNumeric(type);
                    if (skelFieldLen == reqFieldLen || patFieldIsNumeric && !skelFieldIsNumeric || skelFieldIsNumeric && !patFieldIsNumeric) {
                        adjFieldLen = fieldBuilder.length();
                    }
                }
                char c3 = c = type != 11 && type != 3 && type != 6 && (type != 1 || reqFieldChar == 'Y') ? reqFieldChar : fieldBuilder.charAt(0);
                if (type == 11 && flags.contains((Object)DTPGflags.SKELETON_USES_CAP_J)) {
                    c = this.defaultHourFormatChar;
                }
                fieldBuilder = new StringBuilder();
                for (int i = adjFieldLen; i > 0; --i) {
                    fieldBuilder.append(c);
                }
            }
            newPattern.append((CharSequence)fieldBuilder);
        }
        return newPattern.toString();
    }

    @Deprecated
    public String getFields(String pattern) {
        this.fp.set(pattern);
        StringBuilder newPattern = new StringBuilder();
        for (Object item : this.fp.getItems()) {
            if (item instanceof String) {
                newPattern.append(this.fp.quoteLiteral((String)item));
                continue;
            }
            newPattern.append("{" + DateTimePatternGenerator.getName(item.toString()) + "}");
        }
        return newPattern.toString();
    }

    private static String showMask(int mask) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if ((mask & 1 << i) == 0) continue;
            if (result2.length() != 0) {
                result2.append(" | ");
            }
            result2.append(FIELD_NAME[i]);
            result2.append(" ");
        }
        return result2.toString();
    }

    private static String getName(String s) {
        int i = DateTimePatternGenerator.getCanonicalIndex(s, true);
        String name = FIELD_NAME[types[i][1]];
        name = types[i][2] < 0 ? name + ":S" : name + ":N";
        return name;
    }

    private static int getCanonicalIndex(String s, boolean strict) {
        int len = s.length();
        if (len == 0) {
            return -1;
        }
        char ch = s.charAt(0);
        for (int i = 1; i < len; ++i) {
            if (s.charAt(i) == ch) continue;
            return -1;
        }
        int bestRow = -1;
        for (int i = 0; i < types.length; ++i) {
            int[] row = types[i];
            if (row[0] != ch) continue;
            bestRow = i;
            if (row[3] > len || row[row.length - 1] < len) continue;
            return i;
        }
        return strict ? -1 : bestRow;
    }

    private static char getCanonicalChar(int field, char reference) {
        if (reference == 'h' || reference == 'K') {
            return 'h';
        }
        for (int i = 0; i < types.length; ++i) {
            int[] row = types[i];
            if (row[1] != field) continue;
            return (char)row[0];
        }
        throw new IllegalArgumentException("Could not find field " + field);
    }

    static {
        HashMap temp = new HashMap();
        ICUResourceBundle suppData = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt58b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        DayPeriodAllowedHoursSink allowedHoursSink = new DayPeriodAllowedHoursSink(temp);
        suppData.getAllItemsWithFallback("timeData", allowedHoursSink);
        LOCALE_TO_ALLOWED_HOUR = Collections.unmodifiableMap(temp);
        DTPNG_CACHE = new SimpleCache<String, DateTimePatternGenerator>();
        CLDR_FIELD_APPEND = new String[]{"Era", "Year", "Quarter", "Month", "Week", "*", "Day-Of-Week", "Day", "*", "*", "*", "Hour", "Minute", "Second", "*", "Timezone"};
        CLDR_FIELD_NAME = new String[]{"era", "year", "*", "month", "week", "*", "weekday", "day", "*", "*", "dayperiod", "hour", "minute", "second", "*", "zone"};
        FIELD_NAME = new String[]{"Era", "Year", "Quarter", "Month", "Week_in_Year", "Week_in_Month", "Weekday", "Day", "Day_Of_Year", "Day_of_Week_in_Month", "Dayperiod", "Hour", "Minute", "Second", "Fractional_Second", "Zone"};
        CANONICAL_ITEMS = new String[]{"G", "y", "Q", "M", "w", "W", "E", "d", "D", "F", "H", "m", "s", "S", "v"};
        CANONICAL_SET = new HashSet<String>(Arrays.asList(CANONICAL_ITEMS));
        types = new int[][]{{71, 0, -258, 1, 3}, {71, 0, -259, 4}, {121, 1, 256, 1, 20}, {89, 1, 272, 1, 20}, {117, 1, 288, 1, 20}, {114, 1, 304, 1, 20}, {85, 1, -258, 1, 3}, {85, 1, -259, 4}, {85, 1, -257, 5}, {81, 2, 256, 1, 2}, {81, 2, -258, 3}, {81, 2, -259, 4}, {113, 2, 272, 1, 2}, {113, 2, -242, 3}, {113, 2, -243, 4}, {77, 3, 256, 1, 2}, {77, 3, -258, 3}, {77, 3, -259, 4}, {77, 3, -257, 5}, {76, 3, 272, 1, 2}, {76, 3, -274, 3}, {76, 3, -275, 4}, {76, 3, -273, 5}, {108, 3, 272, 1, 1}, {119, 4, 256, 1, 2}, {87, 5, 272, 1}, {69, 6, -258, 1, 3}, {69, 6, -259, 4}, {69, 6, -257, 5}, {99, 6, 288, 1, 2}, {99, 6, -290, 3}, {99, 6, -291, 4}, {99, 6, -289, 5}, {101, 6, 272, 1, 2}, {101, 6, -274, 3}, {101, 6, -275, 4}, {101, 6, -273, 5}, {100, 7, 256, 1, 2}, {68, 8, 272, 1, 3}, {70, 9, 288, 1}, {103, 7, 304, 1, 20}, {97, 10, -258, 1}, {72, 11, 416, 1, 2}, {107, 11, 432, 1, 2}, {104, 11, 256, 1, 2}, {75, 11, 272, 1, 2}, {109, 12, 256, 1, 2}, {115, 13, 256, 1, 2}, {83, 14, 272, 1, 1000}, {65, 13, 288, 1, 1000}, {118, 15, -290, 1}, {118, 15, -291, 4}, {122, 15, -258, 1, 3}, {122, 15, -259, 4}, {90, 15, -273, 1, 3}, {90, 15, -275, 4}, {90, 15, -274, 5}, {79, 15, -274, 1}, {79, 15, -275, 4}, {86, 15, -274, 1}, {86, 15, -275, 2}, {88, 15, -273, 1}, {88, 15, -274, 2}, {88, 15, -275, 4}, {120, 15, -273, 1}, {120, 15, -274, 2}, {120, 15, -275, 4}};
    }

    private static class DistanceInfo {
        int missingFieldMask;
        int extraFieldMask;

        private DistanceInfo() {
        }

        void clear() {
            this.extraFieldMask = 0;
            this.missingFieldMask = 0;
        }

        void setTo(DistanceInfo other) {
            this.missingFieldMask = other.missingFieldMask;
            this.extraFieldMask = other.extraFieldMask;
        }

        void addMissing(int field) {
            this.missingFieldMask |= 1 << field;
        }

        void addExtra(int field) {
            this.extraFieldMask |= 1 << field;
        }

        public String toString() {
            return "missingFieldMask: " + DateTimePatternGenerator.showMask(this.missingFieldMask) + ", extraFieldMask: " + DateTimePatternGenerator.showMask(this.extraFieldMask);
        }
    }

    private static class DateTimeMatcher
    implements Comparable<DateTimeMatcher> {
        private int[] type = new int[16];
        private SkeletonFields original = new SkeletonFields();
        private SkeletonFields baseOriginal = new SkeletonFields();

        private DateTimeMatcher() {
        }

        public boolean fieldIsNumeric(int field) {
            return this.type[field] > 0;
        }

        public String toString() {
            return this.original.toString();
        }

        public String toCanonicalString() {
            return this.original.toCanonicalString();
        }

        String getBasePattern() {
            return this.baseOriginal.toString();
        }

        DateTimeMatcher set(String pattern, FormatParser fp, boolean allowDuplicateFields) {
            Arrays.fill(this.type, 0);
            this.original.clear();
            this.baseOriginal.clear();
            fp.set(pattern);
            for (Object obj : fp.getItems()) {
                VariableField item;
                String value;
                if (!(obj instanceof VariableField) || (value = (item = (VariableField)obj).toString()).charAt(0) == 'a') continue;
                int canonicalIndex = item.getCanonicalIndex();
                int[] row = types[canonicalIndex];
                int field = row[1];
                if (!this.original.isFieldEmpty(field)) {
                    char ch1 = this.original.getFieldChar(field);
                    char ch2 = value.charAt(0);
                    if (allowDuplicateFields || ch1 == 'r' && ch2 == 'U' || ch1 == 'U' && ch2 == 'r') continue;
                    throw new IllegalArgumentException("Conflicting fields:\t" + ch1 + ", " + value + "\t in " + pattern);
                }
                this.original.populate(field, value);
                char repeatChar = (char)row[0];
                int repeatCount = row[3];
                if ("GEzvQ".indexOf(repeatChar) >= 0) {
                    repeatCount = 1;
                }
                this.baseOriginal.populate(field, repeatChar, repeatCount);
                int subField = row[2];
                if (subField > 0) {
                    subField += value.length();
                }
                this.type[field] = subField;
            }
            return this;
        }

        int getFieldMask() {
            int result2 = 0;
            for (int i = 0; i < this.type.length; ++i) {
                if (this.type[i] == 0) continue;
                result2 |= 1 << i;
            }
            return result2;
        }

        void extractFrom(DateTimeMatcher source, int fieldMask) {
            for (int i = 0; i < this.type.length; ++i) {
                if ((fieldMask & 1 << i) != 0) {
                    this.type[i] = source.type[i];
                    this.original.copyFieldFrom(source.original, i);
                    continue;
                }
                this.type[i] = 0;
                this.original.clearField(i);
            }
        }

        int getDistance(DateTimeMatcher other, int includeMask, DistanceInfo distanceInfo) {
            int result2 = 0;
            distanceInfo.clear();
            for (int i = 0; i < 16; ++i) {
                int otherType;
                int myType = (includeMask & 1 << i) == 0 ? 0 : this.type[i];
                if (myType == (otherType = other.type[i])) continue;
                if (myType == 0) {
                    result2 += 65536;
                    distanceInfo.addExtra(i);
                    continue;
                }
                if (otherType == 0) {
                    result2 += 4096;
                    distanceInfo.addMissing(i);
                    continue;
                }
                result2 += Math.abs(myType - otherType);
            }
            return result2;
        }

        @Override
        public int compareTo(DateTimeMatcher that) {
            int result2 = this.original.compareTo(that.original);
            return result2 > 0 ? -1 : (result2 < 0 ? 1 : 0);
        }

        public boolean equals(Object other) {
            return this == other || other != null && other instanceof DateTimeMatcher && this.original.equals(((DateTimeMatcher)other).original);
        }

        public int hashCode() {
            return this.original.hashCode();
        }
    }

    private static class SkeletonFields {
        private byte[] chars = new byte[16];
        private byte[] lengths = new byte[16];
        private static final byte DEFAULT_CHAR = 0;
        private static final byte DEFAULT_LENGTH = 0;

        private SkeletonFields() {
        }

        public void clear() {
            Arrays.fill(this.chars, (byte)0);
            Arrays.fill(this.lengths, (byte)0);
        }

        void copyFieldFrom(SkeletonFields other, int field) {
            this.chars[field] = other.chars[field];
            this.lengths[field] = other.lengths[field];
        }

        void clearField(int field) {
            this.chars[field] = 0;
            this.lengths[field] = 0;
        }

        char getFieldChar(int field) {
            return (char)this.chars[field];
        }

        int getFieldLength(int field) {
            return this.lengths[field];
        }

        void populate(int field, String value) {
            for (char ch : value.toCharArray()) {
                assert (ch == value.charAt(0));
            }
            this.populate(field, value.charAt(0), value.length());
        }

        void populate(int field, char ch, int length) {
            assert (ch <= '\u007f');
            assert (length <= 127);
            this.chars[field] = (byte)ch;
            this.lengths[field] = (byte)length;
        }

        public boolean isFieldEmpty(int field) {
            return this.lengths[field] == 0;
        }

        public String toString() {
            return this.appendTo(new StringBuilder()).toString();
        }

        public String toCanonicalString() {
            return this.appendTo(new StringBuilder(), true).toString();
        }

        public StringBuilder appendTo(StringBuilder sb) {
            return this.appendTo(sb, false);
        }

        private StringBuilder appendTo(StringBuilder sb, boolean canonical) {
            for (int i = 0; i < 16; ++i) {
                this.appendFieldTo(i, sb, canonical);
            }
            return sb;
        }

        public StringBuilder appendFieldTo(int field, StringBuilder sb) {
            return this.appendFieldTo(field, sb, false);
        }

        private StringBuilder appendFieldTo(int field, StringBuilder sb, boolean canonical) {
            char ch = (char)this.chars[field];
            int length = this.lengths[field];
            if (canonical) {
                ch = DateTimePatternGenerator.getCanonicalChar(field, ch);
            }
            for (int i = 0; i < length; ++i) {
                sb.append(ch);
            }
            return sb;
        }

        public int compareTo(SkeletonFields other) {
            for (int i = 0; i < 16; ++i) {
                int charDiff = this.chars[i] - other.chars[i];
                if (charDiff != 0) {
                    return charDiff;
                }
                int lengthDiff = this.lengths[i] - other.lengths[i];
                if (lengthDiff == 0) continue;
                return lengthDiff;
            }
            return 0;
        }

        public boolean equals(Object other) {
            return this == other || other != null && other instanceof SkeletonFields && this.compareTo((SkeletonFields)other) == 0;
        }

        public int hashCode() {
            return Arrays.hashCode(this.chars) ^ Arrays.hashCode(this.lengths);
        }
    }

    private static enum DTPGflags {
        FIX_FRACTIONAL_SECONDS,
        SKELETON_USES_CAP_J,
        SKELETON_USES_b,
        SKELETON_USES_B;


        public static DTPGflags getFlag(String preferred) {
            char last = preferred.charAt(preferred.length() - 1);
            switch (last) {
                case 'b': {
                    return SKELETON_USES_b;
                }
                case 'B': {
                    return SKELETON_USES_B;
                }
            }
            return null;
        }
    }

    private static class PatternWithSkeletonFlag {
        public String pattern;
        public boolean skeletonWasSpecified;

        public PatternWithSkeletonFlag(String pat, boolean skelSpecified) {
            this.pattern = pat;
            this.skeletonWasSpecified = skelSpecified;
        }

        public String toString() {
            return this.pattern + "," + this.skeletonWasSpecified;
        }
    }

    private static class PatternWithMatcher {
        public String pattern;
        public DateTimeMatcher matcherWithSkeleton;

        public PatternWithMatcher(String pat, DateTimeMatcher matcher) {
            this.pattern = pat;
            this.matcherWithSkeleton = matcher;
        }
    }

    @Deprecated
    public static class FormatParser {
        private static final UnicodeSet SYNTAX_CHARS = new UnicodeSet("[a-zA-Z]").freeze();
        private static final UnicodeSet QUOTING_CHARS = new UnicodeSet("[[[:script=Latn:][:script=Cyrl:]]&[[:L:][:M:]]]").freeze();
        private transient PatternTokenizer tokenizer = new PatternTokenizer().setSyntaxCharacters(SYNTAX_CHARS).setExtraQuotingCharacters(QUOTING_CHARS).setUsingQuote(true);
        private List<Object> items = new ArrayList<Object>();

        @Deprecated
        public FormatParser() {
        }

        @Deprecated
        public final FormatParser set(String string2) {
            return this.set(string2, false);
        }

        @Deprecated
        public FormatParser set(String string2, boolean strict) {
            this.items.clear();
            if (string2.length() == 0) {
                return this;
            }
            this.tokenizer.setPattern(string2);
            StringBuffer buffer = new StringBuffer();
            StringBuffer variable = new StringBuffer();
            while (true) {
                buffer.setLength(0);
                int status = this.tokenizer.next(buffer);
                if (status == 0) break;
                if (status == 1) {
                    if (variable.length() != 0 && buffer.charAt(0) != variable.charAt(0)) {
                        this.addVariable(variable, false);
                    }
                    variable.append(buffer);
                    continue;
                }
                this.addVariable(variable, false);
                this.items.add(buffer.toString());
            }
            this.addVariable(variable, false);
            return this;
        }

        private void addVariable(StringBuffer variable, boolean strict) {
            if (variable.length() != 0) {
                this.items.add(new VariableField(variable.toString(), strict));
                variable.setLength(0);
            }
        }

        @Deprecated
        public List<Object> getItems() {
            return this.items;
        }

        @Deprecated
        public String toString() {
            return this.toString(0, this.items.size());
        }

        @Deprecated
        public String toString(int start, int limit) {
            StringBuilder result2 = new StringBuilder();
            for (int i = start; i < limit; ++i) {
                Object item = this.items.get(i);
                if (item instanceof String) {
                    String itemString = (String)item;
                    result2.append(this.tokenizer.quoteLiteral(itemString));
                    continue;
                }
                result2.append(this.items.get(i).toString());
            }
            return result2.toString();
        }

        @Deprecated
        public boolean hasDateAndTimeFields() {
            int foundMask = 0;
            for (Object item : this.items) {
                if (!(item instanceof VariableField)) continue;
                int type = ((VariableField)item).getType();
                foundMask |= 1 << type;
            }
            boolean isDate = (foundMask & 0x3FF) != 0;
            boolean isTime = (foundMask & 0xFC00) != 0;
            return isDate && isTime;
        }

        @Deprecated
        public Object quoteLiteral(String string2) {
            return this.tokenizer.quoteLiteral(string2);
        }
    }

    @Deprecated
    public static class VariableField {
        private final String string;
        private final int canonicalIndex;

        @Deprecated
        public VariableField(String string2) {
            this(string2, false);
        }

        @Deprecated
        public VariableField(String string2, boolean strict) {
            this.canonicalIndex = DateTimePatternGenerator.getCanonicalIndex(string2, strict);
            if (this.canonicalIndex < 0) {
                throw new IllegalArgumentException("Illegal datetime field:\t" + string2);
            }
            this.string = string2;
        }

        @Deprecated
        public int getType() {
            return types[this.canonicalIndex][1];
        }

        @Deprecated
        public static String getCanonicalCode(int type) {
            try {
                return CANONICAL_ITEMS[type];
            }
            catch (Exception e) {
                return String.valueOf(type);
            }
        }

        @Deprecated
        public boolean isNumeric() {
            return types[this.canonicalIndex][2] > 0;
        }

        private int getCanonicalIndex() {
            return this.canonicalIndex;
        }

        @Deprecated
        public String toString() {
            return this.string;
        }
    }

    public static final class PatternInfo {
        public static final int OK = 0;
        public static final int BASE_CONFLICT = 1;
        public static final int CONFLICT = 2;
        public int status;
        public String conflictingPattern;
    }

    private static class DayPeriodAllowedHoursSink
    extends UResource.Sink {
        HashMap<String, String[]> tempMap;

        private DayPeriodAllowedHoursSink(HashMap<String, String[]> tempMap) {
            this.tempMap = tempMap;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table timeData = value.getTable();
            int i = 0;
            while (timeData.getKeyAndValue(i, key, value)) {
                String regionOrLocale = key.toString();
                UResource.Table formatList = value.getTable();
                int j = 0;
                while (formatList.getKeyAndValue(j, key, value)) {
                    if (key.contentEquals("allowed")) {
                        this.tempMap.put(regionOrLocale, value.getStringArrayOrStringAsArray());
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private class AvailableFormatsSink
    extends UResource.Sink {
        PatternInfo returnInfo;

        public AvailableFormatsSink(PatternInfo returnInfo) {
            this.returnInfo = returnInfo;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean isRoot) {
            UResource.Table formatsTable = value.getTable();
            int i = 0;
            while (formatsTable.getKeyAndValue(i, key, value)) {
                String formatKey = key.toString();
                if (!DateTimePatternGenerator.this.isAvailableFormatSet(formatKey)) {
                    DateTimePatternGenerator.this.setAvailableFormat(formatKey);
                    String formatValue = value.toString();
                    DateTimePatternGenerator.this.addPatternWithSkeleton(formatValue, formatKey, !isRoot, this.returnInfo);
                }
                ++i;
            }
        }
    }

    private class AppendItemNamesSink
    extends UResource.Sink {
        private AppendItemNamesSink() {
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table itemsTable = value.getTable();
            int i = 0;
            while (itemsTable.getKeyAndValue(i, key, value)) {
                int field = DateTimePatternGenerator.getCLDRFieldNumber(key);
                if (field != -1) {
                    UResource.Table detailsTable = value.getTable();
                    int j = 0;
                    while (detailsTable.getKeyAndValue(j, key, value)) {
                        if (key.contentEquals("dn")) {
                            if (DateTimePatternGenerator.this.getAppendItemName(field) != null) break;
                            DateTimePatternGenerator.this.setAppendItemName(field, value.toString());
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private class AppendItemFormatsSink
    extends UResource.Sink {
        private AppendItemFormatsSink() {
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table itemsTable = value.getTable();
            int i = 0;
            while (itemsTable.getKeyAndValue(i, key, value)) {
                int field = DateTimePatternGenerator.getAppendFormatNumber(key);
                assert (field != -1);
                if (DateTimePatternGenerator.this.getAppendItemFormat(field) == null) {
                    DateTimePatternGenerator.this.setAppendItemFormat(field, value.toString());
                }
                ++i;
            }
        }
    }
}

