/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DynamicFetch
extends Fetch {
    protected Set<Integer> skipCols;
    protected ResultSet resultSet;

    public DynamicFetch(DataHandler datahandler) {
        super(datahandler);
    }

    @Override
    public void add(ResultSet resultSet) {
        this.add(resultSet, null);
    }

    @Override
    public void add(ResultSet resultSet, Set<Integer> skipCols) {
        if (this.resultSet != null) {
            throw zxJDBC.makeException(zxJDBC.getString("onlyOneResultSet"));
        }
        try {
            if (resultSet != null && resultSet.getMetaData() != null) {
                if (this.description == Py.None) {
                    this.description = this.createDescription(resultSet.getMetaData());
                }
                this.resultSet = resultSet;
                this.skipCols = skipCols;
                this.rowcount = 0;
                this.rownumber = 0;
            }
        }
        catch (PyException e) {
            throw e;
        }
        catch (Throwable e) {
            throw zxJDBC.makeException(e);
        }
    }

    @Override
    public void add(CallableStatement callableStatement, Procedure procedure, PyObject params) {
        throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("nocallprocsupport"));
    }

    @Override
    public PyObject fetchall() {
        return this.fetch(0, true);
    }

    @Override
    public PyObject fetchmany(int size) {
        return this.fetch(size, false);
    }

    private PyObject fetch(int size, boolean all) {
        PyList res = new PyList();
        if (this.resultSet == null) {
            throw zxJDBC.makeException(zxJDBC.DatabaseError, "no results");
        }
        try {
            boolean bl = all = size < 0 ? true : all;
            while ((size-- > 0 || all) && this.resultSet.next()) {
                PyTuple tuple = this.createResult(this.resultSet, this.skipCols, this.description);
                res.append(tuple);
                ++this.rowcount;
                this.rownumber = this.resultSet.getRow();
            }
        }
        catch (AbstractMethodError e) {
            throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("nodynamiccursors"));
        }
        catch (PyException e) {
            throw e;
        }
        catch (Throwable e) {
            throw zxJDBC.makeException(e);
        }
        return res;
    }

    @Override
    public PyObject nextset() {
        return Py.None;
    }

    @Override
    public void scroll(int value, String mode) {
        try {
            int type = this.resultSet.getType();
            if (type != 1003 || value > 0) {
                if ("relative".equals(mode)) {
                    if (value < 0) {
                        value = Math.abs(this.rownumber + value);
                    } else if (value > 0) {
                        value = this.rownumber + value + 1;
                    }
                } else if ("absolute".equals(mode)) {
                    if (value < 0) {
                        throw zxJDBC.makeException(Py.IndexError, "cursor index [" + value + "] out of range");
                    }
                } else {
                    throw zxJDBC.makeException(zxJDBC.ProgrammingError, "invalid cursor scroll mode [" + mode + "]");
                }
                if (value == 0) {
                    this.resultSet.beforeFirst();
                } else if (!this.resultSet.absolute(value)) {
                    throw zxJDBC.makeException(Py.IndexError, "cursor index [" + value + "] out of range");
                }
            } else {
                String msg = "dynamic result set of type [" + type + "] does not support scrolling";
                throw zxJDBC.makeException(zxJDBC.NotSupportedError, msg);
            }
            this.rownumber = this.resultSet.getRow();
        }
        catch (AbstractMethodError e) {
            throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("nodynamiccursors"));
        }
        catch (SQLException e) {
            throw zxJDBC.makeException(e);
        }
        catch (Throwable t) {
            throw zxJDBC.makeException(t);
        }
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.resultSet == null) {
            return;
        }
        this.rownumber = -1;
        try {
            this.resultSet.close();
        }
        finally {
            this.resultSet = null;
        }
    }
}

