/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyComplex;
import org.python.core.PyDictProxy;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyIdentityTuple;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject$PyExposer;
import org.python.core.PyProxy;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.ThreadState;
import org.python.core.WrappedIterIterator;
import org.python.core.__builtin__;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="object", doc="The most base type")
public class PyObject
implements Serializable {
    public static final PyType TYPE;
    protected PyType objtype;
    protected Object javaProxy;
    private static final Map<Class<?>, Class<?>> primitiveMap;

    public PyObject(PyType objtype) {
        this.objtype = objtype;
    }

    public PyObject() {
        this.objtype = PyType.fromClass(this.getClass(), false);
    }

    PyObject(boolean ignored) {
        this.objtype = (PyType)this;
    }

    @ExposedNew
    final void object___init__(PyObject[] args, String[] keywords) {
    }

    public PyType getType() {
        return this.objtype;
    }

    public void setType(PyType type) {
        if (type.builtin || this.getType().builtin) {
            throw Py.TypeError("__class__ assignment: only for heap types");
        }
        type.compatibleForAssignment(this.getType(), "__class__");
        this.objtype = type;
    }

    public void delType() {
        throw Py.TypeError("can't delete __class__ attribute");
    }

    public PyObject fastGetClass() {
        return this.objtype;
    }

    public void dispatch__init__(PyObject[] args, String[] keywords) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void proxyInit() {
        PyProxy ts;
        Class<?> c = this.getType().getProxyType();
        if (this.javaProxy != null || c == null) {
            return;
        }
        if (!PyProxy.class.isAssignableFrom(c)) {
            throw Py.SystemError("Automatic proxy initialization should only occur on proxy classes");
        }
        ThreadState threadState = Py.getThreadState();
        try {
            threadState.pushInitializingProxy(this);
            try {
                ts = (PyProxy)c.newInstance();
            }
            catch (InstantiationException e) {
                Class<?> sup = c.getSuperclass();
                String msg = "Default constructor failed for Java superclass";
                if (sup != null) {
                    msg = msg + " " + sup.getName();
                }
                throw Py.TypeError(msg);
            }
            catch (NoSuchMethodError nsme) {
                throw Py.TypeError("constructor requires arguments");
            }
            catch (Exception exc) {
                throw Py.JavaError(exc);
            }
        }
        finally {
            void proxy;
            proxy.popInitializingProxy();
        }
        if (this.javaProxy != null && this.javaProxy != ts) {
            throw Py.TypeError("Proxy instance already initialized");
        }
        PyObject proxyInstance = ts._getPyInstance();
        if (proxyInstance != null && proxyInstance != this) {
            throw Py.TypeError("Proxy initialized with another instance");
        }
        this.javaProxy = ts;
    }

    public PyString __repr__() {
        return new PyString(this.toString());
    }

    public String toString() {
        return this.object_toString();
    }

    final String object_toString() {
        if (this.getType() == null) {
            return "unknown object";
        }
        String name = this.getType().getName();
        if (name == null) {
            return "unknown object";
        }
        PyObject module = this.getType().getModule();
        if (module instanceof PyString && !module.toString().equals("__builtin__")) {
            return String.format("<%s.%s object at %s>", module.toString(), name, Py.idstr(this));
        }
        return String.format("<%s object at %s>", name, Py.idstr(this));
    }

    public PyString __str__() {
        return this.__repr__();
    }

    public PyUnicode __unicode__() {
        return new PyUnicode(this.__str__());
    }

    public final PyInteger __hash__() {
        return new PyInteger(this.hashCode());
    }

    public int hashCode() {
        return this.object___hash__();
    }

    final int object___hash__() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object ob_other) {
        if (ob_other == this) {
            return true;
        }
        return ob_other instanceof PyObject && this._eq((PyObject)ob_other).__nonzero__();
    }

    public boolean __nonzero__() {
        return true;
    }

    public Object __tojava__(Class<?> c) {
        block7: {
            Class<?> tmp;
            if ((c == Object.class || c == Serializable.class) && this.getJavaProxy() != null) {
                return this.javaProxy;
            }
            if (c.isInstance(this)) {
                return this;
            }
            if (c.isPrimitive() && (tmp = primitiveMap.get(c)) != null) {
                c = tmp;
            }
            if (c.isInstance(this.getJavaProxy())) {
                return this.javaProxy;
            }
            if (c == Double.class || c == Float.class) {
                try {
                    return this.__float__().asDouble();
                }
                catch (PyException pye) {
                    if (pye.match(Py.AttributeError)) break block7;
                    throw pye;
                }
            }
        }
        return Py.NoConversion;
    }

    protected synchronized Object getJavaProxy() {
        if (this.javaProxy == null) {
            this.proxyInit();
        }
        return this.javaProxy;
    }

    public PyObject __call__(PyObject[] args, String[] keywords) {
        throw Py.TypeError(String.format("'%s' object is not callable", this.getType().fastGetName()));
    }

    public PyObject __call__(ThreadState state, PyObject[] args, String[] keywords) {
        return this.__call__(args, keywords);
    }

    public PyObject __call__(PyObject arg1, PyObject[] args, String[] keywords) {
        PyObject[] newArgs = new PyObject[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = arg1;
        return this.__call__(newArgs, keywords);
    }

    public PyObject __call__(ThreadState state, PyObject arg1, PyObject[] args, String[] keywords) {
        return this.__call__(arg1, args, keywords);
    }

    public PyObject __call__(PyObject[] args) {
        return this.__call__(args, Py.NoKeywords);
    }

    public PyObject __call__(ThreadState state, PyObject[] args) {
        return this.__call__(args);
    }

    public PyObject __call__() {
        return this.__call__(Py.EmptyObjects, Py.NoKeywords);
    }

    public PyObject __call__(ThreadState state) {
        return this.__call__();
    }

    public PyObject __call__(PyObject arg0) {
        return this.__call__(new PyObject[]{arg0}, Py.NoKeywords);
    }

    public PyObject __call__(ThreadState state, PyObject arg0) {
        return this.__call__(arg0);
    }

    public PyObject __call__(PyObject arg0, PyObject arg1) {
        return this.__call__(new PyObject[]{arg0, arg1}, Py.NoKeywords);
    }

    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1) {
        return this.__call__(arg0, arg1);
    }

    public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
        return this.__call__(new PyObject[]{arg0, arg1, arg2}, Py.NoKeywords);
    }

    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1, PyObject arg2) {
        return this.__call__(arg0, arg1, arg2);
    }

    public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
        return this.__call__(new PyObject[]{arg0, arg1, arg2, arg3}, Py.NoKeywords);
    }

    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
        return this.__call__(arg0, arg1, arg2, arg3);
    }

    /*
     * WARNING - void declaration
     */
    public PyObject _callextra(PyObject[] args, String[] keywords, PyObject starargs, PyObject kwargs) {
        int argslen = args.length;
        String name = this instanceof PyFunction ? ((PyFunction)this).__name__ + "() " : (this instanceof PyBuiltinCallable ? ((PyBuiltinCallable)this).fastGetName().toString() + "() " : this.getType().fastGetName() + " ");
        if (kwargs != null) {
            PyObject keys = kwargs.__findattr__("keys");
            if (keys == null) {
                throw Py.TypeError(name + "argument after ** must be a mapping");
            }
            for (String keyword2 : keywords) {
                if (kwargs.__finditem__(keyword2) == null) continue;
                throw Py.TypeError(name + "got multiple values for keyword argument '" + keyword2 + "'");
            }
            argslen += kwargs.__len__();
        }
        ArrayList<PyObject> starObjs = null;
        if (starargs != null) {
            starObjs = new ArrayList<PyObject>();
            PyObject iter = Py.iter(starargs, name + "argument after * must be a sequence");
            PyObject cur = null;
            while ((cur = iter.__iternext__()) != null) {
                starObjs.add(cur);
            }
            argslen += starObjs.size();
        }
        PyObject[] newargs = new PyObject[argslen];
        int argidx = args.length - keywords.length;
        System.arraycopy(args, 0, newargs, 0, argidx);
        if (starObjs != null) {
            Iterator it = starObjs.iterator();
            while (it.hasNext()) {
                newargs[argidx++] = (PyObject)it.next();
            }
        }
        System.arraycopy(args, args.length - keywords.length, newargs, argidx, keywords.length);
        argidx += keywords.length;
        if (kwargs != null) {
            PyObject i;
            String[] newkeywords = new String[keywords.length + kwargs.__len__()];
            System.arraycopy(keywords, 0, newkeywords, 0, keywords.length);
            PyObject keys = kwargs.invoke("keys");
            int n = 0;
            while ((i = keys.__finditem__(n)) != null) {
                void key;
                if (!(i instanceof PyString)) {
                    throw Py.TypeError(name + "keywords must be strings");
                }
                newkeywords[keywords.length + key] = ((PyString)i).internedString();
                newargs[argidx++] = kwargs.__finditem__(i);
                ++key;
            }
            keywords = newkeywords;
        }
        if (newargs.length != argidx) {
            args = new PyObject[argidx];
            System.arraycopy(newargs, 0, args, 0, argidx);
        } else {
            args = newargs;
        }
        return this.__call__(args, keywords);
    }

    public boolean isCallable() {
        return this.getType().lookup("__call__") != null;
    }

    public boolean isNumberType() {
        PyType type = this.getType();
        return type.lookup("__int__") != null || type.lookup("__float__") != null;
    }

    public boolean isMappingType() {
        PyType type = this.getType();
        return type.lookup("__getitem__") != null && (!this.isSequenceType() || type.lookup("__getslice__") == null);
    }

    public boolean isSequenceType() {
        return this.getType().lookup("__getitem__") != null;
    }

    public boolean isIndex() {
        return this.getType().lookup("__index__") != null;
    }

    public int __len__() {
        throw Py.TypeError(String.format("object of type '%.200s' has no len()", this.getType().fastGetName()));
    }

    public PyObject __finditem__(PyObject key) {
        throw Py.TypeError(String.format("'%.200s' object is unsubscriptable", this.getType().fastGetName()));
    }

    public PyObject __finditem__(int key) {
        return this.__finditem__(new PyInteger(key));
    }

    public PyObject __finditem__(String key) {
        return this.__finditem__(new PyString(key));
    }

    public PyObject __getitem__(int key) {
        PyObject ret = this.__finditem__(key);
        if (ret == null) {
            throw Py.KeyError("" + key);
        }
        return ret;
    }

    public PyObject __getitem__(PyObject key) {
        PyObject ret = this.__finditem__(key);
        if (ret == null) {
            throw Py.KeyError(key);
        }
        return ret;
    }

    public void __setitem__(PyObject key, PyObject value) {
        throw Py.TypeError(String.format("'%.200s' object does not support item assignment", this.getType().fastGetName()));
    }

    public void __setitem__(String key, PyObject value) {
        this.__setitem__(new PyString(key), value);
    }

    public void __setitem__(int key, PyObject value) {
        this.__setitem__(new PyInteger(key), value);
    }

    public void __delitem__(PyObject key) {
        throw Py.TypeError(String.format("'%.200s' object doesn't support item deletion", this.getType().fastGetName()));
    }

    public void __delitem__(String key) {
        this.__delitem__(new PyString(key));
    }

    public PyObject __getslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        PySlice s = new PySlice(s_start, s_stop, s_step);
        return this.__getitem__(s);
    }

    public void __setslice__(PyObject s_start, PyObject s_stop, PyObject s_step, PyObject value) {
        PySlice s = new PySlice(s_start, s_stop, s_step);
        this.__setitem__(s, value);
    }

    public void __delslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        PySlice s = new PySlice(s_start, s_stop, s_step);
        this.__delitem__(s);
    }

    public PyObject __getslice__(PyObject start, PyObject stop) {
        return this.__getslice__(start, stop, null);
    }

    public void __setslice__(PyObject start, PyObject stop, PyObject value) {
        this.__setslice__(start, stop, null, value);
    }

    public void __delslice__(PyObject start, PyObject stop) {
        this.__delslice__(start, stop, null);
    }

    public PyObject __iter__() {
        throw Py.TypeError(String.format("'%.200s' object is not iterable", this.getType().fastGetName()));
    }

    public Iterable<PyObject> asIterable() {
        return new Iterable<PyObject>(){

            @Override
            public Iterator<PyObject> iterator() {
                return new WrappedIterIterator<PyObject>(PyObject.this.__iter__()){

                    @Override
                    public PyObject next() {
                        return this.getNext();
                    }
                };
            }
        };
    }

    public PyObject __iternext__() {
        return null;
    }

    public final PyObject __findattr__(PyString name) {
        if (name == null) {
            return null;
        }
        return this.__findattr__(name.internedString());
    }

    public final PyObject __findattr__(String name) {
        try {
            return this.__findattr_ex__(name);
        }
        catch (PyException exc) {
            if (exc.match(Py.AttributeError)) {
                return null;
            }
            throw exc;
        }
    }

    public PyObject __findattr_ex__(String name) {
        return this.object___findattr__(name);
    }

    public final PyObject __getattr__(PyString name) {
        return this.__getattr__(name.internedString());
    }

    public final PyObject __getattr__(String name) {
        PyObject ret = this.__findattr_ex__(name);
        if (ret == null) {
            this.noAttributeError(name);
        }
        return ret;
    }

    public void noAttributeError(String name) {
        throw Py.AttributeError(String.format("'%.50s' object has no attribute '%.400s'", this.getType().fastGetName(), name));
    }

    public void readonlyAttributeError(String name) {
        throw Py.TypeError("readonly attribute");
    }

    public final void __setattr__(PyString name, PyObject value) {
        this.__setattr__(name.internedString(), value);
    }

    public void __setattr__(String name, PyObject value) {
        this.object___setattr__(name, value);
    }

    public final void __delattr__(PyString name) {
        this.__delattr__(name.internedString());
    }

    public void __delattr__(String name) {
        this.object___delattr__(name);
    }

    protected PyObject impAttr(String name) {
        return this.__findattr__(name);
    }

    protected void mergeListAttr(PyDictionary accum, String attr) {
        PyObject obj = this.__findattr__(attr);
        if (obj == null) {
            return;
        }
        if (obj instanceof PyList) {
            for (PyObject name : obj.asIterable()) {
                accum.__setitem__(name, Py.None);
            }
        }
    }

    protected void mergeDictAttr(PyDictionary accum, String attr) {
        PyObject obj = this.__findattr__(attr);
        if (obj == null) {
            return;
        }
        if (obj instanceof PyDictionary || obj instanceof PyStringMap || obj instanceof PyDictProxy) {
            accum.update(obj);
        }
    }

    protected void mergeClassDict(PyDictionary accum, PyObject aClass) {
        aClass.mergeDictAttr(accum, "__dict__");
        PyObject bases = aClass.__findattr__("__bases__");
        if (bases == null) {
            return;
        }
        int len = bases.__len__();
        for (int i = 0; i < len; ++i) {
            this.mergeClassDict(accum, bases.__getitem__(i));
        }
    }

    protected void __rawdir__(PyDictionary accum) {
        this.mergeDictAttr(accum, "__dict__");
        this.mergeListAttr(accum, "__methods__");
        this.mergeListAttr(accum, "__members__");
        PyObject itsClass = this.__findattr__("__class__");
        if (itsClass != null) {
            this.mergeClassDict(accum, itsClass);
        }
    }

    public PyObject __dir__() {
        PyDictionary accum = new PyDictionary();
        this.__rawdir__(accum);
        PyList ret = accum.keys();
        ret.sort();
        return ret;
    }

    public PyObject _doget(PyObject container) {
        return this;
    }

    public PyObject _doget(PyObject container, PyObject wherefound) {
        return this._doget(container);
    }

    public boolean _doset(PyObject container, PyObject value) {
        return false;
    }

    boolean jdontdel() {
        return false;
    }

    public Object __coerce_ex__(PyObject o) {
        return null;
    }

    PyObject[] _coerce(PyObject other) {
        if (this.getType() == other.getType() && !(this instanceof PyInstance)) {
            return new PyObject[]{this, other};
        }
        Object result = this.__coerce_ex__(other);
        if (result != null && result != Py.None) {
            if (result instanceof PyObject[]) {
                return (PyObject[])result;
            }
            return new PyObject[]{this, (PyObject)result};
        }
        result = other.__coerce_ex__(this);
        if (result != null && result != Py.None) {
            if (result instanceof PyObject[]) {
                return (PyObject[])result;
            }
            return new PyObject[]{(PyObject)result, other};
        }
        return null;
    }

    public final PyObject __coerce__(PyObject pyo) {
        Object o = this.__coerce_ex__(pyo);
        if (o == null) {
            throw Py.AttributeError("__coerce__");
        }
        return this.adaptToCoerceTuple(o);
    }

    protected final PyObject adaptToCoerceTuple(Object o) {
        if (o == Py.None) {
            return Py.NotImplemented;
        }
        if (o instanceof PyObject[]) {
            return new PyTuple((PyObject[])o);
        }
        return new PyTuple(this, (PyObject)o);
    }

    public int __cmp__(PyObject other) {
        return -2;
    }

    public PyObject __eq__(PyObject other) {
        return null;
    }

    public PyObject __ne__(PyObject other) {
        return null;
    }

    public PyObject __le__(PyObject other) {
        return null;
    }

    public PyObject __lt__(PyObject other) {
        return null;
    }

    public PyObject __ge__(PyObject other) {
        return null;
    }

    public PyObject __gt__(PyObject other) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int _cmp(PyObject o) {
        ThreadState ts;
        PyObject token2;
        block13: {
            PyObject result;
            block12: {
                block11: {
                    block10: {
                        int n;
                        if (this == o) {
                            return 0;
                        }
                        token2 = null;
                        ts = Py.getThreadState();
                        try {
                            if (++ts.compareStateNesting <= 500 || (token2 = PyObject.check_recursion(ts, this, o)) != null) break block10;
                            n = 0;
                        }
                        catch (Throwable throwable) {
                            PyObject.delete_token(ts, token2);
                            --ts.compareStateNesting;
                            throw throwable;
                        }
                        PyObject.delete_token(ts, token2);
                        --ts.compareStateNesting;
                        return n;
                    }
                    result = this.__eq__(o);
                    if (result == null) {
                        result = o.__eq__(this);
                    }
                    if (result == null || !result.__nonzero__()) break block11;
                    int n = 0;
                    PyObject.delete_token(ts, token2);
                    --ts.compareStateNesting;
                    return n;
                }
                result = this.__lt__(o);
                if (result == null) {
                    result = o.__gt__(this);
                }
                if (result == null || !result.__nonzero__()) break block12;
                int n = -1;
                PyObject.delete_token(ts, token2);
                --ts.compareStateNesting;
                return n;
            }
            result = this.__gt__(o);
            if (result == null) {
                result = o.__lt__(this);
            }
            if (result == null || !result.__nonzero__()) break block13;
            int n = 1;
            PyObject.delete_token(ts, token2);
            --ts.compareStateNesting;
            return n;
        }
        int n = this._cmp_unsafe(o);
        PyObject.delete_token(ts, token2);
        --ts.compareStateNesting;
        return n;
    }

    private PyObject make_pair(PyObject o) {
        if (System.identityHashCode(this) < System.identityHashCode(o)) {
            return new PyIdentityTuple(new PyObject[]{this, o});
        }
        return new PyIdentityTuple(new PyObject[]{o, this});
    }

    /*
     * WARNING - void declaration
     */
    private final int _default_cmp(PyObject other) {
        String typeName;
        PyType type;
        if (this._is(other).__nonzero__()) {
            return 0;
        }
        if (this == Py.None) {
            return -1;
        }
        if (other == Py.None) {
            return 1;
        }
        PyType pyType = this.getType();
        if (pyType == (type = other.getType())) {
            return Py.id(this) < Py.id(other) ? -1 : 1;
        }
        String otherType = this.isNumberType() ? "" : pyType.fastGetName();
        int otherTypeName = otherType.compareTo(typeName = other.isNumberType() ? "" : type.fastGetName());
        if (otherTypeName == 0) {
            void result;
            return Py.id((PyObject)result) < Py.id(type) ? -1 : 1;
        }
        return otherTypeName < 0 ? -1 : 1;
    }

    private final int _cmp_unsafe(PyObject other) {
        if (this == other) {
            return 0;
        }
        int result = this._try__cmp__(other);
        if (result != -2) {
            return result;
        }
        return this._default_cmp(other);
    }

    private final int _cmpeq_unsafe(PyObject other) {
        if (this == other) {
            return 0;
        }
        int result = this._try__cmp__(other);
        if (result != -2) {
            return result;
        }
        return this._is(other).__nonzero__() ? 0 : 1;
    }

    private int _try__cmp__(PyObject other) {
        int result = this.__cmp__(other);
        if (result != -2) {
            return result;
        }
        if (!(this instanceof PyInstance) && (result = other.__cmp__(this)) != -2) {
            return -result;
        }
        PyObject[] coerced = this._coerce(other);
        if (coerced != null && (result = coerced[0].__cmp__(coerced[1])) != -2) {
            return result;
        }
        return -2;
    }

    private static final PyObject check_recursion(ThreadState ts, PyObject o1, PyObject o2) {
        PyObject pair;
        PyDictionary stateDict = ts.getCompareStateDict();
        if (stateDict.__finditem__(pair = o1.make_pair(o2)) != null) {
            return null;
        }
        stateDict.__setitem__(pair, pair);
        return pair;
    }

    private static final void delete_token(ThreadState ts, PyObject token2) {
        if (token2 == null) {
            return;
        }
        PyDictionary stateDict = ts.getCompareStateDict();
        stateDict.__delitem__(token2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PyObject _eq(PyObject o) {
        ThreadState ts;
        PyObject token2;
        block8: {
            PyObject res;
            block7: {
                block6: {
                    PyBoolean pyBoolean;
                    PyType t2;
                    token2 = null;
                    PyType t1 = this.getType();
                    if (t1 != (t2 = o.getType()) && t2.isSubType(t1)) {
                        return o._eq(this);
                    }
                    ts = Py.getThreadState();
                    try {
                        if (++ts.compareStateNesting <= 10 || (token2 = PyObject.check_recursion(ts, this, o)) != null) break block6;
                        pyBoolean = Py.True;
                    }
                    catch (Throwable throwable) {
                        PyObject.delete_token(ts, token2);
                        --ts.compareStateNesting;
                        throw throwable;
                    }
                    PyObject.delete_token(ts, token2);
                    --ts.compareStateNesting;
                    return pyBoolean;
                }
                res = this.__eq__(o);
                if (res == null) break block7;
                PyObject pyObject = res;
                PyObject.delete_token(ts, token2);
                --ts.compareStateNesting;
                return pyObject;
            }
            res = o.__eq__(this);
            if (res == null) break block8;
            PyObject pyObject = res;
            PyObject.delete_token(ts, token2);
            --ts.compareStateNesting;
            return pyObject;
        }
        PyBoolean pyBoolean = this._cmpeq_unsafe(o) == 0 ? Py.True : Py.False;
        PyObject.delete_token(ts, token2);
        --ts.compareStateNesting;
        return pyBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PyObject _ne(PyObject o) {
        ThreadState ts;
        PyObject token2;
        block8: {
            PyObject res;
            block7: {
                block6: {
                    PyBoolean pyBoolean;
                    PyType t2;
                    token2 = null;
                    PyType t1 = this.getType();
                    if (t1 != (t2 = o.getType()) && t2.isSubType(t1)) {
                        return o._ne(this);
                    }
                    ts = Py.getThreadState();
                    try {
                        if (++ts.compareStateNesting <= 10 || (token2 = PyObject.check_recursion(ts, this, o)) != null) break block6;
                        pyBoolean = Py.False;
                    }
                    catch (Throwable throwable) {
                        PyObject.delete_token(ts, token2);
                        --ts.compareStateNesting;
                        throw throwable;
                    }
                    PyObject.delete_token(ts, token2);
                    --ts.compareStateNesting;
                    return pyBoolean;
                }
                res = this.__ne__(o);
                if (res == null) break block7;
                PyObject pyObject = res;
                PyObject.delete_token(ts, token2);
                --ts.compareStateNesting;
                return pyObject;
            }
            res = o.__ne__(this);
            if (res == null) break block8;
            PyObject pyObject = res;
            PyObject.delete_token(ts, token2);
            --ts.compareStateNesting;
            return pyObject;
        }
        PyBoolean pyBoolean = this._cmpeq_unsafe(o) != 0 ? Py.True : Py.False;
        PyObject.delete_token(ts, token2);
        --ts.compareStateNesting;
        return pyBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PyObject _le(PyObject o) {
        ThreadState ts;
        PyObject token2;
        block7: {
            PyObject res;
            block6: {
                PyObject pyObject;
                PyType t2;
                token2 = null;
                PyType t1 = this.getType();
                if (t1 != (t2 = o.getType()) && t2.isSubType(t1)) {
                    return o._ge(this);
                }
                ts = Py.getThreadState();
                try {
                    if (++ts.compareStateNesting > 10 && (token2 = PyObject.check_recursion(ts, this, o)) == null) {
                        throw Py.ValueError("can't order recursive values");
                    }
                    res = this.__le__(o);
                    if (res == null) break block6;
                    pyObject = res;
                }
                catch (Throwable throwable) {
                    PyObject.delete_token(ts, token2);
                    --ts.compareStateNesting;
                    throw throwable;
                }
                PyObject.delete_token(ts, token2);
                --ts.compareStateNesting;
                return pyObject;
            }
            res = o.__ge__(this);
            if (res == null) break block7;
            PyObject pyObject = res;
            PyObject.delete_token(ts, token2);
            --ts.compareStateNesting;
            return pyObject;
        }
        PyBoolean pyBoolean = this._cmp_unsafe(o) <= 0 ? Py.True : Py.False;
        PyObject.delete_token(ts, token2);
        --ts.compareStateNesting;
        return pyBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PyObject _lt(PyObject o) {
        ThreadState ts;
        PyObject token2;
        block7: {
            PyObject res;
            block6: {
                PyObject pyObject;
                PyType t2;
                token2 = null;
                PyType t1 = this.getType();
                if (t1 != (t2 = o.getType()) && t2.isSubType(t1)) {
                    return o._gt(this);
                }
                ts = Py.getThreadState();
                try {
                    if (++ts.compareStateNesting > 10 && (token2 = PyObject.check_recursion(ts, this, o)) == null) {
                        throw Py.ValueError("can't order recursive values");
                    }
                    res = this.__lt__(o);
                    if (res == null) break block6;
                    pyObject = res;
                }
                catch (Throwable throwable) {
                    PyObject.delete_token(ts, token2);
                    --ts.compareStateNesting;
                    throw throwable;
                }
                PyObject.delete_token(ts, token2);
                --ts.compareStateNesting;
                return pyObject;
            }
            res = o.__gt__(this);
            if (res == null) break block7;
            PyObject pyObject = res;
            PyObject.delete_token(ts, token2);
            --ts.compareStateNesting;
            return pyObject;
        }
        PyBoolean pyBoolean = this._cmp_unsafe(o) < 0 ? Py.True : Py.False;
        PyObject.delete_token(ts, token2);
        --ts.compareStateNesting;
        return pyBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PyObject _ge(PyObject o) {
        ThreadState ts;
        PyObject token2;
        block7: {
            PyObject res;
            block6: {
                PyObject pyObject;
                PyType t2;
                token2 = null;
                PyType t1 = this.getType();
                if (t1 != (t2 = o.getType()) && t2.isSubType(t1)) {
                    return o._le(this);
                }
                ts = Py.getThreadState();
                try {
                    if (++ts.compareStateNesting > 10 && (token2 = PyObject.check_recursion(ts, this, o)) == null) {
                        throw Py.ValueError("can't order recursive values");
                    }
                    res = this.__ge__(o);
                    if (res == null) break block6;
                    pyObject = res;
                }
                catch (Throwable throwable) {
                    PyObject.delete_token(ts, token2);
                    --ts.compareStateNesting;
                    throw throwable;
                }
                PyObject.delete_token(ts, token2);
                --ts.compareStateNesting;
                return pyObject;
            }
            res = o.__le__(this);
            if (res == null) break block7;
            PyObject pyObject = res;
            PyObject.delete_token(ts, token2);
            --ts.compareStateNesting;
            return pyObject;
        }
        PyBoolean pyBoolean = this._cmp_unsafe(o) >= 0 ? Py.True : Py.False;
        PyObject.delete_token(ts, token2);
        --ts.compareStateNesting;
        return pyBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PyObject _gt(PyObject o) {
        ThreadState ts;
        PyObject token2;
        block7: {
            PyObject res;
            block6: {
                PyObject pyObject;
                PyType t2;
                token2 = null;
                PyType t1 = this.getType();
                if (t1 != (t2 = o.getType()) && t2.isSubType(t1)) {
                    return o._lt(this);
                }
                ts = Py.getThreadState();
                try {
                    if (++ts.compareStateNesting > 10 && (token2 = PyObject.check_recursion(ts, this, o)) == null) {
                        throw Py.ValueError("can't order recursive values");
                    }
                    res = this.__gt__(o);
                    if (res == null) break block6;
                    pyObject = res;
                }
                catch (Throwable throwable) {
                    PyObject.delete_token(ts, token2);
                    --ts.compareStateNesting;
                    throw throwable;
                }
                PyObject.delete_token(ts, token2);
                --ts.compareStateNesting;
                return pyObject;
            }
            res = o.__lt__(this);
            if (res == null) break block7;
            PyObject pyObject = res;
            PyObject.delete_token(ts, token2);
            --ts.compareStateNesting;
            return pyObject;
        }
        PyBoolean pyBoolean = this._cmp_unsafe(o) > 0 ? Py.True : Py.False;
        PyObject.delete_token(ts, token2);
        --ts.compareStateNesting;
        return pyBoolean;
    }

    public PyObject _is(PyObject o) {
        return this == o || this.javaProxy != null && this.javaProxy == o.javaProxy ? Py.True : Py.False;
    }

    public PyObject _isnot(PyObject o) {
        return this != o && (this.javaProxy == null || this.javaProxy != o.javaProxy) ? Py.True : Py.False;
    }

    public final PyObject _in(PyObject o) {
        return Py.newBoolean(o.__contains__(this));
    }

    public final PyObject _notin(PyObject o) {
        return Py.newBoolean(!o.__contains__(this));
    }

    public boolean __contains__(PyObject o) {
        return this.object___contains__(o);
    }

    final boolean object___contains__(PyObject o) {
        for (PyObject item : this.asIterable()) {
            if (!o.equals(item)) continue;
            return true;
        }
        return false;
    }

    public PyObject __not__() {
        return this.__nonzero__() ? Py.False : Py.True;
    }

    public PyString __hex__() {
        throw Py.TypeError("hex() argument can't be converted to hex");
    }

    public PyString __oct__() {
        throw Py.TypeError("oct() argument can't be converted to oct");
    }

    public PyObject __int__() {
        throw Py.AttributeError("__int__");
    }

    public PyObject __long__() {
        throw Py.AttributeError("__long__");
    }

    public PyFloat __float__() {
        throw Py.AttributeError("__float__");
    }

    public PyComplex __complex__() {
        throw Py.AttributeError("__complex__");
    }

    public PyObject __pos__() {
        throw Py.TypeError(String.format("bad operand type for unary +: '%.200s'", this.getType().fastGetName()));
    }

    public PyObject __neg__() {
        throw Py.TypeError(String.format("bad operand type for unary -: '%.200s'", this.getType().fastGetName()));
    }

    public PyObject __abs__() {
        throw Py.TypeError(String.format("bad operand type for abs(): '%.200s'", this.getType().fastGetName()));
    }

    public PyObject __invert__() {
        throw Py.TypeError(String.format("bad operand type for unary ~: '%.200s'", this.getType().fastGetName()));
    }

    public PyObject __index__() {
        throw Py.TypeError(String.format("'%.200s' object cannot be interpreted as an index", this.getType().fastGetName()));
    }

    protected final String _unsupportedop(String op, PyObject o2) {
        Object[] args = new Object[]{op, this.getType().fastGetName(), o2.getType().fastGetName()};
        String msg = this.unsupportedopMessage(op, o2);
        if (msg == null) {
            msg = o2.runsupportedopMessage(op, o2);
        }
        if (msg == null) {
            msg = "unsupported operand type(s) for {0}: ''{1}'' and ''{2}''";
        }
        return MessageFormat.format(msg, args);
    }

    protected String unsupportedopMessage(String op, PyObject o2) {
        return null;
    }

    protected String runsupportedopMessage(String op, PyObject o2) {
        return null;
    }

    public PyObject __pow__(PyObject o2, PyObject o3) {
        return null;
    }

    private boolean isStrUnicodeSpecialCase(PyType t1, PyType t2, String op) {
        return !(op != "+" || t1 != PyString.TYPE && t1 != PyUnicode.TYPE || !t2.isSubType(PyString.TYPE) && !t2.isSubType(PyUnicode.TYPE));
    }

    private PyObject _binop_rule(PyType t1, PyObject o2, PyType t2, String left, String right, String op) {
        PyObject o1 = this;
        PyObject[] where = new PyObject[1];
        PyObject where1 = null;
        PyObject where2 = null;
        PyObject impl1 = t1.lookup_where(left, where);
        where1 = where[0];
        PyObject impl2 = t2.lookup_where(right, where);
        where2 = where[0];
        if (impl2 != null && impl1 != null && where1 != where2 && (t2.isSubType(t1) && !Py.isSubClass(where1, where2) && !Py.isSubClass(t1, where2) || this.isStrUnicodeSpecialCase(t1, t2, op))) {
            PyObject tmp = o1;
            o1 = o2;
            o2 = tmp;
            tmp = impl1;
            impl1 = impl2;
            impl2 = tmp;
            PyType ttmp = t1;
            t1 = t2;
            t2 = ttmp;
        }
        PyObject res = null;
        if (impl1 != null && (res = impl1.__get__(o1, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        if (impl2 != null && (res = impl2.__get__(o2, t2).__call__(o1)) != Py.NotImplemented) {
            return res;
        }
        throw Py.TypeError(this._unsupportedop(op, o2));
    }

    public PyObject __add__(PyObject other) {
        return null;
    }

    public PyObject __radd__(PyObject other) {
        return null;
    }

    public PyObject __iadd__(PyObject other) {
        return null;
    }

    public final PyObject _add(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_add(o2);
        }
        return this._binop_rule(t1, o2, t2, "__add__", "__radd__", "+");
    }

    final PyObject _basic_add(PyObject o2) {
        PyObject x = this.__add__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__radd__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("+", o2));
    }

    public final PyObject _iadd(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_iadd(o2);
        }
        PyObject impl = t1.lookup("__iadd__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__add__", "__radd__", "+");
    }

    final PyObject _basic_iadd(PyObject o2) {
        PyObject x = this.__iadd__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_add(o2);
    }

    public PyObject __sub__(PyObject other) {
        return null;
    }

    public PyObject __rsub__(PyObject other) {
        return null;
    }

    public PyObject __isub__(PyObject other) {
        return null;
    }

    public final PyObject _sub(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_sub(o2);
        }
        return this._binop_rule(t1, o2, t2, "__sub__", "__rsub__", "-");
    }

    final PyObject _basic_sub(PyObject o2) {
        PyObject x = this.__sub__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rsub__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("-", o2));
    }

    public final PyObject _isub(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_isub(o2);
        }
        PyObject impl = t1.lookup("__isub__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__sub__", "__rsub__", "-");
    }

    final PyObject _basic_isub(PyObject o2) {
        PyObject x = this.__isub__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_sub(o2);
    }

    public PyObject __mul__(PyObject other) {
        return null;
    }

    public PyObject __rmul__(PyObject other) {
        return null;
    }

    public PyObject __imul__(PyObject other) {
        return null;
    }

    public final PyObject _mul(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_mul(o2);
        }
        return this._binop_rule(t1, o2, t2, "__mul__", "__rmul__", "*");
    }

    final PyObject _basic_mul(PyObject o2) {
        PyObject x = this.__mul__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rmul__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("*", o2));
    }

    public final PyObject _imul(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_imul(o2);
        }
        PyObject impl = t1.lookup("__imul__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__mul__", "__rmul__", "*");
    }

    final PyObject _basic_imul(PyObject o2) {
        PyObject x = this.__imul__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_mul(o2);
    }

    public PyObject __div__(PyObject other) {
        return null;
    }

    public PyObject __rdiv__(PyObject other) {
        return null;
    }

    public PyObject __idiv__(PyObject other) {
        return null;
    }

    public final PyObject _div(PyObject o2) {
        PyType t2;
        if (Options.Qnew) {
            return this._truediv(o2);
        }
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_div(o2);
        }
        return this._binop_rule(t1, o2, t2, "__div__", "__rdiv__", "/");
    }

    final PyObject _basic_div(PyObject o2) {
        PyObject x = this.__div__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rdiv__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("/", o2));
    }

    public final PyObject _idiv(PyObject o2) {
        PyObject res;
        PyType t2;
        if (Options.Qnew) {
            return this._itruediv(o2);
        }
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_idiv(o2);
        }
        PyObject impl = t1.lookup("__idiv__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__div__", "__rdiv__", "/");
    }

    final PyObject _basic_idiv(PyObject o2) {
        PyObject x = this.__idiv__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_div(o2);
    }

    public PyObject __floordiv__(PyObject other) {
        return null;
    }

    public PyObject __rfloordiv__(PyObject other) {
        return null;
    }

    public PyObject __ifloordiv__(PyObject other) {
        return null;
    }

    public final PyObject _floordiv(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_floordiv(o2);
        }
        return this._binop_rule(t1, o2, t2, "__floordiv__", "__rfloordiv__", "//");
    }

    final PyObject _basic_floordiv(PyObject o2) {
        PyObject x = this.__floordiv__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rfloordiv__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("//", o2));
    }

    public final PyObject _ifloordiv(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_ifloordiv(o2);
        }
        PyObject impl = t1.lookup("__ifloordiv__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__floordiv__", "__rfloordiv__", "//");
    }

    final PyObject _basic_ifloordiv(PyObject o2) {
        PyObject x = this.__ifloordiv__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_floordiv(o2);
    }

    public PyObject __truediv__(PyObject other) {
        return null;
    }

    public PyObject __rtruediv__(PyObject other) {
        return null;
    }

    public PyObject __itruediv__(PyObject other) {
        return null;
    }

    public final PyObject _truediv(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_truediv(o2);
        }
        return this._binop_rule(t1, o2, t2, "__truediv__", "__rtruediv__", "/");
    }

    final PyObject _basic_truediv(PyObject o2) {
        PyObject x = this.__truediv__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rtruediv__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("/", o2));
    }

    public final PyObject _itruediv(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_itruediv(o2);
        }
        PyObject impl = t1.lookup("__itruediv__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__truediv__", "__rtruediv__", "/");
    }

    final PyObject _basic_itruediv(PyObject o2) {
        PyObject x = this.__itruediv__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_truediv(o2);
    }

    public PyObject __mod__(PyObject other) {
        return null;
    }

    public PyObject __rmod__(PyObject other) {
        return null;
    }

    public PyObject __imod__(PyObject other) {
        return null;
    }

    public final PyObject _mod(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_mod(o2);
        }
        return this._binop_rule(t1, o2, t2, "__mod__", "__rmod__", "%");
    }

    final PyObject _basic_mod(PyObject o2) {
        PyObject x = this.__mod__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rmod__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("%", o2));
    }

    public final PyObject _imod(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_imod(o2);
        }
        PyObject impl = t1.lookup("__imod__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__mod__", "__rmod__", "%");
    }

    final PyObject _basic_imod(PyObject o2) {
        PyObject x = this.__imod__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_mod(o2);
    }

    public PyObject __divmod__(PyObject other) {
        return null;
    }

    public PyObject __rdivmod__(PyObject other) {
        return null;
    }

    public PyObject __idivmod__(PyObject other) {
        return null;
    }

    public final PyObject _divmod(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_divmod(o2);
        }
        return this._binop_rule(t1, o2, t2, "__divmod__", "__rdivmod__", "divmod");
    }

    final PyObject _basic_divmod(PyObject o2) {
        PyObject x = this.__divmod__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rdivmod__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("divmod", o2));
    }

    public final PyObject _idivmod(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_idivmod(o2);
        }
        PyObject impl = t1.lookup("__idivmod__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__divmod__", "__rdivmod__", "divmod");
    }

    final PyObject _basic_idivmod(PyObject o2) {
        PyObject x = this.__idivmod__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_divmod(o2);
    }

    public PyObject __pow__(PyObject other) {
        return this.__pow__(other, null);
    }

    public PyObject __rpow__(PyObject other) {
        return null;
    }

    public PyObject __ipow__(PyObject other) {
        return null;
    }

    public final PyObject _pow(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_pow(o2);
        }
        return this._binop_rule(t1, o2, t2, "__pow__", "__rpow__", "**");
    }

    final PyObject _basic_pow(PyObject o2) {
        PyObject x = this.__pow__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rpow__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("**", o2));
    }

    public final PyObject _ipow(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_ipow(o2);
        }
        PyObject impl = t1.lookup("__ipow__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__pow__", "__rpow__", "**");
    }

    final PyObject _basic_ipow(PyObject o2) {
        PyObject x = this.__ipow__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_pow(o2);
    }

    public PyObject __lshift__(PyObject other) {
        return null;
    }

    public PyObject __rlshift__(PyObject other) {
        return null;
    }

    public PyObject __ilshift__(PyObject other) {
        return null;
    }

    public final PyObject _lshift(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_lshift(o2);
        }
        return this._binop_rule(t1, o2, t2, "__lshift__", "__rlshift__", "<<");
    }

    final PyObject _basic_lshift(PyObject o2) {
        PyObject x = this.__lshift__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rlshift__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("<<", o2));
    }

    public final PyObject _ilshift(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_ilshift(o2);
        }
        PyObject impl = t1.lookup("__ilshift__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__lshift__", "__rlshift__", "<<");
    }

    final PyObject _basic_ilshift(PyObject o2) {
        PyObject x = this.__ilshift__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_lshift(o2);
    }

    public PyObject __rshift__(PyObject other) {
        return null;
    }

    public PyObject __rrshift__(PyObject other) {
        return null;
    }

    public PyObject __irshift__(PyObject other) {
        return null;
    }

    public final PyObject _rshift(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_rshift(o2);
        }
        return this._binop_rule(t1, o2, t2, "__rshift__", "__rrshift__", ">>");
    }

    final PyObject _basic_rshift(PyObject o2) {
        PyObject x = this.__rshift__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rrshift__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop(">>", o2));
    }

    public final PyObject _irshift(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_irshift(o2);
        }
        PyObject impl = t1.lookup("__irshift__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__rshift__", "__rrshift__", ">>");
    }

    final PyObject _basic_irshift(PyObject o2) {
        PyObject x = this.__irshift__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_rshift(o2);
    }

    public PyObject __and__(PyObject other) {
        return null;
    }

    public PyObject __rand__(PyObject other) {
        return null;
    }

    public PyObject __iand__(PyObject other) {
        return null;
    }

    public final PyObject _and(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_and(o2);
        }
        return this._binop_rule(t1, o2, t2, "__and__", "__rand__", "&");
    }

    final PyObject _basic_and(PyObject o2) {
        PyObject x = this.__and__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rand__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("&", o2));
    }

    public final PyObject _iand(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_iand(o2);
        }
        PyObject impl = t1.lookup("__iand__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__and__", "__rand__", "&");
    }

    final PyObject _basic_iand(PyObject o2) {
        PyObject x = this.__iand__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_and(o2);
    }

    public PyObject __or__(PyObject other) {
        return null;
    }

    public PyObject __ror__(PyObject other) {
        return null;
    }

    public PyObject __ior__(PyObject other) {
        return null;
    }

    public final PyObject _or(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_or(o2);
        }
        return this._binop_rule(t1, o2, t2, "__or__", "__ror__", "|");
    }

    final PyObject _basic_or(PyObject o2) {
        PyObject x = this.__or__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__ror__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("|", o2));
    }

    public final PyObject _ior(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_ior(o2);
        }
        PyObject impl = t1.lookup("__ior__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__or__", "__ror__", "|");
    }

    final PyObject _basic_ior(PyObject o2) {
        PyObject x = this.__ior__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_or(o2);
    }

    public PyObject __xor__(PyObject other) {
        return null;
    }

    public PyObject __rxor__(PyObject other) {
        return null;
    }

    public PyObject __ixor__(PyObject other) {
        return null;
    }

    public final PyObject _xor(PyObject o2) {
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_xor(o2);
        }
        return this._binop_rule(t1, o2, t2, "__xor__", "__rxor__", "^");
    }

    final PyObject _basic_xor(PyObject o2) {
        PyObject x = this.__xor__(o2);
        if (x != null) {
            return x;
        }
        x = o2.__rxor__(this);
        if (x != null) {
            return x;
        }
        throw Py.TypeError(this._unsupportedop("^", o2));
    }

    public final PyObject _ixor(PyObject o2) {
        PyObject res;
        PyType t2;
        PyType t1 = this.getType();
        if (t1 == (t2 = o2.getType()) || t1.builtin && t2.builtin) {
            return this._basic_ixor(o2);
        }
        PyObject impl = t1.lookup("__ixor__");
        if (impl != null && (res = impl.__get__(this, t1).__call__(o2)) != Py.NotImplemented) {
            return res;
        }
        return this._binop_rule(t1, o2, t2, "__xor__", "__rxor__", "^");
    }

    final PyObject _basic_ixor(PyObject o2) {
        PyObject x = this.__ixor__(o2);
        if (x != null) {
            return x;
        }
        return this._basic_xor(o2);
    }

    public PyObject _jcallexc(Object[] args) throws Throwable {
        try {
            return this.__call__(Py.javas2pys(args));
        }
        catch (PyException e) {
            if (e.value.getJavaProxy() != null) {
                Object t = e.value.__tojava__(Throwable.class);
                if (t != null && t != Py.NoConversion) {
                    throw (Throwable)t;
                }
            } else {
                ThreadState ts = Py.getThreadState();
                if (ts.frame == null) {
                    Py.maybeSystemExit(e);
                }
                if (Options.showPythonProxyExceptions) {
                    Py.stderr.println("Exception in Python proxy returning to Java:");
                    Py.printException(e);
                }
            }
            throw e;
        }
    }

    public void _jthrow(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw Py.JavaError(t);
    }

    public PyObject _jcall(Object[] args) {
        try {
            return this._jcallexc(args);
        }
        catch (Throwable t) {
            this._jthrow(t);
            return null;
        }
    }

    public PyObject invoke(String name, PyObject[] args, String[] keywords) {
        PyObject f = this.__getattr__(name);
        return f.__call__(args, keywords);
    }

    public PyObject invoke(String name, PyObject[] args) {
        PyObject f = this.__getattr__(name);
        return f.__call__(args);
    }

    public PyObject invoke(String name) {
        PyObject f = this.__getattr__(name);
        return f.__call__();
    }

    public PyObject invoke(String name, PyObject arg1) {
        PyObject f = this.__getattr__(name);
        return f.__call__(arg1);
    }

    public PyObject invoke(String name, PyObject arg1, PyObject arg2) {
        PyObject f = this.__getattr__(name);
        return f.__call__(arg1, arg2);
    }

    public PyObject invoke(String name, PyObject arg1, PyObject[] args, String[] keywords) {
        PyObject f = this.__getattr__(name);
        return f.__call__(arg1, args, keywords);
    }

    public PyObject fastGetDict() {
        return null;
    }

    public PyObject getDict() {
        return null;
    }

    public void setDict(PyObject newDict) {
        throw Py.TypeError("can't set attribute '__dict__' of instance of " + this.getType().fastGetName());
    }

    public void delDict() {
        throw Py.TypeError("can't delete attribute '__dict__' of instance of '" + this.getType().fastGetName() + "'");
    }

    public boolean implementsDescrGet() {
        return this.objtype.hasGet;
    }

    public boolean implementsDescrSet() {
        return this.objtype.hasSet;
    }

    public boolean implementsDescrDelete() {
        return this.objtype.hasDelete;
    }

    public boolean isDataDescr() {
        return this.objtype.hasSet || this.objtype.hasDelete;
    }

    public PyObject __get__(PyObject obj, PyObject type) {
        return this._doget(obj, type);
    }

    public void __set__(PyObject obj, PyObject value) {
        if (!this._doset(obj, value)) {
            throw Py.AttributeError("object internal __set__ impl is abstract");
        }
    }

    public void __delete__(PyObject obj) {
        throw Py.AttributeError("object internal __delete__ impl is abstract");
    }

    final PyObject object___getattribute__(PyObject arg0) {
        String name = PyObject.asName(arg0);
        PyObject ret = this.object___findattr__(name);
        if (ret == null) {
            this.noAttributeError(name);
        }
        return ret;
    }

    final PyObject object___findattr__(String name) {
        PyObject obj_dict;
        PyObject descr = this.objtype.lookup(name);
        boolean bl = false;
        if (descr != null && (bl = descr.implementsDescrGet()) && descr.isDataDescr()) {
            return descr.__get__(this, this.objtype);
        }
        PyObject get = this.fastGetDict();
        if (get != null && (obj_dict = get.__finditem__(name)) != null) {
            return obj_dict;
        }
        if (bl) {
            return descr.__get__(this, this.objtype);
        }
        if (descr != null) {
            return descr;
        }
        return null;
    }

    final void object___setattr__(PyObject name, PyObject value) {
        this.hackCheck("__setattr__");
        this.object___setattr__(PyObject.asName(name), value);
    }

    final void object___setattr__(String name, PyObject value) {
        PyObject descr = this.objtype.lookup(name);
        boolean set = false;
        if (descr != null && (set = descr.implementsDescrSet()) && descr.isDataDescr()) {
            descr.__set__(this, value);
            return;
        }
        PyObject obj_dict = this.fastGetDict();
        if (obj_dict != null) {
            obj_dict.__setitem__(name, value);
            return;
        }
        if (set) {
            descr.__set__(this, value);
        }
        if (descr != null) {
            this.readonlyAttributeError(name);
        }
        this.noAttributeError(name);
    }

    final void object___delattr__(PyObject name) {
        this.hackCheck("__delattr__");
        this.object___delattr__(PyObject.asName(name));
    }

    public static final String asName(PyObject obj) {
        try {
            return obj.asName(0);
        }
        catch (ConversionException e) {
            throw Py.TypeError("attribute name must be a string");
        }
    }

    final void object___delattr__(String name) {
        PyObject descr = this.objtype.lookup(name);
        boolean delete = false;
        if (descr != null && (delete = descr.implementsDescrDelete()) && descr.isDataDescr()) {
            descr.__delete__(this);
            return;
        }
        PyObject obj_dict = this.fastGetDict();
        if (obj_dict != null) {
            try {
                obj_dict.__delitem__(name);
            }
            catch (PyException exc) {
                if (exc.match(Py.KeyError)) {
                    this.noAttributeError(name);
                }
                throw exc;
            }
            return;
        }
        if (delete) {
            descr.__delete__(this);
        }
        if (descr != null) {
            this.readonlyAttributeError(name);
        }
        this.noAttributeError(name);
    }

    private void hackCheck(String what) {
        if (this instanceof PyType && ((PyType)this).builtin) {
            throw Py.TypeError(String.format("can't apply this %s to %s object", what, this.objtype.fastGetName()));
        }
    }

    public PyObject __reduce__() {
        return this.object___reduce__();
    }

    final PyObject object___reduce__() {
        return this.object___reduce_ex__(0);
    }

    public PyObject __reduce_ex__(int arg) {
        return this.object___reduce_ex__(arg);
    }

    public PyObject __reduce_ex__() {
        return this.object___reduce_ex__(0);
    }

    final PyObject object___reduce_ex__(int arg) {
        PyObject objreduce;
        PyObject clsreduce;
        PyObject pyObject = this.getType().__findattr__("__reduce__");
        if (pyObject != (clsreduce = new PyObject().getType().__findattr__("__reduce__"))) {
            objreduce = this.__reduce__();
        } else if (arg >= 2) {
            objreduce = this.reduce_2();
        } else {
            PyObject copyreg = __builtin__.__import__("copy_reg", null, null, Py.EmptyTuple);
            PyObject copyreg_reduce = copyreg.__findattr__("_reduce_ex");
            objreduce = copyreg_reduce.__call__(this, (PyObject)new PyInteger(arg));
        }
        return objreduce;
    }

    private static PyObject slotnames(PyObject cls) {
        PyObject slotnames = cls.fastGetDict().__finditem__("__slotnames__");
        if (null != slotnames) {
            return slotnames;
        }
        PyObject copyreg = __builtin__.__import__("copy_reg", null, null, Py.EmptyTuple);
        PyObject copyreg_slotnames = copyreg.__findattr__("_slotnames");
        slotnames = copyreg_slotnames.__call__(cls);
        if (null != slotnames && Py.None != slotnames && !(slotnames instanceof PyList)) {
            throw Py.TypeError("copy_reg._slotnames didn't return a list or None");
        }
        return slotnames;
    }

    /*
     * WARNING - void declaration
     */
    private PyObject reduce_2() {
        void n;
        PyObject getstate;
        void state;
        PyObject getnewargs;
        void args;
        PyObject cls;
        PyObject pyObject;
        PyObject pyObject2;
        Object var1_1 = null;
        PyObject pyObject3 = this.__findattr__("__class__");
        PyObject res = this.__findattr__("__getnewargs__");
        if (null != res) {
            pyObject2 = res.__call__();
            if (null != pyObject2 && !(pyObject2 instanceof PyTuple)) {
                throw Py.TypeError("__getnewargs__ should return a tuple");
            }
        } else {
            pyObject2 = Py.EmptyTuple;
        }
        if (null != (pyObject = this.__findattr__("__getstate__"))) {
            cls = pyObject.__call__();
            if (null == cls) {
                return args;
            }
        } else {
            cls = this.__findattr__("__dict__");
            if (null == cls) {
                cls = Py.None;
            }
            if (null == (getnewargs = PyObject.slotnames((PyObject)state))) {
                return args;
            }
            if (getnewargs != Py.None) {
                if (!(getnewargs instanceof PyList)) {
                    throw Py.AssertionError("slots not a list");
                }
                getstate = new PyDictionary();
                int names = 0;
                for (int slots = 0; slots < ((PyList)getnewargs).size(); ++slots) {
                    PyObject name = ((PyList)getnewargs).pyget(slots);
                    PyObject value = this.__findattr__(name.toString());
                    if (null == value) continue;
                    getstate.__setitem__(name, value);
                    ++names;
                }
                if (names > 0) {
                    cls = new PyTuple(cls, getstate);
                }
            }
        }
        getnewargs = !(this instanceof PyList) ? Py.None : ((PyList)this).__iter__();
        getstate = !(this instanceof PyDictionary) ? Py.None : this.invoke("iteritems");
        PyObject copyreg = __builtin__.__import__("copy_reg", null, null, Py.EmptyTuple);
        PyObject newobj = copyreg.__findattr__("__newobj__");
        int listitems = ((PyTuple)n).size();
        PyObject[] args2 = new PyObject[listitems + 1];
        args2[0] = state;
        for (int dictitems = 0; dictitems < listitems; ++dictitems) {
            args2[dictitems + 1] = ((PyTuple)n).pyget(dictitems);
        }
        return new PyTuple(newobj, new PyTuple(args2), cls, getnewargs, getstate);
    }

    public PyTuple __getnewargs__() {
        return new PyTuple();
    }

    public String asString(int index) throws ConversionException {
        throw new ConversionException(index);
    }

    public String asString() {
        throw Py.TypeError("expected a str");
    }

    public String asStringOrNull(int index) throws ConversionException {
        return this.asString(index);
    }

    public String asStringOrNull() {
        return this.asString();
    }

    public String asName(int index) throws ConversionException {
        throw new ConversionException(index);
    }

    public int asInt(int index) throws ConversionException {
        throw new ConversionException(index);
    }

    public int asInt() {
        PyObject intObj;
        try {
            intObj = this.__int__();
        }
        catch (PyException pye) {
            if (pye.match(Py.AttributeError)) {
                throw Py.TypeError("an integer is required");
            }
            throw pye;
        }
        if (!(intObj instanceof PyInteger) && !(intObj instanceof PyLong)) {
            throw Py.TypeError("nb_int should return int object");
        }
        return intObj.asInt();
    }

    public long asLong(int index) throws ConversionException {
        throw new ConversionException(index);
    }

    public long asLong() {
        PyObject longObj;
        try {
            longObj = this.__long__();
        }
        catch (PyException pye) {
            if (pye.match(Py.AttributeError)) {
                throw Py.TypeError("an integer is required");
            }
            throw pye;
        }
        if (!(longObj instanceof PyLong) && !(longObj instanceof PyInteger)) {
            throw Py.TypeError("integer conversion failed");
        }
        return longObj.asLong();
    }

    public double asDouble() {
        PyFloat floatObj;
        try {
            floatObj = this.__float__();
        }
        catch (PyException pye) {
            if (pye.match(Py.AttributeError)) {
                throw Py.TypeError("a float is required");
            }
            throw pye;
        }
        return floatObj.asDouble();
    }

    public int asIndex() {
        return this.asIndex(null);
    }

    public int asIndex(PyObject err) {
        return this.__index__().asInt();
    }

    static {
        PyType.addBuilder(PyObject.class, new PyObject$PyExposer());
        TYPE = PyType.fromClass(PyObject.class);
        primitiveMap = Generic.map();
        primitiveMap.put(Character.TYPE, Character.class);
        primitiveMap.put(Boolean.TYPE, Boolean.class);
        primitiveMap.put(Byte.TYPE, Byte.class);
        primitiveMap.put(Short.TYPE, Short.class);
        primitiveMap.put(Integer.TYPE, Integer.class);
        primitiveMap.put(Long.TYPE, Long.class);
        primitiveMap.put(Float.TYPE, Float.class);
        primitiveMap.put(Double.TYPE, Double.class);
        if (Py.BOOTSTRAP_TYPES.size() > 0) {
            Py.writeWarning("init", "Bootstrap types weren't encountered in bootstrapping: " + Py.BOOTSTRAP_TYPES);
        }
    }

    public static class ConversionException
    extends Exception {
        public int index;

        public ConversionException(int index) {
            this.index = index;
        }
    }
}

