/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.org.bouncycastle.jcajce.provider.symmetric;

import com.huawei.shade.org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.huawei.shade.org.bouncycastle.crypto.CipherKeyGenerator;
import com.huawei.shade.org.bouncycastle.crypto.engines.BlowfishEngine;
import com.huawei.shade.org.bouncycastle.crypto.macs.CMac;
import com.huawei.shade.org.bouncycastle.crypto.modes.CBCBlockCipher;
import com.huawei.shade.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.huawei.shade.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.huawei.shade.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.huawei.shade.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.huawei.shade.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import com.huawei.shade.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Blowfish {
    private Blowfish() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Blowfish IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new BlowfishEngine()), 64);
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new BlowfishEngine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlowfishEngine());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Blowfish", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Blowfish.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Mac.BLOWFISHCMAC", PREFIX + "$CMAC");
            configurableProvider.addAlgorithm("Cipher.BLOWFISH", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("Cipher", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, PREFIX + "$CBC");
            configurableProvider.addAlgorithm("KeyGenerator.BLOWFISH", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "BLOWFISH");
            configurableProvider.addAlgorithm("AlgorithmParameters.BLOWFISH", PREFIX + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "BLOWFISH");
        }
    }
}

