/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.org.bouncycastle.jcajce.provider.asymmetric.edec;

import com.huawei.shade.org.bouncycastle.asn1.ASN1Encodable;
import com.huawei.shade.org.bouncycastle.asn1.ASN1OctetString;
import com.huawei.shade.org.bouncycastle.asn1.ASN1Set;
import com.huawei.shade.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.huawei.shade.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.huawei.shade.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.huawei.shade.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.huawei.shade.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.huawei.shade.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import com.huawei.shade.org.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;
import com.huawei.shade.org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import com.huawei.shade.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import com.huawei.shade.org.bouncycastle.jcajce.provider.asymmetric.edec.Utils;
import com.huawei.shade.org.bouncycastle.util.Arrays;
import com.huawei.shade.org.bouncycastle.util.Properties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCEdDSAPrivateKey
implements EdDSAPrivateKey {
    static final long serialVersionUID = 1L;
    transient AsymmetricKeyParameter eddsaPrivateKey;
    private final boolean hasPublicKey;
    private final byte[] attributes;

    BCEdDSAPrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.hasPublicKey = true;
        this.attributes = null;
        this.eddsaPrivateKey = asymmetricKeyParameter;
    }

    BCEdDSAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.hasPublicKey = privateKeyInfo.hasPublicKey();
        this.attributes = privateKeyInfo.getAttributes() != null ? privateKeyInfo.getAttributes().getEncoded() : null;
        this.populateFromPrivateKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) throws IOException {
        ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
        this.eddsaPrivateKey = EdECObjectIdentifiers.id_Ed448.equals(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? new Ed448PrivateKeyParameters(ASN1OctetString.getInstance(aSN1Encodable).getOctets(), 0) : new Ed25519PrivateKeyParameters(ASN1OctetString.getInstance(aSN1Encodable).getOctets(), 0);
    }

    public String getAlgorithm() {
        return this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters ? "Ed448" : "Ed25519";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            ASN1Set aSN1Set = ASN1Set.getInstance(this.attributes);
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.eddsaPrivateKey, aSN1Set);
            if (this.hasPublicKey && !Properties.isOverrideSet("com.huawei.shade.org.bouncycastle.pkcs8.v1_info_only")) {
                return privateKeyInfo.getEncoded();
            }
            return new PrivateKeyInfo(privateKeyInfo.getPrivateKeyAlgorithm(), privateKeyInfo.parsePrivateKey(), aSN1Set).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public EdDSAPublicKey getPublicKey() {
        if (this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters) {
            return new BCEdDSAPublicKey(((Ed448PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey());
        }
        return new BCEdDSAPublicKey(((Ed25519PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey());
    }

    AsymmetricKeyParameter engineGetKeyParameters() {
        return this.eddsaPrivateKey;
    }

    public String toString() {
        AsymmetricKeyParameter asymmetricKeyParameter = this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters ? ((Ed448PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey() : ((Ed25519PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey();
        return Utils.keyToString("Private Key", this.getAlgorithm(), asymmetricKeyParameter);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        PrivateKey privateKey = (PrivateKey)object;
        return Arrays.areEqual(privateKey.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.populateFromPrivateKeyInfo(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

