/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Table;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetExistsException;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.filesystem.FileSystemUtil;
import org.kitesdk.data.spi.filesystem.SchemaManager;
import org.kitesdk.data.spi.hive.HiveAbstractMetadataProvider;
import org.kitesdk.data.spi.hive.HiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveManagedMetadataProvider
extends HiveAbstractMetadataProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HiveManagedMetadataProvider.class);

    public HiveManagedMetadataProvider(Configuration conf) {
        super(conf);
    }

    @Override
    public DatasetDescriptor create(String namespace, String name, DatasetDescriptor descriptor) {
        Compatibility.checkDatasetName(namespace, name);
        Compatibility.checkDescriptor(descriptor);
        URI location = descriptor.getLocation();
        String resolved = this.resolveNamespace(namespace, name, location);
        if (resolved != null) {
            if (resolved.equals(namespace)) {
                throw new DatasetExistsException("Metadata already exists for dataset: " + namespace + "." + name);
            }
            if (location != null) {
                DatasetDescriptor loaded = this.load(resolved, name);
                LOG.warn("Creating table managed table {}.{}: replaces default.{}", new Object[]{namespace, name, name});
                Compatibility.checkUpdate(loaded, descriptor);
                location = loaded.getLocation();
            }
        }
        LOG.info("Creating a managed Hive table named: " + name);
        boolean isExternal = location != null;
        DatasetDescriptor toCreate = descriptor;
        if (isExternal) {
            toCreate = new DatasetDescriptor.Builder(descriptor).location(location).build();
        }
        Table table = HiveUtils.tableForDescriptor(namespace, name, toCreate, isExternal, false);
        this.getMetaStoreUtil().createTable(table);
        Table newTable = this.getMetaStoreUtil().getTable(namespace, name);
        Path managerPath = new Path(new Path(newTable.getSd().getLocation()), ".metadata/schemas");
        SchemaManager manager = SchemaManager.create(this.conf, managerPath);
        URI schemaLocation = manager.writeSchema(descriptor.getSchema());
        DatasetDescriptor newDescriptor = null;
        try {
            newDescriptor = new DatasetDescriptor.Builder(descriptor).location(newTable.getSd().getLocation()).schemaUri(schemaLocation).build();
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to set schema.", e);
        }
        HiveUtils.updateTableSchema(newTable, newDescriptor);
        this.getMetaStoreUtil().alterTable(newTable);
        if (isExternal) {
            FileSystemUtil.ensureLocationExists(newDescriptor, this.conf);
        }
        return newDescriptor;
    }

    @Override
    protected URI expectedLocation(String namespace, String name) {
        return null;
    }
}

