/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.SchemaParseException;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.DoubleNode;

public abstract class Schema
extends JsonProperties {
    static final JsonFactory FACTORY = new JsonFactory();
    static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);
    private static final int NO_HASHCODE = Integer.MIN_VALUE;
    private final Type type;
    private static final Set<String> SCHEMA_RESERVED;
    int hashCode = Integer.MIN_VALUE;
    private static final Set<String> FIELD_RESERVED;
    private static final ThreadLocal<Set> SEEN_EQUALS;
    private static final ThreadLocal<Map> SEEN_HASHCODE;
    static final Map<String, Type> PRIMITIVES;
    private static ThreadLocal<Boolean> validateNames;

    Schema(Type type) {
        super(SCHEMA_RESERVED);
        this.type = type;
    }

    public static Schema create(Type type) {
        switch (type) {
            case STRING: {
                return new StringSchema();
            }
            case BYTES: {
                return new BytesSchema();
            }
            case INT: {
                return new IntSchema();
            }
            case LONG: {
                return new LongSchema();
            }
            case FLOAT: {
                return new FloatSchema();
            }
            case DOUBLE: {
                return new DoubleSchema();
            }
            case BOOLEAN: {
                return new BooleanSchema();
            }
            case NULL: {
                return new NullSchema();
            }
        }
        throw new AvroRuntimeException("Can't create a: " + (Object)((Object)type));
    }

    @Override
    public void addProp(String name, JsonNode value) {
        super.addProp(name, value);
        this.hashCode = Integer.MIN_VALUE;
    }

    public static Schema createRecord(List<Field> fields) {
        Schema result = Schema.createRecord(null, null, null, false);
        result.setFields(fields);
        return result;
    }

    public static Schema createRecord(String name, String doc, String namespace, boolean isError) {
        return new RecordSchema(new Name(name, namespace), doc, isError);
    }

    public static Schema createEnum(String name, String doc, String namespace, List<String> values) {
        return new EnumSchema(new Name(name, namespace), doc, new LockableArrayList<String>(values));
    }

    public static Schema createArray(Schema elementType) {
        return new ArraySchema(elementType);
    }

    public static Schema createMap(Schema valueType) {
        return new MapSchema(valueType);
    }

    public static Schema createUnion(List<Schema> types) {
        return new UnionSchema(new LockableArrayList<Schema>(types));
    }

    public static Schema createFixed(String name, String doc, String space, int size) {
        return new FixedSchema(new Name(name, space), doc, size);
    }

    public Type getType() {
        return this.type;
    }

    public Field getField(String fieldname) {
        throw new AvroRuntimeException("Not a record: " + this);
    }

    public List<Field> getFields() {
        throw new AvroRuntimeException("Not a record: " + this);
    }

    public void setFields(List<Field> fields) {
        throw new AvroRuntimeException("Not a record: " + this);
    }

    public List<String> getEnumSymbols() {
        throw new AvroRuntimeException("Not an enum: " + this);
    }

    public int getEnumOrdinal(String symbol) {
        throw new AvroRuntimeException("Not an enum: " + this);
    }

    public boolean hasEnumSymbol(String symbol) {
        throw new AvroRuntimeException("Not an enum: " + this);
    }

    public String getName() {
        return this.type.name;
    }

    public String getDoc() {
        return null;
    }

    public String getNamespace() {
        throw new AvroRuntimeException("Not a named type: " + this);
    }

    public String getFullName() {
        return this.getName();
    }

    public void addAlias(String alias) {
        throw new AvroRuntimeException("Not a named type: " + this);
    }

    public void addAlias(String alias, String space) {
        throw new AvroRuntimeException("Not a named type: " + this);
    }

    public Set<String> getAliases() {
        throw new AvroRuntimeException("Not a named type: " + this);
    }

    public boolean isError() {
        throw new AvroRuntimeException("Not a record: " + this);
    }

    public Schema getElementType() {
        throw new AvroRuntimeException("Not an array: " + this);
    }

    public Schema getValueType() {
        throw new AvroRuntimeException("Not a map: " + this);
    }

    public List<Schema> getTypes() {
        throw new AvroRuntimeException("Not a union: " + this);
    }

    public Integer getIndexNamed(String name) {
        throw new AvroRuntimeException("Not a union: " + this);
    }

    public int getFixedSize() {
        throw new AvroRuntimeException("Not fixed: " + this);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator gen = FACTORY.createJsonGenerator(writer);
            if (pretty) {
                gen.useDefaultPrettyPrinter();
            }
            this.toJson(new Names(), gen);
            gen.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    void toJson(Names names, JsonGenerator gen) throws IOException {
        if (this.props.size() == 0) {
            gen.writeString(this.getName());
        } else {
            gen.writeStartObject();
            gen.writeStringField("type", this.getName());
            this.writeProps(gen);
            gen.writeEndObject();
        }
    }

    void fieldsToJson(Names names, JsonGenerator gen) throws IOException {
        throw new AvroRuntimeException("Not a record: " + this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema that = (Schema)o;
        if (this.type != that.type) {
            return false;
        }
        return this.equalCachedHash(that) && this.props.equals(that.props);
    }

    public final int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = this.computeHash();
        }
        return this.hashCode;
    }

    int computeHash() {
        return this.getType().hashCode() + this.props.hashCode();
    }

    final boolean equalCachedHash(Schema other) {
        return this.hashCode == other.hashCode || this.hashCode == Integer.MIN_VALUE || other.hashCode == Integer.MIN_VALUE;
    }

    public static Schema parse(File file) throws IOException {
        return new Parser().parse(file);
    }

    public static Schema parse(InputStream in) throws IOException {
        return new Parser().parse(in);
    }

    public static Schema parse(String jsonSchema) {
        return new Parser().parse(jsonSchema);
    }

    public static Schema parse(String jsonSchema, boolean validate) {
        return new Parser().setValidate(validate).parse(jsonSchema);
    }

    private static String validateName(String name) {
        if (!validateNames.get().booleanValue()) {
            return name;
        }
        int length = name.length();
        if (length == 0) {
            throw new SchemaParseException("Empty name");
        }
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            throw new SchemaParseException("Illegal initial character: " + name);
        }
        for (int i = 1; i < length; ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            throw new SchemaParseException("Illegal character in: " + name);
        }
        return name;
    }

    static Schema parse(JsonNode schema, Names names) {
        if (schema.isTextual()) {
            Schema result = names.get(schema.getTextValue());
            if (result == null) {
                throw new SchemaParseException("Undefined name: " + schema);
            }
            return result;
        }
        if (schema.isObject()) {
            Set<String> aliases;
            Schema result;
            String type = Schema.getRequiredText(schema, "type", "No type");
            Name name = null;
            String savedSpace = names.space();
            String doc = null;
            if (type.equals("record") || type.equals("error") || type.equals("enum") || type.equals("fixed")) {
                String space = Schema.getOptionalText(schema, "namespace");
                doc = Schema.getOptionalText(schema, "doc");
                if (space == null) {
                    space = names.space();
                }
                if ((name = new Name(Schema.getRequiredText(schema, "name", "No name in schema"), space)).space != null) {
                    names.space(name.space);
                }
            }
            if (PRIMITIVES.containsKey(type)) {
                result = Schema.create(PRIMITIVES.get(type));
            } else if (type.equals("record") || type.equals("error")) {
                JsonNode fieldsNode;
                ArrayList<Field> fields = new ArrayList<Field>();
                result = new RecordSchema(name, doc, type.equals("error"));
                if (name != null) {
                    names.add(result);
                }
                if ((fieldsNode = schema.get("fields")) == null || !fieldsNode.isArray()) {
                    throw new SchemaParseException("Record has no fields: " + schema);
                }
                for (JsonNode field : fieldsNode) {
                    JsonNode defaultValue;
                    String fieldName = Schema.getRequiredText(field, "name", "No field name");
                    String fieldDoc = Schema.getOptionalText(field, "doc");
                    JsonNode fieldTypeNode = field.get("type");
                    if (fieldTypeNode == null) {
                        throw new SchemaParseException("No field type: " + field);
                    }
                    if (fieldTypeNode.isTextual() && names.get(fieldTypeNode.getTextValue()) == null) {
                        throw new SchemaParseException(fieldTypeNode + " is not a defined name." + " The type of the \"" + fieldName + "\" field must be" + " a defined name or a {\"type\": ...} expression.");
                    }
                    Schema fieldSchema = Schema.parse(fieldTypeNode, names);
                    Field.Order order = Field.Order.ASCENDING;
                    JsonNode orderNode = field.get("order");
                    if (orderNode != null) {
                        order = Field.Order.valueOf(orderNode.getTextValue().toUpperCase());
                    }
                    if ((defaultValue = field.get("default")) != null && (Type.FLOAT.equals((Object)fieldSchema.getType()) || Type.DOUBLE.equals((Object)fieldSchema.getType())) && defaultValue.isTextual()) {
                        defaultValue = new DoubleNode(Double.valueOf(defaultValue.getTextValue()));
                    }
                    Field f = new Field(fieldName, fieldSchema, fieldDoc, defaultValue, order);
                    Iterator<String> i = field.getFieldNames();
                    while (i.hasNext()) {
                        String prop = i.next();
                        if (FIELD_RESERVED.contains(prop)) continue;
                        f.addProp(prop, field.get(prop));
                    }
                    f.aliases = Schema.parseAliases(field);
                    fields.add(f);
                }
                result.setFields(fields);
            } else if (type.equals("enum")) {
                JsonNode symbolsNode = schema.get("symbols");
                if (symbolsNode == null || !symbolsNode.isArray()) {
                    throw new SchemaParseException("Enum has no symbols: " + schema);
                }
                LockableArrayList<String> symbols = new LockableArrayList<String>();
                for (JsonNode n : symbolsNode) {
                    symbols.add(n.getTextValue());
                }
                result = new EnumSchema(name, doc, symbols);
                if (name != null) {
                    names.add(result);
                }
            } else if (type.equals("array")) {
                JsonNode itemsNode = schema.get("items");
                if (itemsNode == null) {
                    throw new SchemaParseException("Array has no items type: " + schema);
                }
                result = new ArraySchema(Schema.parse(itemsNode, names));
            } else if (type.equals("map")) {
                JsonNode valuesNode = schema.get("values");
                if (valuesNode == null) {
                    throw new SchemaParseException("Map has no values type: " + schema);
                }
                result = new MapSchema(Schema.parse(valuesNode, names));
            } else if (type.equals("fixed")) {
                JsonNode sizeNode = schema.get("size");
                if (sizeNode == null || !sizeNode.isInt()) {
                    throw new SchemaParseException("Invalid or no size: " + schema);
                }
                result = new FixedSchema(name, doc, sizeNode.getIntValue());
                if (name != null) {
                    names.add(result);
                }
            } else {
                throw new SchemaParseException("Type not supported: " + type);
            }
            Iterator<String> i = schema.getFieldNames();
            while (i.hasNext()) {
                String prop = i.next();
                if (SCHEMA_RESERVED.contains(prop)) continue;
                result.addProp(prop, schema.get(prop));
            }
            names.space(savedSpace);
            if (result instanceof NamedSchema && (aliases = Schema.parseAliases(schema)) != null) {
                for (String alias : aliases) {
                    result.addAlias(alias);
                }
            }
            return result;
        }
        if (schema.isArray()) {
            LockableArrayList<Schema> types = new LockableArrayList<Schema>(schema.size());
            for (JsonNode typeNode : schema) {
                types.add(Schema.parse(typeNode, names));
            }
            return new UnionSchema(types);
        }
        throw new SchemaParseException("Schema not yet supported: " + schema);
    }

    private static Set<String> parseAliases(JsonNode node) {
        JsonNode aliasesNode = node.get("aliases");
        if (aliasesNode == null) {
            return null;
        }
        if (!aliasesNode.isArray()) {
            throw new SchemaParseException("aliases not an array: " + node);
        }
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        for (JsonNode aliasNode : aliasesNode) {
            if (!aliasNode.isTextual()) {
                throw new SchemaParseException("alias not a string: " + aliasNode);
            }
            aliases.add(aliasNode.getTextValue());
        }
        return aliases;
    }

    private static String getRequiredText(JsonNode container, String key, String error) {
        String out = Schema.getOptionalText(container, key);
        if (null == out) {
            throw new SchemaParseException(error + ": " + container);
        }
        return out;
    }

    private static String getOptionalText(JsonNode container, String key) {
        JsonNode jsonNode = container.get(key);
        return jsonNode != null ? jsonNode.getTextValue() : null;
    }

    static JsonNode parseJson(String s) {
        try {
            return MAPPER.readTree(FACTORY.createJsonParser(new StringReader(s)));
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Schema applyAliases(Schema writer, Schema reader) {
        if (writer == reader) {
            return writer;
        }
        IdentityHashMap<Schema, Schema> seen = new IdentityHashMap<Schema, Schema>(1);
        HashMap<Name, Name> aliases = new HashMap<Name, Name>(1);
        HashMap<Name, Map<String, String>> fieldAliases = new HashMap<Name, Map<String, String>>(1);
        Schema.getAliases(reader, seen, aliases, fieldAliases);
        if (aliases.size() == 0 && fieldAliases.size() == 0) {
            return writer;
        }
        seen.clear();
        return Schema.applyAliases(writer, seen, aliases, fieldAliases);
    }

    private static Schema applyAliases(Schema s, Map<Schema, Schema> seen, Map<Name, Name> aliases, Map<Name, Map<String, String>> fieldAliases) {
        Name name = s instanceof NamedSchema ? ((NamedSchema)s).name : null;
        Schema result = s;
        switch (s.getType()) {
            case RECORD: {
                if (seen.containsKey(s)) {
                    return seen.get(s);
                }
                if (aliases.containsKey(name)) {
                    name = aliases.get(name);
                }
                result = Schema.createRecord(name.full, s.getDoc(), null, s.isError());
                seen.put(s, result);
                ArrayList<Field> newFields = new ArrayList<Field>();
                for (Field f : s.getFields()) {
                    Schema fSchema = Schema.applyAliases(f.schema, seen, aliases, fieldAliases);
                    String fName = Schema.getFieldAlias(name, f.name, fieldAliases);
                    Field newF = new Field(fName, fSchema, f.doc, f.defaultValue, f.order);
                    newF.props.putAll(f.props);
                    newFields.add(newF);
                }
                result.setFields(newFields);
                break;
            }
            case ENUM: {
                if (!aliases.containsKey(name)) break;
                result = Schema.createEnum(aliases.get(name).full, s.getDoc(), null, s.getEnumSymbols());
                break;
            }
            case ARRAY: {
                Schema e = Schema.applyAliases(s.getElementType(), seen, aliases, fieldAliases);
                if (e == s.getElementType()) break;
                result = Schema.createArray(e);
                break;
            }
            case MAP: {
                Schema v = Schema.applyAliases(s.getValueType(), seen, aliases, fieldAliases);
                if (v == s.getValueType()) break;
                result = Schema.createMap(v);
                break;
            }
            case UNION: {
                ArrayList<Schema> types = new ArrayList<Schema>();
                for (Schema branch : s.getTypes()) {
                    types.add(Schema.applyAliases(branch, seen, aliases, fieldAliases));
                }
                result = Schema.createUnion(types);
                break;
            }
            case FIXED: {
                if (!aliases.containsKey(name)) break;
                result = Schema.createFixed(aliases.get(name).full, s.getDoc(), null, s.getFixedSize());
            }
        }
        if (result != s) {
            result.props.putAll(s.props);
        }
        return result;
    }

    private static void getAliases(Schema schema, Map<Schema, Schema> seen, Map<Name, Name> aliases, Map<Name, Map<String, String>> fieldAliases) {
        if (schema instanceof NamedSchema) {
            NamedSchema namedSchema = (NamedSchema)schema;
            if (namedSchema.aliases != null) {
                for (Name alias : namedSchema.aliases) {
                    aliases.put(alias, namedSchema.name);
                }
            }
        }
        switch (schema.getType()) {
            case RECORD: {
                if (seen.containsKey(schema)) {
                    return;
                }
                seen.put(schema, schema);
                RecordSchema record = (RecordSchema)schema;
                for (Field field : schema.getFields()) {
                    if (field.aliases != null) {
                        for (String fieldAlias : field.aliases) {
                            Map<String, String> recordAliases = fieldAliases.get(record.name);
                            if (recordAliases == null) {
                                recordAliases = new HashMap<String, String>();
                                fieldAliases.put(record.name, recordAliases);
                            }
                            recordAliases.put(fieldAlias, field.name);
                        }
                    }
                    Schema.getAliases(field.schema, seen, aliases, fieldAliases);
                }
                if (record.aliases == null || !fieldAliases.containsKey(record.name)) break;
                for (Name recordAlias : record.aliases) {
                    fieldAliases.put(recordAlias, fieldAliases.get(record.name));
                }
                break;
            }
            case ARRAY: {
                Schema.getAliases(schema.getElementType(), seen, aliases, fieldAliases);
                break;
            }
            case MAP: {
                Schema.getAliases(schema.getValueType(), seen, aliases, fieldAliases);
                break;
            }
            case UNION: {
                for (Schema s : schema.getTypes()) {
                    Schema.getAliases(s, seen, aliases, fieldAliases);
                }
                break;
            }
        }
    }

    private static String getFieldAlias(Name record, String field, Map<Name, Map<String, String>> fieldAliases) {
        Map<String, String> recordAliases = fieldAliases.get(record);
        if (recordAliases == null) {
            return field;
        }
        String alias = recordAliases.get(field);
        if (alias == null) {
            return field;
        }
        return alias;
    }

    static {
        FACTORY.enable(JsonParser.Feature.ALLOW_COMMENTS);
        FACTORY.setCodec(MAPPER);
        SCHEMA_RESERVED = new HashSet<String>();
        Collections.addAll(SCHEMA_RESERVED, "doc", "fields", "items", "name", "namespace", "size", "symbols", "values", "type", "aliases");
        FIELD_RESERVED = new HashSet<String>();
        Collections.addAll(FIELD_RESERVED, "default", "doc", "name", "order", "type", "aliases");
        SEEN_EQUALS = new ThreadLocal<Set>(){

            @Override
            protected Set initialValue() {
                return new HashSet();
            }
        };
        SEEN_HASHCODE = new ThreadLocal<Map>(){

            @Override
            protected Map initialValue() {
                return new IdentityHashMap();
            }
        };
        PRIMITIVES = new HashMap<String, Type>();
        PRIMITIVES.put("string", Type.STRING);
        PRIMITIVES.put("bytes", Type.BYTES);
        PRIMITIVES.put("int", Type.INT);
        PRIMITIVES.put("long", Type.LONG);
        PRIMITIVES.put("float", Type.FLOAT);
        PRIMITIVES.put("double", Type.DOUBLE);
        PRIMITIVES.put("boolean", Type.BOOLEAN);
        PRIMITIVES.put("null", Type.NULL);
        validateNames = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return true;
            }
        };
    }

    static class LockableArrayList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private boolean locked = false;

        public LockableArrayList() {
        }

        public LockableArrayList(int size) {
            super(size);
        }

        public LockableArrayList(List<E> types) {
            super(types);
        }

        public List<E> lock() {
            this.locked = true;
            return this;
        }

        private void ensureUnlocked() {
            if (this.locked) {
                throw new IllegalStateException();
            }
        }

        @Override
        public boolean add(E e) {
            this.ensureUnlocked();
            return super.add(e);
        }

        @Override
        public boolean remove(Object o) {
            this.ensureUnlocked();
            return super.remove(o);
        }

        @Override
        public E remove(int index) {
            this.ensureUnlocked();
            return super.remove(index);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.ensureUnlocked();
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.ensureUnlocked();
            return super.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.ensureUnlocked();
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.ensureUnlocked();
            return super.retainAll(c);
        }

        @Override
        public void clear() {
            this.ensureUnlocked();
            super.clear();
        }
    }

    static class Names
    extends LinkedHashMap<Name, Schema> {
        private String space;

        public Names() {
        }

        public Names(String space) {
            this.space = space;
        }

        public String space() {
            return this.space;
        }

        public void space(String space) {
            this.space = space;
        }

        @Override
        public Schema get(Object o) {
            Name name;
            if (o instanceof String) {
                Type primitive = PRIMITIVES.get((String)o);
                if (primitive != null) {
                    return Schema.create(primitive);
                }
                name = new Name((String)o, this.space);
            } else {
                name = (Name)o;
            }
            return (Schema)super.get(name);
        }

        public boolean contains(Schema schema) {
            return this.get(((NamedSchema)schema).name) != null;
        }

        public void add(Schema schema) {
            this.put(((NamedSchema)schema).name, schema);
        }

        @Override
        public Schema put(Name name, Schema schema) {
            if (this.containsKey(name)) {
                throw new SchemaParseException("Can't redefine: " + name);
            }
            return super.put(name, schema);
        }
    }

    public static class Parser {
        private Names names = new Names();
        private boolean validate = true;

        public Parser addTypes(Map<String, Schema> types) {
            for (Schema s : types.values()) {
                this.names.add(s);
            }
            return this;
        }

        public Map<String, Schema> getTypes() {
            LinkedHashMap<String, Schema> result = new LinkedHashMap<String, Schema>();
            for (Schema s : this.names.values()) {
                result.put(s.getFullName(), s);
            }
            return result;
        }

        public Parser setValidate(boolean validate) {
            this.validate = validate;
            return this;
        }

        public boolean getValidate() {
            return this.validate;
        }

        public Schema parse(File file) throws IOException {
            return this.parse(FACTORY.createJsonParser(file));
        }

        public Schema parse(InputStream in) throws IOException {
            return this.parse(FACTORY.createJsonParser(in));
        }

        public Schema parse(String s, String ... more) {
            StringBuilder b = new StringBuilder(s);
            for (String part : more) {
                b.append(part);
            }
            return this.parse(b.toString());
        }

        public Schema parse(String s) {
            try {
                return this.parse(FACTORY.createJsonParser(new StringReader(s)));
            }
            catch (IOException e) {
                throw new SchemaParseException(e);
            }
        }

        private Schema parse(JsonParser parser) throws IOException {
            boolean saved = (Boolean)validateNames.get();
            try {
                validateNames.set(this.validate);
                Schema schema = Schema.parse(MAPPER.readTree(parser), this.names);
                return schema;
            }
            catch (JsonParseException e) {
                throw new SchemaParseException(e);
            }
            finally {
                validateNames.set(saved);
            }
        }
    }

    private static class NullSchema
    extends Schema {
        public NullSchema() {
            super(Type.NULL);
        }
    }

    private static class BooleanSchema
    extends Schema {
        public BooleanSchema() {
            super(Type.BOOLEAN);
        }
    }

    private static class DoubleSchema
    extends Schema {
        public DoubleSchema() {
            super(Type.DOUBLE);
        }
    }

    private static class FloatSchema
    extends Schema {
        public FloatSchema() {
            super(Type.FLOAT);
        }
    }

    private static class LongSchema
    extends Schema {
        public LongSchema() {
            super(Type.LONG);
        }
    }

    private static class IntSchema
    extends Schema {
        public IntSchema() {
            super(Type.INT);
        }
    }

    private static class BytesSchema
    extends Schema {
        public BytesSchema() {
            super(Type.BYTES);
        }
    }

    private static class StringSchema
    extends Schema {
        public StringSchema() {
            super(Type.STRING);
        }
    }

    private static class FixedSchema
    extends NamedSchema {
        private final int size;

        public FixedSchema(Name name, String doc, int size) {
            super(Type.FIXED, name, doc);
            if (size < 0) {
                throw new IllegalArgumentException("Invalid fixed size: " + size);
            }
            this.size = size;
        }

        @Override
        public int getFixedSize() {
            return this.size;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FixedSchema)) {
                return false;
            }
            FixedSchema that = (FixedSchema)o;
            return this.equalCachedHash(that) && this.equalNames(that) && this.size == that.size && this.props.equals(that.props);
        }

        @Override
        int computeHash() {
            return super.computeHash() + this.size;
        }

        @Override
        void toJson(Names names, JsonGenerator gen) throws IOException {
            if (this.writeNameRef(names, gen)) {
                return;
            }
            gen.writeStartObject();
            gen.writeStringField("type", "fixed");
            this.writeName(names, gen);
            if (this.getDoc() != null) {
                gen.writeStringField("doc", this.getDoc());
            }
            gen.writeNumberField("size", this.size);
            this.writeProps(gen);
            this.aliasesToJson(gen);
            gen.writeEndObject();
        }
    }

    private static class UnionSchema
    extends Schema {
        private final List<Schema> types;
        private final Map<String, Integer> indexByName = new HashMap<String, Integer>();

        public UnionSchema(LockableArrayList<Schema> types) {
            super(Type.UNION);
            this.types = types.lock();
            int index = 0;
            for (Schema type : types) {
                if (type.getType() == Type.UNION) {
                    throw new AvroRuntimeException("Nested union: " + this);
                }
                String name = type.getFullName();
                if (name == null) {
                    throw new AvroRuntimeException("Nameless in union:" + this);
                }
                if (this.indexByName.put(name, index++) == null) continue;
                throw new AvroRuntimeException("Duplicate in union:" + name);
            }
        }

        @Override
        public List<Schema> getTypes() {
            return this.types;
        }

        @Override
        public Integer getIndexNamed(String name) {
            return this.indexByName.get(name);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnionSchema)) {
                return false;
            }
            UnionSchema that = (UnionSchema)o;
            return this.equalCachedHash(that) && this.types.equals(that.types) && this.props.equals(that.props);
        }

        @Override
        int computeHash() {
            int hash = super.computeHash();
            for (Schema type : this.types) {
                hash += type.computeHash();
            }
            return hash;
        }

        @Override
        public void addProp(String name, String value) {
            throw new AvroRuntimeException("Can't set properties on a union: " + this);
        }

        @Override
        void toJson(Names names, JsonGenerator gen) throws IOException {
            gen.writeStartArray();
            for (Schema type : this.types) {
                type.toJson(names, gen);
            }
            gen.writeEndArray();
        }
    }

    private static class MapSchema
    extends Schema {
        private final Schema valueType;

        public MapSchema(Schema valueType) {
            super(Type.MAP);
            this.valueType = valueType;
        }

        @Override
        public Schema getValueType() {
            return this.valueType;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapSchema)) {
                return false;
            }
            MapSchema that = (MapSchema)o;
            return this.equalCachedHash(that) && this.valueType.equals(that.valueType) && this.props.equals(that.props);
        }

        @Override
        int computeHash() {
            return super.computeHash() + this.valueType.computeHash();
        }

        @Override
        void toJson(Names names, JsonGenerator gen) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", "map");
            gen.writeFieldName("values");
            this.valueType.toJson(names, gen);
            this.writeProps(gen);
            gen.writeEndObject();
        }
    }

    private static class ArraySchema
    extends Schema {
        private final Schema elementType;

        public ArraySchema(Schema elementType) {
            super(Type.ARRAY);
            this.elementType = elementType;
        }

        @Override
        public Schema getElementType() {
            return this.elementType;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArraySchema)) {
                return false;
            }
            ArraySchema that = (ArraySchema)o;
            return this.equalCachedHash(that) && this.elementType.equals(that.elementType) && this.props.equals(that.props);
        }

        @Override
        int computeHash() {
            return super.computeHash() + this.elementType.computeHash();
        }

        @Override
        void toJson(Names names, JsonGenerator gen) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", "array");
            gen.writeFieldName("items");
            this.elementType.toJson(names, gen);
            this.writeProps(gen);
            gen.writeEndObject();
        }
    }

    private static class EnumSchema
    extends NamedSchema {
        private final List<String> symbols;
        private final Map<String, Integer> ordinals;

        public EnumSchema(Name name, String doc, LockableArrayList<String> symbols) {
            super(Type.ENUM, name, doc);
            this.symbols = symbols.lock();
            this.ordinals = new HashMap<String, Integer>();
            int i = 0;
            for (String symbol : symbols) {
                if (this.ordinals.put(Schema.validateName(symbol), i++) == null) continue;
                throw new SchemaParseException("Duplicate enum symbol: " + symbol);
            }
        }

        @Override
        public List<String> getEnumSymbols() {
            return this.symbols;
        }

        @Override
        public boolean hasEnumSymbol(String symbol) {
            return this.ordinals.containsKey(symbol);
        }

        @Override
        public int getEnumOrdinal(String symbol) {
            return this.ordinals.get(symbol);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumSchema)) {
                return false;
            }
            EnumSchema that = (EnumSchema)o;
            return this.equalCachedHash(that) && this.equalNames(that) && this.symbols.equals(that.symbols) && this.props.equals(that.props);
        }

        @Override
        int computeHash() {
            return super.computeHash() + this.symbols.hashCode();
        }

        @Override
        void toJson(Names names, JsonGenerator gen) throws IOException {
            if (this.writeNameRef(names, gen)) {
                return;
            }
            gen.writeStartObject();
            gen.writeStringField("type", "enum");
            this.writeName(names, gen);
            if (this.getDoc() != null) {
                gen.writeStringField("doc", this.getDoc());
            }
            gen.writeArrayFieldStart("symbols");
            for (String symbol : this.symbols) {
                gen.writeString(symbol);
            }
            gen.writeEndArray();
            this.writeProps(gen);
            this.aliasesToJson(gen);
            gen.writeEndObject();
        }
    }

    private static class RecordSchema
    extends NamedSchema {
        private List<Field> fields;
        private Map<String, Field> fieldMap;
        private final boolean isError;

        public RecordSchema(Name name, String doc, boolean isError) {
            super(Type.RECORD, name, doc);
            this.isError = isError;
        }

        @Override
        public boolean isError() {
            return this.isError;
        }

        @Override
        public Field getField(String fieldname) {
            if (this.fieldMap == null) {
                throw new AvroRuntimeException("Schema fields not set yet");
            }
            return this.fieldMap.get(fieldname);
        }

        @Override
        public List<Field> getFields() {
            if (this.fields == null) {
                throw new AvroRuntimeException("Schema fields not set yet");
            }
            return this.fields;
        }

        @Override
        public void setFields(List<Field> fields) {
            if (this.fields != null) {
                throw new AvroRuntimeException("Fields are already set");
            }
            int i = 0;
            this.fieldMap = new HashMap<String, Field>();
            LockableArrayList<Field> ff = new LockableArrayList<Field>();
            for (Field f : fields) {
                if (f.position != -1) {
                    throw new AvroRuntimeException("Field already used: " + f);
                }
                f.position = i++;
                this.fieldMap.put(f.name(), f);
                ff.add(f);
            }
            this.fields = ff.lock();
            this.hashCode = Integer.MIN_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            SeenPair here;
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordSchema)) {
                return false;
            }
            RecordSchema that = (RecordSchema)o;
            if (!this.equalCachedHash(that)) {
                return false;
            }
            if (!this.equalNames(that)) {
                return false;
            }
            if (!this.props.equals(that.props)) {
                return false;
            }
            Set seen = (Set)SEEN_EQUALS.get();
            if (seen.contains(here = new SeenPair(this, o))) {
                return true;
            }
            boolean first = seen.isEmpty();
            try {
                seen.add(here);
                boolean bl = this.fields.equals(((RecordSchema)o).fields);
                return bl;
            }
            finally {
                if (first) {
                    seen.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int computeHash() {
            Map seen = (Map)SEEN_HASHCODE.get();
            if (seen.containsKey(this)) {
                return 0;
            }
            boolean first = seen.isEmpty();
            try {
                seen.put(this, this);
                int n = super.computeHash() + this.fields.hashCode();
                return n;
            }
            finally {
                if (first) {
                    seen.clear();
                }
            }
        }

        @Override
        void toJson(Names names, JsonGenerator gen) throws IOException {
            if (this.writeNameRef(names, gen)) {
                return;
            }
            String savedSpace = names.space;
            gen.writeStartObject();
            gen.writeStringField("type", this.isError ? "error" : "record");
            this.writeName(names, gen);
            names.space = this.name.space;
            if (this.getDoc() != null) {
                gen.writeStringField("doc", this.getDoc());
            }
            gen.writeFieldName("fields");
            this.fieldsToJson(names, gen);
            this.writeProps(gen);
            this.aliasesToJson(gen);
            gen.writeEndObject();
            names.space = savedSpace;
        }

        @Override
        void fieldsToJson(Names names, JsonGenerator gen) throws IOException {
            gen.writeStartArray();
            for (Field f : this.fields) {
                gen.writeStartObject();
                gen.writeStringField("name", f.name());
                gen.writeFieldName("type");
                f.schema().toJson(names, gen);
                if (f.doc() != null) {
                    gen.writeStringField("doc", f.doc());
                }
                if (f.defaultValue() != null) {
                    gen.writeFieldName("default");
                    gen.writeTree(f.defaultValue());
                }
                if (f.order() != Field.Order.ASCENDING) {
                    gen.writeStringField("order", f.order().name);
                }
                if (f.aliases != null && f.aliases.size() != 0) {
                    gen.writeFieldName("aliases");
                    gen.writeStartArray();
                    for (String alias : f.aliases) {
                        gen.writeString(alias);
                    }
                    gen.writeEndArray();
                }
                f.writeProps(gen);
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
    }

    private static class SeenPair {
        private Object s1;
        private Object s2;

        private SeenPair(Object s1, Object s2) {
            this.s1 = s1;
            this.s2 = s2;
        }

        public boolean equals(Object o) {
            return this.s1 == ((SeenPair)o).s1 && this.s2 == ((SeenPair)o).s2;
        }

        public int hashCode() {
            return System.identityHashCode(this.s1) + System.identityHashCode(this.s2);
        }
    }

    private static abstract class NamedSchema
    extends Schema {
        final Name name;
        final String doc;
        Set<Name> aliases;

        public NamedSchema(Type type, Name name, String doc) {
            super(type);
            this.name = name;
            this.doc = doc;
            if (PRIMITIVES.containsKey(name.full)) {
                throw new AvroTypeException("Schemas may not be named after primitives: " + name.full);
            }
        }

        @Override
        public String getName() {
            return this.name.name;
        }

        @Override
        public String getDoc() {
            return this.doc;
        }

        @Override
        public String getNamespace() {
            return this.name.space;
        }

        @Override
        public String getFullName() {
            return this.name.full;
        }

        @Override
        public void addAlias(String alias) {
            this.addAlias(alias, null);
        }

        @Override
        public void addAlias(String name, String space) {
            if (this.aliases == null) {
                this.aliases = new LinkedHashSet<Name>();
            }
            if (space == null) {
                space = this.name.space;
            }
            this.aliases.add(new Name(name, space));
        }

        @Override
        public Set<String> getAliases() {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            if (this.aliases != null) {
                for (Name alias : this.aliases) {
                    result.add(alias.full);
                }
            }
            return result;
        }

        public boolean writeNameRef(Names names, JsonGenerator gen) throws IOException {
            if (this.equals(names.get(this.name))) {
                gen.writeString(this.name.getQualified(names.space()));
                return true;
            }
            if (this.name.name != null) {
                names.put(this.name, this);
            }
            return false;
        }

        public void writeName(Names names, JsonGenerator gen) throws IOException {
            this.name.writeName(names, gen);
        }

        public boolean equalNames(NamedSchema that) {
            return this.name.equals(that.name);
        }

        @Override
        int computeHash() {
            return super.computeHash() + this.name.hashCode();
        }

        public void aliasesToJson(JsonGenerator gen) throws IOException {
            if (this.aliases == null || this.aliases.size() == 0) {
                return;
            }
            gen.writeFieldName("aliases");
            gen.writeStartArray();
            for (Name alias : this.aliases) {
                gen.writeString(alias.getQualified(this.name.space));
            }
            gen.writeEndArray();
        }
    }

    private static class Name {
        private final String name;
        private final String space;
        private final String full;

        public Name(String name, String space) {
            if (name == null) {
                this.full = null;
                this.space = null;
                this.name = null;
                return;
            }
            int lastDot = name.lastIndexOf(46);
            if ("".equals(space)) {
                space = null;
            }
            if (lastDot < 0) {
                this.space = space;
                this.name = Schema.validateName(name);
            } else {
                this.space = name.substring(0, lastDot);
                this.name = Schema.validateName(name.substring(lastDot + 1, name.length()));
            }
            this.full = this.space == null ? this.name : this.space + "." + this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Name)) {
                return false;
            }
            Name that = (Name)o;
            return this.full == null ? that.full == null : this.full.equals(that.full);
        }

        public int hashCode() {
            return this.full == null ? 0 : this.full.hashCode();
        }

        public String toString() {
            return this.full;
        }

        public void writeName(Names names, JsonGenerator gen) throws IOException {
            if (this.name != null) {
                gen.writeStringField("name", this.name);
            }
            if (this.space != null) {
                if (!this.space.equals(names.space())) {
                    gen.writeStringField("namespace", this.space);
                }
                if (names.space() == null) {
                    names.space(this.space);
                }
            } else if (names.space() != null) {
                gen.writeStringField("namespace", "");
            }
        }

        public String getQualified(String defaultSpace) {
            return this.space == null || this.space.equals(defaultSpace) ? this.name : this.full;
        }
    }

    public static class Field
    extends JsonProperties {
        private final String name;
        private transient int position = -1;
        private final Schema schema;
        private final String doc;
        private final JsonNode defaultValue;
        private final Order order;
        private Set<String> aliases;

        public Field(String name, Schema schema, String doc, JsonNode defaultValue) {
            this(name, schema, doc, defaultValue, Order.ASCENDING);
        }

        public Field(String name, Schema schema, String doc, JsonNode defaultValue, Order order) {
            super(FIELD_RESERVED);
            this.name = Schema.validateName(name);
            this.schema = schema;
            this.doc = doc;
            this.defaultValue = defaultValue;
            this.order = order;
        }

        public String name() {
            return this.name;
        }

        public int pos() {
            return this.position;
        }

        public Schema schema() {
            return this.schema;
        }

        public String doc() {
            return this.doc;
        }

        public JsonNode defaultValue() {
            return this.defaultValue;
        }

        public Order order() {
            return this.order;
        }

        @Deprecated
        public Map<String, String> props() {
            return this.getProps();
        }

        public void addAlias(String alias) {
            if (this.aliases == null) {
                this.aliases = new LinkedHashSet<String>();
            }
            this.aliases.add(alias);
        }

        public Set<String> aliases() {
            if (this.aliases == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(this.aliases);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Field)) {
                return false;
            }
            Field that = (Field)other;
            return this.name.equals(that.name) && this.schema.equals(that.schema) && this.defaultValueEquals(that.defaultValue) && this.order == that.order && this.props.equals(that.props);
        }

        public int hashCode() {
            return this.name.hashCode() + this.schema.computeHash();
        }

        private boolean defaultValueEquals(JsonNode thatDefaultValue) {
            if (this.defaultValue == null) {
                return thatDefaultValue == null;
            }
            if (Double.isNaN(this.defaultValue.getDoubleValue())) {
                return Double.isNaN(thatDefaultValue.getDoubleValue());
            }
            return this.defaultValue.equals(thatDefaultValue);
        }

        public String toString() {
            return this.name + " type:" + (Object)((Object)this.schema.type) + " pos:" + this.position;
        }

        public static enum Order {
            ASCENDING,
            DESCENDING,
            IGNORE;

            private String name = this.name().toLowerCase();
        }
    }

    public static enum Type {
        RECORD,
        ENUM,
        ARRAY,
        MAP,
        UNION,
        FIXED,
        STRING,
        BYTES,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        NULL;

        private String name = this.name().toLowerCase();

        public String getName() {
            return this.name;
        }
    }
}

