/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.ZeroArgNode;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.assigner.Assigner;
import org.jruby.runtime.assigner.Pre0Rest0Post0Assigner;
import org.jruby.runtime.assigner.Pre0Rest0Post0BlockAssigner;
import org.jruby.runtime.assigner.Pre0Rest1Post0Assigner;
import org.jruby.runtime.assigner.Pre0Rest1Post0BlockAssigner;
import org.jruby.runtime.assigner.Pre1ExpandedRest0Post0Assigner;
import org.jruby.runtime.assigner.Pre1ExpandedRest0Post0BlockAssigner;
import org.jruby.runtime.assigner.Pre1Rest0Post0Assigner;
import org.jruby.runtime.assigner.Pre1Rest0Post0BlockAssigner;
import org.jruby.runtime.assigner.Pre1Rest1Post0Assigner;
import org.jruby.runtime.assigner.Pre1Rest1Post0BlockAssigner;
import org.jruby.runtime.assigner.Pre2Rest0Post0Assigner;
import org.jruby.runtime.assigner.Pre2Rest0Post0BlockAssigner;
import org.jruby.runtime.assigner.Pre2Rest1Post0Assigner;
import org.jruby.runtime.assigner.Pre2Rest1Post0BlockAssigner;
import org.jruby.runtime.assigner.Pre3Rest0Post0Assigner;
import org.jruby.runtime.assigner.Pre3Rest0Post0BlockAssigner;
import org.jruby.runtime.assigner.Pre3Rest1Post0Assigner;
import org.jruby.runtime.assigner.Pre3Rest1Post0BlockAssigner;
import org.jruby.runtime.assigner.PreManyRest0Post0Assigner;
import org.jruby.runtime.assigner.PreManyRest0Post0BlockAssigner;
import org.jruby.runtime.assigner.PreManyRest1Post0Assigner;
import org.jruby.runtime.assigner.PreManyRest1Post0BlockAssigner;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedBlock
extends ContextAwareBlockBody {
    private boolean noargblock;
    private final ISourcePosition position;
    private final String file;
    private final int line;
    private final Node bodyNode;
    protected Assigner assigner;

    public static Block newInterpretedClosure(ThreadContext context, IterNode iterNode, IRubyObject self) {
        Binding binding2 = context.currentBinding(self);
        NodeType argsNodeId = InterpretedBlock.getArgumentTypeWackyHack(iterNode);
        InterpretedBlock body = new InterpretedBlock(iterNode, Arity.procArityOf(iterNode.getVarNode()), InterpretedBlock.asArgumentType(argsNodeId));
        return new Block(body, binding2);
    }

    public static Block newInterpretedClosure(ThreadContext context, BlockBody body, IRubyObject self) {
        Binding binding2 = context.currentBinding(self);
        return new Block(body, binding2);
    }

    public static BlockBody newBlockBody(IterNode iter, Arity arity2, int argumentType) {
        return new InterpretedBlock(iter, arity2, argumentType);
    }

    private void assignerFor(IterNode iter) {
        boolean hasBlock;
        Node varNode = iter.getVarNode();
        Node block = iter.getBlockVarNode();
        boolean bl = hasBlock = block != null;
        if (varNode == null || varNode instanceof ZeroArgNode) {
            this.noargblock = !hasBlock;
            this.assigner = hasBlock ? new Pre0Rest0Post0BlockAssigner(block) : new Pre0Rest0Post0Assigner();
        } else if (varNode instanceof MultipleAsgnNode) {
            MultipleAsgnNode masgn = (MultipleAsgnNode)varNode;
            int preCount = masgn.getPreCount();
            boolean isRest = masgn.getRest() != null;
            Node rest2 = masgn.getRest();
            ListNode pre = masgn.getPre();
            this.noargblock = false;
            switch (preCount) {
                case 0: {
                    if (isRest) {
                        this.assigner = hasBlock ? new Pre0Rest1Post0BlockAssigner(rest2, block) : new Pre0Rest1Post0Assigner(rest2);
                        break;
                    }
                    if (hasBlock) {
                        this.assigner = new Pre0Rest0Post0BlockAssigner(block);
                        break;
                    }
                    this.noargblock = true;
                    this.assigner = new Pre0Rest0Post0Assigner();
                    break;
                }
                case 1: {
                    if (isRest) {
                        this.assigner = hasBlock ? new Pre1Rest1Post0BlockAssigner(pre.get(0), rest2, block) : new Pre1Rest1Post0Assigner(pre.get(0), rest2);
                        break;
                    }
                    if (hasBlock) {
                        this.assigner = new Pre1Rest0Post0BlockAssigner(pre.get(0), block);
                        break;
                    }
                    this.assigner = new Pre1Rest0Post0Assigner(pre.get(0));
                    break;
                }
                case 2: {
                    if (isRest) {
                        this.assigner = hasBlock ? new Pre2Rest1Post0BlockAssigner(pre.get(0), pre.get(1), rest2, block) : new Pre2Rest1Post0Assigner(pre.get(0), pre.get(1), rest2);
                        break;
                    }
                    if (hasBlock) {
                        this.assigner = new Pre2Rest0Post0BlockAssigner(pre.get(0), pre.get(1), block);
                        break;
                    }
                    this.assigner = new Pre2Rest0Post0Assigner(pre.get(0), pre.get(1));
                    break;
                }
                case 3: {
                    if (isRest) {
                        this.assigner = hasBlock ? new Pre3Rest1Post0BlockAssigner(pre.get(0), pre.get(1), pre.get(2), rest2, block) : new Pre3Rest1Post0Assigner(pre.get(0), pre.get(1), pre.get(2), rest2);
                        break;
                    }
                    if (hasBlock) {
                        this.assigner = new Pre3Rest0Post0BlockAssigner(pre.get(0), pre.get(1), pre.get(2), block);
                        break;
                    }
                    this.assigner = new Pre3Rest0Post0Assigner(pre.get(0), pre.get(1), pre.get(2));
                    break;
                }
                default: {
                    if (isRest) {
                        this.assigner = hasBlock ? new PreManyRest1Post0BlockAssigner(pre, preCount, rest2, block) : new PreManyRest1Post0Assigner(pre, preCount, rest2);
                        break;
                    }
                    if (hasBlock) {
                        this.assigner = new PreManyRest0Post0BlockAssigner(pre, preCount, block);
                        break;
                    }
                    this.assigner = new PreManyRest0Post0Assigner(pre, preCount);
                    break;
                }
            }
        } else {
            this.assigner = hasBlock ? new Pre1ExpandedRest0Post0BlockAssigner(varNode, block) : new Pre1ExpandedRest0Post0Assigner(varNode);
        }
    }

    public InterpretedBlock(IterNode iterNode, int argumentType) {
        this(iterNode, Arity.procArityOf(iterNode == null ? null : iterNode.getVarNode()), argumentType);
    }

    public InterpretedBlock(IterNode iterNode, Arity arity2, int argumentType) {
        super(iterNode.getScope(), arity2, argumentType);
        this.bodyNode = iterNode.getBodyNode() == null ? NilImplicitNode.NIL : iterNode.getBodyNode();
        this.scope = iterNode.getScope();
        this.position = iterNode.getPosition();
        this.file = this.position.getFile();
        this.line = this.position.getLine();
        this.assignerFor(iterNode);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yield(context, binding2, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        IRubyObject iRubyObject;
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        IRubyObject self = this.prepareSelf(binding2);
        try {
            if (!this.noargblock) {
                this.assigner.assign(context.runtime, context, self, arg0, Block.NULL_BLOCK);
            }
            iRubyObject = this.evalBlockBody(context, binding2, self);
            Object var11_10 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        IRubyObject iRubyObject;
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        IRubyObject self = this.prepareSelf(binding2);
        try {
            if (!this.noargblock) {
                this.assigner.assign(context.runtime, context, self, arg0, arg1, Block.NULL_BLOCK);
            }
            iRubyObject = this.evalBlockBody(context, binding2, self);
            Object var12_11 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        IRubyObject iRubyObject;
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        IRubyObject self = this.prepareSelf(binding2);
        try {
            if (!this.noargblock) {
                this.assigner.assign(context.runtime, context, self, arg0, arg1, arg2, Block.NULL_BLOCK);
            }
            iRubyObject = this.evalBlockBody(context, binding2, self);
            Object var13_12 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, Binding binding2, Block.Type type2) {
        IRubyObject iRubyObject;
        IRubyObject self = this.prepareSelf(binding2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            if (!this.noargblock) {
                this.assigner.assign(context.runtime, context, self, Block.NULL_BLOCK);
            }
            iRubyObject = this.evalBlockBody(context, binding2, self);
            Object var10_9 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, binding2, type2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean alreadyArray, Binding binding2, Block.Type type2, Block block) {
        IRubyObject iRubyObject;
        if (klass == null) {
            self = this.prepareSelf(binding2);
        }
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, klass, binding2);
        Ruby runtime = context.runtime;
        try {
            if (!this.noargblock) {
                value2 = alreadyArray ? this.assigner.convertIfAlreadyArray(runtime, value2) : this.assigner.convertToArray(runtime, value2);
                this.assigner.assignArray(runtime, context, self, value2, block);
            }
            iRubyObject = this.evalBlockBody(context, binding2, self);
            Object var15_14 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var15_15 = null;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2, Block block) {
        IRubyObject iRubyObject;
        IRubyObject self = this.prepareSelf(binding2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            if (!this.noargblock) {
                this.assigner.assignArray(context.runtime, context, self, this.assigner.convertToArray(context.runtime, value2), block);
            }
            iRubyObject = this.evalBlockBody(context, binding2, self);
            Object var12_11 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean alreadyArray, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, self, klass, alreadyArray, binding2, type2, Block.NULL_BLOCK);
    }

    /*
     * Loose catch block
     */
    private IRubyObject evalBlockBody(ThreadContext context, Binding binding2, IRubyObject self) {
        while (true) {
            try {
                return ASTInterpreter.INTERPRET_BLOCK(context.runtime, context, this.file, this.line, this.bodyNode, binding2.getMethod(), self, Block.NULL_BLOCK);
            }
            catch (JumpException.RedoJump rj) {
                context.pollThreadEvents();
                continue;
            }
            break;
        }
        catch (StackOverflowError soe) {
            throw context.runtime.newSystemStackError("stack level too deep", soe);
        }
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self = binding2.getSelf();
        binding2.getFrame().setSelf(self);
        return self;
    }

    private IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj, Block.Type type2) {
        return nj.getValue() == null ? context.runtime.getNil() : (IRubyObject)nj.getValue();
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public String getFile() {
        return this.position.getFile();
    }

    public int getLine() {
        return this.position.getLine();
    }
}

