/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.Splat19Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YieldNode
extends Node {
    private final Node argsNode;
    private final boolean expandedArguments;

    public YieldNode(ISourcePosition position, Node argsNode, boolean expandedArguments) {
        super(position);
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        this.expandedArguments = expandedArguments;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.YIELDNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitYieldNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    @Deprecated
    public boolean getCheckState() {
        return this.expandedArguments;
    }

    public boolean getExpandArguments() {
        return this.expandedArguments;
    }

    @Override
    public List<Node> childNodes() {
        return YieldNode.createList(this.argsNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject argsResult = this.argsNode.interpret(runtime, context, self, aBlock);
        if (this.expandedArguments) {
            if (this.argsNode instanceof Splat19Node) {
                argsResult = RuntimeHelpers.unsplatValue19(argsResult);
            }
            return context.getCurrentFrame().getBlock().yieldArray(context, argsResult, null, null);
        }
        return context.getCurrentFrame().getBlock().yield(context, argsResult);
    }

    @Override
    public ByteList definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return aBlock.isGiven() ? YIELD_BYTELIST : null;
    }
}

