/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import org.jruby.RubyClass;
import org.jruby.runtime.builtin.IRubyObject;

public class VariableSite
extends MutableCallSite {
    public final String name;
    private RubyClass.VariableAccessor accessor = RubyClass.VariableAccessor.DUMMY_ACCESSOR;
    private final String file;
    private final int line;
    private int chainCount;

    public VariableSite(MethodType type2, String name2, String file2, int line) {
        super(type2);
        this.name = name2;
        this.file = file2;
        this.line = line;
        this.chainCount = 0;
    }

    public synchronized int chainCount() {
        return this.chainCount;
    }

    public synchronized void incrementChainCount() {
        ++this.chainCount;
    }

    public synchronized void clearChainCount() {
        this.chainCount = 0;
    }

    public final IRubyObject getVariable(IRubyObject object) {
        IRubyObject value2;
        RubyClass.VariableAccessor variableAccessor = this.accessor;
        RubyClass cls = object.getMetaClass().getRealClass();
        if (variableAccessor.getClassId() != cls.hashCode()) {
            this.accessor = variableAccessor = cls.getVariableAccessorForRead(this.name);
        }
        if ((value2 = (IRubyObject)variableAccessor.get(object)) != null) {
            return value2;
        }
        return object.getRuntime().getNil();
    }

    public final IRubyObject setVariable(IRubyObject object, IRubyObject value2) {
        RubyClass.VariableAccessor variableAccessor = this.accessor;
        RubyClass cls = object.getMetaClass().getRealClass();
        if (variableAccessor.getClassId() != cls.hashCode()) {
            this.accessor = variableAccessor = cls.getVariableAccessorForWrite(this.name);
        }
        variableAccessor.set(object, value2);
        return value2;
    }

    public String file() {
        return this.file;
    }

    public int line() {
        return this.line;
    }
}

