/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.management;

import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.Ruby;
import org.jruby.management.ParserStatsMBean;

public class ParserStats
implements ParserStatsMBean {
    private final SoftReference<Ruby> ruby;
    private AtomicInteger totalParseTime = new AtomicInteger(0);
    private AtomicLong totalParsedBytes = new AtomicLong(0L);
    private AtomicInteger totalEvalParses = new AtomicInteger(0);
    private AtomicInteger totalLoadParses = new AtomicInteger(0);
    private AtomicInteger totalJRubyModuleParses = new AtomicInteger(0);

    public ParserStats(Ruby ruby2) {
        this.ruby = new SoftReference<Ruby>(ruby2);
    }

    public void addParseTime(int time2) {
        this.totalParseTime.addAndGet(time2);
    }

    public void addParsedBytes(int bytes2) {
        this.totalParsedBytes.addAndGet(bytes2);
    }

    public void addEvalParse() {
        this.totalEvalParses.incrementAndGet();
    }

    public void addLoadParse() {
        this.totalLoadParses.incrementAndGet();
    }

    public void addJRubyModuleParse() {
        this.totalJRubyModuleParses.incrementAndGet();
    }

    public double getTotalParseTime() {
        Ruby runtime = this.ruby.get();
        if (runtime == null) {
            return 0.0;
        }
        return (double)runtime.getParser().getTotalTime() / 1.0E9;
    }

    public long getTotalParsedBytes() {
        Ruby runtime = this.ruby.get();
        if (runtime == null) {
            return 0L;
        }
        return runtime.getParser().getTotalBytes();
    }

    public double getParseTimePerKB() {
        long totalBytes = this.getTotalParsedBytes();
        if (totalBytes == 0L) {
            return 0.0;
        }
        return this.getTotalParseTime() / ((double)totalBytes / 1000.0);
    }

    public int getNumberOfEvalParses() {
        return this.totalEvalParses.get();
    }

    public int getNumberOfLoadParses() {
        return this.totalLoadParses.get();
    }
}

