/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.InputStream;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassCache;

public class JavaEmbedUtils {
    public static Ruby initialize(List loadPaths) {
        return JavaEmbedUtils.initialize(loadPaths, new RubyInstanceConfig());
    }

    public static Ruby initialize(List loadPaths, ClassCache classCache) {
        RubyInstanceConfig config = new RubyInstanceConfig();
        if (classCache != null) {
            config.setClassCache(classCache);
        }
        return JavaEmbedUtils.initialize(loadPaths, config);
    }

    public static Ruby initialize(List loadPaths, RubyInstanceConfig config) {
        Ruby runtime = Ruby.newInstance(config);
        runtime.getLoadService().init(loadPaths);
        runtime.getLoadService().require("java");
        return runtime;
    }

    public static ClassCache createClassCache(ClassLoader loader) {
        return new ClassCache(loader, new RubyInstanceConfig().getJitMax());
    }

    public static RubyObjectAdapter newObjectAdapter() {
        return new RubyObjectAdapter(){

            public boolean isKindOf(IRubyObject value2, RubyModule rubyModule) {
                return rubyModule.isInstance(value2);
            }

            public IRubyObject setInstanceVariable(IRubyObject obj, String variableName, IRubyObject value2) {
                return obj.getInstanceVariables().setInstanceVariable(variableName, value2);
            }

            public IRubyObject[] convertToJavaArray(IRubyObject array) {
                return ((RubyArray)array).toJavaArray();
            }

            public RubyInteger convertToRubyInteger(IRubyObject obj) {
                return obj.convertToInteger();
            }

            public IRubyObject getInstanceVariable(IRubyObject obj, String variableName) {
                return obj.getInstanceVariables().getInstanceVariable(variableName);
            }

            public RubyString convertToRubyString(IRubyObject obj) {
                return obj.convertToString();
            }

            public IRubyObject callMethod(IRubyObject receiver2, String methodName) {
                return receiver2.callMethod(receiver2.getRuntime().getCurrentContext(), methodName);
            }

            public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject singleArg) {
                return receiver2.callMethod(receiver2.getRuntime().getCurrentContext(), methodName, singleArg);
            }

            public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject[] args2) {
                return receiver2.callMethod(receiver2.getRuntime().getCurrentContext(), methodName, args2);
            }

            public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject[] args2, Block block) {
                return receiver2.callMethod(receiver2.getRuntime().getCurrentContext(), methodName, args2, block);
            }

            public IRubyObject callSuper(IRubyObject receiver2, IRubyObject[] args2) {
                return RuntimeHelpers.invokeSuper(receiver2.getRuntime().getCurrentContext(), receiver2, args2, Block.NULL_BLOCK);
            }

            public IRubyObject callSuper(IRubyObject receiver2, IRubyObject[] args2, Block block) {
                return RuntimeHelpers.invokeSuper(receiver2.getRuntime().getCurrentContext(), receiver2, args2, block);
            }
        };
    }

    public static RubyRuntimeAdapter newRuntimeAdapter() {
        return new RubyRuntimeAdapter(){

            public IRubyObject eval(Ruby runtime, String script) {
                return runtime.evalScriptlet(script);
            }

            public EvalUnit parse(Ruby runtime, String script, String filename2, int lineNumber) {
                return new InterpretedEvalUnit(runtime, runtime.parseEval(script, filename2, null, lineNumber));
            }

            public EvalUnit parse(Ruby runtime, InputStream in, String filename2, int lineNumber) {
                return new InterpretedEvalUnit(runtime, runtime.parseFile(in, filename2, null, lineNumber));
            }
        };
    }

    public static void terminate(Ruby runtime) {
        runtime.tearDown();
    }

    public static Object invokeMethod(Ruby runtime, Object receiver2, String method2, Object[] args2, Class returnType) {
        IRubyObject rubyReceiver = receiver2 != null ? JavaUtil.convertJavaToRuby(runtime, receiver2) : runtime.getTopSelf();
        IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(runtime, args2);
        for (int i2 = 0; i2 < rubyArgs.length; ++i2) {
            IRubyObject obj = rubyArgs[i2];
            if (!(obj instanceof JavaObject)) continue;
            rubyArgs[i2] = Java.wrap(runtime, obj);
        }
        IRubyObject result2 = rubyReceiver.callMethod(runtime.getCurrentContext(), method2, rubyArgs);
        return JavaEmbedUtils.rubyToJava(runtime, result2, returnType);
    }

    public static Object rubyToJava(Ruby runtime, IRubyObject value2, Class type2) {
        return value2.toJava(type2);
    }

    public static Object rubyToJava(IRubyObject value2) {
        return value2.toJava(Object.class);
    }

    public static IRubyObject javaToRuby(Ruby runtime, Object value2) {
        if (value2 instanceof IRubyObject) {
            return (IRubyObject)value2;
        }
        IRubyObject result2 = JavaUtil.convertJavaToUsableRubyObject(runtime, value2);
        return result2 instanceof JavaObject ? Java.wrap(runtime, result2) : result2;
    }

    public static IRubyObject javaToRuby(Ruby runtime, boolean value2) {
        return JavaEmbedUtils.javaToRuby(runtime, value2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public static IRubyObject javaToRuby(Ruby runtime, byte value2) {
        return JavaEmbedUtils.javaToRuby(runtime, (Object)value2);
    }

    public static IRubyObject javaToRuby(Ruby runtime, char value2) {
        return JavaEmbedUtils.javaToRuby(runtime, Character.valueOf(value2));
    }

    public static IRubyObject javaToRuby(Ruby runtime, double value2) {
        return JavaEmbedUtils.javaToRuby(runtime, new Double(value2));
    }

    public static IRubyObject javaToRuby(Ruby runtime, float value2) {
        return JavaEmbedUtils.javaToRuby(runtime, new Float(value2));
    }

    public static IRubyObject javaToRuby(Ruby runtime, int value2) {
        return JavaEmbedUtils.javaToRuby(runtime, (Object)value2);
    }

    public static IRubyObject javaToRuby(Ruby runtime, long value2) {
        return JavaEmbedUtils.javaToRuby(runtime, (Object)value2);
    }

    public static IRubyObject javaToRuby(Ruby runtime, short value2) {
        return JavaEmbedUtils.javaToRuby(runtime, (Object)value2);
    }

    public static class InterpretedEvalUnit
    implements EvalUnit {
        private Ruby runtime;
        private Node node;

        protected InterpretedEvalUnit(Ruby runtime, Node node) {
            this.runtime = runtime;
            this.node = node;
        }

        public IRubyObject run() {
            return this.runtime.runInterpreter(this.node);
        }
    }

    public static interface EvalUnit {
        public IRubyObject run();
    }
}

