/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Interp;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class LoadLocalVarInstr
extends Instr
implements ResultInstr {
    private IRScope scope;
    private TemporaryVariable result;
    private LocalVariable lvar;

    public LoadLocalVarInstr(IRScope scope, TemporaryVariable result2, LocalVariable lvar) {
        super(Operation.BINDING_LOAD);
        assert (result2 != null) : "LoadLocalVarInstr result is null";
        this.lvar = lvar;
        this.result = result2;
        this.scope = scope;
    }

    public Operand[] getOperands() {
        return Instr.EMPTY_OPERANDS;
    }

    public Variable getResult() {
        return this.result;
    }

    public void updateResult(Variable v) {
        this.result = (TemporaryVariable)v;
    }

    public String toString() {
        return this.result + " = load_lvar(" + this.scope.getName() + ", " + this.lvar + ")";
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        return new LoadLocalVarInstr(this.scope, (TemporaryVariable)ii.getRenamedVariable(this.result), (LocalVariable)ii.getRenamedVariable(this.lvar));
    }

    @Interp
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        return this.lvar.retrieve(context, self, currDynScope, temp);
    }

    public void visit(IRVisitor visitor) {
        visitor.LoadLocalVarInstr(this);
    }

    public LocalVariable getLocalVar() {
        return this.lvar;
    }
}

