/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasInstr
extends Instr {
    private final Variable receiver;
    private Operand newName;
    private Operand oldName;

    public AliasInstr(Variable receiver2, Operand newName, Operand oldName) {
        super(Operation.ALIAS);
        this.receiver = receiver2;
        this.newName = newName;
        this.oldName = oldName;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.getReceiver(), this.getNewName(), this.getOldName()};
    }

    @Override
    public String toString() {
        return this.getOperation().toString() + "(" + this.getReceiver() + ", " + this.getNewName() + ", " + this.getOldName() + ")";
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.oldName = this.getOldName().getSimplifiedOperand(valueMap, force);
        this.newName = this.getNewName().getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new AliasInstr((Variable)this.receiver.cloneForInlining(ii), this.getNewName().cloneForInlining(ii), this.getOldName().cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        IRubyObject object = (IRubyObject)this.receiver.retrieve(context, self, currDynScope, temp);
        if (object == null || object instanceof RubyFixnum || object instanceof RubySymbol) {
            throw context.getRuntime().newTypeError("no class to make alias");
        }
        String newNameString = this.getNewName().retrieve(context, self, currDynScope, temp).toString();
        String oldNameString = this.getOldName().retrieve(context, self, currDynScope, temp).toString();
        RubyModule module = object instanceof RubyModule ? (RubyModule)object : object.getMetaClass();
        module.defineAlias(newNameString, oldNameString);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.AliasInstr(this);
    }

    public Variable getReceiver() {
        return this.receiver;
    }

    public Operand getNewName() {
        return this.newName;
    }

    public Operand getOldName() {
        return this.oldName;
    }
}

