/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedCompiledMethod
extends CompiledMethod {
    private final Method method;

    public ReflectedCompiledMethod(RubyModule implementationClass, Arity arity2, Visibility visibility, StaticScope staticScope, Object scriptObject, Method method2, CallConfiguration callConfig, ISourcePosition position, String parameterDesc) {
        this.init(implementationClass, arity2, visibility, staticScope, scriptObject, callConfig, position, parameterDesc);
        this.method = method2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        this.callConfig.pre(context, self, this.getImplementationClass(), name2, block, this.staticScope);
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            try {
                IRubyObject iRubyObject;
                block12: {
                    boolean isTrace = runtime.hasEventHooks();
                    try {
                        if (isTrace) {
                            runtime.callEventHooks(context, RubyEvent.CALL, this.position.getFile(), this.position.getStartLine(), name2, this.getImplementationClass());
                        }
                        iRubyObject = (IRubyObject)this.method.invoke(null, this.$scriptObject, context, self, args2, block);
                        Object var12_15 = null;
                        if (!isTrace) break block12;
                        runtime.callEventHooks(context, RubyEvent.RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        if (!isTrace) throw throwable;
                        runtime.callEventHooks(context, RubyEvent.RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                        throw throwable;
                    }
                }
                Object var14_17 = null;
                this.callConfig.post(context);
                return iRubyObject;
            }
            catch (IllegalArgumentException e) {
                throw RaiseException.createNativeRaiseException(runtime, e, this.method);
            }
            catch (IllegalAccessException e) {
                throw RaiseException.createNativeRaiseException(runtime, e, this.method);
            }
            catch (InvocationTargetException e) {
                Throwable cause2 = e.getCause();
                if (cause2 instanceof JumpException.ReturnJump) {
                    IRubyObject iRubyObject = this.handleReturn(context, (JumpException.ReturnJump)cause2, callNumber);
                    Object var14_18 = null;
                    this.callConfig.post(context);
                    return iRubyObject;
                }
                if (cause2 instanceof JumpException.RedoJump) {
                    IRubyObject iRubyObject = this.handleRedo(runtime);
                    Object var14_19 = null;
                    this.callConfig.post(context);
                    return iRubyObject;
                }
                if (cause2 instanceof RuntimeException) {
                    throw (RuntimeException)cause2;
                }
                if (!(cause2 instanceof Error)) throw RaiseException.createNativeRaiseException(runtime, cause2, this.method);
                throw (Error)cause2;
            }
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            this.callConfig.post(context);
            throw throwable;
        }
    }
}

