/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.SelectorFactory;

@JRubyClass(name={"TCPServer"}, parent="TCPSocket")
public class RubyTCPServer
extends RubyTCPSocket {
    private static ObjectAllocator TCPSERVER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyTCPServer(runtime, klass);
        }
    };
    private ServerSocketChannel ssc;
    private InetSocketAddress socket_address;

    static void createTCPServer(Ruby runtime) {
        RubyClass rb_cTCPServer = runtime.defineClass("TCPServer", runtime.getClass("TCPSocket"), TCPSERVER_ALLOCATOR);
        rb_cTCPServer.defineAnnotatedMethods(RubyTCPServer.class);
        runtime.getObject().setConstant("TCPserver", rb_cTCPServer);
    }

    public RubyTCPServer(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        String host;
        IRubyObject _port;
        Ruby runtime = context.runtime;
        IRubyObject _host = args2[0];
        IRubyObject iRubyObject = _port = args2.length > 1 ? args2[1] : context.nil;
        if (_host.isNil() || _host instanceof RubyString && ((RubyString)_host).isEmpty()) {
            host = "0.0.0.0";
        } else if (_host instanceof RubyFixnum) {
            _port = _host;
            host = "0.0.0.0";
        } else {
            host = _host.convertToString().toString();
        }
        int port = SocketUtils.getPortFrom(context, _port);
        try {
            InetAddress addr2 = InetAddress.getByName(host);
            this.ssc = ServerSocketChannel.open();
            this.socket_address = new InetSocketAddress(addr2, port);
            this.ssc.socket().bind(this.socket_address);
            this.initSocket(runtime, new ChannelDescriptor((Channel)this.ssc, RubyTCPServer.newModeFlags(runtime, ModeFlags.RDWR)));
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "initialize: name or service not known");
        }
        catch (BindException e) {
            throw runtime.newErrnoEADDRFromBindException(e);
        }
        catch (SocketException e) {
            String msg = e.getMessage();
            if (msg.indexOf("Permission denied") != -1) {
                throw runtime.newErrnoEACCESError("bind(2)");
            }
            throw SocketUtils.sockerr(runtime, "initialize: name or service not known");
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "initialize: name or service not known");
        }
        catch (IllegalArgumentException iae) {
            throw SocketUtils.sockerr(runtime, iae.getMessage());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"accept"})
    public IRubyObject accept(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyTCPSocket socket2 = new RubyTCPSocket(runtime, runtime.getClass("TCPSocket"));
        try {
            SocketChannel connected;
            RubyThread thread2 = context.getThread();
            while (true) {
                boolean ready2;
                if (!(ready2 = thread2.select(this, 16))) {
                    context.pollThreadEvents();
                    continue;
                }
                connected = this.ssc.accept();
                if (connected != null) break;
            }
            connected.finishConnect();
            Object object = connected.blockingLock();
            synchronized (object) {
                connected.configureBlocking(false);
                connected.configureBlocking(true);
            }
            socket2.initSocket(runtime, new ChannelDescriptor((Channel)connected, RubyTCPServer.newModeFlags(runtime, ModeFlags.RDWR)));
            return socket2;
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "problem when accepting");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyTCPSocket socket2 = new RubyTCPSocket(runtime, runtime.getClass("TCPSocket"));
        Selector selector = null;
        Object object = this.ssc.blockingLock();
        synchronized (object) {
            boolean oldBlocking = this.ssc.isBlocking();
            this.ssc.configureBlocking(false);
            selector = SelectorFactory.openWithRetryFrom(runtime, SelectorProvider.provider());
            boolean ready2 = context.getThread().select(this, 16, 0L);
            if (!ready2) {
                throw runtime.newErrnoEAGAINError("Resource temporarily unavailable");
            }
            socket2.initSocket(context.getRuntime(), new ChannelDescriptor((Channel)this.ssc.accept(), RubyTCPServer.newModeFlags(runtime, ModeFlags.RDWR)));
            RubyTCPSocket rubyTCPSocket = socket2;
            Object var10_10 = null;
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.ssc.configureBlocking(oldBlocking);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            {
                return rubyTCPSocket;
                catch (IOException e) {
                    throw SocketUtils.sockerr(context.getRuntime(), "problem when accepting");
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.ssc.configureBlocking(oldBlocking);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    @JRubyMethod(name={"listen"}, required=1)
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"peeraddr"}, rest=true)
    public IRubyObject peeraddr(ThreadContext context, IRubyObject[] args2) {
        throw context.getRuntime().newNotImplementedError("not supported");
    }

    @JRubyMethod(name={"getpeername"}, rest=true)
    public IRubyObject getpeername(ThreadContext context, IRubyObject[] args2) {
        throw context.getRuntime().newNotImplementedError("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        IRubyObject tcpServer = recv2.callMethod(context, "new", args2);
        if (!block.isGiven()) {
            return tcpServer;
        }
        try {
            iRubyObject = block.yield(context, tcpServer);
            Object var7_6 = null;
            tcpServer.callMethod(context, "close");
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            tcpServer.callMethod(context, "close");
            throw throwable;
        }
        return iRubyObject;
    }

    public IRubyObject gets(ThreadContext context) {
        throw context.getRuntime().newErrnoENOTCONNError();
    }

    public IRubyObject gets(ThreadContext context, IRubyObject sep) {
        throw context.getRuntime().newErrnoENOTCONNError();
    }

    public IRubyObject gets19(ThreadContext context) {
        throw context.getRuntime().newErrnoENOTCONNError();
    }

    public IRubyObject gets19(ThreadContext context, IRubyObject sep) {
        throw context.getRuntime().newErrnoENOTCONNError();
    }

    public IRubyObject gets19(ThreadContext context, IRubyObject sep, IRubyObject limit2) {
        throw context.getRuntime().newErrnoENOTCONNError();
    }

    @Deprecated
    public IRubyObject accept() {
        return this.accept(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject listen(IRubyObject backlog) {
        return this.listen(this.getRuntime().getCurrentContext(), backlog);
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTCPServer.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }
}

