/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.BIO;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.Digest;
import org.jruby.ext.openssl.impl.EVP;
import org.jruby.ext.openssl.impl.EncContent;
import org.jruby.ext.openssl.impl.Encrypt;
import org.jruby.ext.openssl.impl.Envelope;
import org.jruby.ext.openssl.impl.MemBIO;
import org.jruby.ext.openssl.impl.MessageDigestBIOFilter;
import org.jruby.ext.openssl.impl.Mime;
import org.jruby.ext.openssl.impl.NotVerifiedPKCS7Exception;
import org.jruby.ext.openssl.impl.PKCS7Data;
import org.jruby.ext.openssl.impl.PKCS7DataData;
import org.jruby.ext.openssl.impl.PKCS7DataDigest;
import org.jruby.ext.openssl.impl.PKCS7DataEncrypted;
import org.jruby.ext.openssl.impl.PKCS7DataEnveloped;
import org.jruby.ext.openssl.impl.PKCS7DataSigned;
import org.jruby.ext.openssl.impl.PKCS7DataSignedAndEnveloped;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.impl.RecipInfo;
import org.jruby.ext.openssl.impl.SMIME;
import org.jruby.ext.openssl.impl.SignEnvelope;
import org.jruby.ext.openssl.impl.Signed;
import org.jruby.ext.openssl.impl.SignerInfoWithPkey;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKCS7 {
    private PKCS7Data data;
    private static final byte[] PEM_STRING_PKCS7_START = "-----BEGIN PKCS7-----".getBytes();
    public static final int S_HEADER = 0;
    public static final int S_BODY = 1;
    public static final int S_TAIL = 2;
    public static final int OP_SET_DETACHED_SIGNATURE = 1;
    public static final int OP_GET_DETACHED_SIGNATURE = 2;
    public static final int TEXT = 1;
    public static final int NOCERTS = 2;
    public static final int NOSIGS = 4;
    public static final int NOCHAIN = 8;
    public static final int NOINTERN = 16;
    public static final int NOVERIFY = 32;
    public static final int DETACHED = 64;
    public static final int BINARY = 128;
    public static final int NOATTR = 256;
    public static final int NOSMIMECAP = 512;
    public static final int NOOLDMIMETYPE = 1024;
    public static final int CRLFEOL = 2048;
    public static final int STREAM = 4096;
    public static final int NOCRL = 8192;
    public static final int SMIME_TEXT = 1;
    public static final int SMIME_NOCERTS = 2;
    public static final int SMIME_NOSIGS = 4;
    public static final int SMIME_NOCHAIN = 8;
    public static final int SMIME_NOINTERN = 16;
    public static final int SMIME_NOVERIFY = 32;
    public static final int SMIME_DETACHED = 64;
    public static final int SMIME_BINARY = 128;
    public static final int SMIME_NOATTR = 256;
    public static final int F_B64_READ_PKCS7 = 120;
    public static final int F_B64_WRITE_PKCS7 = 121;
    public static final int F_PKCS7_ADD_ATTRIB_SMIMECAP = 118;
    public static final int F_PKCS7_ADD_CERTIFICATE = 100;
    public static final int F_PKCS7_ADD_CRL = 101;
    public static final int F_PKCS7_ADD_RECIPIENT_INFO = 102;
    public static final int F_PKCS7_ADD_SIGNER = 103;
    public static final int F_PKCS7_BIO_ADD_DIGEST = 125;
    public static final int F_PKCS7_CTRL = 104;
    public static final int F_PKCS7_DATADECODE = 112;
    public static final int F_PKCS7_DATAFINAL = 128;
    public static final int F_PKCS7_DATAINIT = 105;
    public static final int F_PKCS7_DATASIGN = 106;
    public static final int F_PKCS7_DATAVERIFY = 107;
    public static final int F_PKCS7_DECRYPT = 114;
    public static final int F_PKCS7_ENCRYPT = 115;
    public static final int F_PKCS7_FIND_DIGEST = 127;
    public static final int F_PKCS7_GET0_SIGNERS = 124;
    public static final int F_PKCS7_SET_CIPHER = 108;
    public static final int F_PKCS7_SET_CONTENT = 109;
    public static final int F_PKCS7_SET_DIGEST = 126;
    public static final int F_PKCS7_SET_TYPE = 110;
    public static final int F_PKCS7_SIGN = 116;
    public static final int F_PKCS7_SIGNATUREVERIFY = 113;
    public static final int F_PKCS7_SIMPLE_SMIMECAP = 119;
    public static final int F_PKCS7_VERIFY = 117;
    public static final int F_SMIME_READ_PKCS7 = 122;
    public static final int F_SMIME_TEXT = 123;
    public static final int R_CERTIFICATE_VERIFY_ERROR = 117;
    public static final int R_CIPHER_HAS_NO_OBJECT_IDENTIFIER = 144;
    public static final int R_CIPHER_NOT_INITIALIZED = 116;
    public static final int R_CONTENT_AND_DATA_PRESENT = 118;
    public static final int R_DECODE_ERROR = 130;
    public static final int R_DECRYPTED_KEY_IS_WRONG_LENGTH = 100;
    public static final int R_DECRYPT_ERROR = 119;
    public static final int R_DIGEST_FAILURE = 101;
    public static final int R_ERROR_ADDING_RECIPIENT = 120;
    public static final int R_ERROR_SETTING_CIPHER = 121;
    public static final int R_INVALID_MIME_TYPE = 131;
    public static final int R_INVALID_NULL_POINTER = 143;
    public static final int R_MIME_NO_CONTENT_TYPE = 132;
    public static final int R_MIME_PARSE_ERROR = 133;
    public static final int R_MIME_SIG_PARSE_ERROR = 134;
    public static final int R_MISSING_CERIPEND_INFO = 103;
    public static final int R_NO_CONTENT = 122;
    public static final int R_NO_CONTENT_TYPE = 135;
    public static final int R_NO_MULTIPART_BODY_FAILURE = 136;
    public static final int R_NO_MULTIPART_BOUNDARY = 137;
    public static final int R_NO_RECIPIENT_MATCHES_CERTIFICATE = 115;
    public static final int R_NO_RECIPIENT_MATCHES_KEY = 146;
    public static final int R_NO_SIGNATURES_ON_DATA = 123;
    public static final int R_NO_SIGNERS = 142;
    public static final int R_NO_SIG_CONTENT_TYPE = 138;
    public static final int R_OPERATION_NOT_SUPPORTED_ON_THIS_TYPE = 104;
    public static final int R_PKCS7_ADD_SIGNATURE_ERROR = 124;
    public static final int R_PKCS7_DATAFINAL = 126;
    public static final int R_PKCS7_DATAFINAL_ERROR = 125;
    public static final int R_PKCS7_DATASIGN = 145;
    public static final int R_PKCS7_PARSE_ERROR = 139;
    public static final int R_PKCS7_SIG_PARSE_ERROR = 140;
    public static final int R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE = 127;
    public static final int R_SIGNATURE_FAILURE = 105;
    public static final int R_SIGNER_CERTIFICATE_NOT_FOUND = 128;
    public static final int R_SIG_INVALID_MIME_TYPE = 141;
    public static final int R_SMIME_TEXT_ERROR = 129;
    public static final int R_UNABLE_TO_FIND_CERTIFICATE = 106;
    public static final int R_UNABLE_TO_FIND_MEM_BIO = 107;
    public static final int R_UNABLE_TO_FIND_MESSAGE_DIGEST = 108;
    public static final int R_UNKNOWN_DIGEST_TYPE = 109;
    public static final int R_UNKNOWN_OPERATION = 110;
    public static final int R_UNSUPPORTED_CIPHER_TYPE = 111;
    public static final int R_UNSUPPORTED_CONTENT_TYPE = 112;
    public static final int R_WRONG_CONTENT_TYPE = 113;
    public static final int R_WRONG_PKCS7_TYPE = 114;

    public Object ctrl(int cmd, Object v, Object ignored) throws PKCS7Exception {
        return this.data.ctrl(cmd, v, ignored);
    }

    public void setDetached(int v) throws PKCS7Exception {
        this.ctrl(1, v, null);
    }

    public int getDetached() throws PKCS7Exception {
        return (Integer)this.ctrl(2, null, null);
    }

    public boolean isDetached() throws PKCS7Exception {
        return this.isSigned() && this.getDetached() != 0;
    }

    private void initiateWith(Integer nid, DEREncodable content) throws PKCS7Exception {
        this.data = PKCS7Data.fromASN1(nid, content);
    }

    public static PKCS7 fromASN1(DEREncodable obj) throws PKCS7Exception {
        DEREncodable content;
        int size2 = ((ASN1Sequence)obj).size();
        if (size2 == 0) {
            return new PKCS7();
        }
        DERObjectIdentifier contentType = (DERObjectIdentifier)((ASN1Sequence)obj).getObjectAt(0);
        int nid = ASN1Registry.obj2nid(contentType);
        DEREncodable dEREncodable = content = size2 == 1 ? (DEREncodable)null : ((ASN1Sequence)obj).getObjectAt(1);
        if (content != null && content instanceof DERTaggedObject && ((DERTaggedObject)content).getTagNo() == 0) {
            content = ((DERTaggedObject)content).getObject();
        }
        PKCS7 p7 = new PKCS7();
        p7.initiateWith(nid, content);
        return p7;
    }

    public static PKCS7 fromASN1(BIO bio) throws IOException, PKCS7Exception {
        ASN1InputStream ais = new ASN1InputStream(BIO.asInputStream(bio));
        return PKCS7.fromASN1((DEREncodable)ais.readObject());
    }

    public ASN1Encodable asASN1() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        DERObjectIdentifier contentType = ASN1Registry.nid2obj(this.getType());
        vector.add((DEREncodable)contentType);
        vector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)this.data.asASN1()));
        return new DERSequence(vector);
    }

    public byte[] toASN1() throws IOException {
        return this.asASN1().getEncoded();
    }

    public SignerInfoWithPkey addSignature(X509AuxCertificate x509, PrivateKey pkey, MessageDigest dgst) throws PKCS7Exception {
        SignerInfoWithPkey si = new SignerInfoWithPkey();
        si.set(x509, pkey, dgst);
        this.addSigner(si);
        return si;
    }

    public static X509AuxCertificate findByIssuerAndSerial(Collection<X509AuxCertificate> certs, X509Name issuer2, BigInteger serial2) {
        Name name2 = new Name(issuer2);
        for (X509AuxCertificate cert2 : certs) {
            if (!name2.isEqual(cert2.getIssuerX500Principal()) || !serial2.equals(cert2.getSerialNumber())) continue;
            return cert2;
        }
        return null;
    }

    public List<X509AuxCertificate> getSigners(Collection<X509AuxCertificate> certs, List<SignerInfoWithPkey> sinfos, int flags) throws PKCS7Exception {
        ArrayList<X509AuxCertificate> signers2 = new ArrayList<X509AuxCertificate>();
        if (!this.isSigned()) {
            throw new PKCS7Exception(124, 113);
        }
        if (sinfos.size() == 0) {
            throw new PKCS7Exception(124, 142);
        }
        for (SignerInfoWithPkey si : sinfos) {
            IssuerAndSerialNumber ias = si.getIssuerAndSerialNumber();
            X509AuxCertificate signer = null;
            if (certs != null) {
                signer = PKCS7.findByIssuerAndSerial(certs, ias.getName(), ias.getCertificateSerialNumber().getValue());
            }
            if (signer == null && (flags & 0x10) == 0 && this.getSign().getCert() != null) {
                signer = PKCS7.findByIssuerAndSerial(this.getSign().getCert(), ias.getName(), ias.getCertificateSerialNumber().getValue());
            }
            if (signer == null) {
                throw new PKCS7Exception(124, 128);
            }
            signers2.add(signer);
        }
        return signers2;
    }

    public ASN1OctetString digestFromAttributes(ASN1Set attributes2) {
        return (ASN1OctetString)SignerInfoWithPkey.getAttribute(attributes2, 51);
    }

    public void signatureVerify(BIO bio, SignerInfoWithPkey si, X509AuxCertificate x509) throws PKCS7Exception {
        if (!this.isSigned() && !this.isSignedAndEnveloped()) {
            throw new PKCS7Exception(113, 114);
        }
        int md_type = ASN1Registry.obj2nid(si.getDigestAlgorithm().getObjectId());
        BIO btmp = bio;
        MessageDigest mdc = null;
        while (true) {
            if (btmp == null || (btmp = bio.findType(520)) == null) {
                throw new PKCS7Exception(113, 108);
            }
            mdc = ((MessageDigestBIOFilter)btmp).getMessageDigest();
            if (null == mdc) {
                throw new PKCS7Exception(113, -1);
            }
            if (EVP.type(mdc) == md_type) break;
            btmp = btmp.next();
        }
        MessageDigest mdc_tmp = null;
        try {
            mdc_tmp = (MessageDigest)mdc.clone();
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] currentData = new byte[]{};
        ASN1Set sk = si.getAuthenticatedAttributes();
        try {
            if (sk != null && sk.size() > 0) {
                byte[] md_dat = mdc_tmp.digest();
                ASN1OctetString message_digest = this.digestFromAttributes(sk);
                if (message_digest == null) {
                    throw new PKCS7Exception(113, 108);
                }
                if (!Arrays.equals(md_dat, message_digest.getOctets())) {
                    throw new NotVerifiedPKCS7Exception();
                }
                currentData = sk.getEncoded();
            }
            ASN1OctetString os = si.getEncryptedDigest();
            PublicKey pkey = x509.getPublicKey();
            Signature sign2 = Signature.getInstance(EVP.signatureAlgorithm(mdc_tmp, pkey));
            sign2.initVerify(pkey);
            if (currentData.length > 0) {
                sign2.update(currentData);
            }
            if (!sign2.verify(os.getOctets())) {
                throw new NotVerifiedPKCS7Exception();
            }
        }
        catch (NotVerifiedPKCS7Exception e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("Other exception");
            e.printStackTrace();
            throw new NotVerifiedPKCS7Exception();
        }
    }

    public void verify(Collection<X509AuxCertificate> certs, Store store, BIO indata, BIO out, int flags) throws PKCS7Exception {
        int i2;
        if (!this.isSigned()) {
            throw new PKCS7Exception(117, 113);
        }
        if (this.getDetached() != 0 && indata == null) {
            throw new PKCS7Exception(117, 122);
        }
        ArrayList<SignerInfoWithPkey> sinfos = new ArrayList<SignerInfoWithPkey>(this.getSignerInfo());
        if (sinfos.size() == 0) {
            throw new PKCS7Exception(117, 123);
        }
        List<X509AuxCertificate> signers2 = this.getSigners(certs, sinfos, flags);
        if (signers2 == null) {
            throw new NotVerifiedPKCS7Exception();
        }
        if ((flags & 0x20) == 0) {
            for (X509AuxCertificate signer : signers2) {
                StoreContext cert_ctx = new StoreContext();
                if ((flags & 8) == 0) {
                    if (cert_ctx.init(store, signer, new ArrayList<X509AuxCertificate>(this.getSign().getCert())) == 0) {
                        throw new PKCS7Exception(117, -1);
                    }
                    cert_ctx.setPurpose(4);
                } else if (cert_ctx.init(store, signer, null) == 0) {
                    throw new PKCS7Exception(117, -1);
                }
                cert_ctx.setExtraData(1, store.getExtraData(1));
                if ((flags & 0x2000) == 0) {
                    cert_ctx.setCRLs((List)this.getSign().getCrl());
                }
                try {
                    int i3 = cert_ctx.verifyCertificate();
                    int j = 0;
                    if (i3 <= 0) {
                        j = cert_ctx.getError();
                    }
                    cert_ctx.cleanup();
                    if (i3 > 0) continue;
                    throw new PKCS7Exception(117, 117, "Verify error:" + X509Utils.verifyCertificateErrorString(j));
                }
                catch (PKCS7Exception e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PKCS7Exception(117, 117, e);
                }
            }
        }
        BIO tmpin = indata;
        BIO p7bio = this.dataInit(tmpin);
        BIO tmpout = null;
        tmpout = (flags & 1) != 0 ? BIO.mem() : out;
        byte[] buf = new byte[4096];
        try {
            while ((i2 = p7bio.read(buf, 0, buf.length)) > 0) {
                if (tmpout == null) continue;
                tmpout.write(buf, 0, i2);
            }
        }
        catch (IOException e) {
            throw new PKCS7Exception(117, -1, e);
        }
        if ((flags & 1) != 0) {
            new SMIME(Mime.DEFAULT).text(tmpout, out);
        }
        if ((flags & 4) == 0) {
            for (i2 = 0; i2 < sinfos.size(); ++i2) {
                SignerInfoWithPkey si = (SignerInfoWithPkey)((Object)sinfos.get(i2));
                X509AuxCertificate signer = signers2.get(i2);
                this.signatureVerify(p7bio, si, signer);
            }
        }
        if (tmpin == indata && indata != null) {
            p7bio.pop();
        }
    }

    public static PKCS7 sign(X509AuxCertificate signcert, PrivateKey pkey, Collection<X509AuxCertificate> certs, BIO data2, int flags) throws PKCS7Exception {
        PKCS7 p7 = new PKCS7();
        p7.setType(22);
        p7.contentNew(21);
        SignerInfoWithPkey si = p7.addSignature(signcert, pkey, EVP.sha1());
        if ((flags & 2) == 0) {
            p7.addCertificate(signcert);
            if (certs != null) {
                for (X509AuxCertificate c : certs) {
                    p7.addCertificate(c);
                }
            }
        }
        if ((flags & 0x100) == 0) {
            si.addSignedAttribute(50, (DEREncodable)ASN1Registry.nid2obj(21));
            if ((flags & 0x200) == 0) {
                ASN1EncodableVector smcap = new ASN1EncodableVector();
                smcap.add((DEREncodable)new AlgorithmIdentifier(ASN1Registry.nid2obj(44)));
                smcap.add((DEREncodable)new AlgorithmIdentifier(ASN1Registry.nid2obj(37), (DEREncodable)new DERInteger(128)));
                smcap.add((DEREncodable)new AlgorithmIdentifier(ASN1Registry.nid2obj(37), (DEREncodable)new DERInteger(64)));
                smcap.add((DEREncodable)new AlgorithmIdentifier(ASN1Registry.nid2obj(37), (DEREncodable)new DERInteger(40)));
                smcap.add((DEREncodable)new AlgorithmIdentifier(ASN1Registry.nid2obj(31)));
                si.addSignedAttribute(167, (DEREncodable)new DERSequence(smcap));
            }
        }
        if ((flags & 0x1000) != 0) {
            return p7;
        }
        BIO p7bio = p7.dataInit(null);
        try {
            data2.crlfCopy(p7bio, flags);
        }
        catch (IOException e) {
            throw new PKCS7Exception(116, 125, e);
        }
        if ((flags & 0x40) != 0) {
            p7.setDetached(1);
        }
        p7.dataFinal(p7bio);
        return p7;
    }

    public static PKCS7 encrypt(Collection<X509AuxCertificate> certs, byte[] in, CipherSpec cipher2, int flags) throws PKCS7Exception {
        PKCS7 p7 = new PKCS7();
        p7.setType(23);
        try {
            p7.setCipher(cipher2);
            for (X509AuxCertificate x509 : certs) {
                p7.addRecipient(x509);
            }
            BIO p7bio = p7.dataInit(null);
            BIO.memBuf(in).crlfCopy(p7bio, flags);
            p7bio.flush();
            p7.dataFinal(p7bio);
            return p7;
        }
        catch (IOException e) {
            throw new PKCS7Exception(115, 125, e);
        }
    }

    public void decrypt(PrivateKey pkey, X509AuxCertificate cert2, BIO data2, int flags) throws PKCS7Exception {
        if (!this.isEnveloped()) {
            throw new PKCS7Exception(114, 113);
        }
        try {
            BIO tmpmem = this.dataDecode(pkey, null, cert2);
            if ((flags & 1) == 1) {
                BIO tmpbuf = BIO.buffered();
                BIO bread = tmpbuf.push(tmpmem);
                new SMIME(Mime.DEFAULT).text(bread, data2);
            } else {
                int i2;
                byte[] buf = new byte[4096];
                while ((i2 = tmpmem.read(buf, 0, 4096)) > 0) {
                    data2.write(buf, 0, i2);
                }
            }
        }
        catch (IOException e) {
            throw new PKCS7Exception(114, 119, e);
        }
    }

    public void setType(int type2) throws PKCS7Exception {
        switch (type2) {
            case 22: {
                this.data = new PKCS7DataSigned();
                break;
            }
            case 21: {
                this.data = new PKCS7DataData();
                break;
            }
            case 24: {
                this.data = new PKCS7DataSignedAndEnveloped();
                break;
            }
            case 23: {
                this.data = new PKCS7DataEnveloped();
                break;
            }
            case 26: {
                this.data = new PKCS7DataEncrypted();
                break;
            }
            case 25: {
                this.data = new PKCS7DataDigest();
                break;
            }
            default: {
                throw new PKCS7Exception(110, 112);
            }
        }
    }

    public void setCipher(CipherSpec cipher2) throws PKCS7Exception {
        this.data.setCipher(cipher2);
    }

    public RecipInfo addRecipient(X509AuxCertificate recip) throws PKCS7Exception {
        RecipInfo ri = new RecipInfo();
        ri.set(recip);
        this.addRecipientInfo(ri);
        return ri;
    }

    public void contentNew(int nid) throws PKCS7Exception {
        PKCS7 ret = new PKCS7();
        ret.setType(nid);
        this.setContent(ret);
    }

    public void addSigner(SignerInfoWithPkey psi) throws PKCS7Exception {
        this.data.addSigner(psi);
    }

    public void addCertificate(X509AuxCertificate cert2) throws PKCS7Exception {
        this.data.addCertificate(cert2);
    }

    public void addCRL(X509CRL crl) throws PKCS7Exception {
        this.data.addCRL(crl);
    }

    public void addRecipientInfo(RecipInfo ri) throws PKCS7Exception {
        this.data.addRecipientInfo(ri);
    }

    public void setContent(PKCS7 p7) throws PKCS7Exception {
        this.data.setContent(p7);
    }

    public Collection<SignerInfoWithPkey> getSignerInfo() {
        return this.data.getSignerInfo();
    }

    public static PKCS7 readPEM(BIO input) throws PKCS7Exception {
        try {
            byte[] buffer = new byte[1024];
            int read2 = -1;
            read2 = input.gets(buffer, 1024);
            if (read2 > PEM_STRING_PKCS7_START.length) {
                byte[] tmp = new byte[PEM_STRING_PKCS7_START.length];
                System.arraycopy(buffer, 0, tmp, 0, tmp.length);
                if (Arrays.equals(PEM_STRING_PKCS7_START, tmp)) {
                    return PKCS7.fromASN1(BIO.base64Filter(input));
                }
                return null;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public BIO bioAddDigest(BIO pbio, AlgorithmIdentifier alg) throws PKCS7Exception {
        try {
            MessageDigest md = EVP.getDigest(alg.getObjectId());
            BIO btmp = BIO.mdFilter(md);
            if (pbio == null) {
                return btmp;
            }
            pbio.push(btmp);
            return pbio;
        }
        catch (Exception e) {
            throw new PKCS7Exception(125, 109, e);
        }
    }

    public BIO dataDecode(PrivateKey pkey, BIO inBio, X509AuxCertificate pcert) throws PKCS7Exception {
        BIO out = null;
        BIO btmp = null;
        BIO etmp = null;
        BIO bio = null;
        byte[] dataBody = null;
        Set<AlgorithmIdentifier> mdSk = null;
        Collection<RecipInfo> rsk = null;
        AlgorithmIdentifier encAlg = null;
        Cipher evpCipher = null;
        RecipInfo ri2 = null;
        int i2 = this.getType();
        switch (i2) {
            case 22: {
                dataBody = this.getSign().getContents().getOctetString().getOctets();
                mdSk = this.getSign().getMdAlgs();
                break;
            }
            case 24: {
                rsk = this.getSignedAndEnveloped().getRecipientInfo();
                mdSk = this.getSignedAndEnveloped().getMdAlgs();
                dataBody = this.getSignedAndEnveloped().getEncData().getEncData().getOctets();
                encAlg = this.getSignedAndEnveloped().getEncData().getAlgorithm();
                try {
                    evpCipher = PKCS7.getCipher(encAlg.getObjectId());
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    throw new PKCS7Exception(112, 111, e);
                }
            }
            case 23: {
                rsk = this.getEnveloped().getRecipientInfo();
                dataBody = this.getEnveloped().getEncData().getEncData().getOctets();
                encAlg = this.getEnveloped().getEncData().getAlgorithm();
                try {
                    evpCipher = PKCS7.getCipher(encAlg.getObjectId());
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    throw new PKCS7Exception(112, 111, e);
                }
            }
            default: {
                throw new PKCS7Exception(112, 112);
            }
        }
        if (mdSk != null) {
            for (AlgorithmIdentifier xa : mdSk) {
                try {
                    MessageDigest evpMd = EVP.getDigest(xa.getObjectId());
                    btmp = BIO.mdFilter(evpMd);
                    if (out == null) {
                        out = btmp;
                    } else {
                        out.push(btmp);
                    }
                    btmp = null;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    throw new PKCS7Exception(112, 109, e);
                }
            }
        }
        if (evpCipher != null) {
            if (pcert != null) {
                for (RecipInfo ri2 : rsk) {
                    if (ri2.compare(pcert)) break;
                    ri2 = null;
                }
                if (null == ri2) {
                    throw new PKCS7Exception(112, 115);
                }
            }
            byte[] tmp = null;
            if (null == pcert) {
                for (RecipInfo ri2 : rsk) {
                    try {
                        tmp = EVP.decrypt(ri2.getEncKey().getOctets(), pkey);
                        if (tmp != null) {
                            break;
                        }
                    }
                    catch (Exception e) {
                        tmp = null;
                    }
                    ri2 = null;
                }
                if (ri2 == null) {
                    throw new PKCS7Exception(112, 146);
                }
            } else {
                try {
                    Cipher cipher2 = Cipher.getInstance(CipherSpec.getWrappingAlgorithm(pkey.getAlgorithm()));
                    cipher2.init(2, pkey);
                    tmp = cipher2.doFinal(ri2.getEncKey().getOctets());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    throw new PKCS7Exception(112, -1, e);
                }
            }
            DEREncodable params2 = encAlg.getParameters();
            try {
                if (params2 != null && params2 instanceof ASN1OctetString) {
                    SecretKeySpec sks;
                    if (evpCipher.getAlgorithm().startsWith("RC2")) {
                        sks = new SecretKeySpec(tmp, evpCipher.getAlgorithm());
                        RC2ParameterSpec s2 = new RC2ParameterSpec(tmp.length * 8, ((ASN1OctetString)params2).getOctets());
                        evpCipher.init(2, (Key)sks, s2);
                    } else {
                        sks = new SecretKeySpec(tmp, evpCipher.getAlgorithm());
                        IvParameterSpec iv = new IvParameterSpec(((ASN1OctetString)params2).getOctets());
                        evpCipher.init(2, (Key)sks, iv);
                    }
                } else {
                    evpCipher.init(2, new SecretKeySpec(tmp, evpCipher.getAlgorithm()));
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new PKCS7Exception(112, -1, e);
            }
            etmp = BIO.cipherFilter(evpCipher);
            if (out == null) {
                out = etmp;
            } else {
                out.push(etmp);
            }
            etmp = null;
        }
        bio = this.isDetached() || inBio != null ? inBio : (dataBody != null && dataBody.length > 0 ? BIO.memBuf(dataBody) : BIO.mem());
        out.push(bio);
        bio = null;
        return out;
    }

    private static Cipher getCipher(DERObjectIdentifier oid2) throws GeneralSecurityException {
        if (oid2.getId().equals("1.2.840.113549.3.7")) {
            return OpenSSLReal.getCipherBC("DESede/cbc/PKCS5Padding");
        }
        return EVP.getCipher(oid2);
    }

    public BIO dataInit(BIO bio) throws PKCS7Exception {
        Set<AlgorithmIdentifier> mdSk = null;
        ASN1OctetString os = null;
        int i2 = this.data.getType();
        Collection<RecipInfo> rsk = null;
        AlgorithmIdentifier xa = null;
        CipherSpec evpCipher = null;
        BIO out = null;
        BIO btmp = null;
        EncContent enc = null;
        switch (i2) {
            case 22: {
                mdSk = this.getSign().getMdAlgs();
                os = this.getSign().getContents().getOctetString();
                break;
            }
            case 24: {
                rsk = this.getSignedAndEnveloped().getRecipientInfo();
                mdSk = this.getSignedAndEnveloped().getMdAlgs();
                enc = this.getSignedAndEnveloped().getEncData();
                evpCipher = this.getSignedAndEnveloped().getEncData().getCipher();
                if (null != evpCipher) break;
                throw new PKCS7Exception(105, 116);
            }
            case 23: {
                rsk = this.getEnveloped().getRecipientInfo();
                enc = this.getEnveloped().getEncData();
                evpCipher = this.getEnveloped().getEncData().getCipher();
                if (null != evpCipher) break;
                throw new PKCS7Exception(105, 116);
            }
            case 25: {
                xa = this.getDigest().getMd();
                os = this.getDigest().getContents().getOctetString();
                break;
            }
            default: {
                throw new PKCS7Exception(105, 112);
            }
        }
        if (mdSk != null) {
            for (AlgorithmIdentifier ai : mdSk) {
                if ((out = this.bioAddDigest(out, ai)) != null) continue;
                return null;
            }
        }
        if (xa != null && (out = this.bioAddDigest(out, xa)) == null) {
            return null;
        }
        if (evpCipher != null) {
            btmp = BIO.cipherFilter(evpCipher.getCipher());
            String algoBase = evpCipher.getCipher().getAlgorithm();
            if (algoBase.indexOf(47) != -1) {
                algoBase = algoBase.split("/")[0];
            }
            try {
                KeyGenerator gen = KeyGenerator.getInstance(algoBase);
                gen.init(evpCipher.getKeyLenInBits(), new SecureRandom());
                SecretKey key2 = gen.generateKey();
                evpCipher.getCipher().init(1, key2);
                if (null != rsk) {
                    for (RecipInfo ri : rsk) {
                        PublicKey pkey = ri.getCert().getPublicKey();
                        Cipher cipher2 = Cipher.getInstance(CipherSpec.getWrappingAlgorithm(pkey.getAlgorithm()));
                        cipher2.init(1, pkey);
                        byte[] tmp = cipher2.doFinal(key2.getEncoded());
                        ri.setEncKey((ASN1OctetString)new DEROctetString(tmp));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new PKCS7Exception(105, 121, e);
            }
            DERObjectIdentifier encAlgo = ASN1Registry.sym2oid(evpCipher.getOsslName());
            if (encAlgo == null) {
                throw new PKCS7Exception(105, 144);
            }
            if (evpCipher.getCipher().getIV() != null) {
                enc.setAlgorithm(new AlgorithmIdentifier(encAlgo, (DEREncodable)new DEROctetString(evpCipher.getCipher().getIV())));
            } else {
                enc.setAlgorithm(new AlgorithmIdentifier(encAlgo));
            }
            if (out == null) {
                out = btmp;
            } else {
                out.push(btmp);
            }
            btmp = null;
        }
        if (bio == null) {
            if (this.isDetached()) {
                bio = BIO.nullSink();
            } else if (os != null && os.getOctets().length > 0) {
                bio = BIO.memBuf(os.getOctets());
            }
            if (bio == null) {
                bio = BIO.mem();
                bio.setMemEofReturn(0);
            }
        }
        out.push(bio);
        bio = null;
        return out;
    }

    public BIO findDigest(MessageDigest[] pmd, BIO bio, int nid) throws PKCS7Exception {
        while (true) {
            if ((bio = bio.findType(520)) == null) {
                throw new PKCS7Exception(127, 108);
            }
            pmd[0] = ((MessageDigestBIOFilter)bio).getMessageDigest();
            if (pmd[0] == null) {
                throw new PKCS7Exception(127, -1);
            }
            if (nid == EVP.type(pmd[0])) {
                return bio;
            }
            bio = bio.next();
        }
    }

    public int dataFinal(BIO bio) throws PKCS7Exception {
        BIO btmp;
        Collection<SignerInfoWithPkey> siSk = null;
        MessageDigest mdc = null;
        MessageDigest ctx_tmp = null;
        int i2 = this.data.getType();
        switch (i2) {
            case 24: {
                siSk = this.getSignedAndEnveloped().getSignerInfo();
                break;
            }
            case 22: {
                siSk = this.getSign().getSignerInfo();
                break;
            }
            case 25: {
                break;
            }
        }
        if (siSk != null) {
            for (SignerInfoWithPkey si : siSk) {
                if (si.getPkey() == null) continue;
                int j = ASN1Registry.obj2nid(si.getDigestAlgorithm().getObjectId());
                btmp = bio;
                MessageDigest[] _mdc = new MessageDigest[]{mdc};
                btmp = this.findDigest(_mdc, btmp, j);
                mdc = _mdc[0];
                if (btmp == null) {
                    return 0;
                }
                try {
                    ctx_tmp = (MessageDigest)mdc.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
                ASN1Set sk = si.getAuthenticatedAttributes();
                Signature sign2 = null;
                try {
                    if (sk != null && sk.size() > 0) {
                        if (null == si.getSignedAttribute(52)) {
                            DERUTCTime signTime = new DERUTCTime(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime());
                            si.addSignedAttribute(52, (DEREncodable)signTime);
                        }
                        byte[] md_data = ctx_tmp.digest();
                        DEROctetString digest2 = new DEROctetString(md_data);
                        si.addSignedAttribute(51, (DEREncodable)digest2);
                        sk = si.getAuthenticatedAttributes();
                        sign2 = Signature.getInstance(EVP.signatureAlgorithm(ctx_tmp, si.getPkey()));
                        sign2.initSign(si.getPkey());
                        byte[] abuf = sk.getEncoded();
                        sign2.update(abuf);
                    }
                    if (sign2 == null) continue;
                    byte[] out = sign2.sign();
                    si.setEncryptedDigest((ASN1OctetString)new DEROctetString(out));
                }
                catch (Exception e) {
                    throw new PKCS7Exception(128, -1, e);
                }
            }
        } else if (i2 == 25) {
            int nid = ASN1Registry.obj2nid(this.getDigest().getMd().getObjectId());
            MessageDigest[] _mdc = new MessageDigest[]{mdc};
            bio = this.findDigest(_mdc, bio, nid);
            mdc = _mdc[0];
            byte[] md_data = mdc.digest();
            DEROctetString digest3 = new DEROctetString(md_data);
            this.getDigest().setDigest((ASN1OctetString)digest3);
        }
        if (!this.isDetached()) {
            btmp = bio.findType(1025);
            if (null == btmp) {
                throw new PKCS7Exception(128, 107);
            }
            byte[] buf = ((MemBIO)btmp).getMemCopy();
            switch (i2) {
                case 24: {
                    this.getSignedAndEnveloped().getEncData().setEncData((ASN1OctetString)new DEROctetString(buf));
                    break;
                }
                case 23: {
                    this.getEnveloped().getEncData().setEncData((ASN1OctetString)new DEROctetString(buf));
                    break;
                }
                case 22: {
                    if (this.getSign().getContents().isData() && this.getDetached() != 0) {
                        this.getSign().getContents().setData(null);
                        break;
                    }
                    this.getSign().getContents().setData((ASN1OctetString)new DEROctetString(buf));
                    break;
                }
                case 25: {
                    if (this.getDigest().getContents().isData() && this.getDetached() != 0) {
                        this.getDigest().getContents().setData(null);
                        break;
                    }
                    this.getDigest().getContents().setData((ASN1OctetString)new DEROctetString(buf));
                }
            }
        }
        return 1;
    }

    public String toString() {
        return "#<PKCS7 " + this.data + ">";
    }

    public Envelope getEnveloped() {
        return this.data.getEnveloped();
    }

    public SignEnvelope getSignedAndEnveloped() {
        return this.data.getSignedAndEnveloped();
    }

    public Digest getDigest() {
        return this.data.getDigest();
    }

    public Encrypt getEncrypted() {
        return this.data.getEncrypted();
    }

    public ASN1Encodable getOther() {
        return this.data.getOther();
    }

    public void setSign(Signed sign2) {
        this.data.setSign(sign2);
    }

    public Signed getSign() {
        return this.data.getSign();
    }

    public void setData(ASN1OctetString data2) {
        this.data.setData(data2);
    }

    public ASN1OctetString getData() {
        return this.data.getData();
    }

    public boolean isSigned() {
        return this.data.isSigned();
    }

    public boolean isEncrypted() {
        return this.data.isEncrypted();
    }

    public boolean isEnveloped() {
        return this.data.isEnveloped();
    }

    public boolean isSignedAndEnveloped() {
        return this.data.isSignedAndEnveloped();
    }

    public boolean isData() {
        return this.data.isData();
    }

    public boolean isDigest() {
        return this.data.isDigest();
    }

    public boolean isOther() {
        return this.data.isOther();
    }

    public int getType() {
        return this.data.getType();
    }

    public ASN1OctetString getOctetString() {
        if (this.isData()) {
            return this.getData();
        }
        if (this.isOther() && this.getOther() != null && this.getOther() instanceof ASN1OctetString) {
            return (ASN1OctetString)this.getOther();
        }
        return null;
    }
}

