/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.jruby.ext.openssl.impl.EncContent;
import org.jruby.ext.openssl.impl.RecipInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Envelope {
    private int version;
    private EncContent encData = new EncContent();
    private Collection<RecipInfo> recipientInfo = new ArrayList<RecipInfo>();

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int newVersion) {
        this.version = newVersion;
    }

    public final EncContent getEncData() {
        return this.encData;
    }

    public final void setEncData(EncContent newEncData) {
        this.encData = newEncData;
    }

    public final Collection<RecipInfo> getRecipientInfo() {
        return this.recipientInfo;
    }

    public final void setRecipientInfo(Collection<RecipInfo> newRecipientInfo) {
        this.recipientInfo = newRecipientInfo;
    }

    public String toString() {
        return "#<Envelope version=" + this.version + " encData=" + this.encData + " recipientInfo=" + this.recipientInfo + ">";
    }

    public static Envelope fromASN1(DEREncodable content) {
        ASN1Sequence sequence = (ASN1Sequence)content;
        DERInteger version2 = (DERInteger)sequence.getObjectAt(0);
        ASN1Set recipients2 = (ASN1Set)sequence.getObjectAt(1);
        DEREncodable encContent = sequence.getObjectAt(2);
        Envelope envelope = new Envelope();
        envelope.setVersion(version2.getValue().intValue());
        envelope.setRecipientInfo(Envelope.recipientInfosFromASN1Set((DEREncodable)recipients2));
        envelope.setEncData(EncContent.fromASN1(encContent));
        return envelope;
    }

    public ASN1Encodable asASN1() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((DEREncodable)new DERInteger(this.version));
        vector.add((DEREncodable)this.receipientInfosToASN1Set());
        vector.add((DEREncodable)this.encData.asASN1());
        return new DERSequence(vector);
    }

    private ASN1Set receipientInfosToASN1Set() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        for (RecipInfo ri : this.getRecipientInfo()) {
            vector.add((DEREncodable)ri.asASN1());
        }
        return new DERSet(vector);
    }

    private static Collection<RecipInfo> recipientInfosFromASN1Set(DEREncodable content) {
        ASN1Set set = (ASN1Set)content;
        ArrayList<RecipInfo> result2 = new ArrayList<RecipInfo>();
        Enumeration e = set.getObjects();
        while (e.hasMoreElements()) {
            result2.add(RecipInfo.fromASN1((DEREncodable)e.nextElement()));
        }
        return result2;
    }
}

