/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

public class HandleFactory {
    public static Handle createHandle(JRubyClassLoader classLoader, Method method2) {
        String name2 = HandleFactory.createHandleName(method2);
        try {
            Class<?> handleClass = classLoader.loadClass(name2);
            return (Handle)handleClass.newInstance();
        }
        catch (Exception e) {
            Class handleClass = HandleFactory.createHandleClass(classLoader, method2, name2);
            try {
                return (Handle)handleClass.newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public static Class createHandleClass(JRubyClassLoader classLoader, Method method2, String name2) {
        byte[] bytes2 = HandleFactory.createHandleBytes(method2, name2);
        return (classLoader != null ? classLoader : new JRubyClassLoader(JRubyClassLoader.class.getClassLoader())).defineClass(name2, bytes2);
    }

    public static byte[] createHandleBytes(Method method2, String name2) {
        String signature;
        Class<?> returnType = method2.getReturnType();
        Class[] paramTypes = method2.getParameterTypes();
        ClassWriter cv = new ClassWriter(1);
        ((ClassVisitor)cv).visit(49, 49, name2, null, CodegenUtils.p(Handle.class), null);
        boolean needsArgsVersion = true;
        switch (paramTypes.length) {
            case 0: {
                signature = CodegenUtils.sig(Object.class, Object.class);
                break;
            }
            case 1: {
                signature = CodegenUtils.sig(Object.class, Object.class, Object.class);
                break;
            }
            case 2: {
                signature = CodegenUtils.sig(Object.class, Object.class, Object.class, Object.class);
                break;
            }
            case 3: {
                signature = CodegenUtils.sig(Object.class, Object.class, Object.class, Object.class, Object.class);
                break;
            }
            default: {
                needsArgsVersion = false;
                signature = CodegenUtils.sig(Object.class, Object.class, Object[].class);
            }
        }
        SkinnyMethodAdapter m = new SkinnyMethodAdapter(cv, 4113, "invoke", signature, null, null);
        m.start();
        if (!Modifier.isStatic(method2.getModifiers())) {
            m.aload(1);
            if (method2.getDeclaringClass() != Object.class) {
                m.checkcast(CodegenUtils.p(method2.getDeclaringClass()));
            }
        }
        switch (paramTypes.length) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int i2;
                for (i2 = 0; i2 < paramTypes.length; ++i2) {
                    HandleFactory.loadUnboxedArgument(m, i2 + 2, paramTypes[i2]);
                }
                break;
            }
            default: {
                int i2;
                for (i2 = 0; i2 < paramTypes.length; ++i2) {
                    m.aload(2);
                    m.pushInt(i2);
                    m.aaload();
                    Class<?> paramClass = paramTypes[i2];
                    if (paramClass.isPrimitive()) {
                        Class boxType = CodegenUtils.getBoxType(paramClass);
                        m.checkcast(CodegenUtils.p(boxType));
                        m.invokevirtual(CodegenUtils.p(boxType), paramClass.toString() + "Value", CodegenUtils.sig(paramClass, new Class[0]));
                        continue;
                    }
                    if (paramClass == Object.class) continue;
                    m.checkcast(CodegenUtils.p(paramClass));
                }
            }
        }
        if (Modifier.isStatic(method2.getModifiers())) {
            m.invokestatic(CodegenUtils.p(method2.getDeclaringClass()), method2.getName(), CodegenUtils.sig(returnType, paramTypes));
        } else if (Modifier.isInterface(method2.getDeclaringClass().getModifiers())) {
            m.invokeinterface(CodegenUtils.p(method2.getDeclaringClass()), method2.getName(), CodegenUtils.sig(returnType, paramTypes));
        } else {
            m.invokevirtual(CodegenUtils.p(method2.getDeclaringClass()), method2.getName(), CodegenUtils.sig(returnType, paramTypes));
        }
        if (returnType == Void.TYPE) {
            m.aconst_null();
        } else if (returnType.isPrimitive()) {
            Class boxType = CodegenUtils.getBoxType(returnType);
            m.invokestatic(CodegenUtils.p(boxType), "valueOf", CodegenUtils.sig(boxType, returnType));
        }
        m.areturn();
        m.end();
        if (needsArgsVersion) {
            m = new SkinnyMethodAdapter(cv, 4113, "invoke", CodegenUtils.sig(Object.class, Object.class, Object[].class), null, null);
            m.start();
            m.aload(0);
            m.aload(1);
            for (int i3 = 0; i3 < paramTypes.length; ++i3) {
                m.aload(2);
                m.ldc(i3);
                m.aaload();
            }
            m.invokevirtual(name2, "invoke", CodegenUtils.sig(Object.class, CodegenUtils.params(Object.class, Object.class, paramTypes.length)));
            m.areturn();
            m.end();
        }
        m = new SkinnyMethodAdapter(cv, 1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
        m.start();
        m.aload(0);
        m.invokespecial(CodegenUtils.p(Handle.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        m.voidreturn();
        m.end();
        ((ClassVisitor)cv).visitEnd();
        byte[] bytes2 = cv.toByteArray();
        return bytes2;
    }

    private static String createHandleName(Method method2) {
        Class<?> returnType = method2.getReturnType();
        Class[] paramTypes = method2.getParameterTypes();
        return method2.getDeclaringClass().getCanonicalName().replaceAll("\\.", "__") + "#" + method2.getName() + "#" + JITCompiler.getHashForString(CodegenUtils.pretty(returnType, paramTypes));
    }

    public static void loadUnboxedArgument(SkinnyMethodAdapter m, int index2, Class type2) {
        m.aload(index2);
        HandleFactory.unboxAndCast(m, type2);
    }

    public static void unboxAndCast(SkinnyMethodAdapter m, Class paramClass) {
        if (paramClass.isPrimitive()) {
            Class boxType = CodegenUtils.getBoxType(paramClass);
            m.checkcast(CodegenUtils.p(boxType));
            m.invokevirtual(CodegenUtils.p(boxType), paramClass.toString() + "Value", CodegenUtils.sig(paramClass, new Class[0]));
        } else if (paramClass != Object.class) {
            m.checkcast(CodegenUtils.p(paramClass));
        }
    }

    public static void main(String[] args2) {
        try {
            Method method2 = HandleFactory.class.getMethod("dummy", String.class);
            Handle handle = HandleFactory.createHandle(null, method2);
            String prop1 = "java.class.path";
            String prop2 = "";
            for (int i2 = 0; i2 < 10; ++i2) {
                String tmp;
                Object result2;
                int j;
                System.out.print("reflected invocation: ");
                long time2 = System.currentTimeMillis();
                for (j = 0; j < 50000000; ++j) {
                    result2 = method2.invoke(null, prop1);
                    method2.invoke(null, prop2);
                    tmp = prop1;
                    prop1 = prop2;
                    prop2 = tmp;
                    if (j % 10000000 != 0) continue;
                    System.out.println(prop2);
                }
                System.out.println(System.currentTimeMillis() - time2);
                System.out.print("method invocation: ");
                time2 = System.currentTimeMillis();
                for (j = 0; j < 50000000; ++j) {
                    result2 = HandleFactory.dummy(prop1);
                    HandleFactory.dummy(prop2);
                    tmp = prop1;
                    prop1 = prop2;
                    prop2 = tmp;
                    if (j % 10000000 != 0) continue;
                    System.out.println(prop2);
                }
                System.out.println(System.currentTimeMillis() - time2);
                System.out.print("handle invocation: ");
                time2 = System.currentTimeMillis();
                for (j = 0; j < 50000000; ++j) {
                    result2 = handle.invoke((Object)null, (Object)prop1);
                    handle.invoke((Object)null, (Object)prop2);
                    tmp = prop1;
                    prop1 = prop2;
                    prop2 = tmp;
                    if (j % 10000000 != 0) continue;
                    System.out.println(prop2);
                }
                System.out.println(System.currentTimeMillis() - time2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String dummy(String str) {
        if (str.length() == 0) {
            return null;
        }
        return str;
    }

    public static int dummy2() {
        return 1;
    }

    public static Object dummy3(Object obj) {
        return obj;
    }

    public static class Tool {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static void main(String[] args2) {
            if (args2.length != 2) {
                System.err.println("Usage:\n  tool <java class> <target dir>");
                System.exit(1);
            }
            String classname = args2[0];
            String target = args2[1];
            FakeLoader loader = new FakeLoader(Tool.class.getClassLoader());
            try {
                Class<?> klass = loader.loadClass(classname, false);
                Method[] arr$ = klass.getMethods();
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    IOException ioe3;
                    Object var14_13;
                    Method method2 = arr$[i$];
                    String name2 = HandleFactory.createHandleName(method2);
                    byte[] bytes2 = HandleFactory.createHandleBytes(method2, name2);
                    FileOutputStream fos = null;
                    try {
                        try {
                            fos = new FileOutputStream(new File(target, name2 + ".class"));
                            fos.write(bytes2);
                        }
                        catch (IOException ioe2) {
                            throw new RuntimeException(ioe2);
                        }
                        var14_13 = null;
                        {
                        }
                    }
                    catch (Throwable throwable) {
                        var14_13 = null;
                        try {
                            fos.close();
                            throw throwable;
                        }
                        catch (IOException ioe3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException ioe3) {}
                    fos.close();
                    ++i$;
                }
                return;
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeLoader
    extends ClassLoader {
        public FakeLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name2, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name2, resolve);
        }
    }

    public static class Handle {
        private Error fail() {
            return new AbstractMethodError("invalid call signature for target method: " + this.getClass());
        }

        public Object invoke(Object receiver2) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object arg0) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object arg0, Object arg1) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object arg0, Object arg1, Object arg2) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object ... args2) {
            throw this.fail();
        }
    }
}

