/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.InvisibleNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements ISourcePositionHolder {
    static final List<Node> EMPTY_LIST = new ArrayList<Node>();
    public static final ByteList EXPRESSION_BYTELIST = ByteList.create((CharSequence)"expression");
    public static final ByteList ASSIGNMENT_BYTELIST = ByteList.create((CharSequence)"assignment");
    public static final ByteList GLOBAL_VARIABLE_BYTELIST = ByteList.create((CharSequence)"global-variable");
    public static final ByteList METHOD_BYTELIST = ByteList.create((CharSequence)"method");
    public static final ByteList CLASS_VARIABLE_BYTELIST = ByteList.create((CharSequence)"class variable");
    public static final ByteList CONSTANT_BYTELIST = ByteList.create((CharSequence)"constant");
    public static final ByteList LOCAL_VARIABLE_BYTELIST = ByteList.create((CharSequence)"local-variable");
    public static final ByteList LOCAL_VARIABLE_IN_BLOCK_BYTELIST = ByteList.create((CharSequence)"local-variable(in-block)");
    public static final ByteList FALSE_BYTELIST = ByteList.create((CharSequence)"false");
    public static final ByteList INSTANCE_VARIABLE_BYTELIST = ByteList.create((CharSequence)"instance-variable");
    public static final ByteList NIL_BYTELIST = ByteList.create((CharSequence)"nil");
    public static final ByteList SELF_BYTELIST = ByteList.create((CharSequence)"self");
    public static final ByteList SUPER_BYTELIST = ByteList.create((CharSequence)"super");
    public static final ByteList TRUE_BYTELIST = ByteList.create((CharSequence)"true");
    public static final ByteList YIELD_BYTELIST = ByteList.create((CharSequence)"yield");
    private ISourcePosition position;

    public Node(ISourcePosition position) {
        assert (position != null);
        this.position = position;
    }

    @Override
    public ISourcePosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(ISourcePosition position) {
        this.position = position;
    }

    public abstract Object accept(NodeVisitor var1);

    public abstract List<Node> childNodes();

    protected static List<Node> createList(Node ... nodes) {
        ArrayList<Node> list2 = new ArrayList<Node>();
        for (Node node : nodes) {
            if (node == null) continue;
            list2.add(node);
        }
        return list2;
    }

    public String toString() {
        if (this instanceof InvisibleNode) {
            return "";
        }
        StringBuilder builder = new StringBuilder(60);
        builder.append("(").append(this.getNodeName());
        if (this instanceof INameNode) {
            builder.append(":").append(((INameNode)((Object)this)).getName());
        }
        builder.append(" ").append(this.getPosition().getStartLine());
        for (Node child : this.childNodes()) {
            builder.append(", ").append(child);
        }
        builder.append(")");
        return builder.toString();
    }

    protected String getNodeName() {
        String name2 = this.getClass().getName();
        int i2 = name2.lastIndexOf(46);
        String nodeType = name2.substring(i2 + 1);
        return nodeType;
    }

    public boolean isInvisible() {
        return this instanceof InvisibleNode;
    }

    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should not be directly interpreted");
    }

    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value2, Block block, boolean checkArity) {
        throw new RuntimeException("Invalid node encountered in interpreter: \"" + this.getClass().getName() + "\", please report this at www.jruby.org");
    }

    public ByteList definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            this.interpret(runtime, context, self, aBlock);
            return EXPRESSION_BYTELIST;
        }
        catch (JumpException jumpExcptn) {
            return null;
        }
    }

    public abstract NodeType getNodeType();
}

