/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.demo.TextAreaReadline;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyApplet
extends Applet {
    private Ruby runtime;
    private boolean doubleBuffered = true;
    private Color backgroundColor = Color.WHITE;
    private RubyProc startProc;
    private RubyProc stopProc;
    private RubyProc destroyProc;
    private RubyProc paintProc;
    private Graphics priorGraphics;
    private IRubyObject wrappedGraphics;
    private VolatileImage backBuffer;
    private Graphics backBufferGraphics;
    private Facade facade;

    private static RubyProc blockToProc(Ruby runtime, Block block) {
        if (block.isGiven()) {
            RubyProc proc2 = block.getProcObject();
            if (proc2 == null) {
                proc2 = RubyProc.newProc(runtime, block, block.type);
            }
            return proc2;
        }
        return null;
    }

    private boolean getBooleanParameter(String name2, boolean defaultValue) {
        String value2 = this.getParameter(name2);
        if (value2 != null) {
            return value2.equals("true");
        }
        return defaultValue;
    }

    private CompatVersion getCompatVersionParameter(String compat, CompatVersion defaultVersion) {
        CompatVersion compatVersion = defaultVersion;
        if (this.getParameter(compat).equals("1.9")) {
            compatVersion = CompatVersion.RUBY1_9;
        }
        return compatVersion;
    }

    private InputStream getCodeResourceAsStream(String name2) {
        if (name2 == null) {
            return null;
        }
        try {
            URL directURL = new URL(this.getCodeBase(), name2);
            return directURL.openStream();
        }
        catch (IOException iOException) {
            return JRubyApplet.class.getClassLoader().getResourceAsStream(name2);
        }
    }

    private static void safeInvokeAndWait(Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (EventQueue.isDispatchThread()) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        } else {
            EventQueue.invokeAndWait(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        super.init();
        this.facade = this.getBooleanParameter("jruby.console", false) ? new ConsoleFacade(this.getParameter("jruby.banner")) : new TrivialFacade();
        JRubyApplet jRubyApplet = this;
        synchronized (jRubyApplet) {
            if (this.runtime != null) {
                return;
            }
            RubyInstanceConfig config = new RubyInstanceConfig(){
                {
                    this.setInput(JRubyApplet.this.facade.getInputStream());
                    this.setOutput(JRubyApplet.this.facade.getOutputStream());
                    this.setError(JRubyApplet.this.facade.getErrorStream());
                    this.setObjectSpaceEnabled(JRubyApplet.this.getBooleanParameter("jruby.objectspace", false));
                    this.setCompatVersion(JRubyApplet.this.getCompatVersionParameter("jruby.compat", CompatVersion.RUBY1_8));
                }
            };
            Ruby.setSecurityRestricted(true);
            this.runtime = Ruby.newInstance(config);
        }
        final String scriptName = this.getParameter("jruby.script");
        final InputStream scriptStream = this.getCodeResourceAsStream(scriptName);
        final String evalString = this.getParameter("jruby.eval");
        try {
            final JRubyApplet applet = this;
            JRubyApplet.safeInvokeAndWait(new Runnable(){

                public void run() {
                    applet.setLayout(new BorderLayout());
                    applet.facade.attach(applet.runtime, applet);
                    if (scriptStream != null) {
                        applet.runtime.runFromMain(scriptStream, scriptName);
                    }
                    if (evalString != null) {
                        applet.runtime.evalScriptlet(evalString);
                    }
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error running script", e.getCause());
        }
    }

    private void invokeCallback(final RubyProc proc2, final IRubyObject[] args2) {
        if (proc2 == null) {
            return;
        }
        final Ruby ruby2 = this.runtime;
        try {
            JRubyApplet.safeInvokeAndWait(new Runnable(){

                public void run() {
                    proc2.call(ruby2.getCurrentContext(), args2);
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Ruby callback failed", e.getCause());
        }
    }

    public synchronized void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public synchronized Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public synchronized boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public synchronized void setDoubleBuffered(boolean shouldBuffer) {
        this.doubleBuffered = shouldBuffer;
        this.repaint();
    }

    public synchronized void start() {
        super.start();
        this.invokeCallback(this.startProc, new IRubyObject[0]);
    }

    public synchronized void stop() {
        this.invokeCallback(this.stopProc, new IRubyObject[0]);
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        try {
            this.invokeCallback(this.destroyProc, new IRubyObject[0]);
            Object var2_1 = null;
            this.facade.destroy();
            Ruby ruby2 = this.runtime;
            this.runtime = null;
            this.startProc = null;
            this.stopProc = null;
            this.destroyProc = null;
            this.paintProc = null;
            this.priorGraphics = null;
            this.wrappedGraphics = null;
            ruby2.tearDown();
            super.destroy();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.facade.destroy();
            Ruby ruby2 = this.runtime;
            this.runtime = null;
            this.startProc = null;
            this.stopProc = null;
            this.destroyProc = null;
            this.paintProc = null;
            this.priorGraphics = null;
            this.wrappedGraphics = null;
            ruby2.tearDown();
            super.destroy();
            throw throwable;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public synchronized void paint(Graphics g) {
        if (this.doubleBuffered) {
            this.paintBuffered(g);
        } else {
            this.paintUnbuffered(g);
        }
    }

    private synchronized void paintBuffered(Graphics g) {
        do {
            GraphicsConfiguration config = this.getGraphicsConfiguration();
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.backBuffer == null || width != this.backBuffer.getWidth() || height != this.backBuffer.getHeight() || this.backBuffer.validate(config) == 2) {
                if (this.backBuffer != null) {
                    this.backBufferGraphics.dispose();
                    this.backBufferGraphics = null;
                    this.backBuffer.flush();
                    this.backBuffer = null;
                }
                this.backBuffer = config.createCompatibleVolatileImage(width, height);
                this.backBufferGraphics = this.backBuffer.createGraphics();
            }
            this.backBufferGraphics.setClip(g.getClip());
            this.paintUnbuffered(this.backBufferGraphics);
            g.drawImage(this.backBuffer, 0, 0, this);
        } while (this.backBuffer.contentsLost());
    }

    private synchronized void paintUnbuffered(Graphics g) {
        if (this.backgroundColor != null) {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.paintProc != null) {
            if (this.priorGraphics != g) {
                this.wrappedGraphics = JavaUtil.convertJavaToUsableRubyObject(this.runtime, g);
                this.priorGraphics = g;
            }
            ThreadContext context = this.runtime.getCurrentContext();
            this.paintProc.call(context, new IRubyObject[]{this.wrappedGraphics});
        }
        super.paint(g);
    }

    private static class ConsoleFacade
    implements Facade {
        private JTextPane textPane = new JTextPane();
        private JScrollPane scrollPane;
        private TextAreaReadline adaptor;
        private InputStream inputStream;
        private PrintStream outputStream;
        private PrintStream errorStream;

        public ConsoleFacade(String bannerText) {
            this.textPane.setMargin(new Insets(4, 4, 0, 4));
            this.textPane.setCaretColor(new Color(164, 0, 0));
            this.textPane.setBackground(new Color(242, 242, 242));
            this.textPane.setForeground(new Color(164, 0, 0));
            Font font = this.findFont("Monospaced", 0, 14, new String[]{"Monaco", "Andale Mono"});
            this.textPane.setFont(font);
            this.scrollPane = new JScrollPane(this.textPane);
            this.scrollPane.setDoubleBuffered(true);
            if (bannerText != null) {
                bannerText = "  " + bannerText + "  \n\n";
            }
            this.adaptor = new TextAreaReadline(this.textPane, bannerText);
            this.inputStream = this.adaptor.getInputStream();
            this.outputStream = new PrintStream(this.adaptor.getOutputStream());
            this.errorStream = new PrintStream(this.adaptor.getOutputStream());
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public PrintStream getOutputStream() {
            return this.outputStream;
        }

        public PrintStream getErrorStream() {
            return this.errorStream;
        }

        public void attach(Ruby runtime, Applet applet) {
            this.adaptor.hookIntoRuntime(runtime);
            applet.add(this.scrollPane);
            applet.validate();
        }

        public void destroy() {
            Container parent = this.scrollPane.getParent();
            this.adaptor.shutdown();
            if (parent != null) {
                parent.remove(this.scrollPane);
            }
        }

        private Font findFont(String otherwise, int style, int size2, String[] families) {
            Object[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            Arrays.sort(fonts);
            for (int i2 = 0; i2 < families.length; ++i2) {
                if (Arrays.binarySearch(fonts, families[i2]) < 0) continue;
                return new Font(families[i2], style, size2);
            }
            return new Font(otherwise, style, size2);
        }
    }

    private static class TrivialFacade
    implements Facade {
        public InputStream getInputStream() {
            return System.in;
        }

        public PrintStream getOutputStream() {
            return System.out;
        }

        public PrintStream getErrorStream() {
            return System.err;
        }

        public void attach(Ruby runtime, Applet applet) {
            IRubyObject wrappedApplet = JavaEmbedUtils.javaToRuby(runtime, applet);
            runtime.defineGlobalConstant("JRUBY_APPLET", wrappedApplet);
            wrappedApplet.getMetaClass().defineAnnotatedMethods(RubyMethods.class);
        }

        public void destroy() {
        }
    }

    public static class RubyMethods {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_start(IRubyObject recv2, Block block) {
            JRubyApplet applet;
            JRubyApplet jRubyApplet = applet = (JRubyApplet)JavaEmbedUtils.rubyToJava(recv2);
            synchronized (jRubyApplet) {
                applet.startProc = JRubyApplet.blockToProc(applet.runtime, block);
            }
            return recv2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_stop(IRubyObject recv2, Block block) {
            JRubyApplet applet;
            JRubyApplet jRubyApplet = applet = (JRubyApplet)JavaEmbedUtils.rubyToJava(recv2);
            synchronized (jRubyApplet) {
                applet.stopProc = JRubyApplet.blockToProc(applet.runtime, block);
            }
            return recv2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_destroy(IRubyObject recv2, Block block) {
            JRubyApplet applet;
            JRubyApplet jRubyApplet = applet = (JRubyApplet)JavaEmbedUtils.rubyToJava(recv2);
            synchronized (jRubyApplet) {
                applet.destroyProc = JRubyApplet.blockToProc(applet.runtime, block);
            }
            return recv2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_paint(IRubyObject recv2, Block block) {
            JRubyApplet applet;
            JRubyApplet jRubyApplet = applet = (JRubyApplet)JavaEmbedUtils.rubyToJava(recv2);
            synchronized (jRubyApplet) {
                applet.paintProc = JRubyApplet.blockToProc(applet.runtime, block);
                applet.repaint();
            }
            return recv2;
        }
    }

    private static interface Facade {
        public InputStream getInputStream();

        public PrintStream getOutputStream();

        public PrintStream getErrorStream();

        public void attach(Ruby var1, Applet var2);

        public void destroy();
    }
}

