/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;
import org.jruby.util.encoding.CharsetTranscoder;
import org.jruby.util.encoding.RubyCoderResult;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Converter"})
public class RubyConverter
extends RubyObject {
    private CharsetTranscoder transcoder;
    @JRubyConstant
    public static final int INVALID_MASK = 15;
    @JRubyConstant
    public static final int INVALID_REPLACE = 2;
    @JRubyConstant
    public static final int UNDEF_MASK = 240;
    @JRubyConstant
    public static final int UNDEF_REPLACE = 32;
    @JRubyConstant
    public static final int UNDEF_HEX_CHARREF = 48;
    @JRubyConstant
    public static final int PARTIAL_INPUT = 65536;
    @JRubyConstant
    public static final int AFTER_OUTPUT = 131072;
    @JRubyConstant
    public static final int UNIVERSAL_NEWLINE_DECORATOR = 256;
    @JRubyConstant
    public static final int CRLF_NEWLINE_DECORATOR = 4096;
    @JRubyConstant
    public static final int CR_NEWLINE_DECORATOR = 8192;
    @JRubyConstant
    public static final int XML_TEXT_DECORATOR = 16384;
    @JRubyConstant
    public static final int XML_ATTR_CONTENT_DECORATOR = 32768;
    @JRubyConstant
    public static final int XML_ATTR_QUOTE_DECORATOR = 0x100000;
    public static final Map<Encoding, Encoding> NONASCII_TO_ASCII = new HashMap<Encoding, Encoding>();
    private static ObjectAllocator CONVERTER_ALLOCATOR;
    private static final Encoding UTF16;

    public static RubyClass createConverterClass(Ruby runtime) {
        RubyClass converterc = runtime.defineClassUnder("Converter", runtime.getClass("Data"), CONVERTER_ALLOCATOR, runtime.getEncoding());
        runtime.setConverter(converterc);
        converterc.index = 23;
        converterc.setReifiedClass(RubyConverter.class);
        converterc.kindOf = new RubyModule.JavaClassKindOf(RubyConverter.class);
        converterc.defineAnnotatedMethods(RubyConverter.class);
        converterc.defineAnnotatedConstants(RubyConverter.class);
        return converterc;
    }

    public RubyConverter(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public RubyConverter(Ruby runtime) {
        super(runtime, runtime.getConverter());
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject convpath2) {
        throw context.runtime.newNotImplementedError("custom convpath not supported");
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject dest) {
        return this.initialize(context, src, dest, context.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject dest, IRubyObject _opt) {
        Ruby runtime = context.runtime;
        EncodingService encodingService = runtime.getEncodingService();
        Encoding srcEncoding = encodingService.getEncodingFromObjectNoError(src);
        Encoding destEncoding = encodingService.getEncodingFromObjectNoError(dest);
        int flags = 0;
        IRubyObject replace2 = context.nil;
        if (srcEncoding == destEncoding && srcEncoding != null) {
            throw runtime.newConverterNotFoundError("code converter not found (" + srcEncoding + " to " + destEncoding + ")");
        }
        try {
            if (srcEncoding != destEncoding) {
                if (srcEncoding != null) {
                    encodingService.charsetForEncoding(srcEncoding);
                }
                if (destEncoding != null) {
                    encodingService.charsetForEncoding(destEncoding);
                }
            }
        }
        catch (RaiseException e) {
            if (e.getException().getMetaClass().getBaseName().equals("CompatibilityError")) {
                throw runtime.newConverterNotFoundError("code converter not found (" + srcEncoding + " to " + destEncoding + ")");
            }
            throw e;
        }
        if (!_opt.isNil()) {
            if (_opt instanceof RubyHash) {
                RubyHash opt = (RubyHash)_opt;
                flags |= EncodingUtils.econvPrepareOpts(context, opt, new IRubyObject[]{opt});
                IRubyObject value2 = opt.fastARef(runtime.newSymbol("replace"));
                if (value2 != null) {
                    replace2 = value2;
                }
            } else {
                flags = (int)_opt.convertToInteger().getLongValue();
                replace2 = context.nil;
            }
        }
        this.transcoder = new CharsetTranscoder(context, destEncoding, srcEncoding, flags, replace2);
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        return RubyString.newString(context.runtime, "#<Encoding::Converter: " + this.transcoder.inEncoding + " to " + this.transcoder.outEncoding);
    }

    @JRubyMethod
    public IRubyObject convpath(ThreadContext context) {
        Ruby runtime = context.runtime;
        EncodingService encodingService = runtime.getEncodingService();
        IRubyObject utf16Encoding = encodingService.getEncodingList()[UTF16.getIndex()];
        return RubyArray.newArray(runtime, RubyArray.newArray(runtime, this.source_encoding(context), utf16Encoding), RubyArray.newArray(runtime, utf16Encoding, this.destination_encoding(context)));
    }

    @JRubyMethod
    public IRubyObject source_encoding(ThreadContext context) {
        if (this.transcoder.inEncoding == null) {
            return context.nil;
        }
        return context.runtime.getEncodingService().convertEncodingToRubyEncoding(this.transcoder.inEncoding);
    }

    @JRubyMethod
    public IRubyObject destination_encoding(ThreadContext context) {
        if (this.transcoder.outEncoding == null) {
            return context.nil;
        }
        return context.runtime.getEncodingService().convertEncodingToRubyEncoding(this.transcoder.outEncoding);
    }

    @JRubyMethod(required=2, optional=4)
    public IRubyObject primitive_convert(ThreadContext context, IRubyObject[] args2) {
        ByteList inBytes;
        Ruby runtime = context.runtime;
        int outputByteoffset = -1;
        int outputBytesize = 0;
        int flags = 0;
        int hashArg = -1;
        if (args2.length > 2 && !args2[2].isNil()) {
            if (args2.length == 3 && args2[2] instanceof RubyHash) {
                hashArg = 2;
            } else {
                outputByteoffset = (int)args2[2].convertToInteger().getLongValue();
                if (outputByteoffset < 0) {
                    throw runtime.newArgumentError("negative offset");
                }
            }
        }
        if (args2.length > 3 && !args2[3].isNil()) {
            if (args2.length == 4 && args2[3] instanceof RubyHash) {
                hashArg = 3;
            } else {
                outputBytesize = (int)args2[3].convertToInteger().getLongValue();
                if (outputBytesize < 0) {
                    throw runtime.newArgumentError("negative bytesize");
                }
            }
        }
        if (args2.length > 4 && !args2[4].isNil()) {
            if (args2.length > 5 && !args2[5].isNil()) {
                throw runtime.newArgumentError(args2.length, 5);
            }
            if (args2[4] instanceof RubyHash) {
                hashArg = 4;
            } else {
                flags = (int)args2[4].convertToInteger().getLongValue();
            }
        }
        IRubyObject opt = context.nil;
        if (hashArg != -1 && !(opt = TypeConverter.checkHashType(runtime, args2[hashArg])).isNil()) {
            IRubyObject v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("partial_input"));
            if (v.isTrue()) {
                flags |= 0x10000;
            }
            if ((v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("after_output"))).isTrue()) {
                flags |= 0x20000;
            }
        } else {
            flags = 0;
        }
        if (args2[0].isNil()) {
            inBytes = new ByteList();
        } else {
            RubyString input = args2[0].convertToString();
            input.modify19();
            inBytes = input.getByteList();
        }
        RubyString output = args2[1].convertToString();
        output.modify19();
        ByteList outBytes = output.getByteList();
        if (outputByteoffset == -1) {
            outputByteoffset = outBytes.getRealSize();
        } else if (outputByteoffset > outBytes.getRealSize()) {
            throw runtime.newArgumentError("offset too big");
        }
        int outputByteEnd = outputByteoffset + outputBytesize;
        if (outputByteEnd > outBytes.getRealSize()) {
            outBytes.ensure(outputByteEnd);
        }
        RubyCoderResult result2 = this.transcoder.primitiveConvert(context, inBytes, output.getByteList(), outputByteoffset, outputBytesize, inBytes.getEncoding(), inBytes.getEncoding().isAsciiCompatible(), flags);
        outBytes.setEncoding(this.transcoder.outEncoding != null ? this.transcoder.outEncoding : inBytes.getEncoding());
        return this.symbolFromResult(result2, runtime, flags, context);
    }

    @JRubyMethod
    public IRubyObject convert(ThreadContext context, IRubyObject srcBuffer) {
        RubyString srcString = srcBuffer.convertToString();
        boolean is7BitAscii = srcString.isCodeRangeAsciiOnly();
        ByteList srcBL = srcString.getByteList();
        ByteList bytes2 = this.transcoder.convert(context, srcBL, is7BitAscii);
        return context.runtime.newString(bytes2);
    }

    @JRubyMethod
    public IRubyObject finish(ThreadContext context) {
        return context.runtime.newString(this.transcoder.finish(ASCIIEncoding.INSTANCE));
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject replacement(ThreadContext context) {
        String replacement2 = this.transcoder.getReplaceWith();
        if (replacement2 == null) {
            return context.nil;
        }
        return context.runtime.newString(replacement2);
    }

    @JRubyMethod(name={"replacement="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject replacement_set(ThreadContext context, IRubyObject replacement2) {
        this.transcoder.getCodingErrorActions().setReplaceWith(replacement2.convertToString().asJavaString());
        return replacement2;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
    public static IRubyObject asciicompat_encoding(ThreadContext context, IRubyObject self2, IRubyObject strOrEnc) {
        Ruby runtime = context.runtime;
        EncodingService encodingService = runtime.getEncodingService();
        Encoding encoding2 = encodingService.getEncodingFromObjectNoError(strOrEnc);
        if (encoding2 == null) {
            return context.nil;
        }
        if (encoding2.isAsciiCompatible()) {
            return context.nil;
        }
        Encoding asciiCompat = NONASCII_TO_ASCII.get(encoding2);
        if (asciiCompat == null) {
            throw runtime.newConverterNotFoundError("no ASCII compatible encoding found for " + strOrEnc);
        }
        return encodingService.convertEncodingToRubyEncoding(asciiCompat);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject last_error(ThreadContext context) {
        RaiseException lastError = this.transcoder.getLastError();
        if (lastError != null) {
            return lastError.getException();
        }
        return context.nil;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject primitive_errinfo(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyCoderResult lastResult = this.transcoder.getLastResult();
        if (lastResult == null) {
            return runtime.newArray(runtime.newSymbol("source_buffer_empty"), context.nil, context.nil, context.nil, context.nil);
        }
        RubyArray errinfo = RubyArray.newArray(context.runtime);
        if (!lastResult.isError()) {
            return runtime.newArray(runtime.newSymbol(lastResult.stringResult), context.nil, context.nil, context.nil, context.nil);
        }
        errinfo.append(runtime.newSymbol(lastResult.stringResult));
        errinfo.append(RubyString.newString(runtime, lastResult.inEncoding.getName()));
        errinfo.append(RubyString.newString(runtime, lastResult.outEncoding.getName()));
        if (lastResult.isError() && lastResult.errorBytes != null) {
            ByteList errorBytes = new ByteList(lastResult.errorBytes, lastResult.inEncoding, true);
            errinfo.append(RubyString.newString(runtime, errorBytes));
        } else {
            errinfo.append(RubyString.newEmptyString(runtime));
        }
        if (lastResult.readagainBytes != null) {
            ByteList readagainBytes = new ByteList(lastResult.readagainBytes, lastResult.inEncoding, true);
            errinfo.append(RubyString.newString(runtime, readagainBytes));
        } else {
            errinfo.append(RubyString.newEmptyString(runtime));
        }
        return errinfo;
    }

    private IRubyObject symbolFromResult(RubyCoderResult result2, Ruby runtime, int flags, ThreadContext context) {
        if (result2 != null) {
            return runtime.newSymbol(result2.stringResult);
        }
        if ((flags & 0x10000) == 0) {
            return context.runtime.newSymbol("finished");
        }
        return context.runtime.newSymbol("source_buffer_empty");
    }

    static {
        NONASCII_TO_ASCII.put(UTF16BEEncoding.INSTANCE, UTF8Encoding.INSTANCE);
        NONASCII_TO_ASCII.put(UTF16LEEncoding.INSTANCE, UTF8Encoding.INSTANCE);
        NONASCII_TO_ASCII.put(UTF32BEEncoding.INSTANCE, UTF8Encoding.INSTANCE);
        NONASCII_TO_ASCII.put(UTF32LEEncoding.INSTANCE, UTF8Encoding.INSTANCE);
        NONASCII_TO_ASCII.put(EncodingDB.getEncodings().get("ISO-2022-JP".getBytes()).getEncoding(), EncodingDB.getEncodings().get("stateless-ISO-2022-JP".getBytes()).getEncoding());
        CONVERTER_ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new RubyConverter(runtime, klass);
            }
        };
        UTF16 = UTF16BEEncoding.INSTANCE;
    }

    public static class EncodingErrorMethods {
        @JRubyMethod
        public static IRubyObject error_char(ThreadContext context, IRubyObject self2) {
            RubyCoderResult result2 = (RubyCoderResult)self2.dataGetStruct();
            if (result2 != null && result2.isError() && result2.errorBytes != null) {
                ByteList errorBytes = new ByteList(result2.errorBytes, result2.inEncoding, true);
                return RubyString.newString(context.runtime, errorBytes);
            }
            return context.nil;
        }

        @JRubyMethod
        public static IRubyObject readagain_bytes(ThreadContext context, IRubyObject self2) {
            RubyCoderResult result2 = (RubyCoderResult)self2.dataGetStruct();
            if (result2 != null && result2.isError() && result2.readagainBytes != null) {
                ByteList errorBytes = new ByteList(result2.readagainBytes, ASCIIEncoding.INSTANCE, true);
                return RubyString.newString(context.runtime, errorBytes);
            }
            return context.nil;
        }

        @JRubyMethod(name={"incomplete_input?"})
        public static IRubyObject incomplete_input_p(ThreadContext context, IRubyObject self2) {
            RubyCoderResult result2 = (RubyCoderResult)self2.dataGetStruct();
            if (result2 != null) {
                if (result2.isInvalid()) {
                    return context.runtime.getTrue();
                }
                return context.runtime.getFalse();
            }
            return context.nil;
        }

        @JRubyMethod
        public static IRubyObject source_encoding(ThreadContext context, IRubyObject self2) {
            RubyCoderResult result2 = (RubyCoderResult)self2.dataGetStruct();
            return context.runtime.getEncodingService().convertEncodingToRubyEncoding(result2.inEncoding);
        }

        @JRubyMethod
        public static IRubyObject source_encoding_name(ThreadContext context, IRubyObject self2) {
            RubyCoderResult result2 = (RubyCoderResult)self2.dataGetStruct();
            return RubyString.newString(context.runtime, result2.inEncoding.getName());
        }

        @JRubyMethod
        public static IRubyObject destination_encoding(ThreadContext context, IRubyObject self2) {
            RubyCoderResult result2 = (RubyCoderResult)self2.dataGetStruct();
            return context.runtime.getEncodingService().convertEncodingToRubyEncoding(result2.outEncoding);
        }

        @JRubyMethod
        public static IRubyObject destination_encoding_name(ThreadContext context, IRubyObject self2) {
            RubyCoderResult result2 = (RubyCoderResult)self2.dataGetStruct();
            return RubyString.newString(context.runtime, result2.outEncoding.getName());
        }
    }
}

