/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.IntHash;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Numeric;
import org.jruby.util.Pack;
import org.jruby.util.PerlHash;
import org.jruby.util.RegexpOptions;
import org.jruby.util.SipHashInline;
import org.jruby.util.Sprintf;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.string.JavaCrypt;

@JRubyClass(name={"String"}, include={"Enumerable", "Comparable"})
public class RubyString
extends RubyObject
implements EncodingCapable,
MarshalEncoding {
    private static final ASCIIEncoding ASCII = ASCIIEncoding.INSTANCE;
    private static final UTF8Encoding UTF8 = UTF8Encoding.INSTANCE;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int SHARE_LEVEL_NONE = 0;
    private static final int SHARE_LEVEL_BUFFER = 1;
    private static final int SHARE_LEVEL_BYTELIST = 2;
    private volatile int shareLevel = 0;
    private ByteList value;
    private static final String[][] opTable19 = new String[][]{{"+", "+(binary)"}, {"-", "-(binary)"}};
    private static final String[][] opTable18 = new String[][]{{"!", "!@"}, {"~", "~@"}, {"+", "+(binary)"}, {"-", "-(binary)"}, {"+@", "+(unary)"}, {"-@", "-(unary)"}, {"!", "!(unary)"}, {"~", "~(unary)"}};
    private static ObjectAllocator STRING_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return RubyString.newAllocatedString(runtime, klass);
        }
    };
    private static final ByteList EMPTY_ASCII8BIT_BYTELIST = new ByteList(new byte[0], ASCIIEncoding.INSTANCE);
    private static final ByteList EMPTY_USASCII_BYTELIST = new ByteList(new byte[0], USASCIIEncoding.INSTANCE);
    private static EmptyByteListHolder[] EMPTY_BYTELISTS = new EmptyByteListHolder[4];
    private static final ByteList SPACE_BYTELIST = new ByteList(ByteList.plain(" "));
    private static final int TRANS_SIZE = 256;

    public static RubyClass createStringClass(Ruby runtime) {
        RubyClass stringClass = runtime.defineClass("String", runtime.getObject(), STRING_ALLOCATOR);
        runtime.setString(stringClass);
        stringClass.index = 4;
        stringClass.setReifiedClass(RubyString.class);
        stringClass.kindOf = new RubyModule.JavaClassKindOf(RubyString.class);
        stringClass.includeModule(runtime.getComparable());
        if (!runtime.is1_9()) {
            stringClass.includeModule(runtime.getEnumerable());
        }
        stringClass.defineAnnotatedMethods(RubyString.class);
        return stringClass;
    }

    @Override
    public Encoding getEncoding() {
        return this.value.getEncoding();
    }

    @Override
    public void setEncoding(Encoding encoding2) {
        this.value.setEncoding(encoding2);
    }

    @Override
    public boolean shouldMarshalEncoding() {
        return this.getEncoding() != ASCIIEncoding.INSTANCE;
    }

    @Override
    public Encoding getMarshalEncoding() {
        return this.getEncoding();
    }

    public void associateEncoding(Encoding enc) {
        if (this.value.getEncoding() != enc) {
            if (!this.isCodeRangeAsciiOnly() || !enc.isAsciiCompatible()) {
                this.clearCodeRange();
            }
            this.value.setEncoding(enc);
        }
    }

    public final void setEncodingAndCodeRange(Encoding enc, int cr) {
        this.value.setEncoding(enc);
        this.setCodeRange(cr);
    }

    public final Encoding toEncoding(Ruby runtime) {
        return runtime.getEncodingService().findEncoding(this);
    }

    public final int getCodeRange() {
        return this.flags & 0x60;
    }

    public final void setCodeRange(int codeRange) {
        this.clearCodeRange();
        this.flags |= codeRange & 0x60;
    }

    public final void clearCodeRange() {
        this.flags &= 0xFFFFFF9F;
    }

    private void keepCodeRange() {
        if (this.getCodeRange() == 96) {
            this.clearCodeRange();
        }
    }

    public final boolean isCodeRangeAsciiOnly() {
        return this.getCodeRange() == 32;
    }

    public final boolean isAsciiOnly() {
        return this.value.getEncoding().isAsciiCompatible() && this.scanForCodeRange() == 32;
    }

    public final boolean isCodeRangeValid() {
        return (this.flags & 0x40) != 0;
    }

    public final boolean isCodeRangeBroken() {
        return (this.flags & 0x60) == 96;
    }

    static int codeRangeAnd(int cr1, int cr2) {
        if (cr1 == 32) {
            return cr2;
        }
        if (cr1 == 64) {
            return cr2 == 32 ? 64 : cr2;
        }
        return 0;
    }

    private void copyCodeRangeForSubstr(RubyString from, Encoding enc) {
        int fromCr = from.getCodeRange();
        if (fromCr == 32) {
            this.setCodeRange(fromCr);
        } else if (fromCr == 64) {
            if (!enc.isAsciiCompatible() || StringSupport.searchNonAscii(this.value) != -1) {
                this.setCodeRange(64);
            } else {
                this.setCodeRange(32);
            }
        } else if (this.value.getRealSize() == 0) {
            this.setCodeRange(!enc.isAsciiCompatible() ? 64 : 32);
        }
    }

    private void copyCodeRange(RubyString from) {
        this.value.setEncoding(from.value.getEncoding());
        this.setCodeRange(from.getCodeRange());
    }

    public final int scanForCodeRange() {
        int cr = this.getCodeRange();
        if (cr == 0) {
            cr = StringSupport.codeRangeScan(this.value.getEncoding(), this.value);
            this.setCodeRange(cr);
        }
        return cr;
    }

    final boolean singleByteOptimizable() {
        return this.getCodeRange() == 32 || this.value.getEncoding().isSingleByte();
    }

    final boolean singleByteOptimizable(Encoding enc) {
        return this.getCodeRange() == 32 || enc.isSingleByte();
    }

    private Encoding isCompatibleWith(RubyString other) {
        Encoding enc2;
        Encoding enc1 = this.value.getEncoding();
        if (enc1 == (enc2 = other.value.getEncoding())) {
            return enc1;
        }
        if (other.value.getRealSize() == 0) {
            return enc1;
        }
        if (this.value.getRealSize() == 0) {
            return enc2;
        }
        if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
            return null;
        }
        return RubyEncoding.areCompatible(enc1, this.scanForCodeRange(), enc2, other.scanForCodeRange());
    }

    final Encoding isCompatibleWith(EncodingCapable other) {
        Encoding enc2;
        if (other instanceof RubyString) {
            return this.checkEncoding((RubyString)other);
        }
        Encoding enc1 = this.value.getEncoding();
        if (enc1 == (enc2 = other.getEncoding())) {
            return enc1;
        }
        if (this.value.getRealSize() == 0) {
            return enc2;
        }
        if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
            return null;
        }
        if (enc2 instanceof USASCIIEncoding) {
            return enc1;
        }
        if (this.scanForCodeRange() == 32) {
            return enc2;
        }
        return null;
    }

    public final Encoding checkEncoding(RubyString other) {
        Encoding enc = this.isCompatibleWith(other);
        if (enc == null) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + this.value.getEncoding() + " and " + other.value.getEncoding());
        }
        return enc;
    }

    final Encoding checkEncoding(EncodingCapable other) {
        Encoding enc = this.isCompatibleWith(other);
        if (enc == null) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + this.value.getEncoding() + " and " + other.getEncoding());
        }
        return enc;
    }

    private Encoding checkDummyEncoding() {
        Encoding enc = this.value.getEncoding();
        if (enc.isDummy()) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible encoding with this operation: " + enc);
        }
        return enc;
    }

    private boolean isComparableWith(RubyString other) {
        ByteList otherValue = other.value;
        if (this.value.getEncoding() == otherValue.getEncoding() || this.value.getRealSize() == 0 || otherValue.getRealSize() == 0) {
            return true;
        }
        return this.isComparableViaCodeRangeWith(other);
    }

    private boolean isComparableViaCodeRangeWith(RubyString other) {
        int cr1 = this.scanForCodeRange();
        int cr2 = other.scanForCodeRange();
        if (cr1 == 32 && (cr2 == 32 || other.value.getEncoding().isAsciiCompatible())) {
            return true;
        }
        return cr2 == 32 && this.value.getEncoding().isAsciiCompatible();
    }

    private int strLength(Encoding enc) {
        if (this.singleByteOptimizable(enc)) {
            return this.value.getRealSize();
        }
        return this.strLength(this.value, enc);
    }

    public final int strLength() {
        if (this.singleByteOptimizable()) {
            return this.value.getRealSize();
        }
        return this.strLength(this.value);
    }

    private int strLength(ByteList bytes2) {
        return this.strLength(bytes2, bytes2.getEncoding());
    }

    private int strLength(ByteList bytes2, Encoding enc) {
        if (this.isCodeRangeValid() && enc instanceof UTF8Encoding) {
            return StringSupport.utf8Length(this.value);
        }
        long lencr = StringSupport.strLengthWithCodeRange(bytes2, enc);
        int cr = StringSupport.unpackArg(lencr);
        if (cr != 0) {
            this.setCodeRange(cr);
        }
        return StringSupport.unpackResult(lencr);
    }

    final int subLength(int pos2) {
        if (this.singleByteOptimizable() || pos2 < 0) {
            return pos2;
        }
        return StringSupport.strLength(this.value.getEncoding(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + pos2);
    }

    @Override
    public final boolean eql(IRubyObject other) {
        Ruby runtime;
        RubyClass metaclass = this.getMetaClass();
        if (metaclass != (runtime = metaclass.getClassRuntime()).getString() || metaclass != other.getMetaClass()) {
            return super.eql(other);
        }
        return runtime.is1_9() ? this.eql19(runtime, other) : this.eql18(runtime, other);
    }

    private boolean eql18(Ruby runtime, IRubyObject other) {
        return this.value.equal(((RubyString)other).value);
    }

    private boolean eql19(Ruby runtime, IRubyObject other) {
        RubyString otherString = (RubyString)other;
        return this.isComparableWith(otherString) && this.value.equal(((RubyString)other).value);
    }

    public RubyString(Ruby runtime, RubyClass rubyClass) {
        this(runtime, rubyClass, EMPTY_BYTE_ARRAY);
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, CharSequence value2) {
        super(runtime, rubyClass);
        assert (value2 != null);
        Encoding defaultEncoding = runtime.getEncodingService().getLocaleEncoding();
        if (defaultEncoding == null) {
            defaultEncoding = UTF8;
        }
        this.value = RubyString.encodeBytelist(value2, defaultEncoding);
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, CharSequence value2, Encoding defaultEncoding) {
        super(runtime, rubyClass);
        assert (value2 != null);
        this.value = RubyString.encodeBytelist(value2, defaultEncoding);
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, byte[] value2) {
        super(runtime, rubyClass);
        assert (value2 != null);
        this.value = new ByteList(value2);
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2) {
        super(runtime, rubyClass);
        assert (value2 != null);
        this.value = value2;
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2, boolean objectSpace) {
        super(runtime, rubyClass, objectSpace);
        assert (value2 != null);
        this.value = value2;
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2, Encoding encoding2, boolean objectSpace) {
        this(runtime, rubyClass, value2, objectSpace);
        value2.setEncoding(encoding2);
    }

    protected RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2, Encoding enc, int cr) {
        this(runtime, rubyClass, value2);
        value2.setEncoding(enc);
        this.flags |= cr;
    }

    protected RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2, Encoding enc) {
        this(runtime, rubyClass, value2);
        value2.setEncoding(enc);
    }

    protected RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2, int cr) {
        this(runtime, rubyClass, value2);
        this.flags |= cr;
    }

    @Deprecated
    public RubyString newString(CharSequence s2) {
        return new RubyString(this.getRuntime(), this.getType(), s2);
    }

    @Deprecated
    public RubyString newString(ByteList s2) {
        return new RubyString(this.getRuntime(), this.getMetaClass(), s2);
    }

    @Deprecated
    public static RubyString newString(Ruby runtime, RubyClass clazz, CharSequence str) {
        return new RubyString(runtime, clazz, str);
    }

    public static RubyString newStringLight(Ruby runtime, ByteList bytes2) {
        return new RubyString(runtime, runtime.getString(), bytes2, false);
    }

    public static RubyString newStringLight(Ruby runtime, int size2) {
        return new RubyString(runtime, runtime.getString(), new ByteList(size2), false);
    }

    public static RubyString newStringLight(Ruby runtime, int size2, Encoding encoding2) {
        return new RubyString(runtime, runtime.getString(), new ByteList(size2), encoding2, false);
    }

    public static RubyString newString(Ruby runtime, CharSequence str) {
        return new RubyString(runtime, runtime.getString(), str);
    }

    public static RubyString newString(Ruby runtime, String str) {
        return new RubyString(runtime, runtime.getString(), str);
    }

    public static RubyString newUSASCIIString(Ruby runtime, String str) {
        return new RubyString(runtime, runtime.getString(), str, (Encoding)USASCIIEncoding.INSTANCE);
    }

    public static RubyString newString(Ruby runtime, byte[] bytes2) {
        return new RubyString(runtime, runtime.getString(), bytes2);
    }

    public static RubyString newString(Ruby runtime, byte[] bytes2, int start2, int length2) {
        byte[] copy = new byte[length2];
        System.arraycopy(bytes2, start2, copy, 0, length2);
        return new RubyString(runtime, runtime.getString(), new ByteList(copy, false));
    }

    public static RubyString newString(Ruby runtime, ByteList bytes2) {
        return new RubyString(runtime, runtime.getString(), bytes2);
    }

    public static RubyString newString(Ruby runtime, ByteList bytes2, Encoding encoding2) {
        return new RubyString(runtime, runtime.getString(), bytes2, encoding2);
    }

    public static RubyString newUnicodeString(Ruby runtime, String str) {
        ByteList byteList = new ByteList(RubyEncoding.encodeUTF8(str), UTF8Encoding.INSTANCE, false);
        return new RubyString(runtime, runtime.getString(), byteList);
    }

    public static RubyString newUnicodeString(Ruby runtime, CharSequence str) {
        ByteList byteList = new ByteList(RubyEncoding.encodeUTF8(str), UTF8Encoding.INSTANCE, false);
        return new RubyString(runtime, runtime.getString(), byteList);
    }

    public static RubyString newInternalFromJavaExternal(Ruby runtime, String str) {
        Encoding internal = runtime.getDefaultInternalEncoding();
        Charset rubyInt = null;
        if (internal != null && internal.getCharset() != null) {
            rubyInt = internal.getCharset();
        }
        Encoding javaExtEncoding = runtime.getEncodingService().getJavaDefault();
        if (rubyInt == null) {
            return RubyString.newString(runtime, new ByteList(str.getBytes(), javaExtEncoding));
        }
        return RubyString.newString(runtime, new ByteList(RubyEncoding.encode(str, rubyInt), internal));
    }

    public static RubyString newStringShared(Ruby runtime, RubyString orig) {
        orig.shareLevel = 2;
        RubyString str = new RubyString(runtime, runtime.getString(), orig.value);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, ByteList bytes2) {
        return RubyString.newStringShared(runtime, runtime.getString(), bytes2);
    }

    public static RubyString newStringShared(Ruby runtime, ByteList bytes2, Encoding encoding2) {
        return RubyString.newStringShared(runtime, runtime.getString(), bytes2, encoding2);
    }

    public static RubyString newStringShared(Ruby runtime, ByteList bytes2, int codeRange) {
        RubyString str = new RubyString(runtime, runtime.getString(), bytes2, codeRange);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, RubyClass clazz, ByteList bytes2) {
        RubyString str = new RubyString(runtime, clazz, bytes2);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, RubyClass clazz, ByteList bytes2, Encoding encoding2) {
        RubyString str = new RubyString(runtime, clazz, bytes2, encoding2);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, byte[] bytes2) {
        return RubyString.newStringShared(runtime, new ByteList(bytes2, false));
    }

    public static RubyString newStringShared(Ruby runtime, byte[] bytes2, Encoding encoding2) {
        return RubyString.newStringShared(runtime, new ByteList(bytes2, encoding2, false));
    }

    public static RubyString newStringShared(Ruby runtime, byte[] bytes2, int start2, int length2) {
        return RubyString.newStringShared(runtime, new ByteList(bytes2, start2, length2, false));
    }

    public static RubyString newStringShared(Ruby runtime, byte[] bytes2, int start2, int length2, Encoding encoding2) {
        return RubyString.newStringShared(runtime, new ByteList(bytes2, start2, length2, encoding2, false));
    }

    public static RubyString newEmptyString(Ruby runtime) {
        return RubyString.newEmptyString(runtime, runtime.getString());
    }

    public static RubyString newAllocatedString(Ruby runtime, RubyClass metaClass) {
        RubyString empty2 = new RubyString(runtime, metaClass, EMPTY_ASCII8BIT_BYTELIST);
        empty2.shareLevel = 2;
        return empty2;
    }

    public static RubyString newEmptyString(Ruby runtime, RubyClass metaClass) {
        RubyString empty2 = new RubyString(runtime, metaClass, runtime.is1_9() ? EMPTY_USASCII_BYTELIST : EMPTY_ASCII8BIT_BYTELIST);
        empty2.shareLevel = 2;
        return empty2;
    }

    public static RubyString newStringNoCopy(Ruby runtime, ByteList bytes2) {
        return RubyString.newStringNoCopy(runtime, runtime.getString(), bytes2);
    }

    public static RubyString newStringNoCopy(Ruby runtime, RubyClass clazz, ByteList bytes2) {
        return new RubyString(runtime, clazz, bytes2);
    }

    public static RubyString newStringNoCopy(Ruby runtime, byte[] bytes2, int start2, int length2) {
        return RubyString.newStringNoCopy(runtime, new ByteList(bytes2, start2, length2, false));
    }

    public static RubyString newStringNoCopy(Ruby runtime, byte[] bytes2) {
        return RubyString.newStringNoCopy(runtime, new ByteList(bytes2, false));
    }

    static EmptyByteListHolder getEmptyByteList(Encoding enc) {
        EmptyByteListHolder bytes2;
        int index2;
        if (enc == null) {
            enc = ASCIIEncoding.INSTANCE;
        }
        if ((index2 = enc.getIndex()) < EMPTY_BYTELISTS.length && (bytes2 = EMPTY_BYTELISTS[index2]) != null) {
            return bytes2;
        }
        return RubyString.prepareEmptyByteList(enc);
    }

    private static EmptyByteListHolder prepareEmptyByteList(Encoding enc) {
        int index2;
        if (enc == null) {
            enc = ASCIIEncoding.INSTANCE;
        }
        if ((index2 = enc.getIndex()) >= EMPTY_BYTELISTS.length) {
            EmptyByteListHolder[] tmp = new EmptyByteListHolder[index2 + 4];
            System.arraycopy(EMPTY_BYTELISTS, 0, tmp, 0, EMPTY_BYTELISTS.length);
            EMPTY_BYTELISTS = tmp;
        }
        RubyString.EMPTY_BYTELISTS[index2] = new EmptyByteListHolder(enc);
        return RubyString.EMPTY_BYTELISTS[index2];
    }

    public static RubyString newEmptyString(Ruby runtime, RubyClass metaClass, Encoding enc) {
        EmptyByteListHolder holder = RubyString.getEmptyByteList(enc);
        RubyString empty2 = new RubyString(runtime, metaClass, holder.bytes, holder.cr);
        empty2.shareLevel = 2;
        return empty2;
    }

    public static RubyString newEmptyString(Ruby runtime, Encoding enc) {
        return RubyString.newEmptyString(runtime, runtime.getString(), enc);
    }

    public static RubyString newStringNoCopy(Ruby runtime, RubyClass clazz, ByteList bytes2, Encoding enc, int cr) {
        return new RubyString(runtime, clazz, bytes2, enc, cr);
    }

    public static RubyString newStringNoCopy(Ruby runtime, ByteList bytes2, Encoding enc, int cr) {
        return RubyString.newStringNoCopy(runtime, runtime.getString(), bytes2, enc, cr);
    }

    public static RubyString newUsAsciiStringNoCopy(Ruby runtime, ByteList bytes2) {
        return RubyString.newStringNoCopy(runtime, bytes2, USASCIIEncoding.INSTANCE, 32);
    }

    public static RubyString newUsAsciiStringShared(Ruby runtime, ByteList bytes2) {
        RubyString str = RubyString.newStringNoCopy(runtime, bytes2, USASCIIEncoding.INSTANCE, 32);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newUsAsciiStringShared(Ruby runtime, byte[] bytes2, int start2, int length2) {
        byte[] copy = new byte[length2];
        System.arraycopy(bytes2, start2, copy, 0, length2);
        return RubyString.newUsAsciiStringShared(runtime, new ByteList(copy, false));
    }

    @Override
    public int getNativeTypeIndex() {
        return 4;
    }

    @Override
    public Class getJavaClass() {
        return String.class;
    }

    @Override
    public RubyString convertToString() {
        return this;
    }

    @Override
    public String toString() {
        return this.decodeString();
    }

    public String decodeString() {
        return Helpers.decodeByteList(this.getRuntime(), this.value);
    }

    @Override
    public IRubyObject dup() {
        RubyClass mc = this.metaClass.getRealClass();
        if (mc.index != 4) {
            return super.dup();
        }
        return this.strDup(mc.getClassRuntime(), mc.getRealClass());
    }

    @Deprecated
    public final RubyString strDup() {
        return this.strDup(this.getRuntime(), this.getMetaClass());
    }

    public final RubyString strDup(Ruby runtime) {
        return this.strDup(runtime, this.getMetaClass());
    }

    @Deprecated
    final RubyString strDup(RubyClass clazz) {
        return this.strDup(this.getRuntime(), this.getMetaClass());
    }

    final RubyString strDup(Ruby runtime, RubyClass clazz) {
        this.shareLevel = 2;
        RubyString dup2 = new RubyString(runtime, clazz, this.value);
        dup2.shareLevel = 2;
        dup2.flags |= this.flags & 0x78;
        return dup2;
    }

    public final RubyString makeSharedString(Ruby runtime, int index2, int len) {
        return runtime.is1_9() ? this.makeShared19(runtime, runtime.getString(), index2, len) : this.makeShared(runtime, runtime.getString(), index2, len);
    }

    public RubyString makeSharedString19(Ruby runtime, int index2, int len) {
        return this.makeShared19(runtime, runtime.getString(), this.value, index2, len);
    }

    public final RubyString makeShared(Ruby runtime, int index2, int len) {
        return runtime.is1_9() ? this.makeShared19(runtime, this.getType(), index2, len) : this.makeShared(runtime, this.getType(), index2, len);
    }

    public final RubyString makeShared(Ruby runtime, RubyClass meta, int index2, int len) {
        RubyString shared;
        if (len == 0) {
            shared = RubyString.newEmptyString(runtime, meta);
        } else if (len == 1) {
            shared = RubyString.newStringShared(runtime, meta, RubyInteger.SINGLE_CHAR_BYTELISTS[this.value.getUnsafeBytes()[this.value.getBegin() + index2] & 0xFF]);
        } else {
            if (this.shareLevel == 0) {
                this.shareLevel = 1;
            }
            shared = new RubyString(runtime, meta, this.value.makeShared(index2, len));
            shared.shareLevel = 1;
        }
        shared.infectBy(this);
        return shared;
    }

    public final RubyString makeShared19(Ruby runtime, int index2, int len) {
        return this.makeShared19(runtime, this.value, index2, len);
    }

    public final RubyString makeShared19(Ruby runtime, RubyClass meta, int index2, int len) {
        return this.makeShared19(runtime, meta, this.value, index2, len);
    }

    private RubyString makeShared19(Ruby runtime, ByteList value2, int index2, int len) {
        return this.makeShared19(runtime, this.getType(), value2, index2, len);
    }

    private RubyString makeShared19(Ruby runtime, RubyClass meta, ByteList value2, int index2, int len) {
        RubyString shared;
        Encoding enc = value2.getEncoding();
        if (len == 0) {
            shared = RubyString.newEmptyString(runtime, meta, enc);
        } else if (len == 1) {
            shared = RubyString.newStringShared(runtime, meta, new ByteList(new byte[]{(byte)value2.get(index2)}, enc), enc);
        } else {
            if (this.shareLevel == 0) {
                this.shareLevel = 1;
            }
            shared = new RubyString(runtime, meta, value2.makeShared(index2, len));
            shared.shareLevel = 1;
            shared.copyCodeRangeForSubstr(this, enc);
        }
        shared.infectBy(this);
        return shared;
    }

    public final void setByteListShared() {
        if (this.shareLevel != 2) {
            this.shareLevel = 2;
        }
    }

    public final void modifyCheck() {
        this.frozenCheck();
    }

    private void modifyCheck(byte[] b, int len) {
        if (this.value.getUnsafeBytes() != b || this.value.getRealSize() != len) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private void modifyCheck(byte[] b, int len, Encoding enc) {
        if (this.value.getUnsafeBytes() != b || this.value.getRealSize() != len || this.value.getEncoding() != enc) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private void frozenCheck() {
        this.frozenCheck(false);
    }

    private void frozenCheck(boolean runtimeError) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError("string", runtimeError);
        }
    }

    public final void modify() {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup();
            } else {
                this.value.unshare();
            }
            this.shareLevel = 0;
        }
        this.value.invalidate();
    }

    public final void modify19() {
        this.modify();
        this.clearCodeRange();
    }

    private void modifyAndKeepCodeRange() {
        this.modify();
        this.keepCodeRange();
    }

    public final void modify(int length2) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup(length2);
            } else {
                this.value.unshare(length2);
            }
            this.shareLevel = 0;
        } else {
            this.value.ensure(length2);
        }
        this.value.invalidate();
    }

    public final void modify19(int length2) {
        this.modify(length2);
        this.clearCodeRange();
    }

    public final void resize(int length2) {
        this.modify();
        if (this.value.getRealSize() > length2) {
            this.value.setRealSize(length2);
        } else if (this.value.length() < length2) {
            this.value.length(length2);
        }
    }

    public final void view(ByteList bytes2) {
        this.modifyCheck();
        this.value = bytes2;
        this.shareLevel = 0;
    }

    private void view(byte[] bytes2) {
        this.modifyCheck();
        this.value = new ByteList(bytes2);
        this.shareLevel = 0;
        this.value.invalidate();
    }

    private void view(int index2, int len) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.makeShared(index2, len);
                this.shareLevel = 1;
            } else {
                this.value.view(index2, len);
            }
        } else {
            this.value.view(index2, len);
            this.shareLevel = 1;
        }
        this.value.invalidate();
    }

    public static String bytesToString(byte[] bytes2, int beg, int len) {
        return new String(ByteList.plain(bytes2, beg, len));
    }

    public static String byteListToString(ByteList bytes2) {
        return RubyString.bytesToString(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
    }

    public static String bytesToString(byte[] bytes2) {
        return RubyString.bytesToString(bytes2, 0, bytes2.length);
    }

    public static byte[] stringToBytes(String string2) {
        return ByteList.plain(string2);
    }

    @Override
    public RubyString asString() {
        return this;
    }

    @Override
    public IRubyObject checkStringType() {
        return this;
    }

    @Override
    public IRubyObject checkStringType19() {
        return this;
    }

    @JRubyMethod(name={"try_convert"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return str.checkStringType();
    }

    @Override
    @JRubyMethod(name={"to_s", "to_str"})
    public IRubyObject to_s() {
        Ruby runtime = this.getRuntime();
        if (this.getMetaClass().getRealClass() != runtime.getString()) {
            return this.strDup(runtime, runtime.getString());
        }
        return this;
    }

    @Override
    public final int compareTo(IRubyObject other) {
        Ruby runtime = this.getRuntime();
        if (other instanceof RubyString) {
            RubyString otherString = (RubyString)other;
            return runtime.is1_9() ? this.op_cmp19(otherString) : this.op_cmp(otherString);
        }
        return (int)this.op_cmpCommon(runtime.getCurrentContext(), other).convertToInteger().getLongValue();
    }

    @Override
    @JRubyMethod(name={"<=>"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.runtime.newFixnum(this.op_cmp((RubyString)other));
        }
        return this.op_cmpCommon(context, other);
    }

    @JRubyMethod(name={"<=>"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_cmp19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.runtime.newFixnum(this.op_cmp19((RubyString)other));
        }
        return this.op_cmpCommon(context, other);
    }

    private IRubyObject op_cmpCommon(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (other.respondsTo("to_str") && other.respondsTo("<=>")) {
            IRubyObject result2 = Helpers.invokedynamic(context, other, MethodNames.OP_CMP, (IRubyObject)this);
            if (result2.isNil()) {
                return result2;
            }
            if (result2 instanceof RubyFixnum) {
                return RubyFixnum.newFixnum(runtime, -((RubyFixnum)result2).getLongValue());
            }
            return RubyFixnum.zero(runtime).callMethod(context, "-", result2);
        }
        return runtime.getNil();
    }

    @Override
    @JRubyMethod(name={"=="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (this == other) {
            return runtime.getTrue();
        }
        if (other instanceof RubyString) {
            return this.value.equal(((RubyString)other).value) ? runtime.getTrue() : runtime.getFalse();
        }
        return this.op_equalCommon(context, other);
    }

    @JRubyMethod(name={"==", "==="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (this == other) {
            return runtime.getTrue();
        }
        if (other instanceof RubyString) {
            RubyString otherString = (RubyString)other;
            return this.isComparableWith(otherString) && this.value.equal(otherString.value) ? runtime.getTrue() : runtime.getFalse();
        }
        return this.op_equalCommon(context, other);
    }

    private IRubyObject op_equalCommon(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (!other.respondsTo("to_str")) {
            return runtime.getFalse();
        }
        return Helpers.invokedynamic(context, other, MethodNames.OP_EQUAL, (IRubyObject)this).isTrue() ? runtime.getTrue() : runtime.getFalse();
    }

    @JRubyMethod(name={"+"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_plus(ThreadContext context, IRubyObject _str) {
        RubyString str = _str.convertToString();
        RubyString resultStr = RubyString.newString(context.runtime, this.addByteLists(this.value, str.value));
        resultStr.infectBy(this.flags | str.flags);
        return resultStr;
    }

    @JRubyMethod(name={"+"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_plus19(ThreadContext context, IRubyObject _str) {
        RubyString str = _str.convertToString();
        Encoding enc = this.checkEncoding(str);
        RubyString resultStr = RubyString.newStringNoCopy(context.runtime, this.addByteLists(this.value, str.value), enc, RubyString.codeRangeAnd(this.getCodeRange(), str.getCodeRange()));
        resultStr.infectBy(this.flags | str.flags);
        return resultStr;
    }

    private ByteList addByteLists(ByteList value1, ByteList value2) {
        ByteList result2 = new ByteList(value1.getRealSize() + value2.getRealSize());
        result2.setRealSize(value1.getRealSize() + value2.getRealSize());
        System.arraycopy(value1.getUnsafeBytes(), value1.getBegin(), result2.getUnsafeBytes(), 0, value1.getRealSize());
        System.arraycopy(value2.getUnsafeBytes(), value2.getBegin(), result2.getUnsafeBytes(), value1.getRealSize(), value2.getRealSize());
        return result2;
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        return this.multiplyByteList(context, other);
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_mul19(ThreadContext context, IRubyObject other) {
        RubyString result2 = this.multiplyByteList(context, other);
        result2.value.setEncoding(this.value.getEncoding());
        result2.copyCodeRange(this);
        return result2;
    }

    private RubyString multiplyByteList(ThreadContext context, IRubyObject arg2) {
        int len = RubyNumeric.num2int(arg2);
        if (len < 0) {
            throw context.runtime.newArgumentError("negative argument");
        }
        if (len > 0 && Integer.MAX_VALUE / len < this.value.getRealSize()) {
            throw context.runtime.newArgumentError("argument too big");
        }
        ByteList bytes2 = new ByteList(len *= this.value.getRealSize());
        if (len > 0) {
            int n;
            bytes2.setRealSize(len);
            System.arraycopy(this.value.getUnsafeBytes(), this.value.getBegin(), bytes2.getUnsafeBytes(), 0, n);
            for (n = this.value.getRealSize(); n <= len >> 1; n <<= 1) {
                System.arraycopy(bytes2.getUnsafeBytes(), 0, bytes2.getUnsafeBytes(), n, n);
            }
            System.arraycopy(bytes2.getUnsafeBytes(), 0, bytes2.getUnsafeBytes(), n, len - n);
        }
        RubyString result2 = new RubyString(context.runtime, this.getMetaClass(), bytes2);
        result2.infectBy(this);
        return result2;
    }

    @JRubyMethod(name={"%"}, required=1)
    public IRubyObject op_format(ThreadContext context, IRubyObject arg2) {
        return this.opFormatCommon(context, arg2, context.runtime.getInstanceConfig().getCompatVersion());
    }

    private IRubyObject opFormatCommon(ThreadContext context, IRubyObject arg2, CompatVersion compat) {
        boolean tainted;
        IRubyObject tmp;
        if (context.runtime.is1_9() && arg2 instanceof RubyHash) {
            tmp = arg2;
        } else {
            tmp = arg2.checkArrayType();
            if (tmp.isNil()) {
                tmp = arg2;
            }
        }
        ByteList out = new ByteList(this.value.getRealSize());
        out.setEncoding(this.value.getEncoding());
        switch (compat) {
            case RUBY1_8: {
                tainted = Sprintf.sprintf(out, Locale.US, (CharSequence)this.value, tmp);
                break;
            }
            case RUBY1_9: 
            case RUBY2_0: {
                tainted = Sprintf.sprintf1_9(out, Locale.US, this.value, tmp);
                break;
            }
            default: {
                throw new RuntimeException("invalid compat version for sprintf: " + (Object)((Object)compat));
            }
        }
        RubyString str = RubyString.newString(context.runtime, out);
        str.setTaint(tainted || this.isTaint());
        return str;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        Ruby runtime = this.getRuntime();
        return RubyFixnum.newFixnum(runtime, this.strHashCode(runtime));
    }

    @Override
    public int hashCode() {
        return this.strHashCode(this.getRuntime());
    }

    public int strHashCode(Ruby runtime) {
        long hash2;
        long l = hash2 = runtime.isSiphashEnabled() ? SipHashInline.hash24(runtime.getHashSeedK0(), runtime.getHashSeedK1(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize()) : PerlHash.hash(runtime.getHashSeedK0(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize());
        if (runtime.is1_9()) {
            hash2 ^= (long)(this.value.getEncoding().isAsciiCompatible() && this.scanForCodeRange() == 32 ? 0 : this.value.getEncoding().getIndex());
        }
        return (int)hash2;
    }

    public int unseededStrHashCode(Ruby runtime) {
        long hash2;
        long l = hash2 = runtime.isSiphashEnabled() ? SipHashInline.hash24(0L, 0L, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize()) : PerlHash.hash(0L, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize());
        if (runtime.is1_9()) {
            hash2 ^= (long)(this.value.getEncoding().isAsciiCompatible() && this.scanForCodeRange() == 32 ? 0 : this.value.getEncoding().getIndex());
        }
        return (int)hash2;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RubyString && ((RubyString)other).value.equal(this.value);
    }

    public static RubyString objAsString(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject str = obj.callMethod(context, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)obj.anyToString();
        }
        if (obj.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    public final int op_cmp(RubyString other) {
        return this.value.cmp(other.value);
    }

    public final int op_cmp19(RubyString other) {
        int ret = this.value.cmp(other.value);
        if (ret == 0 && !this.isComparableWith(other)) {
            return this.value.getEncoding().getIndex() > other.value.getEncoding().getIndex() ? 1 : -1;
        }
        return ret;
    }

    @Override
    public String asJavaString() {
        return this.toString();
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), this.value.dup());
    }

    public final RubyString cat(byte[] str) {
        this.modify(this.value.getRealSize() + str.length);
        System.arraycopy(str, 0, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), str.length);
        this.value.setRealSize(this.value.getRealSize() + str.length);
        return this;
    }

    public final RubyString cat(byte[] str, int beg, int len) {
        this.modify(this.value.getRealSize() + len);
        System.arraycopy(str, beg, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), len);
        this.value.setRealSize(this.value.getRealSize() + len);
        return this;
    }

    public final RubyString cat19(RubyString str) {
        ByteList other = str.value;
        int otherCr = this.cat19(other, str.getCodeRange());
        this.infectBy(str);
        str.setCodeRange(otherCr);
        return this;
    }

    public final int cat19(ByteList other, int codeRange) {
        return this.cat(other.getUnsafeBytes(), other.getBegin(), other.getRealSize(), other.getEncoding(), codeRange);
    }

    public final RubyString cat(RubyString str) {
        return this.cat(str.getByteList());
    }

    public final RubyString cat(ByteList str) {
        this.modify(this.value.getRealSize() + str.getRealSize());
        System.arraycopy(str.getUnsafeBytes(), str.getBegin(), this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), str.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + str.getRealSize());
        return this;
    }

    public final RubyString cat(byte ch) {
        this.modify(this.value.getRealSize() + 1);
        this.value.getUnsafeBytes()[this.value.getBegin() + this.value.getRealSize()] = ch;
        this.value.setRealSize(this.value.getRealSize() + 1);
        return this;
    }

    public final RubyString cat(int ch) {
        return this.cat((byte)ch);
    }

    public final RubyString cat(int code, Encoding enc) {
        int n = StringSupport.codeLength(this.getRuntime(), enc, code);
        this.modify(this.value.getRealSize() + n);
        enc.codeToMbc(code, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + n);
        return this;
    }

    public final int cat(byte[] bytes2, int p2, int len, Encoding enc, int cr) {
        int resCr;
        Encoding resEnc;
        this.modify(this.value.getRealSize() + len);
        int toCr = this.getCodeRange();
        Encoding toEnc = this.value.getEncoding();
        int cr2 = cr;
        if (toEnc == enc) {
            if (toCr == 0) {
                cr = 0;
            } else if (cr == 0) {
                cr = StringSupport.codeRangeScan(enc, bytes2, p2, len);
            }
        } else {
            if (!toEnc.isAsciiCompatible() || !enc.isAsciiCompatible()) {
                if (len == 0) {
                    return toCr;
                }
                if (this.value.getRealSize() == 0) {
                    System.arraycopy(bytes2, p2, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), len);
                    this.value.setRealSize(this.value.getRealSize() + len);
                    this.setEncodingAndCodeRange(enc, cr);
                    return cr;
                }
                throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + toEnc + " and " + enc);
            }
            if (cr == 0) {
                cr = StringSupport.codeRangeScan(enc, bytes2, p2, len);
            }
            if (toCr == 0 && (toEnc == ASCIIEncoding.INSTANCE || cr != 32)) {
                toCr = this.scanForCodeRange();
            }
        }
        if (cr2 != 0) {
            cr2 = cr;
        }
        if (toEnc != enc && toCr != 32 && cr != 32) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + toEnc + " and " + enc);
        }
        if (toCr == 0) {
            resEnc = toEnc;
            resCr = 0;
        } else if (toCr == 32) {
            if (cr == 32) {
                resEnc = toEnc;
                resCr = 32;
            } else {
                resEnc = enc;
                resCr = cr;
            }
        } else if (toCr == 64) {
            resEnc = toEnc;
            resCr = cr == 32 || cr == 64 ? toCr : cr;
        } else {
            resEnc = toEnc;
            int n = resCr = len > 0 ? 0 : toCr;
        }
        if (len < 0) {
            throw this.getRuntime().newArgumentError("negative string size (or size too big)");
        }
        System.arraycopy(bytes2, p2, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), len);
        this.value.setRealSize(this.value.getRealSize() + len);
        this.setEncodingAndCodeRange(resEnc, resCr);
        return cr2;
    }

    public final int cat(byte[] bytes2, int p2, int len, Encoding enc) {
        return this.cat(bytes2, p2, len, enc, 0);
    }

    public final RubyString catAscii(byte[] bytes2, int p2, int len) {
        Encoding enc = this.value.getEncoding();
        if (enc.isAsciiCompatible()) {
            this.cat(bytes2, p2, len, enc, 32);
        } else {
            byte[] buf = new byte[enc.maxLength()];
            int end2 = p2 + len;
            while (p2 < end2) {
                byte c = bytes2[p2];
                int cl = StringSupport.codeLength(this.getRuntime(), enc, c);
                enc.codeToMbc(c, buf, 0);
                this.cat(buf, 0, cl, enc, 64);
                ++p2;
            }
        }
        return this;
    }

    @JRubyMethod(name={"replace", "initialize_copy"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject replace(IRubyObject other) {
        if (this == other) {
            return this;
        }
        this.replaceCommon(other);
        return this;
    }

    @JRubyMethod(name={"replace", "initialize_copy"}, required=1, compat=CompatVersion.RUBY1_9)
    public RubyString replace19(IRubyObject other) {
        this.modifyCheck();
        if (this == other) {
            return this;
        }
        this.setCodeRange(this.replaceCommon(other).getCodeRange());
        return this;
    }

    private RubyString replaceCommon(IRubyObject other) {
        this.modifyCheck();
        RubyString otherStr = other.convertToString();
        this.shareLevel = 2;
        otherStr.shareLevel = 2;
        this.value = otherStr.value;
        this.infectBy(otherStr);
        return otherStr;
    }

    @JRubyMethod(name={"clear"}, compat=CompatVersion.RUBY1_9)
    public RubyString clear() {
        this.modifyCheck();
        Encoding enc = this.value.getEncoding();
        EmptyByteListHolder holder = RubyString.getEmptyByteList(enc);
        this.value = holder.bytes;
        this.shareLevel = 2;
        this.setCodeRange(holder.cr);
        return this;
    }

    @JRubyMethod(name={"reverse"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject reverse(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() <= 1) {
            return this.strDup(context.runtime);
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        byte[] obytes = new byte[len];
        for (int i2 = 0; i2 <= len >> 1; ++i2) {
            obytes[i2] = bytes2[p2 + len - i2 - 1];
            obytes[len - i2 - 1] = bytes2[p2 + i2];
        }
        return new RubyString(runtime, this.getMetaClass(), new ByteList(obytes, false)).infectBy(this);
    }

    @JRubyMethod(name={"reverse"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject reverse19(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() <= 1) {
            return this.strDup(context.runtime);
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        byte[] obytes = new byte[len];
        boolean single = true;
        Encoding enc = this.value.getEncoding();
        if (this.singleByteOptimizable(enc)) {
            for (int i2 = 0; i2 <= len >> 1; ++i2) {
                obytes[i2] = bytes2[p2 + len - i2 - 1];
                obytes[len - i2 - 1] = bytes2[p2 + i2];
            }
        } else {
            int end2 = p2 + len;
            int op = len;
            while (p2 < end2) {
                int cl = StringSupport.length(enc, bytes2, p2, end2);
                if (cl > 1 || (bytes2[p2] & 0x80) != 0) {
                    single = false;
                    System.arraycopy(bytes2, p2, obytes, op -= cl, cl);
                    p2 += cl;
                    continue;
                }
                obytes[--op] = bytes2[p2++];
            }
        }
        RubyString result2 = new RubyString(runtime, this.getMetaClass(), new ByteList(obytes, false));
        if (this.getCodeRange() == 0) {
            this.setCodeRange(single ? 32 : 64);
        }
        Encoding encoding2 = this.value.getEncoding();
        result2.value.setEncoding(encoding2);
        result2.copyCodeRangeForSubstr(this, encoding2);
        return result2.infectBy(this);
    }

    @JRubyMethod(name={"reverse!"}, compat=CompatVersion.RUBY1_8)
    public RubyString reverse_bang(ThreadContext context) {
        if (this.value.getRealSize() > 1) {
            this.modify();
            byte[] bytes2 = this.value.getUnsafeBytes();
            int p2 = this.value.getBegin();
            int len = this.value.getRealSize();
            for (int i2 = 0; i2 < len >> 1; ++i2) {
                byte b = bytes2[p2 + i2];
                bytes2[p2 + i2] = bytes2[p2 + len - i2 - 1];
                bytes2[p2 + len - i2 - 1] = b;
            }
        }
        return this;
    }

    @JRubyMethod(name={"reverse!"}, compat=CompatVersion.RUBY1_9)
    public RubyString reverse_bang19(ThreadContext context) {
        this.modifyCheck();
        if (this.value.getRealSize() > 1) {
            this.modifyAndKeepCodeRange();
            byte[] bytes2 = this.value.getUnsafeBytes();
            int p2 = this.value.getBegin();
            int len = this.value.getRealSize();
            Encoding enc = this.value.getEncoding();
            if (this.singleByteOptimizable(enc)) {
                for (int i2 = 0; i2 < len >> 1; ++i2) {
                    byte b = bytes2[p2 + i2];
                    bytes2[p2 + i2] = bytes2[p2 + len - i2 - 1];
                    bytes2[p2 + len - i2 - 1] = b;
                }
            } else {
                int end2 = p2 + len;
                int op = len;
                byte[] obytes = new byte[len];
                boolean single = true;
                while (p2 < end2) {
                    int cl = StringSupport.length(enc, bytes2, p2, end2);
                    if (cl > 1 || (bytes2[p2] & 0x80) != 0) {
                        single = false;
                        System.arraycopy(bytes2, p2, obytes, op -= cl, cl);
                        p2 += cl;
                        continue;
                    }
                    obytes[--op] = bytes2[p2++];
                }
                this.value.setUnsafeBytes(obytes);
                if (this.getCodeRange() == 0) {
                    this.setCodeRange(single ? 32 : 64);
                }
            }
        }
        return this;
    }

    public static RubyString newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString newString = RubyString.newStringShared(recv2.getRuntime(), ByteList.EMPTY_BYTELIST);
        newString.setMetaClass((RubyClass)recv2);
        newString.callInit(args2, block);
        return newString;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context) {
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0) {
        this.replace(arg0);
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject arg0) {
        this.replace19(arg0);
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject casecmp(ThreadContext context, IRubyObject other) {
        return RubyFixnum.newFixnum(context.runtime, this.value.caseInsensitiveCmp(other.convertToString().value));
    }

    @JRubyMethod(name={"casecmp"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject casecmp19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        RubyString otherStr = other.convertToString();
        Encoding enc = this.isCompatibleWith(otherStr);
        if (enc == null) {
            return runtime.getNil();
        }
        if (this.singleByteOptimizable() && otherStr.singleByteOptimizable()) {
            return RubyFixnum.newFixnum(runtime, this.value.caseInsensitiveCmp(otherStr.value));
        }
        return this.multiByteCasecmp(runtime, enc, this.value, otherStr.value);
    }

    private IRubyObject multiByteCasecmp(Ruby runtime, Encoding enc, ByteList value2, ByteList otherValue) {
        int ocl;
        int cl;
        int op;
        byte[] bytes2 = value2.getUnsafeBytes();
        int p2 = value2.getBegin();
        int end2 = p2 + value2.getRealSize();
        byte[] obytes = otherValue.getUnsafeBytes();
        int oend = op + otherValue.getRealSize();
        for (op = otherValue.getBegin(); p2 < end2 && op < oend; p2 += cl, op += ocl) {
            int oc;
            int c;
            if (enc.isAsciiCompatible()) {
                c = bytes2[p2] & 0xFF;
                oc = obytes[op] & 0xFF;
            } else {
                c = StringSupport.preciseCodePoint(enc, bytes2, p2, end2);
                oc = StringSupport.preciseCodePoint(enc, obytes, op, oend);
            }
            if (Encoding.isAscii(c) && Encoding.isAscii(oc)) {
                byte uc = AsciiTables.ToUpperCaseTable[c];
                byte uoc = AsciiTables.ToUpperCaseTable[oc];
                if (uc != uoc) {
                    return uc < uoc ? RubyFixnum.minus_one(runtime) : RubyFixnum.one(runtime);
                }
                ocl = 1;
                cl = 1;
                continue;
            }
            cl = StringSupport.length(enc, bytes2, p2, end2);
            int ret = StringSupport.caseCmp(bytes2, p2, obytes, op, cl < (ocl = StringSupport.length(enc, obytes, op, oend)) ? cl : ocl);
            if (ret != 0) {
                return ret < 0 ? RubyFixnum.minus_one(runtime) : RubyFixnum.one(runtime);
            }
            if (cl == ocl) continue;
            return cl < ocl ? RubyFixnum.minus_one(runtime) : RubyFixnum.one(runtime);
        }
        if (end2 - p2 == oend - op) {
            return RubyFixnum.zero(runtime);
        }
        return end2 - p2 > oend - op ? RubyFixnum.one(runtime) : RubyFixnum.minus_one(runtime);
    }

    @Override
    @JRubyMethod(name={"=~"}, compat=CompatVersion.RUBY1_8, writes={FrameField.BACKREF})
    public IRubyObject op_match(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).op_match(context, this);
        }
        if (other instanceof RubyString) {
            throw context.runtime.newTypeError("type mismatch: String given");
        }
        return other.callMethod(context, "=~", this);
    }

    @Override
    @JRubyMethod(name={"=~"}, compat=CompatVersion.RUBY1_9, writes={FrameField.BACKREF})
    public IRubyObject op_match19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).op_match19(context, this);
        }
        if (other instanceof RubyString) {
            throw context.runtime.newTypeError("type mismatch: String given");
        }
        return other.callMethod(context, "=~", this);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8, reads={FrameField.BACKREF})
    public IRubyObject match(ThreadContext context, IRubyObject pattern) {
        return this.getPattern(pattern).callMethod(context, "match", (IRubyObject)this);
    }

    @JRubyMethod(name={"match"}, compat=CompatVersion.RUBY1_9, reads={FrameField.BACKREF})
    public IRubyObject match19(ThreadContext context, IRubyObject pattern, Block block) {
        IRubyObject result2 = this.getPattern(pattern).callMethod(context, "match", (IRubyObject)this);
        return block.isGiven() && !result2.isNil() ? block.yield(context, result2) : result2;
    }

    @JRubyMethod(name={"match"}, required=1, rest=true, compat=CompatVersion.RUBY1_9, reads={FrameField.BACKREF})
    public IRubyObject match19(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyRegexp pattern = this.getPattern(args2[0]);
        args2[0] = this;
        IRubyObject result2 = pattern.callMethod(context, "match", args2);
        return block.isGiven() && !result2.isNil() ? block.yield(context, result2) : result2;
    }

    @JRubyMethod(name={"capitalize"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject capitalize(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.capitalize_bang(context);
        return str;
    }

    @JRubyMethod(name={"capitalize!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject capitalize_bang(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modify();
        int s2 = this.value.getBegin();
        int end2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        boolean modify = false;
        int c = bytes2[s2] & 0xFF;
        if (ASCII.isLower(c)) {
            bytes2[s2] = AsciiTables.ToUpperCaseTable[c];
            modify = true;
        }
        while (++s2 < end2) {
            c = bytes2[s2] & 0xFF;
            if (!ASCII.isUpper(c)) continue;
            bytes2[s2] = AsciiTables.ToLowerCaseTable[c];
            modify = true;
        }
        return modify ? this : runtime.getNil();
    }

    @JRubyMethod(name={"capitalize"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject capitalize19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.capitalize_bang19(context);
        return str;
    }

    @JRubyMethod(name={"capitalize!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject capitalize_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s2 = this.value.getBegin();
        int end2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        boolean modify = false;
        int c = StringSupport.codePoint(runtime, enc, bytes2, s2, end2);
        if (enc.isLower(c)) {
            enc.codeToMbc(StringSupport.toUpper(enc, c), bytes2, s2);
            modify = true;
        }
        s2 += StringSupport.codeLength(runtime, enc, c);
        while (s2 < end2) {
            c = StringSupport.codePoint(runtime, enc, bytes2, s2, end2);
            if (enc.isUpper(c)) {
                enc.codeToMbc(StringSupport.toLower(enc, c), bytes2, s2);
                modify = true;
            }
            s2 += StringSupport.codeLength(runtime, enc, c);
        }
        return modify ? this : runtime.getNil();
    }

    @JRubyMethod(name={">="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.runtime.newBoolean(this.op_cmp((RubyString)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_ge19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.runtime.newBoolean(this.op_cmp19((RubyString)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.runtime.newBoolean(this.op_cmp((RubyString)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={">"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_gt19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.runtime.newBoolean(this.op_cmp19((RubyString)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.runtime.newBoolean(this.op_cmp((RubyString)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_le19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.runtime.newBoolean(this.op_cmp19((RubyString)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.runtime.newBoolean(this.op_cmp((RubyString)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    @JRubyMethod(name={"<"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_lt19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.runtime.newBoolean(this.op_cmp19((RubyString)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    @JRubyMethod(name={"eql?"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject str_eql_p(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (other instanceof RubyString && this.value.equal(((RubyString)other).value)) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(name={"eql?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject str_eql_p19(ThreadContext context, IRubyObject other) {
        RubyString otherString;
        Ruby runtime = context.runtime;
        if (other instanceof RubyString && this.isComparableWith(otherString = (RubyString)other) && this.value.equal(otherString.value)) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(name={"upcase"}, compat=CompatVersion.RUBY1_8)
    public RubyString upcase(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.upcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"upcase!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject upcase_bang(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modify();
        return this.singleByteUpcase(runtime, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"upcase"}, compat=CompatVersion.RUBY1_9)
    public RubyString upcase19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.upcase_bang19(context);
        return str;
    }

    @JRubyMethod(name={"upcase!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject upcase_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s2 = this.value.getBegin();
        int end2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (this.singleByteOptimizable(enc)) {
            return this.singleByteUpcase(runtime, bytes2, s2, end2);
        }
        return this.multiByteUpcase(runtime, enc, bytes2, s2, end2);
    }

    private IRubyObject singleByteUpcase(Ruby runtime, byte[] bytes2, int s2, int end2) {
        boolean modify = false;
        while (s2 < end2) {
            int c = bytes2[s2] & 0xFF;
            if (ASCII.isLower(c)) {
                bytes2[s2] = AsciiTables.ToUpperCaseTable[c];
                modify = true;
            }
            ++s2;
        }
        return modify ? this : runtime.getNil();
    }

    private IRubyObject multiByteUpcase(Ruby runtime, Encoding enc, byte[] bytes2, int s2, int end2) {
        boolean modify = false;
        while (s2 < end2) {
            int c;
            if (enc.isAsciiCompatible() && Encoding.isAscii(c = bytes2[s2] & 0xFF)) {
                if (ASCII.isLower(c)) {
                    bytes2[s2] = AsciiTables.ToUpperCaseTable[c];
                    modify = true;
                }
                ++s2;
                continue;
            }
            c = StringSupport.codePoint(runtime, enc, bytes2, s2, end2);
            if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper(enc, c), bytes2, s2);
                modify = true;
            }
            s2 += StringSupport.codeLength(runtime, enc, c);
        }
        return modify ? this : runtime.getNil();
    }

    @JRubyMethod(name={"downcase"}, compat=CompatVersion.RUBY1_8)
    public RubyString downcase(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.downcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"downcase!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject downcase_bang(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modify();
        return this.singleByteDowncase(runtime, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"downcase"}, compat=CompatVersion.RUBY1_9)
    public RubyString downcase19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.downcase_bang19(context);
        return str;
    }

    @JRubyMethod(name={"downcase!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject downcase_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s2 = this.value.getBegin();
        int end2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (this.singleByteOptimizable(enc)) {
            return this.singleByteDowncase(runtime, bytes2, s2, end2);
        }
        return this.multiByteDowncase(runtime, enc, bytes2, s2, end2);
    }

    private IRubyObject singleByteDowncase(Ruby runtime, byte[] bytes2, int s2, int end2) {
        boolean modify = false;
        while (s2 < end2) {
            int c = bytes2[s2] & 0xFF;
            if (ASCII.isUpper(c)) {
                bytes2[s2] = AsciiTables.ToLowerCaseTable[c];
                modify = true;
            }
            ++s2;
        }
        return modify ? this : runtime.getNil();
    }

    private IRubyObject multiByteDowncase(Ruby runtime, Encoding enc, byte[] bytes2, int s2, int end2) {
        boolean modify = false;
        while (s2 < end2) {
            int c;
            if (enc.isAsciiCompatible() && Encoding.isAscii(c = bytes2[s2] & 0xFF)) {
                if (ASCII.isUpper(c)) {
                    bytes2[s2] = AsciiTables.ToLowerCaseTable[c];
                    modify = true;
                }
                ++s2;
                continue;
            }
            c = StringSupport.codePoint(runtime, enc, bytes2, s2, end2);
            if (enc.isUpper(c)) {
                enc.codeToMbc(StringSupport.toLower(enc, c), bytes2, s2);
                modify = true;
            }
            s2 += StringSupport.codeLength(runtime, enc, c);
        }
        return modify ? this : runtime.getNil();
    }

    @JRubyMethod(name={"swapcase"}, compat=CompatVersion.RUBY1_8)
    public RubyString swapcase(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.swapcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"swapcase!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject swapcase_bang(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modify();
        return this.singleByteSwapcase(runtime, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"swapcase"}, compat=CompatVersion.RUBY1_9)
    public RubyString swapcase19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.swapcase_bang19(context);
        return str;
    }

    @JRubyMethod(name={"swapcase!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject swapcase_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s2 = this.value.getBegin();
        int end2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (this.singleByteOptimizable(enc)) {
            return this.singleByteSwapcase(runtime, bytes2, s2, end2);
        }
        return this.multiByteSwapcase(runtime, enc, bytes2, s2, end2);
    }

    private IRubyObject singleByteSwapcase(Ruby runtime, byte[] bytes2, int s2, int end2) {
        boolean modify = false;
        while (s2 < end2) {
            int c = bytes2[s2] & 0xFF;
            if (ASCII.isUpper(c)) {
                bytes2[s2] = AsciiTables.ToLowerCaseTable[c];
                modify = true;
            } else if (ASCII.isLower(c)) {
                bytes2[s2] = AsciiTables.ToUpperCaseTable[c];
                modify = true;
            }
            ++s2;
        }
        return modify ? this : runtime.getNil();
    }

    private IRubyObject multiByteSwapcase(Ruby runtime, Encoding enc, byte[] bytes2, int s2, int end2) {
        boolean modify = false;
        while (s2 < end2) {
            int c = StringSupport.codePoint(runtime, enc, bytes2, s2, end2);
            if (enc.isUpper(c)) {
                enc.codeToMbc(StringSupport.toLower(enc, c), bytes2, s2);
                modify = true;
            } else if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper(enc, c), bytes2, s2);
                modify = true;
            }
            s2 += StringSupport.codeLength(runtime, enc, c);
        }
        return modify ? this : runtime.getNil();
    }

    @JRubyMethod(name={"dump"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject dump() {
        return this.dumpCommon(false);
    }

    @JRubyMethod(name={"dump"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject dump19() {
        return this.dumpCommon(true);
    }

    private IRubyObject dumpCommon(boolean is1_9) {
        Ruby runtime = this.getRuntime();
        ByteList buf = null;
        Encoding enc = this.value.getEncoding();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int len = 2;
        block4: while (p2 < end2) {
            int n;
            int c = bytes2[p2++] & 0xFF;
            switch (c) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 27: 
                case 34: 
                case 92: {
                    len += 2;
                    continue block4;
                }
                case 35: {
                    len += this.isEVStr(bytes2, p2, end2) ? 2 : 1;
                    continue block4;
                }
            }
            if (ASCII.isPrint(c)) {
                ++len;
                continue;
            }
            if (is1_9 && enc instanceof UTF8Encoding && (n = StringSupport.preciseLength(enc, bytes2, p2 - 1, end2) - 1) > 0) {
                if (buf == null) {
                    buf = new ByteList();
                }
                int cc = StringSupport.codePoint(runtime, enc, bytes2, p2 - 1, end2);
                Sprintf.sprintf(runtime, buf, (CharSequence)"%x", cc);
                len += buf.getRealSize() + 4;
                buf.setRealSize(0);
                p2 += n;
                continue;
            }
            len += 4;
        }
        if (is1_9 && !enc.isAsciiCompatible()) {
            len += ".force_encoding(\"".length() + enc.getName().length + "\")".length();
        }
        ByteList outBytes = new ByteList(len);
        byte[] out = outBytes.getUnsafeBytes();
        int q = 0;
        p2 = this.value.getBegin();
        end2 = p2 + this.value.getRealSize();
        out[q++] = 34;
        while (p2 < end2) {
            int c;
            if ((c = bytes2[p2++] & 0xFF) == 34 || c == 92) {
                out[q++] = 92;
                out[q++] = (byte)c;
                continue;
            }
            if (c == 35) {
                if (this.isEVStr(bytes2, p2, end2)) {
                    out[q++] = 92;
                }
                out[q++] = 35;
                continue;
            }
            if (!is1_9 && ASCII.isPrint(c)) {
                out[q++] = (byte)c;
                continue;
            }
            if (c == 10) {
                out[q++] = 92;
                out[q++] = 110;
                continue;
            }
            if (c == 13) {
                out[q++] = 92;
                out[q++] = 114;
                continue;
            }
            if (c == 9) {
                out[q++] = 92;
                out[q++] = 116;
                continue;
            }
            if (c == 12) {
                out[q++] = 92;
                out[q++] = 102;
                continue;
            }
            if (c == 11) {
                out[q++] = 92;
                out[q++] = 118;
                continue;
            }
            if (c == 8) {
                out[q++] = 92;
                out[q++] = 98;
                continue;
            }
            if (c == 7) {
                out[q++] = 92;
                out[q++] = 97;
                continue;
            }
            if (c == 27) {
                out[q++] = 92;
                out[q++] = 101;
                continue;
            }
            if (is1_9 && ASCII.isPrint(c)) {
                out[q++] = (byte)c;
                continue;
            }
            out[q++] = 92;
            if (is1_9) {
                int n;
                if (enc instanceof UTF8Encoding && (n = StringSupport.preciseLength(enc, bytes2, p2 - 1, end2) - 1) > 0) {
                    int cc = StringSupport.codePoint(runtime, enc, bytes2, p2 - 1, end2);
                    p2 += n;
                    outBytes.setRealSize(q);
                    Sprintf.sprintf(runtime, outBytes, (CharSequence)"u{%x}", cc);
                    q = outBytes.getRealSize();
                    continue;
                }
                outBytes.setRealSize(q);
                Sprintf.sprintf(runtime, outBytes, (CharSequence)"x%02X", c);
                q = outBytes.getRealSize();
                continue;
            }
            outBytes.setRealSize(q);
            Sprintf.sprintf(runtime, outBytes, (CharSequence)"%03o", c);
            q = outBytes.getRealSize();
        }
        out[q++] = 34;
        outBytes.setRealSize(q);
        assert (out == outBytes.getUnsafeBytes());
        RubyString result2 = new RubyString(runtime, this.getMetaClass(), outBytes);
        if (is1_9) {
            if (!enc.isAsciiCompatible()) {
                result2.cat(".force_encoding(\"".getBytes());
                result2.cat(enc.getName());
                result2.cat((byte)34).cat((byte)41);
                enc = ASCII;
            }
            result2.associateEncoding(enc);
            result2.setCodeRange(32);
        }
        return result2.infectBy(this);
    }

    @JRubyMethod(name={"insert"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject insert(ThreadContext context, IRubyObject indexArg, IRubyObject stringArg) {
        assert (!context.runtime.is1_9());
        RubyString str = stringArg.convertToString();
        int index2 = RubyNumeric.num2int(indexArg);
        if (index2 == -1) {
            return this.append(stringArg);
        }
        if (index2 < 0) {
            ++index2;
        }
        this.replaceInternal(this.checkIndex(index2, this.value.getRealSize()), 0, str);
        return this;
    }

    @JRubyMethod(name={"insert"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject insert19(ThreadContext context, IRubyObject indexArg, IRubyObject stringArg) {
        RubyString str = stringArg.convertToString();
        int index2 = RubyNumeric.num2int(indexArg);
        if (index2 == -1) {
            return this.append19(stringArg);
        }
        if (index2 < 0) {
            ++index2;
        }
        this.replaceInternal19(this.checkIndex(index2, this.strLength()), 0, str);
        return this;
    }

    private int checkIndex(int beg, int len) {
        if (beg > len) {
            this.raiseIndexOutOfString(beg);
        }
        if (beg < 0) {
            if (-beg > len) {
                this.raiseIndexOutOfString(beg);
            }
            beg += len;
        }
        return beg;
    }

    private int checkIndexForRef(int beg, int len) {
        if (beg >= len) {
            this.raiseIndexOutOfString(beg);
        }
        if (beg < 0) {
            if (-beg > len) {
                this.raiseIndexOutOfString(beg);
            }
            beg += len;
        }
        return beg;
    }

    private int checkLength(int len) {
        if (len < 0) {
            throw this.getRuntime().newIndexError("negative length " + len);
        }
        return len;
    }

    private void raiseIndexOutOfString(int index2) {
        throw this.getRuntime().newIndexError("index " + index2 + " out of string");
    }

    private void prefixEscapeCat(int c) {
        this.cat(92);
        this.cat(c);
    }

    private boolean isEVStr(byte[] bytes2, int p2, int end2) {
        return p2 < end2 ? this.isEVStr(bytes2[p2] & 0xFF) : false;
    }

    public boolean isEVStr(int c) {
        return c == 36 || c == 64 || c == 123;
    }

    @Override
    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject inspect() {
        Ruby runtime = this.getRuntime();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        RubyString result2 = new RubyString(runtime, runtime.getString(), new ByteList(end2 - p2));
        Encoding enc = runtime.getKCode().getEncoding();
        result2.cat(34);
        while (p2 < end2) {
            int c;
            int n;
            if ((n = enc.length((byte)(c = bytes2[p2++] & 0xFF))) > 1 && p2 - 1 <= end2 - n) {
                result2.cat(bytes2, p2 - 1, n);
                p2 += n - 1;
                continue;
            }
            if (c == 34 || c == 92 || c == 35 && this.isEVStr(bytes2, p2, end2)) {
                result2.prefixEscapeCat(c);
                continue;
            }
            if (ASCII.isPrint(c)) {
                result2.cat(c);
                continue;
            }
            if (c == 10) {
                result2.prefixEscapeCat(110);
                continue;
            }
            if (c == 13) {
                result2.prefixEscapeCat(114);
                continue;
            }
            if (c == 9) {
                result2.prefixEscapeCat(116);
                continue;
            }
            if (c == 12) {
                result2.prefixEscapeCat(102);
                continue;
            }
            if (c == 11) {
                result2.prefixEscapeCat(118);
                continue;
            }
            if (c == 8) {
                result2.prefixEscapeCat(98);
                continue;
            }
            if (c == 7) {
                result2.prefixEscapeCat(97);
                continue;
            }
            if (c == 27) {
                result2.prefixEscapeCat(101);
                continue;
            }
            Sprintf.sprintf(runtime, result2.value, (CharSequence)"\\%03o", c & 0xFF);
        }
        result2.cat(34);
        return result2.infectBy(this);
    }

    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject inspect19() {
        int c1;
        int c0;
        Ruby runtime = this.getRuntime();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        RubyString result2 = new RubyString(runtime, runtime.getString(), new ByteList(end2 - p2));
        Encoding enc = this.getEncoding();
        Encoding resultEnc = runtime.getDefaultInternalEncoding();
        if (resultEnc == null) {
            resultEnc = runtime.getDefaultExternalEncoding();
        }
        if (!resultEnc.isAsciiCompatible()) {
            resultEnc = USASCIIEncoding.INSTANCE;
        }
        result2.associateEncoding(resultEnc);
        boolean isUnicode = StringSupport.isUnicode(enc);
        EncodingDB.Entry e = null;
        CaseInsensitiveBytesHash<EncodingDB.Entry> encodings = runtime.getEncodingService().getEncodings();
        if (enc == encodings.get("UTF-16".getBytes()).getEncoding() && end2 - p2 > 1) {
            c0 = bytes2[p2] & 0xFF;
            c1 = bytes2[p2 + 1] & 0xFF;
            if (c0 == 254 && c1 == 255) {
                e = encodings.get("UTF-16BE".getBytes());
            } else if (c0 == 255 && c1 == 254) {
                e = encodings.get("UTF-16LE".getBytes());
            } else {
                isUnicode = false;
            }
        } else if (enc == encodings.get("UTF-32".getBytes()).getEncoding() && end2 - p2 > 3) {
            c0 = bytes2[p2] & 0xFF;
            c1 = bytes2[p2 + 1] & 0xFF;
            int c2 = bytes2[p2 + 2] & 0xFF;
            int c3 = bytes2[p2 + 3] & 0xFF;
            if (c0 == 0 && c1 == 0 && c2 == 254 && c3 == 255) {
                e = encodings.get("UTF-32BE".getBytes());
            } else if (c3 == 0 && c2 == 0 && c1 == 254 && c0 == 255) {
                e = encodings.get("UTF-32LE".getBytes());
            } else {
                isUnicode = false;
            }
        }
        if (e != null) {
            enc = e.getEncoding();
        }
        result2.cat(34);
        int prev = p2;
        while (p2 < end2) {
            int cc = 0;
            int n = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (n <= 0) {
                if (p2 > prev) {
                    result2.cat(bytes2, prev, p2 - prev);
                }
                if (end2 < p2 + (n = enc.minLength())) {
                    n = end2 - p2;
                }
                while (n-- > 0) {
                    Sprintf.sprintf(runtime, result2.getByteList(), (CharSequence)"\\x%02X", bytes2[p2] & 0xFF);
                    prev = ++p2;
                }
                continue;
            }
            int c = enc.mbcToCode(bytes2, p2, end2);
            if ((enc.isAsciiCompatible() || isUnicode) && (c == 34 || c == 92 || c == 35 && (p2 += n) < end2 && StringSupport.preciseLength(enc, bytes2, p2, end2) > 0 && (cc = StringSupport.codePoint(runtime, enc, bytes2, p2, end2)) == 36 || cc == 64 || cc == 123)) {
                if (p2 - n > prev) {
                    result2.cat(bytes2, prev, p2 - n - prev);
                }
                result2.cat(92);
                if (enc.isAsciiCompatible() || enc == resultEnc) {
                    prev = p2 - n;
                    continue;
                }
            }
            switch (c) {
                case 10: {
                    cc = 110;
                    break;
                }
                case 13: {
                    cc = 114;
                    break;
                }
                case 9: {
                    cc = 116;
                    break;
                }
                case 12: {
                    cc = 102;
                    break;
                }
                case 11: {
                    cc = 118;
                    break;
                }
                case 8: {
                    cc = 98;
                    break;
                }
                case 7: {
                    cc = 97;
                    break;
                }
                case 27: {
                    cc = 101;
                    break;
                }
                default: {
                    cc = 0;
                }
            }
            if (cc != 0) {
                if (p2 - n > prev) {
                    result2.cat(bytes2, prev, p2 - n - prev);
                }
                result2.cat(92);
                result2.cat(cc);
                prev = p2;
                continue;
            }
            if (enc == resultEnc && enc.isPrint(c) || enc.isAsciiCompatible() && Encoding.isAscii(c) && enc.isPrint(c)) continue;
            if (p2 - n > prev) {
                result2.cat(bytes2, prev, p2 - n - prev);
            }
            Sprintf.sprintf(runtime, result2.getByteList(), (CharSequence)StringSupport.escapedCharFormat(c, isUnicode), c);
            prev = p2;
        }
        if (p2 > prev) {
            result2.cat(bytes2, prev, p2 - prev);
        }
        result2.cat(34);
        return result2.infectBy(this);
    }

    public int size() {
        return this.value.getRealSize();
    }

    @JRubyMethod(name={"length", "size"}, compat=CompatVersion.RUBY1_8)
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.value.getRealSize());
    }

    @JRubyMethod(name={"length", "size"}, compat=CompatVersion.RUBY1_9)
    public RubyFixnum length19() {
        return this.getRuntime().newFixnum(this.strLength());
    }

    @JRubyMethod(name={"bytesize"})
    public RubyFixnum bytesize() {
        return this.length();
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return this.isEmpty() ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public RubyString append(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            this.cat(ConvertBytes.longToByteList(((RubyFixnum)other).getLongValue()));
            return this;
        }
        if (other instanceof RubyFloat) {
            return this.cat((RubyString)((RubyFloat)other).to_s());
        }
        if (other instanceof RubySymbol) {
            this.cat(((RubySymbol)other).getBytes());
            return this;
        }
        RubyString otherStr = other.convertToString();
        this.infectBy(otherStr);
        return this.cat(otherStr.value);
    }

    public RubyString append19(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            this.cat19(ConvertBytes.longToByteList(((RubyFixnum)other).getLongValue()), 32);
            return this;
        }
        if (other instanceof RubyFloat) {
            return this.cat19((RubyString)((RubyFloat)other).to_s());
        }
        if (other instanceof RubySymbol) {
            this.cat19(((RubySymbol)other).getBytes(), 0);
            return this;
        }
        return this.cat19(other.convertToString());
    }

    @JRubyMethod(name={"concat", "<<"}, compat=CompatVersion.RUBY1_8)
    public RubyString concat(IRubyObject other) {
        long longValue;
        if (other instanceof RubyFixnum && (longValue = ((RubyFixnum)other).getLongValue()) >= 0L && longValue < 256L) {
            return this.cat((byte)longValue);
        }
        return this.append(other);
    }

    @JRubyMethod(name={"concat", "<<"}, compat=CompatVersion.RUBY1_9)
    public RubyString concat19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (other instanceof RubyFixnum) {
            int c = RubyNumeric.num2int(other);
            if (c < 0) {
                throw runtime.newRangeError("negative string size (or size too big)");
            }
            return this.concatNumeric(runtime, c);
        }
        if (other instanceof RubyBignum) {
            if (((RubyBignum)other).getBigIntegerValue().signum() < 0) {
                throw runtime.newRangeError("negative string size (or size too big)");
            }
            long c = ((RubyBignum)other).getLongValue();
            return this.concatNumeric(runtime, (int)c);
        }
        return this.append19(other);
    }

    private RubyString concatNumeric(Ruby runtime, int c) {
        int cl;
        Encoding enc = this.value.getEncoding();
        try {
            cl = StringSupport.codeLength(runtime, enc, c);
            this.modify19(this.value.getRealSize() + cl);
            if (enc == USASCIIEncoding.INSTANCE) {
                if (c > 255) {
                    runtime.newRangeError(c + " out of char range");
                }
                if (c > 121) {
                    this.value.setEncoding(ASCIIEncoding.INSTANCE);
                    enc = this.value.getEncoding();
                }
            }
            enc.codeToMbc(c, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize());
        }
        catch (EncodingException e) {
            throw runtime.newRangeError(c + " out of char range");
        }
        this.value.setRealSize(this.value.getRealSize() + cl);
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject prepend(ThreadContext context, IRubyObject other) {
        return this.replace19(other.convertToString().op_plus19(context, this));
    }

    @JRubyMethod(name={"crypt"})
    public RubyString crypt(ThreadContext context, IRubyObject other) {
        RubyString otherStr = other.convertToString();
        ByteList salt = otherStr.getByteList();
        if (salt.getRealSize() < 2) {
            throw context.runtime.newArgumentError("salt too short(need >=2 bytes)");
        }
        salt = salt.makeShared(0, 2);
        RubyString result2 = RubyString.newStringShared(context.runtime, JavaCrypt.crypt(salt, this.getByteList()));
        result2.infectBy(this);
        result2.infectBy(otherStr);
        return result2;
    }

    public static RubyString stringValue(IRubyObject object) {
        return (RubyString)(object instanceof RubyString ? object : object.convertToString());
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, Block block) {
        RubyString str = this.strDup(context.runtime);
        str.sub_bang(context, arg0, block);
        return str;
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = this.strDup(context.runtime);
        str.sub_bang(context, arg0, arg1, block);
        return str;
    }

    @JRubyMethod(name={"sub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        if (block.isGiven()) {
            return this.subBangIter(context, this.getQuotedPattern(arg0), block);
        }
        throw context.runtime.newArgumentError(1, 2);
    }

    @JRubyMethod(name={"sub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.subBangNoIter(context, this.getQuotedPattern(arg0), arg1.convertToString());
    }

    private IRubyObject subBangIter(ThreadContext context, Regex pattern, Block block) {
        int range = this.value.getBegin() + this.value.getRealSize();
        Matcher matcher = pattern.matcher(this.value.getUnsafeBytes(), this.value.getBegin(), range);
        if (RubyRegexp.matcherSearch(context.runtime, matcher, this.value.getBegin(), range, 0) >= 0) {
            this.frozenCheck(true);
            byte[] bytes2 = this.value.getUnsafeBytes();
            int size2 = this.value.getRealSize();
            RubyMatchData match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
            context.setBackRef(match2);
            RubyString repl = RubyString.objAsString(context, block.yield(context, this.makeShared(context.runtime, matcher.getBegin(), matcher.getEnd() - matcher.getBegin())));
            this.modifyCheck(bytes2, size2);
            this.frozenCheck(true);
            context.setBackRef(match2);
            return this.subBangCommon(context, pattern, matcher, repl, repl.flags);
        }
        return context.setBackRef(context.runtime.getNil());
    }

    private IRubyObject subBangNoIter(ThreadContext context, Regex pattern, RubyString repl) {
        int tuFlags = repl.flags;
        int range = this.value.getBegin() + this.value.getRealSize();
        Matcher matcher = pattern.matcher(this.value.getUnsafeBytes(), this.value.getBegin(), range);
        if (RubyRegexp.matcherSearch(context.runtime, matcher, this.value.getBegin(), range, 0) >= 0) {
            repl = RubyRegexp.regsub(repl, this, matcher, context.runtime.getKCode().getEncoding());
            RubyMatchData match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
            context.setBackRef(match2);
            return this.subBangCommon(context, pattern, matcher, repl, tuFlags);
        }
        return context.setBackRef(context.runtime.getNil());
    }

    private IRubyObject subBangCommon(ThreadContext context, Regex pattern, Matcher matcher, RubyString repl, int tuFlags) {
        int beg = matcher.getBegin();
        int plen = matcher.getEnd() - beg;
        ByteList replValue = repl.value;
        if (replValue.getRealSize() > plen) {
            this.modify(this.value.getRealSize() + replValue.getRealSize() - plen);
        } else {
            this.modify();
        }
        if (replValue.getRealSize() != plen) {
            int src = this.value.getBegin() + beg + plen;
            int dst = this.value.getBegin() + beg + replValue.getRealSize();
            int length2 = this.value.getRealSize() - beg - plen;
            System.arraycopy(this.value.getUnsafeBytes(), src, this.value.getUnsafeBytes(), dst, length2);
        }
        System.arraycopy(replValue.getUnsafeBytes(), replValue.getBegin(), this.value.getUnsafeBytes(), this.value.getBegin() + beg, replValue.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + replValue.getRealSize() - plen);
        this.infectBy(tuFlags);
        return this;
    }

    @JRubyMethod(name={"sub"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub19(ThreadContext context, IRubyObject arg0, Block block) {
        RubyString str = this.strDup(context.runtime);
        str.sub_bang19(context, arg0, block);
        return str;
    }

    @JRubyMethod(name={"sub"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = this.strDup(context.runtime);
        str.sub_bang19(context, arg0, arg1, block);
        return str;
    }

    @JRubyMethod(name={"sub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub_bang19(ThreadContext context, IRubyObject arg0, Block block) {
        Regex prepared;
        Regex pattern;
        RubyRegexp regexp2;
        Ruby runtime = context.runtime;
        this.frozenCheck();
        if (arg0 instanceof RubyRegexp) {
            regexp2 = (RubyRegexp)arg0;
            pattern = regexp2.getPattern();
            prepared = regexp2.preparePattern(this);
        } else {
            regexp2 = null;
            pattern = this.getStringPattern19(runtime, arg0);
            prepared = RubyRegexp.preparePattern(runtime, pattern, this);
        }
        if (block.isGiven()) {
            return this.subBangIter19(runtime, context, pattern, prepared, null, block, regexp2);
        }
        throw context.runtime.newArgumentError(1, 2);
    }

    @JRubyMethod(name={"sub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub_bang19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        Regex prepared;
        Regex pattern;
        RubyRegexp regexp2;
        Ruby runtime = context.runtime;
        IRubyObject hash2 = TypeConverter.convertToTypeWithCheck(arg1, runtime.getHash(), "to_hash");
        this.frozenCheck();
        if (arg0 instanceof RubyRegexp) {
            regexp2 = (RubyRegexp)arg0;
            pattern = regexp2.getPattern();
            prepared = regexp2.preparePattern(this);
        } else {
            regexp2 = null;
            pattern = this.getStringPattern19(runtime, arg0);
            prepared = RubyRegexp.preparePattern(runtime, pattern, this);
        }
        if (hash2.isNil()) {
            return this.subBangNoIter19(runtime, context, pattern, prepared, arg1.convertToString(), regexp2);
        }
        return this.subBangIter19(runtime, context, pattern, prepared, (RubyHash)hash2, block, regexp2);
    }

    private IRubyObject subBangIter19(Ruby runtime, ThreadContext context, Regex pattern, Regex prepared, RubyHash hash2, Block block, RubyRegexp regexp2) {
        int begin2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int range = begin2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        if (RubyRegexp.matcherSearch(runtime, matcher, begin2, range, 0) >= 0) {
            RubyString repl;
            int tuFlags;
            RubyMatchData match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
            match2.regexp = regexp2;
            context.setBackRef(match2);
            RubyString subStr = this.makeShared19(runtime, matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
            if (hash2 == null) {
                tuFlags = 0;
                repl = RubyString.objAsString(context, block.yield(context, subStr));
            } else {
                tuFlags = hash2.flags;
                repl = RubyString.objAsString(context, hash2.op_aref(context, subStr));
            }
            this.modifyCheck(bytes2, len, enc);
            this.frozenCheck();
            return this.subBangCommon19(context, pattern, matcher, repl, tuFlags | repl.flags);
        }
        return context.setBackRef(runtime.getNil());
    }

    private IRubyObject subBangNoIter19(Ruby runtime, ThreadContext context, Regex pattern, Regex prepared, RubyString repl, RubyRegexp regexp2) {
        int begin2 = this.value.getBegin();
        int range = begin2 + this.value.getRealSize();
        Matcher matcher = prepared.matcher(this.value.getUnsafeBytes(), begin2, range);
        if (RubyRegexp.matcherSearch(runtime, matcher, begin2, range, 0) >= 0) {
            repl = RubyRegexp.regsub19(repl, this, matcher, pattern);
            RubyMatchData match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
            match2.regexp = regexp2;
            context.setBackRef(match2);
            return this.subBangCommon19(context, pattern, matcher, repl, repl.flags);
        }
        return context.setBackRef(runtime.getNil());
    }

    private IRubyObject subBangCommon19(ThreadContext context, Regex pattern, Matcher matcher, RubyString repl, int tuFlags) {
        int beg = matcher.getBegin();
        int end2 = matcher.getEnd();
        int cr = this.getCodeRange();
        Encoding enc = this.isCompatibleWith(repl);
        if (enc == null) {
            enc = this.subBangVerifyEncoding(context, repl, beg, end2);
        }
        int plen = end2 - beg;
        ByteList replValue = repl.value;
        if (replValue.getRealSize() > plen) {
            this.modify19(this.value.getRealSize() + replValue.getRealSize() - plen);
        } else {
            this.modify19();
        }
        this.associateEncoding(enc);
        if (cr > 0 && cr < 96) {
            int cr2 = repl.getCodeRange();
            cr = cr2 == 96 || cr == 64 && cr2 == 32 ? 0 : cr2;
        }
        if (replValue.getRealSize() != plen) {
            int src = this.value.getBegin() + beg + plen;
            int dst = this.value.getBegin() + beg + replValue.getRealSize();
            int length2 = this.value.getRealSize() - beg - plen;
            System.arraycopy(this.value.getUnsafeBytes(), src, this.value.getUnsafeBytes(), dst, length2);
        }
        System.arraycopy(replValue.getUnsafeBytes(), replValue.getBegin(), this.value.getUnsafeBytes(), this.value.getBegin() + beg, replValue.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + replValue.getRealSize() - plen);
        this.setCodeRange(cr);
        return this.infectBy(tuFlags);
    }

    private Encoding subBangVerifyEncoding(ThreadContext context, RubyString repl, int beg, int end2) {
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        Encoding strEnc = this.value.getEncoding();
        if (StringSupport.codeRangeScan(strEnc, bytes2, p2, beg) != 32 || StringSupport.codeRangeScan(strEnc, bytes2, p2 + end2, len - end2) != 32) {
            throw context.runtime.newArgumentError("incompatible character encodings " + strEnc + " and " + repl.value.getEncoding());
        }
        return repl.value.getEncoding();
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, Block block) {
        return this.gsub(context, arg0, block, false);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub(context, arg0, arg1, block, false);
    }

    @JRubyMethod(name={"gsub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        return this.gsub(context, arg0, block, true);
    }

    @JRubyMethod(name={"gsub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub(context, arg0, arg1, block, true);
    }

    private IRubyObject gsub(ThreadContext context, IRubyObject arg0, Block block, boolean bang) {
        if (block.isGiven()) {
            return this.gsubCommon(context, bang, arg0, block, null, 0);
        }
        return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, bang ? "gsub!" : "gsub", arg0);
    }

    private IRubyObject gsub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block, boolean bang) {
        RubyString repl = arg1.convertToString();
        return this.gsubCommon(context, bang, arg0, block, repl, repl.flags);
    }

    private IRubyObject gsubCommon(ThreadContext context, boolean bang, IRubyObject arg2, Block block, RubyString repl, int tuFlags) {
        Ruby runtime = context.runtime;
        Regex pattern = this.getQuotedPattern(arg2);
        int begin2 = this.value.getBegin();
        int slen = this.value.getRealSize();
        int range = begin2 + slen;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Matcher matcher = pattern.matcher(bytes2, begin2, range);
        int beg = RubyRegexp.matcherSearch(runtime, matcher, begin2, range, 0);
        if (beg < 0) {
            context.setBackRef(runtime.getNil());
            return bang ? runtime.getNil() : this.strDup(runtime);
        }
        if (repl == null && bang && this.isFrozen()) {
            throw this.getRuntime().newRuntimeError("can't modify frozen string");
        }
        int blen = slen + 30;
        ByteList dest = new ByteList(blen);
        dest.setRealSize(blen);
        int offset2 = 0;
        int buf = 0;
        int bp = 0;
        int cp = begin2;
        Encoding enc = this.getEncodingForKCodeDefault(runtime, pattern, arg2);
        RubyMatchData match2 = null;
        while (beg >= 0) {
            RubyString val;
            int begz = matcher.getBegin();
            int endz = matcher.getEnd();
            if (repl == null) {
                match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
                context.setBackRef(match2);
                val = RubyString.objAsString(context, block.yield(context, this.substr(runtime, begz, endz - begz)));
                this.modifyCheck(bytes2, slen);
                if (bang) {
                    this.frozenCheck();
                }
            } else {
                val = RubyRegexp.regsub(repl, this, matcher, enc);
            }
            tuFlags |= val.flags;
            ByteList vbuf = val.value;
            int len = bp - buf + (beg - offset2) + vbuf.getRealSize() + 3;
            if (blen < len) {
                while (blen < len) {
                    blen <<= 1;
                }
                len = bp - buf;
                dest.realloc(blen);
                dest.setRealSize(blen);
                bp = buf + len;
            }
            len = beg - offset2;
            System.arraycopy(bytes2, cp, dest.getUnsafeBytes(), bp, len);
            System.arraycopy(vbuf.getUnsafeBytes(), vbuf.getBegin(), dest.getUnsafeBytes(), bp += len, vbuf.getRealSize());
            bp += vbuf.getRealSize();
            offset2 = endz;
            if (begz == endz) {
                if (slen <= endz) break;
                len = enc.length(bytes2, begin2 + endz, range);
                System.arraycopy(bytes2, begin2 + endz, dest.getUnsafeBytes(), bp, len);
                bp += len;
                offset2 = endz + len;
            }
            cp = begin2 + offset2;
            if (offset2 > slen) break;
            beg = RubyRegexp.matcherSearch(runtime, matcher, cp, range, 0);
        }
        if (repl == null) {
            context.setBackRef(match2);
        } else {
            match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
            context.setBackRef(match2);
        }
        if (slen > offset2) {
            int len = bp - buf;
            if (blen - len < slen - offset2) {
                blen = len + slen - offset2;
                dest.realloc(blen);
                bp = buf + len;
            }
            System.arraycopy(bytes2, cp, dest.getUnsafeBytes(), bp, slen - offset2);
            bp += slen - offset2;
        }
        dest.setRealSize(bp - buf);
        if (bang) {
            this.view(dest);
            return this.infectBy(tuFlags);
        }
        return new RubyString(runtime, this.getMetaClass(), dest).infectBy(tuFlags | this.flags);
    }

    @JRubyMethod(name={"gsub"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gsub19(ThreadContext context, IRubyObject arg0, Block block) {
        return block.isGiven() ? this.gsubCommon19(context, block, null, null, arg0, false, 0) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "gsub", arg0);
    }

    @JRubyMethod(name={"gsub"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gsub19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub19(context, arg0, arg1, block, false);
    }

    @JRubyMethod(name={"gsub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gsub_bang19(ThreadContext context, IRubyObject arg0, Block block) {
        this.checkFrozen();
        return block.isGiven() ? this.gsubCommon19(context, block, null, null, arg0, true, 0) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "gsub!", arg0);
    }

    @JRubyMethod(name={"gsub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gsub_bang19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        this.checkFrozen();
        return this.gsub19(context, arg0, arg1, block, true);
    }

    private IRubyObject gsub19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block, boolean bang) {
        int tuFlags;
        RubyString str;
        RubyHash hash2;
        Ruby runtime = context.runtime;
        IRubyObject tryHash = TypeConverter.convertToTypeWithCheck(arg1, runtime.getHash(), "to_hash");
        if (tryHash.isNil()) {
            hash2 = null;
            str = arg1.convertToString();
            tuFlags = str.flags;
        } else {
            hash2 = (RubyHash)tryHash;
            str = null;
            tuFlags = hash2.flags & 8;
        }
        return this.gsubCommon19(context, block, str, hash2, arg0, bang, tuFlags);
    }

    private IRubyObject gsubCommon19(ThreadContext context, Block block, RubyString repl, RubyHash hash2, IRubyObject arg0, boolean bang, int tuFlags) {
        return this.gsubCommon19(context, block, repl, hash2, arg0, bang, tuFlags, true);
    }

    private IRubyObject gsubCommon19(ThreadContext context, Block block, RubyString repl, RubyHash hash2, IRubyObject arg0, boolean bang, int tuFlags, boolean useBackref) {
        Regex prepared;
        Regex pattern;
        RubyRegexp regexp2;
        Ruby runtime = context.runtime;
        if (arg0 instanceof RubyRegexp) {
            regexp2 = (RubyRegexp)arg0;
            pattern = regexp2.getPattern();
            prepared = regexp2.preparePattern(this);
        } else {
            regexp2 = null;
            pattern = this.getStringPattern19(runtime, arg0);
            prepared = RubyRegexp.preparePattern(runtime, pattern, this);
        }
        int begin2 = this.value.getBegin();
        int slen = this.value.getRealSize();
        int range = begin2 + slen;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        int beg = RubyRegexp.matcherSearch(runtime, matcher, begin2, range, 0);
        if (beg < 0) {
            if (useBackref) {
                context.setBackRef(runtime.getNil());
            }
            return bang ? runtime.getNil() : this.strDup(runtime);
        }
        RubyString dest = new RubyString(runtime, this.getMetaClass(), new ByteList(slen + 30));
        int offset2 = 0;
        int cp = begin2;
        Encoding enc = this.value.getEncoding();
        dest.setEncoding(enc);
        dest.setCodeRange(enc.isAsciiCompatible() ? 32 : 64);
        RubyMatchData match2 = null;
        do {
            RubyString val;
            int begz = matcher.getBegin();
            int endz = matcher.getEnd();
            if (repl != null) {
                val = RubyRegexp.regsub19(repl, this, matcher, pattern);
            } else {
                RubyString substr = this.makeShared19(runtime, begz, endz - begz);
                if (hash2 != null) {
                    val = RubyString.objAsString(context, hash2.op_aref(context, substr));
                } else {
                    match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
                    match2.regexp = regexp2;
                    context.setBackRef(match2);
                    val = RubyString.objAsString(context, block.yield(context, substr));
                }
                this.modifyCheck(bytes2, slen, enc);
                if (bang) {
                    this.frozenCheck();
                }
            }
            tuFlags |= val.flags;
            int len = beg - offset2;
            if (len != 0) {
                dest.cat(bytes2, cp, len, enc);
            }
            dest.cat19(val);
            offset2 = endz;
            if (begz == endz) {
                if (slen <= endz) break;
                len = StringSupport.length(enc, bytes2, begin2 + endz, range);
                dest.cat(bytes2, begin2 + endz, len, enc);
                offset2 = endz + len;
            }
            cp = begin2 + offset2;
        } while (offset2 <= slen && (beg = RubyRegexp.matcherSearch(runtime, matcher, cp, range, 0)) >= 0);
        if (slen > offset2) {
            dest.cat(bytes2, cp, slen - offset2, enc);
        }
        if (match2 != null) {
            if (useBackref) {
                context.setBackRef(match2);
            }
        } else {
            match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
            match2.regexp = regexp2;
            context.setBackRef(match2);
        }
        if (bang) {
            this.view(dest.value);
            this.setCodeRange(dest.getCodeRange());
            return this.infectBy(tuFlags);
        }
        return dest.infectBy(tuFlags | this.flags);
    }

    @JRubyMethod(name={"index"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject index(ThreadContext context, IRubyObject arg0) {
        return this.indexCommon(context.runtime, context, arg0, 0);
    }

    @JRubyMethod(name={"index"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject index(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        Ruby runtime = context.runtime;
        if (pos2 < 0 && (pos2 += this.value.getRealSize()) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.setBackRef(runtime.getNil());
            }
            return runtime.getNil();
        }
        return this.indexCommon(runtime, context, arg0, pos2);
    }

    private IRubyObject indexCommon(Ruby runtime, ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub3;
            pos2 = regSub.adjustStartPos(this, pos2, false);
            IRubyObject[] holder = new IRubyObject[]{context.nil};
            pos2 = regSub.search(context, this, pos2, false, holder);
            context.setBackRef(holder[0]);
        } else {
            if (sub3 instanceof RubyFixnum) {
                int c_int = RubyNumeric.fix2int((RubyFixnum)sub3);
                if (c_int < 0 || c_int > 255) {
                    return runtime.getNil();
                }
                byte c = (byte)c_int;
                byte[] bytes2 = this.value.getUnsafeBytes();
                int end2 = this.value.getBegin() + this.value.getRealSize();
                pos2 += this.value.getBegin();
                while (pos2 < end2) {
                    if (bytes2[pos2] == c) {
                        return RubyFixnum.newFixnum(runtime, pos2 - this.value.getBegin());
                    }
                    ++pos2;
                }
                return runtime.getNil();
            }
            if (sub3 instanceof RubyString) {
                pos2 = this.strIndex((RubyString)sub3, pos2);
            } else {
                IRubyObject tmp = sub3.checkStringType();
                if (tmp.isNil()) {
                    throw runtime.newTypeError("type mismatch: " + sub3.getMetaClass().getName() + " given");
                }
                pos2 = this.strIndex((RubyString)tmp, pos2);
            }
        }
        return pos2 == -1 ? runtime.getNil() : RubyFixnum.newFixnum(runtime, pos2);
    }

    private int strIndex(RubyString sub3, int offset2) {
        ByteList byteList = this.value;
        if (offset2 < 0 && (offset2 += byteList.getRealSize()) < 0) {
            return -1;
        }
        ByteList other = sub3.value;
        if (RubyString.sizeIsSmaller(byteList, offset2, other)) {
            return -1;
        }
        if (other.getRealSize() == 0) {
            return offset2;
        }
        return byteList.indexOf(other, offset2);
    }

    private static boolean sizeIsSmaller(ByteList byteList, int offset2, ByteList other) {
        return byteList.getRealSize() - offset2 < other.getRealSize();
    }

    @JRubyMethod(name={"index"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject index19(ThreadContext context, IRubyObject arg0) {
        return this.indexCommon19(context.runtime, context, arg0, 0);
    }

    @JRubyMethod(name={"index"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject index19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        Ruby runtime = context.runtime;
        if (pos2 < 0 && (pos2 += this.strLength()) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.setBackRef(runtime.getNil());
            }
            return runtime.getNil();
        }
        return this.indexCommon19(runtime, context, arg0, pos2);
    }

    private IRubyObject indexCommon19(Ruby runtime, ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            if (pos2 > this.strLength()) {
                return context.nil;
            }
            RubyRegexp regSub = (RubyRegexp)sub3;
            pos2 = this.singleByteOptimizable() ? pos2 : StringSupport.nth(this.checkEncoding(regSub), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize(), pos2) - this.value.getBegin();
            pos2 = regSub.adjustStartPos19(this, pos2, false);
            IRubyObject[] holder = new IRubyObject[]{context.nil};
            pos2 = regSub.search19(context, this, pos2, false, holder);
            context.setBackRef(holder[0]);
            pos2 = this.subLength(pos2);
        } else if (sub3 instanceof RubyString) {
            pos2 = this.strIndex19((RubyString)sub3, pos2);
            pos2 = this.subLength(pos2);
        } else {
            IRubyObject tmp = sub3.checkStringType();
            if (tmp.isNil()) {
                throw runtime.newTypeError("type mismatch: " + sub3.getMetaClass().getName() + " given");
            }
            pos2 = this.strIndex19((RubyString)tmp, pos2);
            pos2 = this.subLength(pos2);
        }
        return pos2 == -1 ? runtime.getNil() : RubyFixnum.newFixnum(runtime, pos2);
    }

    private int strIndex19(RubyString sub3, int offset2) {
        Encoding enc = this.checkEncoding(sub3);
        if (sub3.scanForCodeRange() == 96) {
            return -1;
        }
        int len = this.strLength(enc);
        int slen = sub3.strLength(enc);
        if (offset2 < 0 && (offset2 += len) < 0) {
            return -1;
        }
        if (len - offset2 < slen) {
            return -1;
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        if (offset2 != 0) {
            offset2 = this.singleByteOptimizable() ? offset2 : StringSupport.offset(enc, bytes2, p2, end2, offset2);
            p2 += offset2;
        }
        if (slen == 0) {
            return offset2;
        }
        int pos2;
        while ((pos2 = this.value.indexOf(sub3.value, p2 - this.value.getBegin())) >= 0) {
            int t = enc.rightAdjustCharHead(bytes2, p2, p2 + (pos2 -= p2 - this.value.getBegin()), end2);
            if (t == p2 + pos2) {
                return pos2 + offset2;
            }
            if ((len -= t - p2) <= 0) {
                return -1;
            }
            offset2 += t - p2;
            p2 = t;
        }
        return pos2;
    }

    @JRubyMethod(name={"rindex"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rindex(ThreadContext context, IRubyObject arg0) {
        return this.rindexCommon(context.runtime, context, arg0, this.value.getRealSize());
    }

    @JRubyMethod(name={"rindex"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rindex(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        Ruby runtime = context.runtime;
        if (pos2 < 0 && (pos2 += this.value.getRealSize()) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.setBackRef(runtime.getNil());
            }
            return runtime.getNil();
        }
        if (pos2 > this.value.getRealSize()) {
            pos2 = this.value.getRealSize();
        }
        return this.rindexCommon(runtime, context, arg0, pos2);
    }

    private IRubyObject rindexCommon(Ruby runtime, ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub3;
            if (regSub.length() > 0) {
                pos2 = regSub.adjustStartPos(this, pos2, true);
                IRubyObject[] holder = new IRubyObject[]{context.nil};
                pos2 = regSub.search(context, this, pos2, true, holder) - this.value.getBegin();
                context.setBackRef(holder[0]);
            }
        } else if (sub3 instanceof RubyString) {
            pos2 = this.strRindex((RubyString)sub3, pos2);
        } else {
            if (sub3 instanceof RubyFixnum) {
                int c_int = RubyNumeric.fix2int((RubyFixnum)sub3);
                if (c_int < 0 || c_int > 255) {
                    return runtime.getNil();
                }
                byte c = (byte)c_int;
                byte[] bytes2 = this.value.getUnsafeBytes();
                int pbeg = this.value.getBegin();
                int p2 = pbeg + pos2;
                if (pos2 == this.value.getRealSize()) {
                    if (pos2 == 0) {
                        return runtime.getNil();
                    }
                    --p2;
                }
                while (pbeg <= p2) {
                    if (bytes2[p2] == c) {
                        return RubyFixnum.newFixnum(runtime, p2 - this.value.getBegin());
                    }
                    --p2;
                }
                return runtime.getNil();
            }
            IRubyObject tmp = sub3.checkStringType();
            if (tmp.isNil()) {
                throw runtime.newTypeError("type mismatch: " + sub3.getMetaClass().getName() + " given");
            }
            pos2 = this.strRindex((RubyString)tmp, pos2);
        }
        if (pos2 >= 0) {
            return RubyFixnum.newFixnum(runtime, pos2);
        }
        return runtime.getNil();
    }

    private int strRindex(RubyString sub3, int pos2) {
        int subLength = sub3.value.getRealSize();
        if (this.value.getRealSize() < subLength) {
            return -1;
        }
        if (this.value.getRealSize() - pos2 < subLength) {
            pos2 = this.value.getRealSize() - subLength;
        }
        return this.value.lastIndexOf(sub3.value, pos2);
    }

    @JRubyMethod(name={"rindex"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rindex19(ThreadContext context, IRubyObject arg0) {
        return this.rindexCommon19(context.runtime, context, arg0, this.strLength());
    }

    @JRubyMethod(name={"rindex"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rindex19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        Ruby runtime = context.runtime;
        int length2 = this.strLength();
        if (pos2 < 0 && (pos2 += length2) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.setBackRef(runtime.getNil());
            }
            return runtime.getNil();
        }
        if (pos2 > length2) {
            pos2 = length2;
        }
        return this.rindexCommon19(runtime, context, arg0, pos2);
    }

    private IRubyObject rindexCommon19(Ruby runtime, ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub3;
            int n = pos2 = this.singleByteOptimizable() ? pos2 : StringSupport.nth(this.value.getEncoding(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize(), pos2) - this.value.getBegin();
            if (regSub.length() > 0) {
                pos2 = regSub.adjustStartPos19(this, pos2, true);
                IRubyObject[] holder = new IRubyObject[]{context.nil};
                pos2 = regSub.search19(context, this, pos2, true, holder);
                context.setBackRef(holder[0]);
                pos2 = this.subLength(pos2);
            }
        } else if (sub3 instanceof RubyString) {
            pos2 = this.strRindex19((RubyString)sub3, pos2);
        } else {
            IRubyObject tmp = sub3.checkStringType();
            if (tmp.isNil()) {
                throw runtime.newTypeError("type mismatch: " + sub3.getMetaClass().getName() + " given");
            }
            pos2 = this.strRindex19((RubyString)tmp, pos2);
        }
        if (pos2 >= 0) {
            return RubyFixnum.newFixnum(runtime, pos2);
        }
        return runtime.getNil();
    }

    private int strRindex19(RubyString sub3, int pos2) {
        int slen;
        Encoding enc = this.checkEncoding(sub3);
        if (sub3.scanForCodeRange() == 96) {
            return -1;
        }
        int len = this.strLength(enc);
        if (len < (slen = sub3.strLength(enc))) {
            return -1;
        }
        if (len - pos2 < slen) {
            pos2 = len - slen;
        }
        if (len == 0) {
            return pos2;
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        byte[] sbytes = sub3.value.getUnsafeBytes();
        int sp = sub3.value.getBegin();
        slen = sub3.value.getRealSize();
        int s2 = StringSupport.nth(enc, bytes2, p2, end2, pos2);
        while (s2 >= 0) {
            if (ByteList.memcmp(bytes2, s2, sbytes, sp, slen) == 0) {
                return pos2;
            }
            if (pos2 == 0) break;
            --pos2;
            s2 = enc.prevCharHead(bytes2, p2, s2, end2);
        }
        return -1;
    }

    @Deprecated
    public final IRubyObject substr(int beg, int len) {
        return this.substr(this.getRuntime(), beg, len);
    }

    public final IRubyObject substr(Ruby runtime, int beg, int len) {
        int length2 = this.value.length();
        if (len < 0 || beg > length2) {
            return runtime.getNil();
        }
        if (beg < 0 && (beg += length2) < 0) {
            return runtime.getNil();
        }
        int end2 = Math.min(length2, beg + len);
        return runtime.is1_9() ? this.makeShared19(runtime, beg, end2 - beg) : this.makeShared(runtime, beg, end2 - beg);
    }

    private IRubyObject byteSubstr(Ruby runtime, int beg, int len) {
        int length2 = this.value.length();
        if (len < 0 || beg > length2) {
            return runtime.getNil();
        }
        if (beg < 0 && (beg += length2) < 0) {
            return runtime.getNil();
        }
        if (beg + len > length2) {
            len = length2 - beg;
        }
        if (len <= 0) {
            len = 0;
        }
        return this.makeShared19(runtime, beg, len);
    }

    private IRubyObject byteARef(Ruby runtime, IRubyObject idx) {
        if (idx instanceof RubyRange) {
            int[] begLen = ((RubyRange)idx).begLenInt(this.getByteList().length(), 0);
            return begLen == null ? runtime.getNil() : this.byteSubstr(runtime, begLen[0], begLen[1]);
        }
        int index2 = idx instanceof RubyFixnum ? RubyNumeric.fix2int((RubyFixnum)idx) : RubyNumeric.num2int(idx);
        IRubyObject obj = this.byteSubstr(runtime, index2, 1);
        if (obj.isNil() || ((RubyString)obj).getByteList().length() == 0) {
            return runtime.getNil();
        }
        return obj;
    }

    public final IRubyObject substr19(Ruby runtime, int beg, int len) {
        Encoding enc;
        if (len < 0) {
            return runtime.getNil();
        }
        int length2 = this.value.getRealSize();
        if (length2 == 0) {
            len = 0;
        }
        if (this.singleByteOptimizable(enc = this.value.getEncoding())) {
            if (beg > length2) {
                return runtime.getNil();
            }
            if (beg < 0 && (beg += length2) < 0) {
                return runtime.getNil();
            }
            if (beg + len > length2) {
                len = length2 - beg;
            }
            if (len <= 0) {
                beg = 0;
                len = 0;
            }
            return this.makeShared19(runtime, beg, len);
        }
        if (beg + len > length2) {
            len = length2 - beg;
        }
        return this.multibyteSubstr19(runtime, enc, len, beg, length2);
    }

    private IRubyObject multibyteSubstr19(Ruby runtime, Encoding enc, int len, int beg, int length2) {
        int p2;
        int s2 = this.value.getBegin();
        int end2 = s2 + length2;
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (beg < 0) {
            if (len > -beg) {
                len = -beg;
            }
            if (-beg * enc.maxLength() < length2 >>> 3) {
                beg = -beg;
                int e = end2;
                while (beg-- > len && (e = enc.prevCharHead(bytes2, s2, e, e)) != -1) {
                }
                int p3 = e;
                if (p3 == -1) {
                    return runtime.getNil();
                }
                while (len-- > 0 && (p3 = enc.prevCharHead(bytes2, s2, p3, e)) != -1) {
                }
                if (p3 == -1) {
                    return runtime.getNil();
                }
                return this.makeShared19(runtime, p3 - s2, e - p3);
            }
            if ((beg += this.strLength(enc)) < 0) {
                return runtime.getNil();
            }
        } else if (beg > 0 && beg > this.strLength(enc)) {
            return runtime.getNil();
        }
        if (len == 0) {
            p2 = 0;
        } else if (this.isCodeRangeValid() && enc instanceof UTF8Encoding) {
            p2 = StringSupport.utf8Nth(bytes2, s2, end2, beg);
            len = StringSupport.utf8Offset(bytes2, p2, end2, len);
        } else if (enc.isFixedWidth()) {
            int w = enc.maxLength();
            p2 = s2 + beg * w;
            if (p2 > end2) {
                p2 = end2;
                len = 0;
            } else {
                len = len * w > end2 - p2 ? end2 - p2 : (len *= w);
            }
        } else {
            p2 = StringSupport.nth(enc, bytes2, s2, end2, beg);
            len = p2 == end2 ? 0 : StringSupport.offset(enc, bytes2, p2, end2, len);
        }
        return this.makeShared19(runtime, p2 - s2, len);
    }

    private IRubyObject replaceInternal(int beg, int len, RubyString repl) {
        int oldLength = this.value.getRealSize();
        if (beg + len >= oldLength) {
            len = oldLength - beg;
        }
        ByteList replBytes = repl.value;
        int replLength = replBytes.getRealSize();
        int newLength = oldLength + replLength - len;
        byte[] oldBytes = this.value.getUnsafeBytes();
        int oldBegin = this.value.getBegin();
        this.modify(newLength);
        if (replLength != len) {
            System.arraycopy(oldBytes, oldBegin + beg + len, this.value.getUnsafeBytes(), beg + replLength, oldLength - (beg + len));
        }
        if (replLength > 0) {
            System.arraycopy(replBytes.getUnsafeBytes(), replBytes.getBegin(), this.value.getUnsafeBytes(), beg, replLength);
        }
        this.value.setRealSize(newLength);
        return this.infectBy(repl);
    }

    private void replaceInternal19(int beg, int len, RubyString repl) {
        int e;
        Encoding enc = this.checkEncoding(repl);
        int p2 = this.value.getBegin();
        if (this.singleByteOptimizable()) {
            e = (p2 += beg) + len;
        } else {
            int end2 = p2 + this.value.getRealSize();
            byte[] bytes2 = this.value.getUnsafeBytes();
            p2 = StringSupport.nth(enc, bytes2, p2, end2, beg);
            if (p2 == -1) {
                p2 = end2;
            }
            if ((e = StringSupport.nth(enc, bytes2, p2, end2, len)) == -1) {
                e = end2;
            }
        }
        int cr = this.getCodeRange();
        if (cr == 96) {
            this.clearCodeRange();
        }
        this.replaceInternal(p2 - this.value.getBegin(), e - p2, repl);
        this.associateEncoding(enc);
        cr = RubyString.codeRangeAnd(cr, repl.getCodeRange());
        if (cr != 96) {
            this.setCodeRange(cr);
        }
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg1 instanceof RubyRegexp) {
            return this.subpat(runtime, context, (RubyRegexp)arg1, RubyNumeric.num2int(arg2));
        }
        return this.substr(runtime, RubyNumeric.num2int(arg1), RubyNumeric.num2int(arg2));
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubyFixnum) {
            return this.op_aref(runtime, RubyFixnum.fix2int((RubyFixnum)arg2));
        }
        if (arg2 instanceof RubyRegexp) {
            return this.subpat(runtime, context, (RubyRegexp)arg2, 0);
        }
        if (arg2 instanceof RubyString) {
            RubyString str = (RubyString)arg2;
            return this.value.indexOf(str.value) != -1 ? str.strDup(runtime) : runtime.getNil();
        }
        if (arg2 instanceof RubyRange) {
            int[] begLen = ((RubyRange)arg2).begLenInt(this.value.length(), 0);
            return begLen == null ? runtime.getNil() : this.substr(runtime, begLen[0], begLen[1]);
        }
        return this.op_aref(runtime, RubyFixnum.num2int(arg2));
    }

    private IRubyObject op_aref(Ruby runtime, int idx) {
        if (idx < 0) {
            idx += this.value.getRealSize();
        }
        return idx < 0 || idx >= this.value.getRealSize() ? runtime.getNil() : runtime.newFixnum(this.value.get(idx) & 0xFF);
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aref19(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg1 instanceof RubyRegexp) {
            return this.subpat19(runtime, context, (RubyRegexp)arg1, arg2);
        }
        return this.substr19(runtime, RubyNumeric.num2int(arg1), RubyNumeric.num2int(arg2));
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aref19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubyFixnum) {
            return this.op_aref19(runtime, RubyNumeric.fix2int((RubyFixnum)arg2));
        }
        if (arg2 instanceof RubyRegexp) {
            return this.subpat19(runtime, context, (RubyRegexp)arg2);
        }
        if (arg2 instanceof RubyString) {
            RubyString str = (RubyString)arg2;
            return this.strIndex19(str, 0) != -1 ? str.strDup(runtime) : runtime.getNil();
        }
        if (arg2 instanceof RubyRange) {
            int len = this.strLength();
            int[] begLen = ((RubyRange)arg2).begLenInt(len, 0);
            return begLen == null ? runtime.getNil() : this.substr19(runtime, begLen[0], begLen[1]);
        }
        return this.op_aref19(runtime, RubyNumeric.num2int(arg2));
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject byteslice(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        return this.byteSubstr(context.runtime, RubyNumeric.num2int(arg1), RubyNumeric.num2int(arg2));
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject byteslice(ThreadContext context, IRubyObject arg2) {
        return this.byteARef(context.runtime, arg2);
    }

    private IRubyObject op_aref19(Ruby runtime, int idx) {
        IRubyObject str = this.substr19(runtime, idx, 1);
        return !str.isNil() && ((RubyString)str).value.getRealSize() == 0 ? runtime.getNil() : str;
    }

    private void subpatSet(ThreadContext context, RubyRegexp regexp2, int nth, IRubyObject repl) {
        int end2;
        int start2;
        Ruby runtime = context.runtime;
        IRubyObject[] holder = new IRubyObject[]{context.nil};
        int result2 = regexp2.search(context, this, 0, false, holder);
        context.setBackRef(holder[0]);
        if (result2 < 0) {
            throw runtime.newIndexError("regexp not matched");
        }
        RubyMatchData match2 = (RubyMatchData)holder[0];
        nth = this.subpatSetCheck(runtime, nth, match2.regs);
        if (match2.regs == null) {
            start2 = match2.begin;
            end2 = match2.end;
        } else {
            start2 = match2.regs.beg[nth];
            end2 = match2.regs.end[nth];
        }
        if (start2 == -1) {
            throw runtime.newIndexError("regexp group " + nth + " not matched");
        }
        this.replaceInternal(start2, end2 - start2, repl.convertToString());
    }

    private int subpatSetCheck(Ruby runtime, int nth, Region regs) {
        int numRegs;
        int n = numRegs = regs == null ? 1 : regs.numRegs;
        if (nth < numRegs) {
            if (nth < 0) {
                if (-nth < numRegs) {
                    return nth + numRegs;
                }
            } else {
                return nth;
            }
        }
        throw runtime.newIndexError("index " + nth + " out of regexp");
    }

    private IRubyObject subpat(Ruby runtime, ThreadContext context, RubyRegexp regex, int nth) {
        IRubyObject[] holder = new IRubyObject[]{context.nil};
        int result2 = regex.search(context, this, 0, false, holder);
        context.setBackRef(holder[0]);
        if (result2 >= 0) {
            return RubyRegexp.nth_match(nth, holder[0]);
        }
        return runtime.getNil();
    }

    private void subpatSet19(ThreadContext context, RubyRegexp regexp2, IRubyObject backref, IRubyObject repl) {
        int end2;
        int start2;
        int nth;
        Ruby runtime = context.runtime;
        IRubyObject[] holder = new IRubyObject[]{context.nil};
        int result2 = regexp2.search19(context, this, 0, false, holder);
        context.setBackRef(holder[0]);
        if (result2 < 0) {
            throw runtime.newIndexError("regexp not matched");
        }
        RubyMatchData match2 = (RubyMatchData)holder[0];
        int n = nth = backref == null ? 0 : this.subpatSetCheck(runtime, match2.backrefNumber(backref), match2.regs);
        if (match2.regs == null) {
            start2 = match2.begin;
            end2 = match2.end;
        } else {
            start2 = match2.regs.beg[nth];
            end2 = match2.regs.end[nth];
        }
        if (start2 == -1) {
            throw runtime.newIndexError("regexp group " + nth + " not matched");
        }
        RubyString replStr = repl.convertToString();
        Encoding enc = this.checkEncoding(replStr);
        this.replaceInternal(start2, end2 - start2, replStr);
        this.associateEncoding(enc);
    }

    private IRubyObject subpat19(Ruby runtime, ThreadContext context, RubyRegexp regex, IRubyObject backref) {
        IRubyObject[] holder = new IRubyObject[]{context.nil};
        int result2 = regex.search19(context, this, 0, false, holder);
        context.setBackRef(holder[0]);
        if (result2 >= 0) {
            RubyMatchData match2 = (RubyMatchData)holder[0];
            return RubyRegexp.nth_match(match2.backrefNumber(backref), match2);
        }
        return runtime.getNil();
    }

    private IRubyObject subpat19(Ruby runtime, ThreadContext context, RubyRegexp regex) {
        IRubyObject[] holder = new IRubyObject[]{context.nil};
        int result2 = regex.search19(context, this, 0, false, holder);
        context.setBackRef(holder[0]);
        if (result2 >= 0) {
            return RubyRegexp.nth_match(0, holder[0]);
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyFixnum) {
            return this.op_aset(context, RubyNumeric.fix2int((RubyFixnum)arg0), arg1);
        }
        if (arg0 instanceof RubyRegexp) {
            this.subpatSet(context, (RubyRegexp)arg0, 0, arg1.convertToString());
            return arg1;
        }
        if (arg0 instanceof RubyString) {
            RubyString orig = (RubyString)arg0;
            int beg = this.value.indexOf(orig.value);
            if (beg < 0) {
                throw context.runtime.newIndexError("string not matched");
            }
            this.replaceInternal(beg, orig.value.getRealSize(), arg1.convertToString());
            return arg1;
        }
        if (arg0 instanceof RubyRange) {
            int[] begLen = ((RubyRange)arg0).begLenInt(this.value.getRealSize(), 2);
            this.replaceInternal(begLen[0], begLen[1], arg1.convertToString());
            return arg1;
        }
        return this.op_aset(context, RubyNumeric.num2int(arg0), arg1);
    }

    private IRubyObject op_aset(ThreadContext context, int idx, IRubyObject arg1) {
        idx = this.checkIndexForRef(idx, this.value.getRealSize());
        if (arg1 instanceof RubyFixnum) {
            this.modify();
            this.value.set(idx, RubyNumeric.fix2int((RubyFixnum)arg1));
        } else {
            this.replaceInternal(idx, 1, arg1.convertToString());
        }
        return arg1;
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (arg0 instanceof RubyRegexp) {
            this.subpatSet(context, (RubyRegexp)arg0, RubyNumeric.num2int(arg1), arg2);
        } else {
            int beg = RubyNumeric.num2int(arg0);
            int len = RubyNumeric.num2int(arg1);
            this.checkLength(len);
            RubyString repl = arg2.convertToString();
            this.replaceInternal(this.checkIndex(beg, this.value.getRealSize()), len, repl);
        }
        return arg2;
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aset19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyFixnum) {
            return this.op_aset19(context, RubyNumeric.fix2int((RubyFixnum)arg0), arg1);
        }
        if (arg0 instanceof RubyRegexp) {
            this.subpatSet19(context, (RubyRegexp)arg0, null, arg1);
            return arg1;
        }
        if (arg0 instanceof RubyString) {
            RubyString orig = (RubyString)arg0;
            int beg = this.strIndex19(orig, 0);
            if (beg < 0) {
                throw context.runtime.newIndexError("string not matched");
            }
            beg = this.subLength(beg);
            this.replaceInternal19(beg, orig.strLength(), arg1.convertToString());
            return arg1;
        }
        if (arg0 instanceof RubyRange) {
            int[] begLen = ((RubyRange)arg0).begLenInt(this.strLength(), 2);
            this.replaceInternal19(begLen[0], begLen[1], arg1.convertToString());
            return arg1;
        }
        return this.op_aset19(context, RubyNumeric.num2int(arg0), arg1);
    }

    private IRubyObject op_aset19(ThreadContext context, int idx, IRubyObject arg1) {
        this.replaceInternal19(this.checkIndex(idx, this.strLength()), 1, arg1.convertToString());
        return arg1;
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aset19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (arg0 instanceof RubyRegexp) {
            this.subpatSet19(context, (RubyRegexp)arg0, arg1, arg2);
        } else {
            int beg = RubyNumeric.num2int(arg0);
            int len = RubyNumeric.num2int(arg1);
            this.checkLength(len);
            RubyString repl = arg2.convertToString();
            this.replaceInternal19(this.checkIndex(beg, this.strLength()), len, repl);
        }
        return arg2;
    }

    private boolean isHeadSlice(int beg, int len) {
        return beg == 0 && len > 0 && len <= this.value.getRealSize();
    }

    private boolean isTailSlice(int beg, int len) {
        return beg >= 0 && len > 0 && beg + len == this.value.getRealSize();
    }

    private void exciseHead(int len) {
        this.view(len, this.value.getRealSize() - len);
    }

    private void exciseTail(int len) {
        this.view(0, this.value.getRealSize() - len);
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0) {
        IRubyObject result2 = this.op_aref(context, arg0);
        if (!result2.isNil()) {
            int beg = -1;
            int len = 1;
            if (arg0 instanceof RubyFixnum) {
                beg = RubyNumeric.num2int(arg0);
            } else if (arg0 instanceof RubyRange) {
                int[] begLen = ((RubyRange)arg0).begLenInt(this.value.getRealSize(), 2);
                beg = begLen[0];
                len = begLen[1];
            }
            if (this.isHeadSlice(beg, len)) {
                this.exciseHead(len);
            } else if (this.isTailSlice(beg, len)) {
                this.exciseTail(len);
            } else {
                this.op_aset(context, arg0, (IRubyObject)RubyString.newEmptyString(context.runtime));
            }
        }
        return result2;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = this.op_aref(context, arg0, arg1);
        if (!result2.isNil()) {
            int beg = -1;
            int len = 0;
            if (arg0 instanceof RubyFixnum && arg1 instanceof RubyFixnum) {
                beg = RubyNumeric.num2int(arg0);
                len = RubyNumeric.num2int(arg1);
            }
            if (this.isHeadSlice(beg, len)) {
                this.exciseHead(len);
            } else if (this.isTailSlice(beg, len)) {
                this.exciseTail(len);
            } else {
                this.op_aset(context, arg0, arg1, RubyString.newEmptyString(context.runtime));
            }
        }
        return result2;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject slice_bang19(ThreadContext context, IRubyObject arg0) {
        IRubyObject result2 = this.op_aref19(context, arg0);
        if (result2.isNil()) {
            this.modifyCheck();
        } else {
            this.op_aset19(context, arg0, (IRubyObject)RubyString.newEmptyString(context.runtime));
        }
        return result2;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject slice_bang19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = this.op_aref19(context, arg0, arg1);
        if (result2.isNil()) {
            this.modifyCheck();
        } else {
            this.op_aset19(context, arg0, arg1, RubyString.newEmptyString(context.runtime));
        }
        return result2;
    }

    @JRubyMethod(name={"succ", "next"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject succ(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.succ_bang();
        return str;
    }

    @JRubyMethod(name={"succ!", "next!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject succ_bang() {
        int c;
        int i2;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return this;
        }
        this.modify();
        boolean alnumSeen = false;
        int pos2 = -1;
        int n = 0;
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        for (i2 = end2 - 1; i2 >= p2; --i2) {
            c = bytes2[i2] & 0xFF;
            if (!ASCII.isAlnum(c)) continue;
            alnumSeen = true;
            if (ASCII.isDigit(c) && c < 57 || ASCII.isLower(c) && c < 122 || ASCII.isUpper(c) && c < 90) {
                bytes2[i2] = (byte)(c + 1);
                pos2 = -1;
                break;
            }
            pos2 = i2;
            int n2 = ASCII.isDigit(c) ? 49 : (n = ASCII.isLower(c) ? 97 : 65);
            bytes2[i2] = ASCII.isDigit(c) ? 48 : (ASCII.isLower(c) ? 97 : 65);
        }
        if (!alnumSeen) {
            for (i2 = end2 - 1; i2 >= p2; --i2) {
                c = bytes2[i2] & 0xFF;
                if (c < 255) {
                    bytes2[i2] = (byte)(c + 1);
                    pos2 = -1;
                    break;
                }
                pos2 = i2;
                n = 1;
                bytes2[i2] = 0;
            }
        }
        if (pos2 > -1) {
            this.value.insert(pos2, (byte)n);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private static NeighborChar succChar(Encoding enc, byte[] bytes, int p, int len) {
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = len - 1; i >= 0 && bytes[p + i] == -1; --i) {
                bytes[p + i] = 0;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) + 1);
            cl = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (cl > 0) {
                if (cl == len) {
                    return NeighborChar.FOUND;
                }
                for (j = p + cl; j < p + len - cl; ++j) {
                    bytes[j] = -1;
                }
            }
            if (cl != -1 || i >= len - 1) ** continue;
            for (len2 = len - 1; len2 > 0 && StringSupport.preciseLength(enc, bytes, p, p + len2) == -1; --len2) {
            }
            j = p + len2 + 1;
            while (true) {
                if (j < p + len - (len2 + 1)) ** break;
                ** continue;
                bytes[j] = -1;
                ++j;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static NeighborChar predChar(Encoding enc, byte[] bytes, int p, int len) {
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = len - 1; i >= 0 && bytes[p + i] == 0; --i) {
                bytes[p + i] = -1;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) - 1);
            cl = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (cl > 0) {
                if (cl == len) {
                    return NeighborChar.FOUND;
                }
                for (j = p + cl; j < p + len - cl; ++j) {
                    bytes[j] = 0;
                }
            }
            if (cl != -1 || i >= len - 1) ** continue;
            for (len2 = len - 1; len2 > 0 && StringSupport.preciseLength(enc, bytes, p, p + len2) == -1; --len2) {
            }
            j = p + len2 + 1;
            while (true) {
                if (j < p + len - (len2 + 1)) ** break;
                ** continue;
                bytes[j] = 0;
                ++j;
            }
            break;
        }
    }

    private static NeighborChar succAlnumChar(Encoding enc, byte[] bytes2, int p2, int len, byte[] carry, int carryP) {
        int cType;
        byte[] save = new byte[7];
        int c = enc.mbcToCode(bytes2, p2, p2 + len);
        if (enc.isDigit(c)) {
            cType = 4;
        } else if (enc.isAlpha(c)) {
            cType = 1;
        } else {
            return NeighborChar.NOT_CHAR;
        }
        System.arraycopy(bytes2, p2, save, 0, len);
        NeighborChar ret = RubyString.succChar(enc, bytes2, p2, len);
        if (ret == NeighborChar.FOUND && enc.isCodeCType(c = enc.mbcToCode(bytes2, p2, p2 + len), cType)) {
            return NeighborChar.FOUND;
        }
        System.arraycopy(save, 0, bytes2, p2, len);
        int range = 1;
        while (true) {
            System.arraycopy(bytes2, p2, save, 0, len);
            ret = RubyString.predChar(enc, bytes2, p2, len);
            if (ret == NeighborChar.FOUND) {
                c = enc.mbcToCode(bytes2, p2, p2 + len);
                if (!enc.isCodeCType(c, cType)) {
                    System.arraycopy(save, 0, bytes2, p2, len);
                    break;
                }
            } else {
                System.arraycopy(save, 0, bytes2, p2, len);
                break;
            }
            ++range;
        }
        if (range == 1) {
            return NeighborChar.NOT_CHAR;
        }
        if (cType != 4) {
            System.arraycopy(bytes2, p2, carry, carryP, len);
            return NeighborChar.WRAPPED;
        }
        System.arraycopy(bytes2, p2, carry, carryP, len);
        RubyString.succChar(enc, carry, carryP, len);
        return NeighborChar.WRAPPED;
    }

    @JRubyMethod(name={"succ", "next"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject succ19(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyString str = this.value.getRealSize() > 0 ? new RubyString(runtime, this.getMetaClass(), this.succCommon19(this.value)) : RubyString.newEmptyString(runtime, this.getType(), this.value.getEncoding());
        return str.infectBy(this);
    }

    @JRubyMethod(name={"succ!", "next!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject succ_bang19() {
        this.modifyCheck();
        if (this.value.getRealSize() > 0) {
            this.value = this.succCommon19(this.value);
            this.shareLevel = 0;
        }
        return this;
    }

    private ByteList succCommon19(ByteList original) {
        int cl;
        int end2;
        byte[] carry = new byte[7];
        int carryP = 0;
        carry[0] = 1;
        int carryLen = 1;
        ByteList valueCopy = new ByteList(original);
        valueCopy.setEncoding(original.getEncoding());
        Encoding enc = original.getEncoding();
        int p2 = valueCopy.getBegin();
        int s2 = end2 = p2 + valueCopy.getRealSize();
        byte[] bytes2 = valueCopy.getUnsafeBytes();
        NeighborChar neighbor = NeighborChar.FOUND;
        int lastAlnum = -1;
        boolean alnumSeen = false;
        block5: while ((s2 = enc.prevCharHead(bytes2, p2, s2, end2)) != -1) {
            if (neighbor == NeighborChar.NOT_CHAR && lastAlnum != -1 && (ASCII.isAlpha(bytes2[lastAlnum] & 0xFF) ? ASCII.isDigit(bytes2[s2] & 0xFF) : ASCII.isDigit(bytes2[lastAlnum] & 0xFF) && ASCII.isAlpha(bytes2[s2] & 0xFF))) {
                s2 = lastAlnum;
                break;
            }
            cl = StringSupport.preciseLength(enc, bytes2, s2, end2);
            if (cl <= 0) continue;
            neighbor = RubyString.succAlnumChar(enc, bytes2, s2, cl, carry, 0);
            switch (neighbor) {
                case NOT_CHAR: {
                    continue block5;
                }
                case FOUND: {
                    return valueCopy;
                }
                case WRAPPED: {
                    lastAlnum = s2;
                }
            }
            alnumSeen = true;
            carryP = s2 - p2;
            carryLen = cl;
        }
        if (!alnumSeen) {
            s2 = end2;
            while ((s2 = enc.prevCharHead(bytes2, p2, s2, end2)) != -1) {
                cl = StringSupport.preciseLength(enc, bytes2, s2, end2);
                if (cl <= 0) continue;
                neighbor = RubyString.succChar(enc, bytes2, s2, cl);
                if (neighbor == NeighborChar.FOUND) {
                    return valueCopy;
                }
                if (StringSupport.preciseLength(enc, bytes2, s2, s2 + 1) != cl) {
                    RubyString.succChar(enc, bytes2, s2, cl);
                }
                if (!enc.isAsciiCompatible()) {
                    System.arraycopy(bytes2, s2, carry, 0, cl);
                    carryLen = cl;
                }
                carryP = s2 - p2;
            }
        }
        valueCopy.ensure(valueCopy.getBegin() + valueCopy.getRealSize() + carryLen);
        s2 = valueCopy.getBegin() + carryP;
        System.arraycopy(valueCopy.getUnsafeBytes(), s2, valueCopy.getUnsafeBytes(), s2 + carryLen, valueCopy.getRealSize() - carryP);
        System.arraycopy(carry, 0, valueCopy.getUnsafeBytes(), s2, carryLen);
        valueCopy.setRealSize(valueCopy.getRealSize() + carryLen);
        return valueCopy;
    }

    @JRubyMethod(name={"upto"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject upto18(ThreadContext context, IRubyObject end2, Block block) {
        return this.uptoCommon18(context, end2, false, block);
    }

    @JRubyMethod(name={"upto"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject upto18(ThreadContext context, IRubyObject end2, IRubyObject excl, Block block) {
        return this.uptoCommon18(context, end2, excl.isTrue(), block);
    }

    final IRubyObject uptoCommon18(ThreadContext context, IRubyObject arg2, boolean excl, Block block) {
        RubyString end2 = arg2.convertToString();
        this.checkEncoding(end2);
        int n = this.op_cmp19(end2);
        if (n > 0 || excl && n == 0) {
            return this;
        }
        IRubyObject afterEnd = end2.callMethod(context, "succ");
        RubyString current2 = this;
        while (!current2.op_equal19(context, afterEnd).isTrue()) {
            block.yield(context, current2);
            if (!excl && current2.op_equal19(context, end2).isTrue()) break;
            current2 = current2.callMethod(context, "succ").convertToString();
            if ((!excl || !current2.op_equal19(context, end2).isTrue()) && current2.value.getRealSize() <= end2.value.getRealSize() && current2.value.getRealSize() != 0) continue;
            break;
        }
        return this;
    }

    @JRubyMethod(name={"upto"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject upto19(ThreadContext context, IRubyObject end2, Block block) {
        Ruby runtime = context.runtime;
        return block.isGiven() ? this.uptoCommon19(context, end2, false, block) : RubyEnumerator.enumeratorize(runtime, (IRubyObject)this, "upto", end2);
    }

    @JRubyMethod(name={"upto"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject upto19(ThreadContext context, IRubyObject end2, IRubyObject excl, Block block) {
        return block.isGiven() ? this.uptoCommon19(context, end2, excl.isTrue(), block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "upto", new IRubyObject[]{end2, excl});
    }

    final IRubyObject uptoCommon19(ThreadContext context, IRubyObject arg2, boolean excl, Block block) {
        return this.uptoCommon19(context, arg2, excl, block, false);
    }

    final IRubyObject uptoCommon19(ThreadContext context, IRubyObject arg2, boolean excl, Block block, boolean asSymbol) {
        boolean isAscii;
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubySymbol) {
            throw runtime.newTypeError("can't convert Symbol into String");
        }
        RubyString end2 = arg2.convertToString();
        Encoding enc = this.checkEncoding(end2);
        boolean bl = isAscii = this.scanForCodeRange() == 32 && end2.scanForCodeRange() == 32;
        if (this.value.getRealSize() == 1 && end2.value.getRealSize() == 1 && isAscii) {
            byte e;
            byte c = this.value.getUnsafeBytes()[this.value.getBegin()];
            if (c > (e = end2.value.getUnsafeBytes()[end2.value.getBegin()]) || excl && c == e) {
                return this;
            }
            do {
                RubyString s2 = new RubyString(runtime, runtime.getString(), RubyInteger.SINGLE_CHAR_BYTELISTS[c & 0xFF], enc, 32);
                s2.shareLevel = 2;
                block.yield(context, asSymbol ? runtime.newSymbol(s2.toString()) : s2);
                if (!excl && c == e) break;
                c = (byte)(c + 1);
            } while (!excl || c != e);
            return this;
        }
        if (isAscii && ASCII.isDigit(this.value.getUnsafeBytes()[this.value.getBegin()]) && ASCII.isDigit(end2.value.getUnsafeBytes()[end2.value.getBegin()])) {
            int s3;
            int send2 = s3 + this.value.getRealSize();
            byte[] bytes2 = this.value.getUnsafeBytes();
            for (s3 = this.value.getBegin(); s3 < send2; ++s3) {
                if (ASCII.isDigit(bytes2[s3] & 0xFF)) continue;
                return this.uptoCommon19NoDigits(context, end2, excl, block, asSymbol);
            }
            send2 = s3 + end2.value.getRealSize();
            bytes2 = end2.value.getUnsafeBytes();
            for (s3 = end2.value.getBegin(); s3 < send2; ++s3) {
                if (ASCII.isDigit(bytes2[s3] & 0xFF)) continue;
                return this.uptoCommon19NoDigits(context, end2, excl, block, asSymbol);
            }
            IRubyObject b = this.stringToInum19(10, false);
            IRubyObject e = end2.stringToInum19(10, false);
            IRubyObject[] args2 = new IRubyObject[2];
            args2[0] = RubyFixnum.newFixnum(runtime, this.value.length());
            RubyArray argsArr = runtime.newArrayNoCopy(args2);
            if (b instanceof RubyFixnum && e instanceof RubyFixnum) {
                int ei = RubyNumeric.fix2int(e);
                for (int bi = RubyNumeric.fix2int(b); !(bi > ei || excl && bi == ei); ++bi) {
                    args2[1] = RubyFixnum.newFixnum(runtime, bi);
                    ByteList to = new ByteList(this.value.length() + 5);
                    Sprintf.sprintf(to, "%.*d", (IRubyObject)argsArr);
                    RubyString str = RubyString.newStringNoCopy(runtime, to, USASCIIEncoding.INSTANCE, 32);
                    block.yield(context, asSymbol ? runtime.newSymbol(str.toString()) : str);
                }
            } else {
                String op;
                String string2 = op = excl ? "<" : "<=";
                while (b.callMethod(context, op, e).isTrue()) {
                    args2[1] = b;
                    ByteList to = new ByteList(this.value.length() + 5);
                    Sprintf.sprintf(to, "%.*d", (IRubyObject)argsArr);
                    RubyString str = RubyString.newStringNoCopy(runtime, to, USASCIIEncoding.INSTANCE, 32);
                    block.yield(context, asSymbol ? runtime.newSymbol(str.toString()) : str);
                    b = b.callMethod(context, "succ");
                }
            }
            return this;
        }
        return this.uptoCommon19NoDigits(context, end2, excl, block, asSymbol);
    }

    private IRubyObject uptoCommon19NoDigits(ThreadContext context, RubyString end2, boolean excl, Block block, boolean asSymbol) {
        Ruby runtime = context.runtime;
        int n = this.op_cmp19(end2);
        if (n > 0 || excl && n == 0) {
            return this;
        }
        IRubyObject afterEnd = end2.callMethod(context, "succ");
        RubyString current2 = this.strDup(context.runtime);
        while (!current2.op_equal19(context, afterEnd).isTrue()) {
            IRubyObject next2 = null;
            if (excl || !current2.op_equal19(context, end2).isTrue()) {
                next2 = current2.callMethod(context, "succ");
            }
            block.yield(context, asSymbol ? runtime.newSymbol(current2.toString()) : current2);
            if (next2 == null) break;
            current2 = next2.convertToString();
            if ((!excl || !current2.op_equal19(context, end2).isTrue()) && current2.getByteList().length() <= end2.getByteList().length() && current2.getByteList().length() != 0) continue;
            break;
        }
        return this;
    }

    @JRubyMethod(name={"include?"}, compat=CompatVersion.RUBY1_8)
    public RubyBoolean include_p(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        if (obj instanceof RubyFixnum) {
            int c = RubyNumeric.fix2int((RubyFixnum)obj);
            for (int i2 = 0; i2 < this.value.getRealSize(); ++i2) {
                if (this.value.get(i2) != (byte)c) continue;
                return runtime.getTrue();
            }
            return runtime.getFalse();
        }
        return this.value.indexOf(obj.convertToString().value) == -1 ? runtime.getFalse() : runtime.getTrue();
    }

    @JRubyMethod(name={"include?"}, compat=CompatVersion.RUBY1_9)
    public RubyBoolean include_p19(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        return this.strIndex19(obj.convertToString(), 0) == -1 ? runtime.getFalse() : runtime.getTrue();
    }

    @JRubyMethod(name={"chr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chr(ThreadContext context) {
        return this.substr19(context.runtime, 0, 1);
    }

    @JRubyMethod(name={"getbyte"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getbyte(ThreadContext context, IRubyObject index2) {
        Ruby runtime = context.runtime;
        int i2 = RubyNumeric.num2int(index2);
        if (i2 < 0) {
            i2 += this.value.getRealSize();
        }
        if (i2 < 0 || i2 >= this.value.getRealSize()) {
            return runtime.getNil();
        }
        return RubyFixnum.newFixnum(runtime, this.value.getUnsafeBytes()[this.value.getBegin() + i2] & 0xFF);
    }

    @JRubyMethod(name={"setbyte"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject setbyte(ThreadContext context, IRubyObject index2, IRubyObject val) {
        this.modifyAndKeepCodeRange();
        int i2 = RubyNumeric.num2int(index2);
        int b = RubyNumeric.num2int(val);
        this.value.getUnsafeBytes()[this.checkIndexForRef((int)i2, (int)this.value.getRealSize())] = (byte)b;
        return val;
    }

    @JRubyMethod(name={"to_i"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_i() {
        return this.stringToInum(10, false);
    }

    @JRubyMethod(name={"to_i"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_i(IRubyObject arg0) {
        long base = this.checkBase(arg0);
        return this.stringToInum((int)base, false);
    }

    @JRubyMethod(name={"to_i"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_i19() {
        return this.stringToInum19(10, false);
    }

    @JRubyMethod(name={"to_i"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_i19(IRubyObject arg0) {
        long base = this.checkBase(arg0);
        return this.stringToInum19((int)base, false);
    }

    private long checkBase(IRubyObject arg0) {
        long base = arg0.convertToInteger().getLongValue();
        if (base < 0L) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        return base;
    }

    public IRubyObject stringToInum(int base, boolean badcheck) {
        ByteList s2 = this.value;
        return ConvertBytes.byteListToInum(this.getRuntime(), s2, base, badcheck);
    }

    public IRubyObject stringToInum19(int base, boolean badcheck) {
        ByteList s2 = this.value;
        return ConvertBytes.byteListToInum19(this.getRuntime(), s2, base, badcheck);
    }

    @JRubyMethod(name={"oct"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject oct(ThreadContext context) {
        return this.stringToInum(-8, false);
    }

    @JRubyMethod(name={"oct"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject oct19(ThreadContext context) {
        if (!this.value.getEncoding().isAsciiCompatible()) {
            throw context.runtime.newEncodingCompatibilityError("ASCII incompatible encoding: " + this.value.getEncoding());
        }
        return this.oct(context);
    }

    @JRubyMethod(name={"hex"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject hex(ThreadContext context) {
        return this.stringToInum(16, false);
    }

    @JRubyMethod(name={"hex"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject hex19(ThreadContext context) {
        if (!this.value.getEncoding().isAsciiCompatible()) {
            throw context.runtime.newEncodingCompatibilityError("ASCII incompatible encoding: " + this.value.getEncoding());
        }
        return this.stringToInum19(16, false);
    }

    @JRubyMethod(name={"to_f"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuntime(), this);
    }

    @JRubyMethod(name={"to_f"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_f19() {
        return RubyNumeric.str2fnum19(this.getRuntime(), this, false);
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public RubyArray split(ThreadContext context) {
        return this.split(context, context.runtime.getNil());
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public RubyArray split(ThreadContext context, IRubyObject arg0) {
        return this.splitCommon(arg0, false, 0, 0, context);
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public RubyArray split(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int lim = RubyNumeric.num2int(arg1);
        if (lim <= 0) {
            return this.splitCommon(arg0, false, lim, 1, context);
        }
        if (lim == 1) {
            return this.value.getRealSize() == 0 ? context.runtime.newArray() : context.runtime.newArray((IRubyObject)this);
        }
        return this.splitCommon(arg0, true, lim, 1, context);
    }

    private RubyArray splitCommon(IRubyObject spat, boolean limit2, int lim, int i2, ThreadContext context) {
        RubyArray result2;
        if (spat.isNil() && (spat = context.runtime.getGlobalVariables().get("$;")).isNil()) {
            result2 = this.awkSplit(limit2, lim, i2);
        } else if (spat instanceof RubyString && ((RubyString)spat).value.getRealSize() == 1) {
            RubyString strSpat = (RubyString)spat;
            result2 = strSpat.value.getUnsafeBytes()[strSpat.value.getBegin()] == 32 ? this.awkSplit(limit2, lim, i2) : this.regexSplit(context, spat, limit2, lim, i2);
        } else {
            result2 = this.regexSplit(context, spat, limit2, lim, i2);
        }
        if (!limit2 && lim == 0) {
            while (result2.size() > 0 && ((RubyString)result2.eltInternal((int)(result2.size() - 1))).value.getRealSize() == 0) {
                result2.pop(context);
            }
        }
        return result2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RubyArray regexSplit(ThreadContext context, IRubyObject pat, boolean limit2, int lim, int i2) {
        int end2;
        Ruby runtime = context.runtime;
        Regex pattern = this.getQuotedPattern(pat);
        int begin2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int range = begin2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Matcher matcher = pattern.matcher(bytes2, begin2, range);
        RubyArray result2 = runtime.newArray();
        Encoding enc = this.getEncodingForKCodeDefault(runtime, pattern, pat);
        boolean captures2 = pattern.numberOfCaptures() != 0;
        int beg = 0;
        boolean lastNull = false;
        int start2 = begin2;
        while ((end2 = RubyRegexp.matcherSearch(runtime, matcher, start2, range, 0)) >= 0) {
            block7: {
                if (start2 == end2 + begin2 && matcher.getBegin() == matcher.getEnd()) {
                    if (len == 0) {
                        result2.append(RubyString.newEmptyString(runtime, this.getMetaClass()).infectBy(this));
                        break;
                    }
                    if (lastNull) {
                        result2.append(this.makeShared(runtime, beg, enc.length(bytes2, begin2 + beg, range)));
                        beg = start2 - begin2;
                        break block7;
                    } else {
                        start2 += start2 == range ? 1 : enc.length(bytes2, start2, range);
                        lastNull = true;
                        continue;
                    }
                }
                result2.append(this.makeShared(runtime, beg, end2 - beg));
                beg = matcher.getEnd();
                start2 = begin2 + beg;
            }
            lastNull = false;
            if (captures2) {
                this.populateCapturesForSplit(runtime, result2, matcher, false);
            }
            if (!limit2 || lim > ++i2) continue;
        }
        context.setBackRef(runtime.getNil());
        if (len > 0 && (limit2 || len > beg || lim < 0)) {
            result2.append(this.makeShared(runtime, beg, len - beg));
        }
        return result2;
    }

    private Encoding getEncodingForKCodeDefault(Ruby runtime, Regex pattern, IRubyObject pat) {
        RubyRegexp regexp2;
        Encoding enc = pattern.getEncoding();
        if (enc != runtime.getKCode().getEncoding() && pat instanceof RubyRegexp && (regexp2 = (RubyRegexp)pat).isKCodeDefault()) {
            enc = runtime.getKCode().getEncoding();
        }
        return enc;
    }

    private void populateCapturesForSplit(Ruby runtime, RubyArray result2, Matcher matcher, boolean is19) {
        Region region = matcher.getRegion();
        for (int i2 = 1; i2 < region.numRegs; ++i2) {
            int beg = region.beg[i2];
            if (beg == -1) continue;
            result2.append(is19 ? this.makeShared19(runtime, beg, region.end[i2] - beg) : this.makeShared(runtime, beg, region.end[i2] - beg));
        }
    }

    private RubyArray awkSplit(boolean limit2, int lim, int i2) {
        Ruby runtime = this.getRuntime();
        RubyArray result2 = runtime.newArray();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        boolean skip2 = true;
        int e = 0;
        int b = 0;
        while (p2 < end2) {
            int c = bytes2[p2++] & 0xFF;
            if (skip2) {
                if (ASCII.isSpace(c)) {
                    ++b;
                    continue;
                }
                e = b + 1;
                skip2 = false;
                if (!limit2 || lim > i2) continue;
                break;
            }
            if (ASCII.isSpace(c)) {
                result2.append(this.makeShared(runtime, b, e - b));
                skip2 = true;
                b = e + 1;
                if (!limit2) continue;
                ++i2;
                continue;
            }
            ++e;
        }
        if (len > 0 && (limit2 || len > b || lim < 0)) {
            result2.append(this.makeShared(runtime, b, len - b));
        }
        return result2;
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public RubyArray split19(ThreadContext context) {
        return this.split19(context, context.runtime.getNil());
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public RubyArray split19(ThreadContext context, IRubyObject arg0) {
        return this.splitCommon19(arg0, false, 0, 0, context, true);
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public RubyArray split19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int lim = RubyNumeric.num2int(arg1);
        if (lim <= 0) {
            return this.splitCommon19(arg0, false, lim, 1, context, true);
        }
        if (lim == 1) {
            return this.value.getRealSize() == 0 ? context.runtime.newArray() : context.runtime.newArray((IRubyObject)this);
        }
        return this.splitCommon19(arg0, true, lim, 1, context, true);
    }

    public RubyArray split19(ThreadContext context, IRubyObject arg0, boolean useBackref) {
        return this.splitCommon19(arg0, useBackref, this.flags, this.flags, context, useBackref);
    }

    private RubyArray splitCommon19(IRubyObject spat, boolean limit2, int lim, int i2, ThreadContext context, boolean useBackref) {
        RubyArray result2;
        if (spat.isNil() && (spat = context.runtime.getGlobalVariables().get("$;")).isNil()) {
            result2 = this.awkSplit19(limit2, lim, i2);
        } else if (spat instanceof RubyString) {
            ByteList spatValue = ((RubyString)spat).value;
            int len = spatValue.getRealSize();
            Encoding spatEnc = spatValue.getEncoding();
            if (len == 0) {
                Regex pattern = RubyRegexp.getRegexpFromCache(context.runtime, spatValue, spatEnc, new RegexpOptions());
                result2 = this.regexSplit19(context, pattern, pattern, limit2, lim, i2, useBackref);
            } else {
                byte[] bytes2 = spatValue.getUnsafeBytes();
                int p2 = spatValue.getBegin();
                int c = spatEnc.isAsciiCompatible() ? (len == 1 ? bytes2[p2] & 0xFF : -1) : (len == StringSupport.preciseLength(spatEnc, bytes2, p2, p2 + len) ? spatEnc.mbcToCode(bytes2, p2, p2 + len) : -1);
                result2 = c == 32 ? this.awkSplit19(limit2, lim, i2) : this.stringSplit19(context, (RubyString)spat, limit2, lim, i2);
            }
        } else {
            Regex prepared;
            Regex pattern;
            Ruby runtime = context.runtime;
            if (spat instanceof RubyRegexp) {
                RubyRegexp regexp2 = (RubyRegexp)spat;
                pattern = regexp2.getPattern();
                prepared = regexp2.preparePattern(this);
            } else {
                pattern = this.getStringPattern19(runtime, spat);
                prepared = RubyRegexp.preparePattern(runtime, pattern, this);
            }
            result2 = this.regexSplit19(context, pattern, prepared, limit2, lim, i2, useBackref);
        }
        if (!limit2 && lim == 0) {
            while (result2.size() > 0 && ((RubyString)result2.eltInternal((int)(result2.size() - 1))).value.getRealSize() == 0) {
                result2.pop(context);
            }
        }
        return result2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RubyArray regexSplit19(ThreadContext context, Regex pattern, Regex prepared, boolean limit2, int lim, int i2, boolean useBackref) {
        int end2;
        Ruby runtime = context.runtime;
        int begin2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int range = begin2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        RubyArray result2 = runtime.newArray();
        Encoding enc = this.value.getEncoding();
        boolean captures2 = pattern.numberOfCaptures() != 0;
        int beg = 0;
        boolean lastNull = false;
        int start2 = begin2;
        while ((end2 = RubyRegexp.matcherSearch(runtime, matcher, start2, range, 0)) >= 0) {
            block8: {
                if (start2 == end2 + begin2 && matcher.getBegin() == matcher.getEnd()) {
                    if (len == 0) {
                        result2.append(RubyString.newEmptyString(runtime, this.getMetaClass()).infectBy(this));
                        break;
                    }
                    if (lastNull) {
                        result2.append(this.makeShared19(runtime, beg, StringSupport.length(enc, bytes2, begin2 + beg, range)));
                        beg = start2 - begin2;
                        break block8;
                    } else {
                        start2 += start2 == range ? 1 : StringSupport.length(enc, bytes2, start2, range);
                        lastNull = true;
                        continue;
                    }
                }
                result2.append(this.makeShared19(runtime, beg, end2 - beg));
                beg = matcher.getEnd();
                start2 = begin2 + beg;
            }
            lastNull = false;
            if (captures2) {
                this.populateCapturesForSplit(runtime, result2, matcher, true);
            }
            if (!limit2 || lim > ++i2) continue;
        }
        if (useBackref) {
            context.setBackRef(runtime.getNil());
        }
        if (len > 0 && (limit2 || len > beg || lim < 0)) {
            result2.append(this.makeShared19(runtime, beg, len - beg));
        }
        return result2;
    }

    private RubyArray awkSplit19(boolean limit2, int lim, int i2) {
        int p2;
        Ruby runtime = this.getRuntime();
        RubyArray result2 = runtime.newArray();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int ptr = p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        Encoding enc = this.value.getEncoding();
        boolean skip2 = true;
        int e = 0;
        int b = 0;
        boolean singlebyte = this.singleByteOptimizable(enc);
        while (p2 < end2) {
            int c;
            if (singlebyte) {
                c = bytes2[p2++] & 0xFF;
            } else {
                c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2);
                p2 += StringSupport.length(enc, bytes2, p2, end2);
            }
            if (skip2) {
                if (enc.isSpace(c)) {
                    b = p2 - ptr;
                    continue;
                }
                e = p2 - ptr;
                skip2 = false;
                if (!limit2 || lim > i2) continue;
                break;
            }
            if (enc.isSpace(c)) {
                result2.append(this.makeShared19(runtime, b, e - b));
                skip2 = true;
                b = p2 - ptr;
                if (!limit2) continue;
                ++i2;
                continue;
            }
            e = p2 - ptr;
        }
        if (len > 0 && (limit2 || len > b || lim < 0)) {
            result2.append(this.makeShared19(runtime, b, len - b));
        }
        return result2;
    }

    private RubyArray stringSplit19(ThreadContext context, RubyString spat, boolean limit2, int lim, int i2) {
        int e;
        Ruby runtime = context.runtime;
        if (this.scanForCodeRange() == 96) {
            throw runtime.newArgumentError("invalid byte sequence in " + this.value.getEncoding());
        }
        if (spat.scanForCodeRange() == 96) {
            throw runtime.newArgumentError("invalid byte sequence in " + spat.value.getEncoding());
        }
        RubyArray result2 = runtime.newArray();
        Encoding enc = this.checkEncoding(spat);
        ByteList pattern = spat.value;
        byte[] patternBytes = pattern.getUnsafeBytes();
        int patternBegin = pattern.getBegin();
        int patternRealSize = pattern.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int begin2 = this.value.getBegin();
        int realSize = this.value.getRealSize();
        int p2 = 0;
        while (p2 < realSize && (e = RubyString.indexOf(bytes2, begin2, realSize, patternBytes, patternBegin, patternRealSize, p2)) >= 0) {
            int t = enc.rightAdjustCharHead(bytes2, p2 + begin2, e + begin2, begin2 + realSize) - begin2;
            if (t != e) {
                p2 = t;
                continue;
            }
            result2.append(this.makeShared19(runtime, p2, e - p2));
            p2 = e + pattern.getRealSize();
            if (!limit2 || lim > ++i2) continue;
            break;
        }
        if (this.value.getRealSize() > 0 && (limit2 || this.value.getRealSize() > p2 || lim < 0)) {
            result2.append(this.makeShared19(runtime, p2, this.value.getRealSize() - p2));
        }
        return result2;
    }

    static int indexOf(byte[] source2, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first2 = target[targetOffset];
        int max2 = sourceOffset + (sourceCount - targetCount);
        for (int i2 = sourceOffset + fromIndex; i2 <= max2; ++i2) {
            if (source2[i2] != first2) {
                while (++i2 <= max2 && source2[i2] != first2) {
                }
            }
            if (i2 > max2) continue;
            int j = i2 + 1;
            int end2 = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end2 && source2[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end2) continue;
            return i2 - sourceOffset;
        }
        return -1;
    }

    private RubyString getStringForPattern(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject val = obj.checkStringType();
        if (val.isNil()) {
            throw this.getRuntime().newTypeError("wrong argument type " + obj.getMetaClass() + " (expected Regexp)");
        }
        return (RubyString)val;
    }

    private RubyRegexp getPattern(IRubyObject obj) {
        if (obj instanceof RubyRegexp) {
            return (RubyRegexp)obj;
        }
        return RubyRegexp.newRegexp(this.getRuntime(), this.getStringForPattern((IRubyObject)obj).value);
    }

    private Regex getQuotedPattern(IRubyObject obj) {
        if (obj instanceof RubyRegexp) {
            return ((RubyRegexp)obj).getPattern();
        }
        Ruby runtime = this.getRuntime();
        return RubyRegexp.getQuotedRegexpFromCache(runtime, this.getStringForPattern((IRubyObject)obj).value, runtime.getKCode().getEncoding(), new RegexpOptions());
    }

    private Regex getStringPattern(Ruby runtime, Encoding enc, IRubyObject obj) {
        return RubyRegexp.getQuotedRegexpFromCache(runtime, this.getStringForPattern((IRubyObject)obj).value, enc, new RegexpOptions());
    }

    private Regex getStringPattern19(Ruby runtime, IRubyObject obj) {
        RubyString str = this.getStringForPattern(obj);
        if (str.scanForCodeRange() == 96) {
            throw runtime.newRegexpError("invalid multybyte character: " + RubyRegexp.regexpDescription19(runtime, str.value, new RegexpOptions(), str.value.getEncoding()).toString());
        }
        if (str.value.getEncoding().isDummy()) {
            throw runtime.newArgumentError("can't make regexp with dummy encoding");
        }
        return RubyRegexp.getQuotedRegexpFromCache19(runtime, str.value, new RegexpOptions(), str.isAsciiOnly());
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject scan(ThreadContext context, IRubyObject arg2, Block block) {
        int tuFlags;
        Regex pattern;
        Ruby runtime = context.runtime;
        Encoding enc = runtime.getKCode().getEncoding();
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regex = (RubyRegexp)arg2;
            pattern = regex.getPattern();
            tuFlags = regex.flags;
        } else {
            pattern = this.getStringPattern(runtime, enc, arg2);
            tuFlags = arg2.isTaint() ? 8 : 0;
        }
        int begin2 = this.value.getBegin();
        int range = begin2 + this.value.getRealSize();
        Matcher matcher = pattern.matcher(this.value.getUnsafeBytes(), begin2, range);
        if (block.isGiven()) {
            return this.scanIter(context, pattern, matcher, enc, block, begin2, range, tuFlags);
        }
        return this.scanNoIter(context, pattern, matcher, enc, begin2, range, tuFlags);
    }

    private IRubyObject scanIter(ThreadContext context, Regex pattern, Matcher matcher, Encoding enc, Block block, int begin2, int range, int tuFlags) {
        Ruby runtime = context.runtime;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int size2 = this.value.getRealSize();
        IRubyObject match2 = null;
        int end2 = 0;
        if (pattern.numberOfCaptures() == 0) {
            while (RubyRegexp.matcherSearch(runtime, matcher, begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
                RubyString substr = this.makeShared(runtime, matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
                substr.infectBy(tuFlags);
                ((RubyBasicObject)match2).infectBy(tuFlags);
                context.setBackRef(match2);
                block.yield(context, substr);
                this.modifyCheck(bytes2, size2);
            }
        } else {
            while (RubyRegexp.matcherSearch(runtime, matcher, begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
                ((RubyBasicObject)match2).infectBy(tuFlags);
                context.setBackRef(match2);
                block.yield(context, this.populateCapturesForScan(runtime, matcher, range, tuFlags, false));
                this.modifyCheck(bytes2, size2);
            }
        }
        context.setBackRef(match2 == null ? runtime.getNil() : match2);
        return this;
    }

    private IRubyObject scanNoIter(ThreadContext context, Regex pattern, Matcher matcher, Encoding enc, int begin2, int range, int tuFlags) {
        Ruby runtime = context.runtime;
        RubyArray ary = runtime.newArray();
        int end2 = 0;
        if (pattern.numberOfCaptures() == 0) {
            while (RubyRegexp.matcherSearch(runtime, matcher, begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                RubyString substr = this.makeShared(runtime, matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
                substr.infectBy(tuFlags);
                ary.append(substr);
            }
        } else {
            while (RubyRegexp.matcherSearch(runtime, matcher, begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                ary.append(this.populateCapturesForScan(runtime, matcher, range, tuFlags, false));
            }
        }
        if (ary.size() > 0) {
            RubyMatchData match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
            match2.infectBy(tuFlags);
            context.setBackRef(match2);
        } else {
            context.setBackRef(runtime.getNil());
        }
        return ary;
    }

    private int positionEnd(Matcher matcher, Encoding enc, int begin2, int range) {
        int end2 = matcher.getEnd();
        if (matcher.getBegin() == end2) {
            if (this.value.getRealSize() > end2) {
                return end2 + enc.length(this.value.getUnsafeBytes(), begin2 + end2, range);
            }
            return end2 + 1;
        }
        return end2;
    }

    private IRubyObject populateCapturesForScan(Ruby runtime, Matcher matcher, int range, int tuFlags, boolean is19) {
        Region region = matcher.getRegion();
        RubyArray result2 = this.getRuntime().newArray(region.numRegs);
        for (int i2 = 1; i2 < region.numRegs; ++i2) {
            int beg = region.beg[i2];
            if (beg == -1) {
                result2.append(runtime.getNil());
                continue;
            }
            RubyString substr = is19 ? this.makeShared19(runtime, beg, region.end[i2] - beg) : this.makeShared(runtime, beg, region.end[i2] - beg);
            substr.infectBy(tuFlags);
            result2.append(substr);
        }
        return result2;
    }

    @JRubyMethod(name={"scan"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject scan19(ThreadContext context, IRubyObject arg2, Block block) {
        Regex prepared;
        Regex pattern;
        int tuFlags;
        RubyRegexp regexp2;
        Ruby runtime = context.runtime;
        Encoding enc = this.value.getEncoding();
        if (arg2 instanceof RubyRegexp) {
            regexp2 = (RubyRegexp)arg2;
            tuFlags = regexp2.flags;
            pattern = regexp2.getPattern();
            prepared = regexp2.preparePattern(this);
        } else {
            regexp2 = null;
            tuFlags = arg2.isTaint() ? 8 : 0;
            pattern = this.getStringPattern19(runtime, arg2);
            prepared = RubyRegexp.preparePattern(runtime, pattern, this);
        }
        if (block.isGiven()) {
            return this.scanIter19(context, pattern, prepared, enc, block, regexp2, tuFlags);
        }
        return this.scanNoIter19(context, pattern, prepared, enc, regexp2, tuFlags);
    }

    private IRubyObject scanIter19(ThreadContext context, Regex pattern, Regex prepared, Encoding enc, Block block, RubyRegexp regexp2, int tuFlags) {
        Ruby runtime = context.runtime;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int begin2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int range = begin2 + len;
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        int end2 = 0;
        IRubyObject match2 = null;
        if (pattern.numberOfCaptures() == 0) {
            while (RubyRegexp.matcherSearch(runtime, matcher, begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
                ((RubyMatchData)match2).regexp = regexp2;
                RubyString substr = this.makeShared19(runtime, matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
                substr.infectBy(tuFlags);
                ((RubyBasicObject)match2).infectBy(tuFlags);
                context.setBackRef(match2);
                block.yield(context, substr);
                this.modifyCheck(bytes2, len, enc);
            }
        } else {
            while (RubyRegexp.matcherSearch(runtime, matcher, begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
                ((RubyMatchData)match2).regexp = regexp2;
                ((RubyBasicObject)match2).infectBy(tuFlags);
                context.setBackRef(match2);
                block.yield(context, this.populateCapturesForScan(runtime, matcher, range, tuFlags, true));
                this.modifyCheck(bytes2, len, enc);
            }
        }
        context.setBackRef(match2 == null ? runtime.getNil() : match2);
        return this;
    }

    private IRubyObject scanNoIter19(ThreadContext context, Regex pattern, Regex prepared, Encoding enc, RubyRegexp regexp2, int tuFlags) {
        Ruby runtime = context.runtime;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int begin2 = this.value.getBegin();
        int range = begin2 + this.value.getRealSize();
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        RubyArray ary = runtime.newArray();
        int end2 = 0;
        if (pattern.numberOfCaptures() == 0) {
            while (RubyRegexp.matcherSearch(runtime, matcher, begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                RubyString substr = this.makeShared19(runtime, matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
                substr.infectBy(tuFlags);
                ary.append(substr);
            }
        } else {
            while (RubyRegexp.matcherSearch(runtime, matcher, begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                ary.append(this.populateCapturesForScan(runtime, matcher, range, tuFlags, true));
            }
        }
        if (ary.size() > 0) {
            RubyMatchData match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
            match2.regexp = regexp2;
            match2.infectBy(tuFlags);
            context.setBackRef(match2);
        } else {
            context.setBackRef(runtime.getNil());
        }
        return ary;
    }

    @JRubyMethod(name={"start_with?"})
    public IRubyObject start_with_p(ThreadContext context) {
        return context.runtime.getFalse();
    }

    @JRubyMethod(name={"start_with?"})
    public IRubyObject start_with_p(ThreadContext context, IRubyObject arg2) {
        return this.start_with_pCommon(arg2) ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    @JRubyMethod(name={"start_with?"}, rest=true)
    public IRubyObject start_with_p(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!this.start_with_pCommon(args2[i2])) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    private boolean start_with_pCommon(IRubyObject arg2) {
        IRubyObject tmp = arg2.checkStringType();
        if (tmp.isNil()) {
            return false;
        }
        RubyString otherString = (RubyString)tmp;
        this.checkEncoding(otherString);
        if (this.value.getRealSize() < otherString.value.getRealSize()) {
            return false;
        }
        return this.value.startsWith(otherString.value);
    }

    @JRubyMethod(name={"end_with?"})
    public IRubyObject end_with_p(ThreadContext context) {
        return context.runtime.getFalse();
    }

    @JRubyMethod(name={"end_with?"})
    public IRubyObject end_with_p(ThreadContext context, IRubyObject arg2) {
        return this.end_with_pCommon(arg2) ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    @JRubyMethod(name={"end_with?"}, rest=true)
    public IRubyObject end_with_p(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!this.end_with_pCommon(args2[i2])) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    private boolean end_with_pCommon(IRubyObject arg2) {
        IRubyObject tmp = arg2.checkStringType();
        if (tmp.isNil()) {
            return false;
        }
        RubyString otherString = (RubyString)tmp;
        int otherLength = otherString.value.getRealSize();
        Encoding enc = this.checkEncoding(otherString);
        if (this.value.getRealSize() < otherLength) {
            return false;
        }
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        if (otherLength == 0) {
            return true;
        }
        int s2 = end2 - otherLength;
        if (enc.leftAdjustCharHead(this.value.getUnsafeBytes(), p2, s2, end2) != s2) {
            return false;
        }
        return this.value.endsWith(otherString.value);
    }

    private IRubyObject justify(IRubyObject arg0, int jflag) {
        Ruby runtime = this.getRuntime();
        return this.justifyCommon(runtime, SPACE_BYTELIST, RubyFixnum.num2int(arg0), jflag);
    }

    private IRubyObject justify(IRubyObject arg0, IRubyObject arg1, int jflag) {
        Ruby runtime = this.getRuntime();
        RubyString padStr = arg1.convertToString();
        ByteList pad = padStr.value;
        if (pad.getRealSize() == 0) {
            throw runtime.newArgumentError("zero width padding");
        }
        int width = RubyFixnum.num2int(arg0);
        RubyString result2 = this.justifyCommon(runtime, pad, width, jflag);
        if (this.value.getRealSize() < width) {
            result2.infectBy(padStr);
        }
        return result2;
    }

    private RubyString justifyCommon(Ruby runtime, ByteList pad, int width, int jflag) {
        if (width < 0 || this.value.getRealSize() >= width) {
            return this.strDup(runtime);
        }
        ByteList res = new ByteList(width);
        res.setRealSize(width);
        int padP = pad.getBegin();
        int padLen = pad.getRealSize();
        byte[] padBytes = pad.getUnsafeBytes();
        int p2 = res.getBegin();
        byte[] bytes2 = res.getUnsafeBytes();
        if (jflag != 108) {
            int n = width - this.value.getRealSize();
            int end2 = p2 + (jflag == 114 ? n : n / 2);
            if (padLen <= 1) {
                while (p2 < end2) {
                    bytes2[p2++] = padBytes[padP];
                }
            } else {
                int q = padP;
                while (p2 + padLen <= end2) {
                    System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                    p2 += padLen;
                }
                while (p2 < end2) {
                    bytes2[p2++] = padBytes[q++];
                }
            }
        }
        System.arraycopy(this.value.getUnsafeBytes(), this.value.getBegin(), bytes2, p2, this.value.getRealSize());
        if (jflag != 114) {
            p2 += this.value.getRealSize();
            int end3 = res.getBegin() + width;
            if (padLen <= 1) {
                while (p2 < end3) {
                    bytes2[p2++] = padBytes[padP];
                }
            } else {
                while (p2 + padLen <= end3) {
                    System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                    p2 += padLen;
                }
                while (p2 < end3) {
                    bytes2[p2++] = padBytes[padP++];
                }
            }
        }
        RubyString result2 = new RubyString(runtime, this.getMetaClass(), res);
        if (!runtime.is1_9() && RubyFixnum.num2int(result2.length()) > RubyFixnum.num2int(this.length()) || runtime.is1_9() && RubyFixnum.num2int(result2.length19()) > RubyFixnum.num2int(this.length19())) {
            result2.infectBy(this);
        }
        return result2;
    }

    private IRubyObject justify19(IRubyObject arg0, int jflag) {
        Ruby runtime = this.getRuntime();
        RubyString result2 = this.justifyCommon(runtime, SPACE_BYTELIST, 1, true, this.value.getEncoding(), RubyFixnum.num2int(arg0), jflag);
        if (this.getCodeRange() != 96) {
            result2.setCodeRange(this.getCodeRange());
        }
        return result2;
    }

    private IRubyObject justify19(IRubyObject arg0, IRubyObject arg1, int jflag) {
        int cr;
        Ruby runtime = this.getRuntime();
        RubyString padStr = arg1.convertToString();
        ByteList pad = padStr.value;
        Encoding enc = this.checkEncoding(padStr);
        int padCharLen = padStr.strLength(enc);
        if (pad.getRealSize() == 0 || padCharLen == 0) {
            throw runtime.newArgumentError("zero width padding");
        }
        int width = RubyFixnum.num2int(arg0);
        RubyString result2 = this.justifyCommon(runtime, pad, padCharLen, padStr.singleByteOptimizable(), enc, width, jflag);
        if (RubyFixnum.num2int(result2.length19()) > RubyFixnum.num2int(this.length19())) {
            result2.infectBy(padStr);
        }
        if ((cr = RubyString.codeRangeAnd(this.getCodeRange(), padStr.getCodeRange())) != 96) {
            result2.setCodeRange(cr);
        }
        return result2;
    }

    private RubyString justifyCommon(Ruby runtime, ByteList pad, int padCharLen, boolean padSinglebyte, Encoding enc, int width, int jflag) {
        int padPP;
        int len = this.strLength(enc);
        if (width < 0 || len >= width) {
            return this.strDup(runtime);
        }
        int n = width - len;
        int llen = jflag == 108 ? 0 : (jflag == 114 ? n : n / 2);
        int rlen = n - llen;
        int padP = pad.getBegin();
        int padLen = pad.getRealSize();
        byte[] padBytes = pad.getUnsafeBytes();
        ByteList res = new ByteList(this.value.getRealSize() + n * padLen / padCharLen + 2);
        int p2 = res.getBegin();
        byte[] bytes2 = res.getUnsafeBytes();
        while (llen > 0) {
            if (padLen <= 1) {
                bytes2[p2++] = padBytes[padP];
                --llen;
                continue;
            }
            if (llen > padCharLen) {
                System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                p2 += padLen;
                llen -= padCharLen;
                continue;
            }
            padPP = padSinglebyte ? padP + llen : StringSupport.nth(enc, padBytes, padP, padP + padLen, llen);
            n = padPP - padP;
            System.arraycopy(padBytes, padP, bytes2, p2, n);
            p2 += n;
            break;
        }
        System.arraycopy(this.value.getUnsafeBytes(), this.value.getBegin(), bytes2, p2, this.value.getRealSize());
        p2 += this.value.getRealSize();
        while (rlen > 0) {
            if (padLen <= 1) {
                bytes2[p2++] = padBytes[padP];
                --rlen;
                continue;
            }
            if (rlen > padCharLen) {
                System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                p2 += padLen;
                rlen -= padCharLen;
                continue;
            }
            padPP = padSinglebyte ? padP + rlen : StringSupport.nth(enc, padBytes, padP, padP + padLen, rlen);
            n = padPP - padP;
            System.arraycopy(padBytes, padP, bytes2, p2, n);
            p2 += n;
            break;
        }
        res.setRealSize(p2);
        RubyString result2 = new RubyString(runtime, this.getMetaClass(), res);
        if (!runtime.is1_9() && RubyFixnum.num2int(result2.length()) > RubyFixnum.num2int(this.length()) || runtime.is1_9() && RubyFixnum.num2int(result2.length19()) > RubyFixnum.num2int(this.length19())) {
            result2.infectBy(this);
        }
        result2.associateEncoding(enc);
        return result2;
    }

    @JRubyMethod(name={"ljust"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject ljust(IRubyObject arg0) {
        return this.justify(arg0, 108);
    }

    @JRubyMethod(name={"ljust"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject ljust(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 108);
    }

    @JRubyMethod(name={"ljust"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject ljust19(IRubyObject arg0) {
        return this.justify19(arg0, 108);
    }

    @JRubyMethod(name={"ljust"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject ljust19(IRubyObject arg0, IRubyObject arg1) {
        return this.justify19(arg0, arg1, 108);
    }

    @JRubyMethod(name={"rjust"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rjust(IRubyObject arg0) {
        return this.justify(arg0, 114);
    }

    @JRubyMethod(name={"rjust"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rjust(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 114);
    }

    @JRubyMethod(name={"rjust"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rjust19(IRubyObject arg0) {
        return this.justify19(arg0, 114);
    }

    @JRubyMethod(name={"rjust"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rjust19(IRubyObject arg0, IRubyObject arg1) {
        return this.justify19(arg0, arg1, 114);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject center(IRubyObject arg0) {
        return this.justify(arg0, 99);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject center(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 99);
    }

    @JRubyMethod(name={"center"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject center19(IRubyObject arg0) {
        return this.justify19(arg0, 99);
    }

    @JRubyMethod(name={"center"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject center19(IRubyObject arg0, IRubyObject arg1) {
        return this.justify19(arg0, arg1, 99);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject partition(ThreadContext context, Block block) {
        return RubyEnumerable.partition(context, this, block);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject partition(ThreadContext context, IRubyObject arg2, Block block) {
        RubyString sep;
        int pos2;
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regex = (RubyRegexp)arg2;
            IRubyObject[] holder = new IRubyObject[]{context.nil};
            pos2 = regex.search19(context, this, 0, false, holder);
            context.setBackRef(holder[0]);
            if (pos2 < 0) {
                return this.partitionMismatch(runtime);
            }
            sep = (RubyString)this.subpat19(runtime, context, regex);
            if (pos2 == 0 && sep.value.getRealSize() == 0) {
                return this.partitionMismatch(runtime);
            }
        } else {
            IRubyObject tmp = arg2.checkStringType();
            if (tmp.isNil()) {
                throw runtime.newTypeError("type mismatch: " + arg2.getMetaClass().getName() + " given");
            }
            sep = (RubyString)tmp;
            pos2 = this.strIndex19(sep, 0);
            if (pos2 < 0) {
                return this.partitionMismatch(runtime);
            }
        }
        return RubyArray.newArray(runtime, new IRubyObject[]{this.makeShared19(runtime, 0, pos2), sep, this.makeShared19(runtime, pos2 + sep.value.getRealSize(), this.value.getRealSize() - pos2 - sep.value.getRealSize())});
    }

    private IRubyObject partitionMismatch(Ruby runtime) {
        return RubyArray.newArray(runtime, new IRubyObject[]{this, RubyString.newEmptyString(runtime), RubyString.newEmptyString(runtime)});
    }

    @JRubyMethod(name={"rpartition"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject rpartition(ThreadContext context, IRubyObject arg2) {
        RubyString sep;
        int pos2;
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regex = (RubyRegexp)arg2;
            IRubyObject[] holder = new IRubyObject[]{context.nil};
            pos2 = regex.search19(context, this, this.value.getRealSize(), true, holder);
            context.setBackRef(holder[0]);
            if (pos2 < 0) {
                return this.rpartitionMismatch(runtime);
            }
            sep = (RubyString)RubyRegexp.nth_match(0, holder[0]);
        } else {
            IRubyObject tmp = arg2.checkStringType();
            if (tmp.isNil()) {
                throw runtime.newTypeError("type mismatch: " + arg2.getMetaClass().getName() + " given");
            }
            sep = (RubyString)tmp;
            pos2 = this.strRindex19(sep, this.subLength(this.value.getRealSize()));
            if (pos2 < 0) {
                return this.rpartitionMismatch(runtime);
            }
        }
        return RubyArray.newArray(runtime, new IRubyObject[]{this.substr19(runtime, 0, pos2), sep, this.substr19(runtime, pos2 + sep.strLength(), this.value.getRealSize())});
    }

    private IRubyObject rpartitionMismatch(Ruby runtime) {
        return RubyArray.newArray(runtime, new IRubyObject[]{RubyString.newEmptyString(runtime), RubyString.newEmptyString(runtime), this});
    }

    @JRubyMethod(name={"chop"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject chop(ThreadContext context) {
        if (this.value.getRealSize() == 0) {
            return RubyString.newEmptyString(context.runtime, this.getMetaClass()).infectBy(this);
        }
        return this.makeShared(context.runtime, 0, this.choppedLength());
    }

    @JRubyMethod(name={"chop!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject chop_bang(ThreadContext context) {
        if (this.value.getRealSize() == 0) {
            return context.runtime.getNil();
        }
        this.view(0, this.choppedLength());
        return this;
    }

    private int choppedLength() {
        int end2 = this.value.getRealSize() - 1;
        if (this.value.getUnsafeBytes()[this.value.getBegin() + end2] == 10 && end2 > 0 && this.value.getUnsafeBytes()[this.value.getBegin() + end2 - 1] == 13) {
            --end2;
        }
        return end2;
    }

    @JRubyMethod(name={"chop"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chop19(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return RubyString.newEmptyString(runtime, this.getMetaClass(), this.value.getEncoding()).infectBy(this);
        }
        return this.makeShared19(runtime, 0, this.choppedLength19(runtime));
    }

    @JRubyMethod(name={"chop!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chop_bang19(ThreadContext context) {
        this.modifyCheck();
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        this.view(0, this.choppedLength19(runtime));
        if (this.getCodeRange() != 32) {
            this.clearCodeRange();
        }
        return this;
    }

    private int choppedLength19(Ruby runtime) {
        int s2;
        int end2;
        int p2 = this.value.getBegin();
        if (p2 > (end2 = p2 + this.value.getRealSize())) {
            return 0;
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        int s3 = enc.prevCharHead(bytes2, p2, end2, end2);
        if (s3 == -1) {
            return 0;
        }
        if (s3 > p2 && StringSupport.codePoint(runtime, enc, bytes2, s3, end2) == 10 && (s2 = enc.prevCharHead(bytes2, p2, s3, end2)) != -1 && StringSupport.codePoint(runtime, enc, bytes2, s2, end2) == 13) {
            s3 = s2;
        }
        return s3 - p2;
    }

    @JRubyMethod(name={"chomp"}, compat=CompatVersion.RUBY1_8)
    public RubyString chomp(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.chomp_bang(context);
        return str;
    }

    @JRubyMethod(name={"chomp"}, compat=CompatVersion.RUBY1_8)
    public RubyString chomp(ThreadContext context, IRubyObject arg0) {
        RubyString str = this.strDup(context.runtime);
        str.chomp_bang(context, arg0);
        return str;
    }

    @JRubyMethod(name={"chomp!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject chomp_bang(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        IRubyObject rsObj = runtime.getGlobalVariables().get("$/");
        if (rsObj == runtime.getGlobalVariables().getDefaultSeparator()) {
            return this.smartChopBangCommon(runtime);
        }
        return this.chompBangCommon(runtime, rsObj);
    }

    @JRubyMethod(name={"chomp!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject chomp_bang(ThreadContext context, IRubyObject arg0) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        return this.chompBangCommon(runtime, arg0);
    }

    private IRubyObject chompBangCommon(Ruby runtime, IRubyObject rsObj) {
        if (rsObj.isNil()) {
            return rsObj;
        }
        RubyString rs = rsObj.convertToString();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int rslen = rs.value.getRealSize();
        if (rslen == 0) {
            while (len > 0 && bytes2[p2 + len - 1] == 10) {
                if (--len <= 0 || bytes2[p2 + len - 1] != 13) continue;
                --len;
            }
            if (len < this.value.getRealSize()) {
                this.view(0, len);
                return this;
            }
            return runtime.getNil();
        }
        if (rslen > len) {
            return runtime.getNil();
        }
        byte newline = rs.value.getUnsafeBytes()[rslen - 1];
        if (rslen == 1 && newline == 10) {
            return this.smartChopBangCommon(runtime);
        }
        if (bytes2[p2 + len - 1] == newline && rslen <= 1 || this.value.endsWith(rs.value)) {
            this.view(0, this.value.getRealSize() - rslen);
            return this;
        }
        return runtime.getNil();
    }

    private IRubyObject smartChopBangCommon(Ruby runtime) {
        ByteList v = this.value;
        int len = v.getRealSize();
        int p2 = v.getBegin();
        byte[] bytes2 = v.getUnsafeBytes();
        byte b = bytes2[p2 + len - 1];
        if (b == 10) {
            if (--len > 0 && bytes2[p2 + len - 1] == 13) {
                --len;
            }
            this.view(0, len);
        } else if (b == 13) {
            this.view(0, --len);
        } else {
            this.modifyCheck();
            return runtime.getNil();
        }
        return this;
    }

    @JRubyMethod(name={"chomp"}, compat=CompatVersion.RUBY1_9)
    public RubyString chomp19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.chomp_bang19(context);
        return str;
    }

    @JRubyMethod(name={"chomp"}, compat=CompatVersion.RUBY1_9)
    public RubyString chomp19(ThreadContext context, IRubyObject arg0) {
        RubyString str = this.strDup(context.runtime);
        str.chomp_bang19(context, arg0);
        return str;
    }

    @JRubyMethod(name={"chomp!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chomp_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        IRubyObject rsObj = runtime.getGlobalVariables().get("$/");
        if (rsObj == runtime.getGlobalVariables().getDefaultSeparator()) {
            return this.smartChopBangCommon19(runtime);
        }
        return this.chompBangCommon19(runtime, rsObj);
    }

    @JRubyMethod(name={"chomp!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chomp_bang19(ThreadContext context, IRubyObject arg0) {
        this.modifyCheck();
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        return this.chompBangCommon19(runtime, arg0);
    }

    private IRubyObject chompBangCommon19(Ruby runtime, IRubyObject rsObj) {
        if (rsObj.isNil()) {
            return rsObj;
        }
        RubyString rs = rsObj.convertToString();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int rslen = rs.value.getRealSize();
        if (rslen == 0) {
            while (len > 0 && bytes2[p2 + len - 1] == 10) {
                if (--len <= 0 || bytes2[p2 + len - 1] != 13) continue;
                --len;
            }
            if (len < this.value.getRealSize()) {
                this.keepCodeRange();
                this.view(0, len);
                return this;
            }
            return runtime.getNil();
        }
        if (rslen > len) {
            return runtime.getNil();
        }
        byte newline = rs.value.getUnsafeBytes()[rslen - 1];
        if (rslen == 1 && newline == 10) {
            return this.smartChopBangCommon19(runtime);
        }
        Encoding enc = this.checkEncoding(rs);
        if (rs.scanForCodeRange() == 96) {
            return runtime.getNil();
        }
        int pp = end2 - rslen;
        if (bytes2[p2 + len - 1] == newline && rslen <= 1 || this.value.endsWith(rs.value)) {
            if (enc.leftAdjustCharHead(bytes2, p2, pp, end2) != pp) {
                return runtime.getNil();
            }
            if (this.getCodeRange() != 32) {
                this.clearCodeRange();
            }
            this.view(0, this.value.getRealSize() - rslen);
            return this;
        }
        return runtime.getNil();
    }

    private IRubyObject smartChopBangCommon19(Ruby runtime) {
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        this.keepCodeRange();
        if (enc.minLength() > 1) {
            int pp = enc.leftAdjustCharHead(bytes2, p2, end2 - enc.minLength(), end2);
            if (enc.isNewLine(bytes2, pp, end2)) {
                end2 = pp;
            }
            if ((pp = end2 - enc.minLength()) >= p2 && StringSupport.preciseLength(enc, bytes2, pp = enc.leftAdjustCharHead(bytes2, p2, pp, end2), end2) > 0 && enc.mbcToCode(bytes2, pp, end2) == 13) {
                end2 = pp;
            }
            if (end2 == p2 + this.value.getRealSize()) {
                this.modifyCheck();
                return runtime.getNil();
            }
            len = end2 - p2;
            this.view(0, len);
        } else if (bytes2[p2 + len - 1] == 10) {
            if (--len > 0 && bytes2[p2 + len - 1] == 13) {
                --len;
            }
            this.view(0, len);
        } else if (bytes2[p2 + len - 1] == 13) {
            this.view(0, --len);
        } else {
            this.modifyCheck();
            return runtime.getNil();
        }
        return this;
    }

    @JRubyMethod(name={"lstrip"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject lstrip(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.lstrip_bang(context);
        return str;
    }

    @JRubyMethod(name={"lstrip!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject lstrip_bang(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        return this.singleByteLStrip(runtime, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"lstrip"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject lstrip19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.lstrip_bang19(context);
        return str;
    }

    @JRubyMethod(name={"lstrip!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject lstrip_bang19(ThreadContext context) {
        this.modifyCheck();
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        Encoding enc = this.value.getEncoding();
        int s2 = this.value.getBegin();
        int end2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        IRubyObject result2 = this.singleByteOptimizable(enc) ? this.singleByteLStrip(runtime, bytes2, s2, end2) : this.multiByteLStrip(runtime, enc, bytes2, s2, end2);
        this.keepCodeRange();
        return result2;
    }

    private IRubyObject singleByteLStrip(Ruby runtime, byte[] bytes2, int s2, int end2) {
        int p2;
        for (p2 = s2; p2 < end2 && ASCII.isSpace(bytes2[p2] & 0xFF); ++p2) {
        }
        if (p2 > s2) {
            this.view(p2 - s2, end2 - p2);
            return this;
        }
        return runtime.getNil();
    }

    private IRubyObject multiByteLStrip(Ruby runtime, Encoding enc, byte[] bytes2, int s2, int end2) {
        int p2;
        int c;
        for (p2 = s2; p2 < end2 && ASCII.isSpace(c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2)); p2 += StringSupport.codeLength(runtime, enc, c)) {
        }
        if (p2 > s2) {
            this.view(p2 - s2, end2 - p2);
            return this;
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"rstrip"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rstrip(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.rstrip_bang(context);
        return str;
    }

    @JRubyMethod(name={"rstrip!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rstrip_bang(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        return this.singleByteRStrip(runtime, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"rstrip"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rstrip19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.rstrip_bang19(context);
        return str;
    }

    @JRubyMethod(name={"rstrip!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rstrip_bang19(ThreadContext context) {
        this.modifyCheck();
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        IRubyObject result2 = this.singleByteOptimizable(this.value.getEncoding()) ? this.singleByteRStrip19(runtime) : this.multiByteRStrip19(runtime);
        this.keepCodeRange();
        return result2;
    }

    private IRubyObject singleByteRStrip(Ruby runtime, byte[] bytes2, int s2, int end2) {
        int endp;
        for (endp = end2 - 1; endp >= s2 && bytes2[endp] == 0; --endp) {
        }
        while (endp >= s2 && ASCII.isSpace(bytes2[endp] & 0xFF)) {
            --endp;
        }
        if (endp < end2 - 1) {
            this.view(0, endp - s2 + 1);
            return this;
        }
        return runtime.getNil();
    }

    private IRubyObject singleByteRStrip19(Ruby runtime) {
        int endp;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int start2 = this.value.getBegin();
        int end2 = start2 + this.value.getRealSize();
        for (endp = end2 - 1; endp >= start2 && (bytes2[endp] == 0 || ASCII.isSpace(bytes2[endp] & 0xFF)); --endp) {
        }
        if (endp < end2 - 1) {
            this.view(0, endp - start2 + 1);
            return this;
        }
        return runtime.getNil();
    }

    private IRubyObject multiByteRStrip19(Ruby runtime) {
        int point;
        int prev;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int start2 = this.value.getBegin();
        int end2 = start2 + this.value.getRealSize();
        Encoding enc = this.value.getEncoding();
        int endp = end2;
        while ((prev = enc.prevCharHead(bytes2, start2, endp, end2)) != -1 && ((point = StringSupport.codePoint(runtime, enc, bytes2, prev, end2)) == 0 || ASCII.isSpace(point))) {
            endp = prev;
        }
        if (endp < end2) {
            this.view(0, endp - start2);
            return this;
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"strip"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject strip(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.strip_bang(context);
        return str;
    }

    @JRubyMethod(name={"strip!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject strip_bang(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        return this.singleByteStrip(runtime, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"strip"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject strip19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.strip_bang19(context);
        return str;
    }

    @JRubyMethod(name={"strip!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject strip_bang19(ThreadContext context) {
        this.modifyCheck();
        IRubyObject left2 = this.lstrip_bang19(context);
        IRubyObject right = this.rstrip_bang19(context);
        return left2.isNil() && right.isNil() ? context.runtime.getNil() : this;
    }

    private IRubyObject singleByteStrip(Ruby runtime, byte[] bytes2, int s2, int end2) {
        int endp;
        int p2;
        for (p2 = s2; p2 < end2 && ASCII.isSpace(bytes2[p2] & 0xFF); ++p2) {
        }
        for (endp = end2 - 1; endp >= p2 && bytes2[endp] == 0; --endp) {
        }
        while (endp >= p2 && ASCII.isSpace(bytes2[endp] & 0xFF)) {
            --endp;
        }
        if (p2 > s2 || endp < end2 - 1) {
            this.view(p2 - s2, endp - p2 + 1);
            return this;
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject count(ThreadContext context) {
        throw context.runtime.newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject count(ThreadContext context, IRubyObject arg2) {
        boolean[] table = new boolean[256];
        arg2.convertToString().trSetupTable(table, true);
        return this.countCommon(context.runtime, table);
    }

    @JRubyMethod(name={"count"}, required=1, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject count(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return RubyFixnum.zero(runtime);
        }
        boolean[] table = new boolean[256];
        args2[0].convertToString().trSetupTable(table, true);
        for (int i2 = 1; i2 < args2.length; ++i2) {
            args2[i2].convertToString().trSetupTable(table, false);
        }
        return this.countCommon(runtime, table);
    }

    private IRubyObject countCommon(Ruby runtime, boolean[] table) {
        int i2 = 0;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        while (p2 < end2) {
            if (!table[bytes2[p2++] & 0xFF]) continue;
            ++i2;
        }
        return runtime.newFixnum(i2);
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject count19(ThreadContext context) {
        throw context.runtime.newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject count19(ThreadContext context, IRubyObject arg2) {
        int c;
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return RubyFixnum.zero(runtime);
        }
        RubyString otherStr = arg2.convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        if (otherStr.value.length() == 1 && enc.isAsciiCompatible() && (c = otherStr.value.unsafeBytes()[otherStr.value.getBegin()] & 0xFF) < 128 && this.scanForCodeRange() != 96) {
            if (this.value.length() == 0) {
                return RubyFixnum.zero(runtime);
            }
            byte[] bytes2 = this.value.unsafeBytes();
            int p2 = this.value.getBegin();
            int end2 = p2 + this.value.length();
            int n = 0;
            while (p2 < end2) {
                if ((bytes2[p2++] & 0xFF) != c) continue;
                ++n;
            }
            return RubyFixnum.newFixnum(runtime, n);
        }
        boolean[] table = new boolean[257];
        TrTables tables = otherStr.trSetupTable(context.runtime, table, null, true, enc);
        return this.countCommon19(runtime, table, tables, enc);
    }

    @JRubyMethod(name={"count"}, required=1, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject count19(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return RubyFixnum.zero(runtime);
        }
        RubyString otherStr = args2[0].convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] table = new boolean[257];
        TrTables tables = otherStr.trSetupTable(runtime, table, null, true, enc);
        for (int i2 = 1; i2 < args2.length; ++i2) {
            otherStr = args2[i2].convertToString();
            enc = this.checkEncoding(otherStr);
            tables = otherStr.trSetupTable(runtime, table, tables, false, enc);
        }
        return this.countCommon19(runtime, table, tables, enc);
    }

    private IRubyObject countCommon19(Ruby runtime, boolean[] table, TrTables tables, Encoding enc) {
        int i2 = 0;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        while (p2 < end2) {
            int c;
            if (enc.isAsciiCompatible() && (c = bytes2[p2] & 0xFF) < 128) {
                if (table[c]) {
                    ++i2;
                }
                ++p2;
                continue;
            }
            c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2);
            int cl = StringSupport.codeLength(runtime, enc, c);
            if (this.trFind(c, table, tables)) {
                ++i2;
            }
            p2 += cl;
        }
        return runtime.newFixnum(i2);
    }

    @JRubyMethod(name={"delete"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete(ThreadContext context) {
        throw context.runtime.newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"delete"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete(ThreadContext context, IRubyObject arg2) {
        RubyString str = this.strDup(context.runtime);
        str.delete_bang(context, arg2);
        return str;
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.runtime);
        str.delete_bang(context, args2);
        return str;
    }

    @JRubyMethod(name={"delete!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete_bang(ThreadContext context) {
        throw context.runtime.newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"delete!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete_bang(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        arg2.convertToString().trSetupTable(squeeze2, true);
        return this.delete_bangCommon(runtime, squeeze2);
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete_bang(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        args2[0].convertToString().trSetupTable(squeeze2, true);
        for (int i2 = 1; i2 < args2.length; ++i2) {
            args2[i2].convertToString().trSetupTable(squeeze2, false);
        }
        return this.delete_bangCommon(runtime, squeeze2);
    }

    private IRubyObject delete_bangCommon(Ruby runtime, boolean[] squeeze2) {
        int s2;
        this.modify();
        int t = s2 = this.value.getBegin();
        int send2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        boolean modify = false;
        while (s2 < send2) {
            if (squeeze2[bytes2[s2] & 0xFF]) {
                modify = true;
            } else {
                bytes2[t++] = bytes2[s2];
            }
            ++s2;
        }
        this.value.setRealSize(t - this.value.getBegin());
        return modify ? this : runtime.getNil();
    }

    @JRubyMethod(name={"delete"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete19(ThreadContext context) {
        throw context.runtime.newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"delete"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete19(ThreadContext context, IRubyObject arg2) {
        RubyString str = this.strDup(context.runtime);
        str.delete_bang19(context, arg2);
        return str;
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete19(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.runtime);
        str.delete_bang19(context, args2);
        return str;
    }

    @JRubyMethod(name={"delete!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete_bang19(ThreadContext context) {
        throw context.runtime.newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"delete!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete_bang19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        RubyString otherStr = arg2.convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] squeeze2 = new boolean[257];
        TrTables tables = otherStr.trSetupTable(runtime, squeeze2, null, true, enc);
        return this.delete_bangCommon19(runtime, squeeze2, tables, enc);
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete_bang19(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        RubyString otherStr = args2[0].convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] squeeze2 = new boolean[257];
        TrTables tables = otherStr.trSetupTable(runtime, squeeze2, null, true, enc);
        for (int i2 = 1; i2 < args2.length; ++i2) {
            otherStr = args2[i2].convertToString();
            enc = this.checkEncoding(otherStr);
            tables = otherStr.trSetupTable(runtime, squeeze2, tables, false, enc);
        }
        return this.delete_bangCommon19(runtime, squeeze2, tables, enc);
    }

    private IRubyObject delete_bangCommon19(Ruby runtime, boolean[] squeeze2, TrTables tables, Encoding enc) {
        int cr;
        int s2;
        this.modifyAndKeepCodeRange();
        int t = s2 = this.value.getBegin();
        int send2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        boolean modify = false;
        boolean asciiCompatible = enc.isAsciiCompatible();
        int n = cr = asciiCompatible ? 32 : 64;
        while (s2 < send2) {
            int c;
            if (asciiCompatible && Encoding.isAscii(c = bytes2[s2] & 0xFF)) {
                if (squeeze2[c]) {
                    modify = true;
                } else {
                    if (t != s2) {
                        bytes2[t] = (byte)c;
                    }
                    ++t;
                }
                ++s2;
                continue;
            }
            c = StringSupport.codePoint(runtime, enc, bytes2, s2, send2);
            int cl = StringSupport.codeLength(runtime, enc, c);
            if (this.trFind(c, squeeze2, tables)) {
                modify = true;
            } else {
                if (t != s2) {
                    enc.codeToMbc(c, bytes2, t);
                }
                t += cl;
                if (cr == 32) {
                    cr = 64;
                }
            }
            s2 += cl;
        }
        this.value.setRealSize(t - this.value.getBegin());
        this.setCodeRange(cr);
        return modify ? this : runtime.getNil();
    }

    @JRubyMethod(name={"squeeze"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.squeeze_bang(context);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze(ThreadContext context, IRubyObject arg2) {
        RubyString str = this.strDup(context.runtime);
        str.squeeze_bang(context, arg2);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.runtime);
        str.squeeze_bang(context, args2);
        return str;
    }

    @JRubyMethod(name={"squeeze!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze_bang(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            squeeze2[i2] = true;
        }
        this.modify();
        return this.squeezeCommon(runtime, squeeze2);
    }

    @JRubyMethod(name={"squeeze!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze_bang(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        arg2.convertToString().trSetupTable(squeeze2, true);
        this.modify();
        return this.squeezeCommon(runtime, squeeze2);
    }

    @JRubyMethod(name={"squeeze!"}, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze_bang(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            return this.squeeze_bang(context);
        }
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        args2[0].convertToString().trSetupTable(squeeze2, true);
        for (int i2 = 1; i2 < args2.length; ++i2) {
            args2[i2].convertToString().trSetupTable(squeeze2, false);
        }
        this.modify();
        return this.squeezeCommon(runtime, squeeze2);
    }

    private IRubyObject squeezeCommon(Ruby runtime, boolean[] squeeze2) {
        int s2;
        int t = s2 = this.value.getBegin();
        int send2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int save = -1;
        while (s2 < send2) {
            int c;
            if ((c = bytes2[s2++] & 0xFF) == save && squeeze2[c]) continue;
            int n = t++;
            save = c;
            bytes2[n] = (byte)save;
        }
        if (t - this.value.getBegin() != this.value.getRealSize()) {
            this.value.setRealSize(t - this.value.getBegin());
            return this;
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"squeeze"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.squeeze_bang19(context);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze19(ThreadContext context, IRubyObject arg2) {
        RubyString str = this.strDup(context.runtime);
        str.squeeze_bang19(context, arg2);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze19(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.runtime);
        str.squeeze_bang19(context, args2);
        return str;
    }

    @JRubyMethod(name={"squeeze!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            squeeze2[i2] = true;
        }
        this.modifyAndKeepCodeRange();
        if (this.singleByteOptimizable()) {
            return this.squeezeCommon(runtime, squeeze2);
        }
        return this.squeezeCommon19(runtime, squeeze2, null, this.value.getEncoding(), false);
    }

    @JRubyMethod(name={"squeeze!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze_bang19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        RubyString otherStr = arg2.convertToString();
        boolean[] squeeze2 = new boolean[257];
        TrTables tables = otherStr.trSetupTable(runtime, squeeze2, null, true, this.checkEncoding(otherStr));
        this.modifyAndKeepCodeRange();
        if (this.singleByteOptimizable() && otherStr.singleByteOptimizable()) {
            return this.squeezeCommon(runtime, squeeze2);
        }
        return this.squeezeCommon19(runtime, squeeze2, tables, this.value.getEncoding(), true);
    }

    @JRubyMethod(name={"squeeze!"}, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze_bang19(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        RubyString otherStr = args2[0].convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] squeeze2 = new boolean[257];
        TrTables tables = otherStr.trSetupTable(runtime, squeeze2, null, true, enc);
        boolean singlebyte = this.singleByteOptimizable() && otherStr.singleByteOptimizable();
        for (int i2 = 1; i2 < args2.length; ++i2) {
            otherStr = args2[i2].convertToString();
            enc = this.checkEncoding(otherStr);
            singlebyte = singlebyte && otherStr.singleByteOptimizable();
            tables = otherStr.trSetupTable(runtime, squeeze2, tables, false, enc);
        }
        this.modifyAndKeepCodeRange();
        if (singlebyte) {
            return this.squeezeCommon(runtime, squeeze2);
        }
        return this.squeezeCommon19(runtime, squeeze2, tables, enc, true);
    }

    private IRubyObject squeezeCommon19(Ruby runtime, boolean[] squeeze2, TrTables tables, Encoding enc, boolean isArg) {
        int s2;
        int t = s2 = this.value.getBegin();
        int send2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int save = -1;
        while (s2 < send2) {
            int c;
            if (enc.isAsciiCompatible() && (c = bytes2[s2] & 0xFF) < 128) {
                if (c != save || isArg && !squeeze2[c]) {
                    int n = t++;
                    save = c;
                    bytes2[n] = (byte)save;
                }
                ++s2;
                continue;
            }
            c = StringSupport.codePoint(runtime, enc, bytes2, s2, send2);
            int cl = StringSupport.codeLength(runtime, enc, c);
            if (c != save || isArg && !this.trFind(c, squeeze2, tables)) {
                if (t != s2) {
                    enc.codeToMbc(c, bytes2, t);
                }
                save = c;
                t += cl;
            }
            s2 += cl;
        }
        if (t - this.value.getBegin() != this.value.getRealSize()) {
            this.value.setRealSize(t - this.value.getBegin());
            return this;
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"tr"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject tr(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.runtime);
        str.trTrans(context, src, repl, false);
        return str;
    }

    @JRubyMethod(name={"tr!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject tr_bang(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans(context, src, repl, false);
    }

    @JRubyMethod(name={"tr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject tr19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.runtime);
        str.trTrans19(context, src, repl, false);
        return str;
    }

    @JRubyMethod(name={"tr!"})
    public IRubyObject tr_bang19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans19(context, src, repl, false);
    }

    private void trSetupTable(boolean[] table, boolean init) {
        int c;
        TR tr2 = new TR(this.value);
        boolean cflag = false;
        if (this.value.getRealSize() > 1 && this.value.getUnsafeBytes()[this.value.getBegin()] == 94) {
            cflag = true;
            ++tr2.p;
        }
        if (init) {
            for (int i2 = 0; i2 < 256; ++i2) {
                table[i2] = true;
            }
        }
        boolean[] buf = new boolean[256];
        for (int i3 = 0; i3 < 256; ++i3) {
            buf[i3] = cflag;
        }
        while ((c = this.trNext(tr2)) >= 0) {
            buf[c & 0xFF] = !cflag;
        }
        for (int i4 = 0; i4 < 256; ++i4) {
            table[i4] = table[i4] && buf[i4];
        }
    }

    private TrTables trSetupTable(Ruby runtime, boolean[] table, TrTables tables, boolean init, Encoding enc) {
        int c;
        TR tr2 = new TR(this.value);
        boolean cflag = false;
        if (this.value.getRealSize() > 1) {
            if (enc.isAsciiCompatible()) {
                if ((this.value.getUnsafeBytes()[this.value.getBegin()] & 0xFF) == 94) {
                    cflag = true;
                    ++tr2.p;
                }
            } else {
                int l = StringSupport.preciseLength(enc, tr2.buf, tr2.p, tr2.pend);
                if (enc.mbcToCode(tr2.buf, tr2.p, tr2.pend) == 94) {
                    cflag = true;
                    tr2.p += l;
                }
            }
        }
        if (init) {
            for (int i2 = 0; i2 < 256; ++i2) {
                table[i2] = true;
            }
            table[256] = cflag;
        } else if (table[256] && !cflag) {
            table[256] = false;
        }
        boolean[] buf = new boolean[256];
        for (int i3 = 0; i3 < 256; ++i3) {
            buf[i3] = cflag;
        }
        IntHash<IRubyObject> hash2 = null;
        IntHash phash = null;
        while ((c = this.trNext(tr2, runtime, enc)) >= 0) {
            if (c < 256) {
                buf[c & 0xFF] = !cflag;
                continue;
            }
            if (hash2 == null) {
                hash2 = new IntHash<IRubyObject>();
                if (tables == null) {
                    tables = new TrTables();
                }
                if (cflag) {
                    phash = tables.noDel;
                    tables.noDel = hash2;
                } else {
                    phash = tables.del;
                    tables.del = hash2;
                }
            }
            if (phash != null && phash.get(c) == null) continue;
            hash2.put(c, NEVER);
        }
        for (int i4 = 0; i4 < 256; ++i4) {
            table[i4] = table[i4] && buf[i4];
        }
        return tables;
    }

    private boolean trFind(int c, boolean[] table, TrTables tables) {
        if (c < 256) {
            return table[c];
        }
        if (tables != null) {
            if (tables.del != null) {
                if (tables.noDel == null || tables.noDel.get(c) == null) {
                    return true;
                }
            } else if (tables.noDel != null && tables.noDel.get(c) != null) {
                return false;
            }
        }
        return table[256];
    }

    private IRubyObject trTrans(ThreadContext context, IRubyObject src, IRubyObject repl, boolean sflag) {
        int s2;
        int c;
        int i2;
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        ByteList replList = repl.convertToString().value;
        if (replList.getRealSize() == 0) {
            return this.delete_bang(context, src);
        }
        ByteList srcList = src.convertToString().value;
        TR trSrc = new TR(srcList);
        boolean cflag = false;
        if (srcList.getRealSize() >= 2 && srcList.getUnsafeBytes()[srcList.getBegin()] == 94) {
            cflag = true;
            ++trSrc.p;
        }
        int[] trans = new int[256];
        TR trRepl = new TR(replList);
        if (cflag) {
            for (i2 = 0; i2 < 256; ++i2) {
                trans[i2] = 1;
            }
            while ((c = this.trNext(trSrc)) >= 0) {
                trans[c & 0xFF] = -1;
            }
            while ((c = this.trNext(trRepl)) >= 0) {
            }
            for (i2 = 0; i2 < 256; ++i2) {
                if (trans[i2] < 0) continue;
                trans[i2] = trRepl.now;
            }
        } else {
            for (i2 = 0; i2 < 256; ++i2) {
                trans[i2] = -1;
            }
            while ((c = this.trNext(trSrc)) >= 0) {
                int r = this.trNext(trRepl);
                if (r == -1) {
                    r = trRepl.now;
                }
                trans[c & 0xFF] = r;
            }
        }
        this.modify();
        int send2 = s2 + this.value.getRealSize();
        byte[] sbytes = this.value.getUnsafeBytes();
        boolean modify = false;
        if (sflag) {
            int t = s2;
            int last2 = -1;
            while (s2 < send2) {
                byte c0;
                if ((c = trans[(c0 = sbytes[s2++]) & 0xFF]) >= 0) {
                    if (last2 == c) continue;
                    last2 = c;
                    sbytes[t++] = (byte)(c & 0xFF);
                    modify = true;
                    continue;
                }
                last2 = -1;
                sbytes[t++] = c0;
            }
            if (this.value.getRealSize() > t - this.value.getBegin()) {
                this.value.setRealSize(t - this.value.getBegin());
                modify = true;
            }
        } else {
            for (s2 = this.value.getBegin(); s2 < send2; ++s2) {
                c = trans[sbytes[s2] & 0xFF];
                if (c < 0) continue;
                sbytes[s2] = (byte)(c & 0xFF);
                modify = true;
            }
        }
        return modify ? this : runtime.getNil();
    }

    private IRubyObject trTrans19(ThreadContext context, IRubyObject src, IRubyObject repl, boolean sflag) {
        int s2;
        int c;
        int i2;
        Encoding e2;
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        RubyString replStr = repl.convertToString();
        ByteList replList = replStr.value;
        if (replList.getRealSize() == 0) {
            return this.delete_bang19(context, src);
        }
        RubyString srcStr = src.convertToString();
        ByteList srcList = srcStr.value;
        Encoding e1 = this.checkEncoding(srcStr);
        Encoding enc = e1 == (e2 = this.checkEncoding(replStr)) ? e1 : srcStr.checkEncoding(replStr);
        int cr = this.getCodeRange();
        TR trSrc = new TR(srcList);
        boolean cflag = false;
        if (this.value.getRealSize() > 0) {
            if (enc.isAsciiCompatible()) {
                if (trSrc.buf.length > 0 && (trSrc.buf[trSrc.p] & 0xFF) == 94 && trSrc.p + 1 < trSrc.pend) {
                    cflag = true;
                    ++trSrc.p;
                }
            } else {
                int cl = StringSupport.preciseLength(enc, trSrc.buf, trSrc.p, trSrc.pend);
                if (enc.mbcToCode(trSrc.buf, trSrc.p, trSrc.pend) == 94 && trSrc.p + cl < trSrc.pend) {
                    cflag = true;
                    trSrc.p += cl;
                }
            }
        }
        boolean singlebyte = this.singleByteOptimizable();
        int[] trans = new int[256];
        IntHash<Integer> hash2 = null;
        TR trRepl = new TR(replList);
        int last2 = 0;
        if (cflag) {
            for (i2 = 0; i2 < 256; ++i2) {
                trans[i2] = 1;
            }
            while ((c = this.trNext(trSrc, runtime, enc)) >= 0) {
                if (c < 256) {
                    trans[c & 0xFF] = -1;
                    continue;
                }
                if (hash2 == null) {
                    hash2 = new IntHash<Integer>();
                }
                hash2.put(c, 1);
            }
            while ((c = this.trNext(trRepl, runtime, enc)) >= 0) {
            }
            last2 = trRepl.now;
            for (i2 = 0; i2 < 256; ++i2) {
                if (trans[i2] < 0) continue;
                trans[i2] = last2;
            }
        } else {
            for (i2 = 0; i2 < 256; ++i2) {
                trans[i2] = -1;
            }
            while ((c = this.trNext(trSrc, runtime, enc)) >= 0) {
                int r = this.trNext(trRepl, runtime, enc);
                if (r == -1) {
                    r = trRepl.now;
                }
                if (c < 256) {
                    trans[c] = r;
                    if (StringSupport.codeLength(runtime, enc, r) == 1) continue;
                    singlebyte = false;
                    continue;
                }
                if (hash2 == null) {
                    hash2 = new IntHash();
                }
                hash2.put(c, r);
            }
        }
        if (cr == 64) {
            cr = 32;
        }
        this.modifyAndKeepCodeRange();
        int send2 = s2 + this.value.getRealSize();
        byte[] sbytes = this.value.getUnsafeBytes();
        int max2 = this.value.getRealSize();
        boolean modify = false;
        if (sflag) {
            int save = -1;
            byte[] buf = new byte[max2];
            int t = 0;
            while (s2 < send2) {
                boolean mayModify = false;
                int c0 = c = StringSupport.codePoint(runtime, e1, sbytes, s2, send2);
                int clen = StringSupport.codeLength(runtime, e1, c);
                int tlen = enc == e1 ? clen : StringSupport.codeLength(runtime, enc, c);
                s2 += clen;
                if ((c = this.trCode(c, trans, hash2, cflag, last2, false)) != -1) {
                    if (save == c) {
                        if (cr != 32 || Encoding.isAscii(c)) continue;
                        cr = 64;
                        continue;
                    }
                    save = c;
                    tlen = StringSupport.codeLength(runtime, enc, c);
                    modify = true;
                } else {
                    save = -1;
                    c = c0;
                    if (enc != e1) {
                        mayModify = true;
                    }
                }
                while (t + tlen >= max2) {
                    byte[] tbuf = new byte[max2 <<= 1];
                    System.arraycopy(buf, 0, tbuf, 0, buf.length);
                    buf = tbuf;
                }
                enc.codeToMbc(c, buf, t);
                if (mayModify && (tlen == 1 ? sbytes[s2] != buf[t] : ByteList.memcmp(sbytes, s2, buf, t, tlen) != 0)) {
                    modify = true;
                }
                if (cr == 32 && !Encoding.isAscii(c)) {
                    cr = 64;
                }
                t += tlen;
            }
            this.value.setUnsafeBytes(buf);
            this.value.setRealSize(t);
        } else if (enc.isSingleByte() || singlebyte && hash2 == null) {
            for (s2 = this.value.getBegin(); s2 < send2; ++s2) {
                c = sbytes[s2] & 0xFF;
                if (trans[c] != -1) {
                    if (!cflag) {
                        c = trans[c];
                        sbytes[s2] = (byte)c;
                    } else {
                        sbytes[s2] = (byte)last2;
                    }
                    modify = true;
                }
                if (cr != 32 || Encoding.isAscii(c)) continue;
                cr = 64;
            }
        } else {
            max2 += max2 >> 1;
            byte[] buf = new byte[max2];
            int t = 0;
            while (s2 < send2) {
                boolean mayModify = false;
                int c0 = c = StringSupport.codePoint(runtime, e1, sbytes, s2, send2);
                int clen = StringSupport.codeLength(runtime, e1, c);
                int tlen = enc == e1 ? clen : StringSupport.codeLength(runtime, enc, c);
                if ((c = this.trCode(c, trans, hash2, cflag, last2, true)) != -1) {
                    tlen = StringSupport.codeLength(runtime, enc, c);
                    modify = true;
                } else {
                    c = c0;
                    if (enc != e1) {
                        mayModify = true;
                    }
                }
                while (t + tlen >= max2) {
                    byte[] tbuf = new byte[max2 <<= 1];
                    System.arraycopy(buf, 0, tbuf, 0, buf.length);
                    buf = tbuf;
                }
                enc.codeToMbc(c, buf, t);
                if (mayModify && (tlen == 1 ? sbytes[s2] != buf[t] : ByteList.memcmp(sbytes, s2, buf, t, tlen) != 0)) {
                    modify = true;
                }
                if (cr == 32 && !Encoding.isAscii(c)) {
                    cr = 64;
                }
                s2 += clen;
                t += tlen;
            }
            this.value.setUnsafeBytes(buf);
            this.value.setRealSize(t);
        }
        if (modify) {
            if (cr != 96) {
                this.setCodeRange(cr);
            }
            this.associateEncoding(enc);
            return this;
        }
        return runtime.getNil();
    }

    private int trCode(int c, int[] trans, IntHash<Integer> hash2, boolean cflag, int last2, boolean set) {
        if (c < 256) {
            return trans[c];
        }
        if (hash2 != null) {
            Integer tmp = hash2.get(c);
            if (tmp == null) {
                return cflag ? last2 : -1;
            }
            return cflag ? -1 : tmp;
        }
        return cflag && set ? last2 : -1;
    }

    private int trNext(TR t) {
        byte[] buf = t.buf;
        while (!t.gen) {
            if (t.p == t.pend) {
                return -1;
            }
            if (t.p < t.pend - 1 && buf[t.p] == 92) {
                ++t.p;
            }
            t.now = buf[t.p++] & 0xFF;
            if (t.p < t.pend - 1 && buf[t.p] == 45) {
                ++t.p;
                if (t.p < t.pend) {
                    if (t.now > (buf[t.p] & 0xFF)) {
                        ++t.p;
                        continue;
                    }
                    t.gen = true;
                    t.max = buf[t.p++] & 0xFF;
                }
            }
            return t.now;
        }
        if (++t.now < t.max) {
            return t.now;
        }
        t.gen = false;
        return t.max;
    }

    private int trNext(TR t, Ruby runtime, Encoding enc) {
        byte[] buf = t.buf;
        if (!t.gen) {
            if (t.p == t.pend) {
                return -1;
            }
            if (t.p < t.pend - 1 && buf[t.p] == 92) {
                ++t.p;
            }
            t.now = StringSupport.codePoint(runtime, enc, buf, t.p, t.pend);
            t.p += StringSupport.codeLength(runtime, enc, t.now);
            if (t.p < t.pend - 1 && buf[t.p] == 45) {
                ++t.p;
                if (t.p < t.pend) {
                    int c = StringSupport.codePoint(runtime, enc, buf, t.p, t.pend);
                    t.p += StringSupport.codeLength(runtime, enc, c);
                    if (t.now > c) {
                        if (t.now < 128 && c < 128) {
                            throw runtime.newArgumentError("invalid range \"" + (char)t.now + "-" + (char)c + "\" in string transliteration");
                        }
                        throw runtime.newArgumentError("invalid range in string transliteration");
                    }
                    t.gen = true;
                    t.max = c;
                }
            }
            return t.now;
        }
        if (++t.now < t.max) {
            return t.now;
        }
        t.gen = false;
        return t.max;
    }

    @JRubyMethod(name={"tr_s"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject tr_s(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.runtime);
        str.trTrans(context, src, repl, true);
        return str;
    }

    @JRubyMethod(name={"tr_s!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject tr_s_bang(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans(context, src, repl, true);
    }

    @JRubyMethod(name={"tr_s"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject tr_s19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.runtime);
        str.trTrans19(context, src, repl, true);
        return str;
    }

    @JRubyMethod(name={"tr_s!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject tr_s_bang19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans19(context, src, repl, true);
    }

    public IRubyObject each_line(ThreadContext context, Block block) {
        return this.each_lineCommon(context, context.runtime.getGlobalVariables().get("$/"), block);
    }

    public IRubyObject each_line(ThreadContext context, IRubyObject arg2, Block block) {
        return this.each_lineCommon(context, arg2, block);
    }

    public IRubyObject each_lineCommon(ThreadContext context, IRubyObject sep, Block block) {
        Ruby runtime = context.runtime;
        if (sep.isNil()) {
            block.yield(context, this);
            return this;
        }
        RubyString sepStr = sep.convertToString();
        ByteList sepValue = sepStr.value;
        int rslen = sepValue.getRealSize();
        byte newline = rslen == 0 ? (byte)10 : sepValue.getUnsafeBytes()[sepValue.getBegin() + rslen - 1];
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        int ptr = p2;
        int s2 = p2;
        int len = this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        p2 += rslen;
        while (p2 < end2) {
            if (rslen == 0 && bytes2[p2] == 10) {
                if (++p2 != end2 && bytes2[p2] == 10) {
                    while (p2 < end2 && bytes2[p2] == 10) {
                        ++p2;
                    }
                }
            } else if (ptr < p2 && bytes2[p2 - 1] == newline && (rslen <= 1 || ByteList.memcmp(sepValue.getUnsafeBytes(), sepValue.getBegin(), rslen, bytes2, p2 - rslen, rslen) == 0)) {
                block.yield(context, this.makeShared(runtime, s2 - ptr, p2 - s2).infectBy(this));
                this.modifyCheck(bytes2, len);
                s2 = p2;
            }
            ++p2;
        }
        if (s2 != end2) {
            if (p2 > end2) {
                p2 = end2;
            }
            block.yield(context, this.makeShared(runtime, s2 - ptr, p2 - s2).infectBy(this));
        }
        return this;
    }

    @JRubyMethod(name={"each"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject each18(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_line(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each");
    }

    @JRubyMethod(name={"each"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject each18(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon(context, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", arg2);
    }

    @JRubyMethod(name={"each_line"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject each_line18(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_line(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_line");
    }

    @JRubyMethod(name={"each_line"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject each_line18(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon(context, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", arg2);
    }

    @JRubyMethod(name={"lines"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject lines18(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_line(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "lines");
    }

    @JRubyMethod(name={"lines"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject lines18(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon(context, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "lines", arg2);
    }

    @JRubyMethod(name={"each_line"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_line19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_lineCommon19(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_line");
    }

    @JRubyMethod(name={"each_line"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_line19(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon19(context, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", arg2);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject lines(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_lineCommon19(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "lines");
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject lines(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon19(context, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "lines", arg2);
    }

    @JRubyMethod(name={"lines"}, compat=CompatVersion.RUBY2_0)
    public IRubyObject lines20(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_lineCommon19(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "lines").callMethod(context, "to_a");
    }

    @JRubyMethod(name={"lines"}, compat=CompatVersion.RUBY2_0)
    public IRubyObject lines20(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon19(context, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "lines", arg2).callMethod(context, "to_a");
    }

    private IRubyObject each_lineCommon19(ThreadContext context, Block block) {
        return this.each_lineCommon19(context, context.runtime.getGlobalVariables().get("$/"), block);
    }

    private IRubyObject each_lineCommon19(ThreadContext context, IRubyObject sep, Block block) {
        int p2;
        Ruby runtime = context.runtime;
        if (sep.isNil()) {
            block.yield(context, this);
            return this;
        }
        if (!sep.respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + sep.getMetaClass() + " into String");
        }
        ByteList val = this.value.shallowDup();
        int s2 = p2 = val.getBegin();
        int offset2 = p2;
        int len = val.getRealSize();
        int end2 = p2 + len;
        byte[] bytes2 = val.getUnsafeBytes();
        RubyString sepStr = sep.convertToString();
        if (sepStr == runtime.getGlobalVariables().getDefaultSeparator()) {
            Encoding enc = val.getEncoding();
            while (p2 < end2) {
                int p0;
                if (bytes2[p2] == 10 && enc.isNewLine(bytes2, p0 = enc.leftAdjustCharHead(bytes2, s2, p2, end2), end2)) {
                    p2 = p0 + StringSupport.length(enc, bytes2, p0, end2);
                    block.yield(context, this.makeShared19(runtime, val, s2 - offset2, p2 - s2).infectBy(this));
                    s2 = p2;
                    continue;
                }
                ++p2;
            }
        } else {
            Encoding enc = this.checkEncoding(sepStr);
            ByteList sepValue = sepStr.value;
            int rslen = sepValue.getRealSize();
            int newLine = rslen == 0 ? 10 : StringSupport.codePoint(runtime, enc, sepValue.getUnsafeBytes(), sepValue.getBegin(), sepValue.getBegin() + sepValue.getRealSize());
            while (p2 < end2) {
                int c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2);
                int n = StringSupport.codeLength(runtime, enc, c);
                if (rslen == 0 && c == newLine) {
                    if ((p2 += n) < end2 && (c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2)) != newLine) continue;
                    while (p2 < end2 && StringSupport.codePoint(runtime, enc, bytes2, p2, end2) == newLine) {
                        p2 += n;
                    }
                    p2 -= n;
                }
                if (c == newLine && rslen <= end2 - p2 && (rslen <= 1 || ByteList.memcmp(sepValue.getUnsafeBytes(), sepValue.getBegin(), rslen, bytes2, p2, rslen) == 0)) {
                    block.yield(context, this.makeShared19(runtime, val, s2 - offset2, p2 - s2 + (rslen != 0 ? rslen : n)).infectBy(this));
                    s2 = p2 + (rslen != 0 ? rslen : n);
                }
                p2 += n;
            }
        }
        if (s2 != end2) {
            block.yield(context, this.makeShared19(runtime, val, s2 - offset2, end2 - s2).infectBy(this));
        }
        return this;
    }

    public RubyString each_byte(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        for (int i2 = 0; i2 < this.value.length(); ++i2) {
            block.yield(context, runtime.newFixnum(this.value.get(i2) & 0xFF));
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"})
    public IRubyObject each_byte19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byte(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
    }

    @JRubyMethod
    public IRubyObject bytes(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byte(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "bytes");
    }

    @JRubyMethod(name={"each_char"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject each_char18(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charCommon18(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_char");
    }

    @JRubyMethod(name={"chars"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject chars18(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charCommon18(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "chars");
    }

    private IRubyObject each_charCommon18(ThreadContext context, Block block) {
        int n;
        int p2;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int end2 = p2 + this.value.getRealSize();
        Ruby runtime = context.runtime;
        Encoding enc = runtime.getKCode().getEncoding();
        ByteList val = this.value.shallowDup();
        for (p2 = this.value.getBegin(); p2 < end2; p2 += n) {
            n = StringSupport.length(enc, bytes2, p2, end2);
            block.yield(context, this.makeShared19(runtime, val, p2 - val.getBegin(), n));
        }
        return this;
    }

    @JRubyMethod(name={"each_char"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_char19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charCommon19(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_char");
    }

    @JRubyMethod(name={"chars"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chars19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charCommon19(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "chars");
    }

    private IRubyObject each_charCommon19(ThreadContext context, Block block) {
        int n;
        boolean is7bit;
        int p2;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int end2 = p2 + this.value.getRealSize();
        Encoding enc = this.value.getEncoding();
        Ruby runtime = context.runtime;
        ByteList val = this.value.shallowDup();
        boolean isUSASCII = val.getEncoding() == USASCIIEncoding.INSTANCE;
        boolean bl = is7bit = this.getCodeRange() == 32;
        for (p2 = this.value.getBegin(); p2 < end2; p2 += n) {
            n = is7bit ? 1 : StringSupport.length(enc, bytes2, p2, end2);
            RubyString str = n == 1 && isUSASCII ? RubyString.newStringShared(runtime, RubyFixnum.SINGLE_CHAR_BYTELISTS19[bytes2[p2]], 32) : this.makeShared19(runtime, val, p2 - this.value.getBegin(), n);
            block.yield(context, str);
        }
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_codepoint");
        }
        return this.singleByteOptimizable() ? this.each_byte(context, block) : this.each_codepointCommon(context, block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject codepoints(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "codepoints");
        }
        return this.singleByteOptimizable() ? this.each_byte(context, block) : this.each_codepointCommon(context, block);
    }

    private IRubyObject each_codepointCommon(ThreadContext context, Block block) {
        int n;
        int p2;
        Ruby runtime = context.runtime;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int end2 = p2 + this.value.getRealSize();
        Encoding enc = this.value.getEncoding();
        for (p2 = this.value.getBegin(); p2 < end2; p2 += n) {
            int c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2);
            n = StringSupport.codeLength(runtime, enc, c);
            block.yield(context, runtime.newFixnum(c));
        }
        return this;
    }

    private RubySymbol to_sym() {
        RubySymbol specialCaseIntern = this.checkSpecialCasesIntern(this.value);
        if (specialCaseIntern != null) {
            return specialCaseIntern;
        }
        RubySymbol symbol = this.getRuntime().getSymbolTable().getSymbol(this.value);
        if (symbol.getBytes() == this.value) {
            this.shareLevel = 2;
        }
        return symbol;
    }

    private RubySymbol checkSpecialCasesIntern(ByteList value2) {
        String[][] opTable = this.getRuntime().is1_8() ? opTable18 : opTable19;
        for (int i2 = 0; i2 < opTable.length; ++i2) {
            String op = opTable[i2][1];
            if (!value2.toString().equals(op)) continue;
            return this.getRuntime().getSymbolTable().getSymbol(opTable[i2][0]);
        }
        return null;
    }

    @JRubyMethod(name={"to_sym", "intern"}, compat=CompatVersion.RUBY1_8)
    public RubySymbol intern() {
        if (this.value.getRealSize() == 0) {
            throw this.getRuntime().newArgumentError("interning empty string");
        }
        for (int i2 = 0; i2 < this.value.getRealSize(); ++i2) {
            if (this.value.getUnsafeBytes()[this.value.getBegin() + i2] != 0) continue;
            throw this.getRuntime().newArgumentError("symbol string may not contain '\\0'");
        }
        return this.to_sym();
    }

    @JRubyMethod(name={"to_sym", "intern"}, compat=CompatVersion.RUBY1_9)
    public RubySymbol intern19() {
        return this.to_sym();
    }

    @JRubyMethod(name={"ord"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject ord(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubyFixnum.newFixnum(runtime, StringSupport.codePoint(runtime, this.value.getEncoding(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize()));
    }

    @JRubyMethod(name={"sum"})
    public IRubyObject sum(ThreadContext context) {
        return this.sumCommon(context, 16L);
    }

    @JRubyMethod(name={"sum"})
    public IRubyObject sum(ThreadContext context, IRubyObject arg2) {
        return this.sumCommon(context, RubyNumeric.num2long(arg2));
    }

    public IRubyObject sumCommon(ThreadContext context, long bits) {
        Ruby runtime = context.runtime;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        if (bits >= 64L) {
            RubyFixnum one = RubyFixnum.one(runtime);
            IRubyObject sum2 = RubyFixnum.zero(runtime);
            while (p2 < end2) {
                this.modifyCheck(bytes2, len);
                sum2 = sum2.callMethod(context, "+", RubyFixnum.newFixnum(runtime, bytes2[p2++] & 0xFF));
            }
            if (bits != 0L) {
                IRubyObject mod = one.callMethod(context, "<<", (IRubyObject)RubyFixnum.newFixnum(runtime, bits));
                sum2 = sum2.callMethod(context, "&", mod.callMethod(context, "-", one));
            }
            return sum2;
        }
        long sum3 = 0L;
        while (p2 < end2) {
            this.modifyCheck(bytes2, len);
            sum3 += (long)(bytes2[p2++] & 0xFF);
        }
        return RubyFixnum.newFixnum(runtime, bits == 0L ? sum3 : sum3 & (1L << (int)bits) - 1L);
    }

    @JRubyMethod(name={"to_c"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_c(ThreadContext context) {
        Ruby runtime = context.runtime;
        IRubyObject s2 = Helpers.invoke(context, (IRubyObject)this, "gsub", (IRubyObject)RubyRegexp.newDummyRegexp(runtime, Numeric.ComplexPatterns.underscores_pat), (IRubyObject)runtime.newString(new ByteList(new byte[]{95})));
        RubyArray a = RubyComplex.str_to_c_internal(context, s2);
        if (!a.eltInternal(0).isNil()) {
            return a.eltInternal(0);
        }
        return RubyComplex.newComplexCanonicalize(context, RubyFixnum.zero(runtime));
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext context) {
        Ruby runtime = context.runtime;
        IRubyObject s2 = Helpers.invoke(context, (IRubyObject)this, "gsub", (IRubyObject)RubyRegexp.newDummyRegexp(runtime, Numeric.ComplexPatterns.underscores_pat), (IRubyObject)runtime.newString(new ByteList(new byte[]{95})));
        RubyArray a = RubyRational.str_to_r_internal(context, s2);
        if (!a.eltInternal(0).isNil()) {
            return a.eltInternal(0);
        }
        return RubyRational.newRationalCanonicalize(context, RubyFixnum.zero(runtime));
    }

    public static RubyString unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyString result2 = RubyString.newString(input.getRuntime(), input.unmarshalString());
        input.registerLinkTarget(result2);
        return result2;
    }

    @JRubyMethod(name={"unpack"})
    public RubyArray unpack(IRubyObject obj) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)obj).value);
    }

    public void empty() {
        this.value = ByteList.EMPTY_BYTELIST;
        this.shareLevel = 2;
    }

    @JRubyMethod(name={"encoding"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encoding(ThreadContext context) {
        return context.runtime.getEncodingService().getEncoding(this.value.getEncoding());
    }

    public IRubyObject encode_bang(ThreadContext context, IRubyObject arg0) {
        return this.encode_bang(context, new IRubyObject[]{arg0});
    }

    public IRubyObject encode_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.encode_bang(context, new IRubyObject[]{arg0, arg1});
    }

    public IRubyObject encode_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.encode_bang(context, new IRubyObject[]{arg0, arg1, arg2});
    }

    @JRubyMethod(name={"encode!"}, optional=3, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode_bang(ThreadContext context, IRubyObject[] args2) {
        this.modify19();
        IRubyObject[] newstr_p = new IRubyObject[]{this};
        Encoding encindex = EncodingUtils.strTranscode(context, args2, newstr_p);
        if (encindex == null) {
            return this;
        }
        if (newstr_p[0] == this) {
            this.setEncoding(encindex);
            return this;
        }
        this.replace(newstr_p[0]);
        this.setEncoding(encindex);
        return this;
    }

    @JRubyMethod(name={"encode"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode(ThreadContext context) {
        return EncodingUtils.strEncode(context, this, new IRubyObject[0]);
    }

    @JRubyMethod(name={"encode"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode(ThreadContext context, IRubyObject arg2) {
        return EncodingUtils.strEncode(context, this, arg2);
    }

    @JRubyMethod(name={"encode"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode(ThreadContext context, IRubyObject toEncoding, IRubyObject arg2) {
        return EncodingUtils.strEncode(context, this, toEncoding, arg2);
    }

    @JRubyMethod(name={"encode"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode(ThreadContext context, IRubyObject toEncoding, IRubyObject forcedEncoding, IRubyObject opts) {
        Ruby runtime = context.runtime;
        return EncodingUtils.strEncode(context, this, toEncoding, forcedEncoding, opts);
    }

    private static Encoding getEncoding(Ruby runtime, IRubyObject toEnc) {
        try {
            return runtime.getEncodingService().getEncodingFromObject(toEnc);
        }
        catch (Exception e) {
            throw runtime.newConverterNotFoundError("code converter not found (" + toEnc.toString() + ")");
        }
    }

    @JRubyMethod(name={"force_encoding"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject force_encoding(ThreadContext context, IRubyObject enc) {
        this.modify19();
        Encoding encoding2 = context.runtime.getEncodingService().getEncodingFromObject(enc);
        this.associateEncoding(encoding2);
        this.clearCodeRange();
        return this;
    }

    @JRubyMethod(name={"valid_encoding?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject valid_encoding_p(ThreadContext context) {
        Ruby runtime = context.runtime;
        return this.scanForCodeRange() == 96 ? runtime.getFalse() : runtime.getTrue();
    }

    @JRubyMethod(name={"ascii_only?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject ascii_only_p(ThreadContext context) {
        Ruby runtime = context.runtime;
        return this.scanForCodeRange() == 32 ? runtime.getTrue() : runtime.getFalse();
    }

    public void setValue(CharSequence value2) {
        this.view(ByteList.plain(value2));
    }

    public void setValue(ByteList value2) {
        this.view(value2);
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    public ByteList getByteList() {
        return this.value;
    }

    public String getUnicodeValue() {
        return RubyEncoding.decodeUTF8(this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize());
    }

    private static ByteList encodeBytelist(CharSequence value2, Encoding encoding2) {
        Charset charset = encoding2.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        byte[] bytes2 = RubyEncoding.encode(value2, charset);
        return new ByteList(bytes2, encoding2, false);
    }

    @Override
    public Object toJava(Class target) {
        if (target.isAssignableFrom(String.class)) {
            return this.decodeString();
        }
        if (target.isAssignableFrom(ByteList.class)) {
            return this.value;
        }
        return super.toJava(target);
    }

    private static final class TrTables {
        private IntHash<IRubyObject> del;
        private IntHash<IRubyObject> noDel;

        private TrTables() {
        }
    }

    private static final class TR {
        int p;
        int pend;
        int now;
        int max;
        boolean gen;
        byte[] buf;

        TR(ByteList bytes2) {
            this.p = bytes2.getBegin();
            this.pend = bytes2.getRealSize() + this.p;
            this.buf = bytes2.getUnsafeBytes();
            this.max = 0;
            this.now = 0;
            this.gen = false;
        }
    }

    private static enum NeighborChar {
        NOT_CHAR,
        FOUND,
        WRAPPED;

    }

    private static final class EmptyByteListHolder {
        final ByteList bytes;
        final int cr;

        EmptyByteListHolder(Encoding enc) {
            this.bytes = new ByteList(ByteList.NULL_ARRAY, enc);
            this.cr = this.bytes.getEncoding().isAsciiCompatible() ? 32 : 64;
        }
    }
}

