/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ModuleVersionGuardInstr
extends Instr {
    private final int expectedVersion;
    private final RubyModule module;
    private Operand candidateObj;
    private Label failurePathLabel;

    public ModuleVersionGuardInstr(RubyModule module, int expectedVersion, Operand candidateObj, Label failurePathLabel) {
        super(Operation.MODULE_GUARD);
        this.module = module;
        this.expectedVersion = expectedVersion;
        this.candidateObj = candidateObj;
        this.failurePathLabel = failurePathLabel;
    }

    public Label getFailurePathLabel() {
        return this.failurePathLabel;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.candidateObj};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.candidateObj = this.candidateObj.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.candidateObj + ", " + this.expectedVersion + "[" + this.module.getName() + "], " + this.failurePathLabel + ")";
    }

    @Override
    public Instr cloneForInlinedScope(InlinerInfo ii) {
        return new ModuleVersionGuardInstr(this.module, this.expectedVersion, this.candidateObj.cloneForInlining(ii), ii.getRenamedLabel(this.failurePathLabel));
    }

    @Override
    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return new ModuleVersionGuardInstr(this.module, this.expectedVersion, this.candidateObj.cloneForInlining(ii), this.failurePathLabel);
    }

    private boolean versionMatches(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject receiver2 = (IRubyObject)this.candidateObj.retrieve(context, self2, currDynScope, temp);
        return receiver2.getMetaClass().getGeneration() == this.expectedVersion;
    }

    @Override
    public int interpretAndGetNewIPC(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, int ipc) {
        return this.versionMatches(context, currDynScope, self2, temp) ? ipc : this.getFailurePathLabel().getTargetPC();
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ModuleVersionGuardInstr(this);
    }
}

