/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import jnr.constants.platform.Errno;
import jnr.posix.FileStat;
import jnr.posix.HANDLE;
import jnr.posix.JavaFileStat;
import jnr.posix.JavaPOSIX;
import jnr.posix.JavaPasswd;
import jnr.posix.JavaSecuredFile;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.util.Chmod;
import jnr.posix.util.ExecIt;
import jnr.posix.util.FieldAccess;
import jnr.posix.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLibCHelper {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    private static final ThreadLocal<Integer> errno;
    private final POSIXHandler handler;
    private final Field fdField;
    private final Field handleField;
    private final Map<String, String> env;
    private static final Class SEL_CH_IMPL;
    private static final Method SEL_CH_IMPL_GET_FD;
    private static final Class FILE_CHANNEL_IMPL;
    private static final Field FILE_CHANNEL_IMPL_FD;
    private static final Field FILE_DESCRIPTOR_FD;
    ThreadLocal<Integer> pwIndex = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public JavaLibCHelper(POSIXHandler handler) {
        this.env = new HashMap<String, String>();
        this.handler = handler;
        this.handleField = Platform.IS_WINDOWS ? FieldAccess.getProtectedField(FileDescriptor.class, "handle") : null;
        this.fdField = FILE_DESCRIPTOR_FD;
    }

    public static FileDescriptor getDescriptorFromChannel(Channel channel) {
        if (SEL_CH_IMPL_GET_FD != null && SEL_CH_IMPL.isInstance(channel)) {
            try {
                return (FileDescriptor)SEL_CH_IMPL_GET_FD.invoke((Object)channel, new Object[0]);
            }
            catch (Exception e) {
            }
        } else if (FILE_CHANNEL_IMPL_FD != null && FILE_CHANNEL_IMPL.isInstance(channel)) {
            try {
                return (FileDescriptor)FILE_CHANNEL_IMPL_FD.get(channel);
            }
            catch (Exception e) {
            }
        } else if (FILE_DESCRIPTOR_FD != null) {
            FileDescriptor unixFD = new FileDescriptor();
            try {
                Method getFD = channel.getClass().getMethod("getFD", new Class[0]);
                FILE_DESCRIPTOR_FD.set(unixFD, (Integer)getFD.invoke((Object)channel, new Object[0]));
                return unixFD;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return new FileDescriptor();
    }

    static int errno() {
        Integer errno2 = errno.get();
        return errno2 != null ? errno2 : 0;
    }

    static void errno(int errno2) {
        errno.set(errno2);
    }

    static void errno(Errno errno2) {
        errno.set(errno2.intValue());
    }

    public int chmod(String filename2, int mode2) {
        return Chmod.chmod(new JavaSecuredFile(filename2), Integer.toOctalString(mode2));
    }

    public int chown(String filename2, int user, int group2) {
        PosixExec launcher = new PosixExec(this.handler);
        int chownResult = -1;
        int chgrpResult = -1;
        try {
            if (user != -1) {
                chownResult = launcher.runAndWait("chown", "" + user, filename2);
            }
            if (group2 != -1) {
                chgrpResult = launcher.runAndWait("chgrp ", "" + user, filename2);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return chownResult != -1 && chgrpResult != -1 ? 0 : 1;
    }

    public int getfd(FileDescriptor descriptor) {
        return JavaLibCHelper.getfdFromDescriptor(descriptor);
    }

    public static int getfdFromDescriptor(FileDescriptor descriptor) {
        if (descriptor == null || FILE_DESCRIPTOR_FD == null) {
            return -1;
        }
        try {
            return FILE_DESCRIPTOR_FD.getInt(descriptor);
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    public HANDLE gethandle(FileDescriptor descriptor) {
        if (descriptor == null || this.handleField == null) {
            return HANDLE.valueOf(-1L);
        }
        try {
            return HANDLE.valueOf(this.handleField.getLong(descriptor));
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return HANDLE.valueOf(-1L);
    }

    public String getlogin() {
        return System.getProperty("user.name");
    }

    public int getpid() {
        return this.handler.getPID();
    }

    public Passwd getpwent() {
        JavaPasswd retVal = this.pwIndex.get() == 0 ? new JavaPasswd(this.handler) : null;
        this.pwIndex.set(this.pwIndex.get() + 1);
        return retVal;
    }

    public int setpwent() {
        return 0;
    }

    public int endpwent() {
        this.pwIndex.set(0);
        return 0;
    }

    public Passwd getpwuid(int which) {
        return which == JavaPOSIX.LoginInfo.UID ? new JavaPasswd(this.handler) : null;
    }

    public int isatty(int fd) {
        return fd == 1 || fd == 0 || fd == 2 ? 1 : 0;
    }

    public int link(String oldpath, String newpath) {
        try {
            return new PosixExec(this.handler).runAndWait("ln", oldpath, newpath);
        }
        catch (Exception e) {
            JavaLibCHelper.errno(Errno.EINVAL);
            return -1;
        }
    }

    public int lstat(String path2, FileStat stat2) {
        JavaSecuredFile file2 = new JavaSecuredFile(path2);
        if (!((File)file2).exists()) {
            this.handler.error(Errno.ENOENT, "lstat", path2);
        }
        JavaFileStat jstat = (JavaFileStat)stat2;
        jstat.setup(path2);
        return 0;
    }

    public int mkdir(String path2, int mode2) {
        JavaSecuredFile dir = new JavaSecuredFile(path2);
        if (!((File)dir).mkdir()) {
            return -1;
        }
        this.chmod(path2, mode2);
        return 0;
    }

    public int rmdir(String path2) {
        return new JavaSecuredFile(path2).delete() ? 0 : -1;
    }

    public static int chdir(String path2) {
        System.setProperty("user.dir", path2);
        return 0;
    }

    public int stat(String path2, FileStat stat2) {
        JavaFileStat jstat = (JavaFileStat)stat2;
        try {
            JavaSecuredFile file2 = new JavaSecuredFile(path2);
            if (!((File)file2).exists()) {
                this.handler.error(Errno.ENOENT, "stat", path2);
            }
            jstat.setup(((File)file2).getCanonicalPath());
        }
        catch (IOException e) {
            // empty catch block
        }
        return 0;
    }

    public int symlink(String oldpath, String newpath) {
        try {
            return new PosixExec(this.handler).runAndWait("ln", "-s", oldpath, newpath);
        }
        catch (Exception e) {
            JavaLibCHelper.errno(Errno.EEXIST);
            return -1;
        }
    }

    public int readlink(String oldpath, ByteBuffer buffer, int length2) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new PosixExec(this.handler).runAndWait((OutputStream)baos, "readlink", oldpath);
            byte[] bytes2 = baos.toByteArray();
            if (bytes2.length > length2 || bytes2.length == 0) {
                return -1;
            }
            buffer.put(bytes2, 0, bytes2.length - 1);
            return buffer.position();
        }
        catch (InterruptedException e) {
            JavaLibCHelper.errno(Errno.ENOENT);
            return -1;
        }
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public static FileDescriptor toFileDescriptor(int fileDescriptor) {
        FileDescriptor descriptor = new FileDescriptor();
        try {
            FILE_DESCRIPTOR_FD.set(descriptor, fileDescriptor);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return descriptor;
    }

    static {
        Field ffd;
        Field fd;
        Class<?> fileChannelImpl;
        Method getFD;
        Class<?> selChImpl;
        errno = new ThreadLocal();
        try {
            selChImpl = Class.forName("sun.nio.ch.SelChImpl");
            try {
                getFD = selChImpl.getMethod("getFD", new Class[0]);
                getFD.setAccessible(true);
            }
            catch (Exception e) {
                getFD = null;
            }
        }
        catch (Exception e) {
            selChImpl = null;
            getFD = null;
        }
        SEL_CH_IMPL = selChImpl;
        SEL_CH_IMPL_GET_FD = getFD;
        try {
            fileChannelImpl = Class.forName("sun.nio.ch.FileChannelImpl");
            try {
                fd = fileChannelImpl.getDeclaredField("fd");
                fd.setAccessible(true);
            }
            catch (Exception e) {
                fd = null;
            }
        }
        catch (Exception e) {
            fileChannelImpl = null;
            fd = null;
        }
        FILE_CHANNEL_IMPL = fileChannelImpl;
        FILE_CHANNEL_IMPL_FD = fd;
        try {
            ffd = FileDescriptor.class.getDeclaredField("fd");
            ffd.setAccessible(true);
        }
        catch (Exception e) {
            ffd = null;
        }
        FILE_DESCRIPTOR_FD = ffd;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ErrnoParsingOutputStream
    extends OutputStream {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final AtomicReference<Errno> errno;
        static Map<Pattern, Errno> errorPatterns = new HashMap<Pattern, Errno>();

        private ErrnoParsingOutputStream(AtomicReference<Errno> errno2) {
            this.errno = errno2;
        }

        @Override
        public void write(int b) throws IOException {
            if (b != 13 && b != 10 && b != -1) {
                this.baos.write(b);
            } else if (this.baos.size() > 0) {
                String errorString = this.baos.toString();
                this.baos.reset();
                this.parseError(errorString);
            }
        }

        void parseError(String errorString) {
            for (Map.Entry<Pattern, Errno> entry : errorPatterns.entrySet()) {
                if (!entry.getKey().matcher(errorString).find()) continue;
                this.errno.set(entry.getValue());
            }
        }

        static {
            errorPatterns.put(Pattern.compile("File exists"), Errno.EEXIST);
            errorPatterns.put(Pattern.compile("Operation not permitted"), Errno.EPERM);
            errorPatterns.put(Pattern.compile("No such file or directory"), Errno.ENOENT);
            errorPatterns.put(Pattern.compile("Input/output error"), Errno.EIO);
            errorPatterns.put(Pattern.compile("Not a directory"), Errno.ENOTDIR);
            errorPatterns.put(Pattern.compile("No space left on device"), Errno.ENOSPC);
            errorPatterns.put(Pattern.compile("Read-only file system"), Errno.EROFS);
            errorPatterns.put(Pattern.compile("Too many links"), Errno.EMLINK);
        }
    }

    private static class PosixExec
    extends ExecIt {
        private final AtomicReference<Errno> errno = new AtomicReference<Errno>(Errno.EINVAL);
        private final ErrnoParsingOutputStream errorStream = new ErrnoParsingOutputStream(this.errno);

        public PosixExec(POSIXHandler handler) {
            super(handler);
        }

        private int parseResult(int result2) {
            if (result2 == 0) {
                return result2;
            }
            JavaLibCHelper.errno(this.errno.get());
            return -1;
        }

        public int runAndWait(String ... args2) throws IOException, InterruptedException {
            return this.runAndWait((OutputStream)this.handler.getOutputStream(), this.errorStream, args2);
        }

        public int runAndWait(OutputStream output, String ... args2) throws IOException, InterruptedException {
            return this.runAndWait(output, this.errorStream, args2);
        }

        public int runAndWait(OutputStream output, OutputStream error2, String ... args2) throws IOException, InterruptedException {
            return this.parseResult(super.runAndWait(output, error2, args2));
        }
    }
}

