/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.JRubyNonExistentFile;
import org.jruby.util.JarCache;
import org.jruby.util.JarDirectoryResource;
import org.jruby.util.JarFileResource;
import org.jruby.util.JarFileStat;

abstract class JarResource
implements FileResource {
    private static Pattern PREFIX_MATCH = Pattern.compile("^(?:jar:)?(?:file:)?(.*)$");
    private static final JarCache jarCache = new JarCache();
    private final String jarPath;
    private final JarFileStat fileStat;

    public static JarResource create(String pathname2) {
        JarResource resource2;
        Matcher matcher = PREFIX_MATCH.matcher(pathname2);
        String sanitized = matcher.matches() ? matcher.group(1) : pathname2;
        int bang = sanitized.indexOf(33);
        if (bang < 0) {
            return null;
        }
        String jarPath = sanitized.substring(0, bang);
        String entryPath = sanitized.substring(bang + 1);
        if (!entryPath.startsWith("/")) {
            entryPath = "/" + entryPath;
        }
        if ((resource2 = JarResource.createJarResource(jarPath, entryPath)) == null) {
            resource2 = JarResource.createJarResource(jarPath, entryPath.substring(1));
        }
        return resource2;
    }

    private static JarResource createJarResource(String jarPath, String path2) {
        JarCache.JarIndex index2 = jarCache.getIndex(jarPath);
        if (index2 == null) {
            return null;
        }
        String[] entries2 = index2.getDirEntries(path2);
        if (entries2 != null) {
            return new JarDirectoryResource(jarPath, path2, entries2);
        }
        JarEntry jarEntry = index2.getJarEntry(path2);
        if (jarEntry != null) {
            InputStream jarEntryStream = index2.getInputStream(jarEntry);
            return new JarFileResource(path2, jarEntry, jarEntryStream);
        }
        return null;
    }

    protected JarResource(String jarPath) {
        this.jarPath = jarPath;
        this.fileStat = new JarFileStat(this);
    }

    @Override
    public String absolutePath() {
        return this.jarPath + "!" + this.entryName();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public FileStat stat(POSIX posix) {
        return this.fileStat;
    }

    @Override
    public FileStat lstat(POSIX posix) {
        return this.stat(posix);
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return JRubyNonExistentFile.NOT_EXIST;
    }

    protected abstract String entryName();
}

