/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormatter;

@JRubyClass(name={"Time"}, include={"Comparable"})
public class RubyTime
extends RubyObject {
    public static final String UTC = "UTC";
    private DateTime dt;
    private long nsec;
    private static final DateTimeFormatter ONE_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern("EEE MMM  d HH:mm:ss yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TWO_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_FORMATTER = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss Z yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_UTC_FORMATTER = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss 'UTC' yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_FORMATTER_19 = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss Z").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_UTC_FORMATTER_19 = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss 'UTC'").withLocale(Locale.ENGLISH);
    private static final Pattern TZ_PATTERN = Pattern.compile("([^-\\+\\d]+)?([\\+-]?)(\\d+)(?::(\\d+))?(?::\\d+)?");
    private static final Pattern TIME_OFFSET_PATTERN = Pattern.compile("([\\+-])(\\d\\d):(\\d\\d)");
    private static final ByteList TZ_STRING = ByteList.create("TZ");
    private boolean isTzRelative = false;
    private static final Map<String, String> LONG_TZNAME = Helpers.map("MET", "CET", "ROC", "Asia/Taipei", "WET", "Europe/Lisbon");
    private static final Map<String, String> NON_JVM_TZNAME = Helpers.map("EDT", "EST", "CDT", "CST", "MDT", "MST", "PDT", "PST");
    private static final Map<String, String> SHORT_STD_TZNAME = Helpers.map("Etc/UCT", "UCT", "MET", "MET", "UCT", "UCT");
    private static final Map<String, String> SHORT_DL_TZNAME = Helpers.map("Etc/UCT", "UCT", "MET", "MEST", "UCT", "UCT");
    private static ObjectAllocator TIME_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            DateTimeZone dtz = RubyTime.getLocalTimeZone(runtime);
            DateTime dt = new DateTime(dtz);
            RubyTime rt = new RubyTime(runtime, klass, dt);
            rt.setNSec(0L);
            return rt;
        }
    };
    private static final String[] MONTHS = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final Map<String, Integer> MONTHS_MAP = new HashMap<String, Integer>();
    private static final int ARG_SIZE = 7;

    private void setIsTzRelative(boolean tzRelative) {
        this.isTzRelative = tzRelative;
    }

    @Override
    public int getNativeTypeIndex() {
        return 19;
    }

    private static IRubyObject getEnvTimeZone(Ruby runtime) {
        RubyString tzVar = runtime.newString(TZ_STRING);
        RubyHash h = (RubyHash)runtime.getObject().getConstant("ENV");
        IRubyObject tz = h.op_aref(runtime.getCurrentContext(), tzVar);
        return tz;
    }

    public static DateTimeZone getLocalTimeZone(Ruby runtime) {
        IRubyObject tz = RubyTime.getEnvTimeZone(runtime);
        if (tz == null || !(tz instanceof RubyString)) {
            return DateTimeZone.getDefault();
        }
        return RubyTime.getTimeZone(runtime, tz.toString());
    }

    public static DateTimeZone getTimeZone(Ruby runtime, long seconds) {
        if (seconds >= 86400L || seconds <= -86400L) {
            throw runtime.newArgumentError("utc_offset out of range");
        }
        String zone2 = seconds + "s";
        DateTimeZone cachedZone = runtime.getTimezoneCache().get(zone2);
        if (cachedZone != null) {
            return cachedZone;
        }
        DateTimeZone dtz = DateTimeZone.forOffsetMillis((int)(seconds * 1000L));
        runtime.getTimezoneCache().put(zone2, dtz);
        return dtz;
    }

    public static DateTimeZone getTimeZone(Ruby runtime, String zone2) {
        DateTimeZone cachedZone = runtime.getTimezoneCache().get(zone2);
        if (cachedZone != null) {
            return cachedZone;
        }
        String originalZone = zone2;
        if (NON_JVM_TZNAME.containsKey(zone2.toUpperCase())) {
            zone2 = NON_JVM_TZNAME.get(zone2.toUpperCase());
        }
        TimeZone tz = TimeZone.getTimeZone(zone2);
        Matcher tzMatcher = TZ_PATTERN.matcher(zone2);
        if (tzMatcher.matches()) {
            String sign2 = tzMatcher.group(2);
            String hours = tzMatcher.group(3);
            String minutes = tzMatcher.group(4);
            if (Integer.parseInt(hours) > 23 || minutes != null && Integer.parseInt(minutes) > 59) {
                throw runtime.newArgumentError("utc_offset out of range");
            }
            if (("00".equals(hours) || "0".equals(hours)) && (minutes == null || "00".equals(minutes) || "0".equals(minutes))) {
                zone2 = "Etc/GMT";
            } else {
                sign2 = "-".equals(sign2) ? "+" : "-";
                zone2 = "GMT" + sign2 + hours;
                if (minutes != null) {
                    zone2 = zone2 + minutes;
                }
            }
            tz = TimeZone.getTimeZone(zone2);
        } else if (LONG_TZNAME.containsKey(zone2)) {
            tz.setID(LONG_TZNAME.get(zone2.toUpperCase()));
        }
        if ("GMT".equalsIgnoreCase(zone2) || UTC.equalsIgnoreCase(zone2)) {
            zone2 = "Etc/" + zone2;
            tz = TimeZone.getTimeZone(zone2);
        }
        DateTimeZone dtz = DateTimeZone.forTimeZone(tz);
        runtime.getTimezoneCache().put(originalZone, dtz);
        return dtz;
    }

    public static DateTimeZone getTimeZoneFromUtcOffset(Ruby runtime, String utcOffset) {
        DateTimeZone cachedZone = runtime.getTimezoneCache().get(utcOffset);
        if (cachedZone != null) {
            return cachedZone;
        }
        Matcher offsetMatcher = TIME_OFFSET_PATTERN.matcher(utcOffset);
        if (offsetMatcher.matches()) {
            String sign2 = offsetMatcher.group(1);
            String hours = offsetMatcher.group(2);
            String minutes = offsetMatcher.group(3);
            if (Integer.parseInt(hours) > 23 || minutes != null && Integer.parseInt(minutes) > 59) {
                throw runtime.newArgumentError("utc_offset out of range");
            }
            long seconds = Integer.parseInt(hours) * 3600 + Integer.parseInt(minutes) * 60;
            seconds = "-".equals(sign2) ? -1L * seconds : seconds;
            DateTimeZone dtz = DateTimeZone.forOffsetMillis((int)(seconds * 1000L));
            runtime.getTimezoneCache().put(utcOffset, dtz);
            return dtz;
        }
        throw runtime.newArgumentError("\"+HH:MM\" or \"-HH:MM\" expected for utc_offset");
    }

    public RubyTime(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public RubyTime(Ruby runtime, RubyClass rubyClass, DateTime dt) {
        super(runtime, rubyClass);
        this.dt = dt;
    }

    public static RubyClass createTimeClass(Ruby runtime) {
        RubyClass timeClass = runtime.defineClass("Time", runtime.getObject(), TIME_ALLOCATOR);
        timeClass.index = 19;
        timeClass.setReifiedClass(RubyTime.class);
        runtime.setTime(timeClass);
        timeClass.includeModule(runtime.getComparable());
        timeClass.defineAnnotatedMethods(RubyTime.class);
        return timeClass;
    }

    public void setNSec(long nsec2) {
        this.nsec = nsec2;
    }

    public long getNSec() {
        return this.nsec;
    }

    public void setUSec(long usec2) {
        this.nsec = 1000L * usec2;
    }

    public long getUSec() {
        return this.nsec / 1000L;
    }

    public void updateCal(DateTime dt) {
        this.dt = dt;
    }

    protected long getTimeInMillis() {
        return this.dt.getMillis();
    }

    public static RubyTime newTime(Ruby runtime, long milliseconds) {
        return RubyTime.newTime(runtime, new DateTime(milliseconds));
    }

    public static RubyTime newTime(Ruby runtime, DateTime dt) {
        return new RubyTime(runtime, runtime.getTime(), dt);
    }

    public static RubyTime newTime(Ruby runtime, DateTime dt, long nsec2) {
        RubyTime t = new RubyTime(runtime, runtime.getTime(), dt);
        t.setNSec(nsec2);
        return t;
    }

    @Override
    public Class<?> getJavaClass() {
        return java.util.Date.class;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (!(original instanceof RubyTime)) {
            throw this.getRuntime().newTypeError("Expecting an instance of class Time");
        }
        RubyTime originalTime = (RubyTime)original;
        this.dt = originalTime.dt;
        this.nsec = originalTime.nsec;
        return this;
    }

    @JRubyMethod(name={"succ"})
    public RubyTime succ() {
        return RubyTime.newTime(this.getRuntime(), this.dt.plusSeconds(1));
    }

    @JRubyMethod(name={"gmtime", "utc"})
    public RubyTime gmtime() {
        this.dt = this.dt.withZone(DateTimeZone.UTC);
        return this;
    }

    @JRubyMethod(name={"localtime"})
    public RubyTime localtime() {
        this.dt = this.dt.withZone(RubyTime.getLocalTimeZone(this.getRuntime()));
        return this;
    }

    @JRubyMethod(name={"localtime"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyTime localtime19(ThreadContext context, IRubyObject[] args2) {
        String zone2;
        if (args2.length == 0) {
            return this.localtime();
        }
        String offset2 = args2[0].asJavaString();
        Matcher offsetMatcher = TIME_OFFSET_PATTERN.matcher(offset2);
        if (!offsetMatcher.matches()) {
            throw context.runtime.newArgumentError("\"+HH:MM\" or \"-HH:MM\" expected for utc_offset");
        }
        String sign2 = offsetMatcher.group(1);
        String hours = offsetMatcher.group(2);
        String minutes = offsetMatcher.group(3);
        if ("00".equals(hours) && "00".equals(minutes)) {
            zone2 = "Etc/GMT";
        } else {
            String sgn = "+".equals(sign2) ? "-" : "+";
            zone2 = "GMT" + sgn + hours + ":" + minutes;
        }
        DateTimeZone dtz = RubyTime.getTimeZone(context.runtime, zone2);
        return RubyTime.newTime(context.runtime, this.dt.withZone(dtz), this.nsec);
    }

    @JRubyMethod(name={"gmt?", "utc?", "gmtime?"})
    public RubyBoolean gmt() {
        return this.getRuntime().newBoolean(this.dt.getZone().getID().equals(UTC));
    }

    @JRubyMethod(name={"getgm", "getutc"})
    public RubyTime getgm() {
        return RubyTime.newTime(this.getRuntime(), this.dt.withZone(DateTimeZone.UTC), this.nsec);
    }

    @JRubyMethod(name={"getlocal"}, compat=CompatVersion.RUBY1_8)
    public RubyTime getlocal() {
        return RubyTime.newTime(this.getRuntime(), this.dt.withZone(RubyTime.getLocalTimeZone(this.getRuntime())), this.nsec);
    }

    @JRubyMethod(name={"getlocal"}, compat=CompatVersion.RUBY1_9, optional=1)
    public RubyTime getlocal19(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            return RubyTime.newTime(this.getRuntime(), this.dt.withZone(RubyTime.getLocalTimeZone(this.getRuntime())), this.nsec);
        }
        Matcher tzMatcher = TIME_OFFSET_PATTERN.matcher(args2[0].toString());
        int millis = 0;
        if (tzMatcher.matches()) {
            int hours = Integer.parseInt(tzMatcher.group(2));
            int minutes = Integer.parseInt(tzMatcher.group(3));
            millis = (hours * 60 + minutes) * 60 * 1000;
            if (tzMatcher.group(1).equals("-")) {
                millis = -millis;
            }
        } else {
            throw this.getRuntime().newArgumentError("\"+HH:MM\" or \"-HH:MM\" expected for utc_offset");
        }
        return RubyTime.newTime(this.getRuntime(), this.dt.withZone(DateTimeZone.forOffsetMillis(millis)), this.nsec);
    }

    @JRubyMethod(name={"strftime"}, required=1)
    public RubyString strftime(IRubyObject format) {
        RubyDateFormatter rdf = this.getRuntime().getCurrentContext().getRubyDateFormatter();
        return rdf.compileAndFormat(format.convertToString(), false, this.dt, this.nsec, null);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other.isNil()) {
            return RubyBoolean.newBoolean(this.getRuntime(), false);
        }
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) == 0);
        }
        return RubyComparable.op_equal19(context, this, other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    private int cmp(RubyTime other) {
        long nsec_other;
        Ruby runtime = this.getRuntime();
        long millis = this.getTimeInMillis();
        long millis_other = other.getTimeInMillis();
        long nanosec = runtime.is1_9() ? this.nsec : this.nsec / 1000L * 1000L;
        long l = nsec_other = runtime.is1_9() ? other.nsec : other.nsec / 1000L * 1000L;
        if (millis > millis_other || millis == millis_other && nanosec > nsec_other) {
            return 1;
        }
        if (millis < millis_other || millis == millis_other && nanosec < nsec_other) {
            return -1;
        }
        return 0;
    }

    @JRubyMethod(name={"+"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_plus(IRubyObject other) {
        if (other instanceof RubyTime) {
            throw this.getRuntime().newTypeError("time + time ?");
        }
        long adjustment = Math.round(RubyNumeric.num2dbl(other) * 1000000.0);
        return this.opPlusMicros(adjustment);
    }

    @JRubyMethod(name={"+"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_plus19(ThreadContext context, IRubyObject other) {
        this.checkOpCoercion(context, other);
        if (other instanceof RubyTime) {
            throw this.getRuntime().newTypeError("time + time ?");
        }
        other = other.callMethod(context, "to_r");
        long adjustNanos = (long)(RubyNumeric.num2dbl(other) * 1.0E9);
        return this.opPlusNanos(adjustNanos);
    }

    private IRubyObject opPlusMicros(long adjustMicros) {
        long currentMillis = this.getTimeInMillis();
        long adjustMillis = adjustMicros / 1000L;
        long adjustNanosLeft = adjustMicros - adjustMillis * 1000L;
        long newMillisPart = currentMillis + adjustMillis;
        long newNanosPart = this.nsec + adjustNanosLeft;
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.dt = new DateTime(newMillisPart).withZone(this.dt.getZone());
        newTime.setNSec(newNanosPart);
        return newTime;
    }

    private IRubyObject opPlusNanos(long adjustNanos) {
        long currentMillis = this.getTimeInMillis();
        long adjustMillis = adjustNanos / 1000000L;
        long adjustNanosLeft = adjustNanos - adjustMillis * 1000000L;
        long newMillisPart = currentMillis + adjustMillis;
        long newNanosPart = this.nsec + adjustNanosLeft;
        if (newNanosPart >= 1000000L) {
            newNanosPart -= 1000000L;
            ++newMillisPart;
        }
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.dt = new DateTime(newMillisPart).withZone(this.dt.getZone());
        newTime.setNSec(newNanosPart);
        return newTime;
    }

    private void checkOpCoercion(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            throw context.runtime.newTypeError("no implicit conversion to rational from string");
        }
        if (other.isNil()) {
            throw context.runtime.newTypeError("no implicit conversion to rational from nil");
        }
        if (!other.respondsTo("to_r")) {
            throw context.runtime.newTypeError("can't convert " + other.getMetaClass().getBaseName() + " into Rational");
        }
    }

    private IRubyObject opMinus(RubyTime other) {
        long timeInMillis = this.getTimeInMillis() - other.getTimeInMillis();
        double timeInSeconds = (double)timeInMillis / 1000.0 + (double)(this.getNSec() - other.getNSec()) / 1.0E9;
        return RubyFloat.newFloat(this.getRuntime(), timeInSeconds);
    }

    @JRubyMethod(name={"-"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_minus(IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.opMinus((RubyTime)other);
        }
        return this.opMinusCommon(other);
    }

    @JRubyMethod(name={"-"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_minus19(ThreadContext context, IRubyObject other) {
        this.checkOpCoercion(context, other);
        if (other instanceof RubyTime) {
            return this.opMinus((RubyTime)other);
        }
        return this.opMinusCommon(other.callMethod(context, "to_r"));
    }

    private IRubyObject opMinusCommon(IRubyObject other) {
        long nano;
        long adjustmentInNanos = (long)(RubyNumeric.num2dbl(other) * 1.0E9);
        long adjustmentInMillis = adjustmentInNanos / 1000000L;
        long adjustmentInNanosLeft = adjustmentInNanos % 1000000L;
        long time = this.getTimeInMillis() - adjustmentInMillis;
        if (this.nsec < adjustmentInNanosLeft) {
            --time;
            nano = 1000000L - (adjustmentInNanosLeft - this.nsec);
        } else {
            nano = this.nsec - adjustmentInNanosLeft;
        }
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.dt = new DateTime(time).withZone(this.dt.getZone());
        newTime.setNSec(nano);
        return newTime;
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.runtime.newBoolean(RubyNumeric.fix2int(Helpers.invokedynamic(context, (IRubyObject)this, MethodNames.OP_CMP, other)) == 0);
        }
        return context.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.runtime.newFixnum(this.cmp((RubyTime)other));
        }
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"<=>"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_cmp19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.runtime.newFixnum(this.cmp((RubyTime)other));
        }
        IRubyObject tmp = Helpers.invokedynamic(context, other, MethodNames.OP_CMP, (IRubyObject)this);
        if (tmp.isNil()) {
            return context.runtime.getNil();
        }
        int n = -RubyComparable.cmpint(context, tmp, this, other);
        if (n == 0) {
            return context.runtime.newFixnum(0);
        }
        if (n > 0) {
            return context.runtime.newFixnum(1);
        }
        return context.runtime.newFixnum(-1);
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyTime) {
            RubyTime otherTime = (RubyTime)other;
            return this.nsec == otherTime.nsec && this.getTimeInMillis() == otherTime.getTimeInMillis() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"asctime", "ctime"})
    public RubyString asctime() {
        DateTimeFormatter simpleDateFormat = this.dt.getDayOfMonth() < 10 ? ONE_DAY_CTIME_FORMATTER : TWO_DAY_CTIME_FORMATTER;
        String result2 = simpleDateFormat.print(this.dt);
        return this.getRuntime().newString(result2);
    }

    @Override
    @JRubyMethod(name={"to_s", "inspect"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_s() {
        return this.inspectCommon(TO_S_FORMATTER, TO_S_UTC_FORMATTER);
    }

    @JRubyMethod(name={"to_s", "inspect"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_s19() {
        return this.inspectCommon(TO_S_FORMATTER_19, TO_S_UTC_FORMATTER_19);
    }

    private IRubyObject inspectCommon(DateTimeFormatter formatter, DateTimeFormatter utcFormatter) {
        DateTimeFormatter simpleDateFormat = this.dt.getZone() == DateTimeZone.UTC ? utcFormatter : formatter;
        String result2 = simpleDateFormat.print(this.dt);
        if (this.isTzRelative) {
            DateTimeZone dtz = this.dt.getZone();
            int offset2 = dtz.toTimeZone().getOffset(this.dt.getMillis());
            DateTimeZone invertedDTZ = DateTimeZone.forOffsetMillis(offset2);
            DateTime invertedDT = this.dt.withZone(invertedDTZ);
            result2 = simpleDateFormat.print(invertedDT);
        }
        return this.getRuntime().newString(result2);
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.getRuntime().newArrayNoCopy(this.sec(), this.min(), this.hour(), this.mday(), this.month(), this.year(), this.wday(), this.yday(), this.isdst(), this.zone());
    }

    @JRubyMethod(name={"to_f"})
    public RubyFloat to_f() {
        long millis = this.getTimeInMillis();
        long nanos = this.nsec;
        double secs = 0.0;
        if (millis != 0L) {
            secs += (double)millis / 1000.0;
        }
        if (nanos != 0L) {
            secs += (double)nanos / 1.0E9;
        }
        return RubyFloat.newFloat(this.getRuntime(), secs);
    }

    @JRubyMethod(name={"to_i", "tv_sec"})
    public RubyInteger to_i() {
        return this.getRuntime().newFixnum(this.getTimeInMillis() / 1000L);
    }

    @JRubyMethod(name={"nsec", "tv_nsec"}, compat=CompatVersion.RUBY1_9)
    public RubyInteger nsec() {
        return this.getRuntime().newFixnum(this.getTimeInMillis() % 1000L * 1000000L + this.nsec);
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext context) {
        IRubyObject denominator2;
        IRubyObject rational = this.to_f().to_r(context);
        if (rational instanceof RubyRational && RubyNumeric.num2long(denominator2 = ((RubyRational)rational).denominator(context)) == 1L) {
            return ((RubyRational)rational).numerator(context);
        }
        return rational;
    }

    @JRubyMethod(name={"usec", "tv_usec"})
    public RubyInteger usec() {
        return this.getRuntime().newFixnum((long)(this.dt.getMillisOfSecond() * 1000) + this.getUSec());
    }

    public void setMicroseconds(long mic) {
        long millis = this.getTimeInMillis() % 1000L;
        long withoutMillis = this.getTimeInMillis() - millis;
        this.dt = this.dt.withMillis(withoutMillis += mic / 1000L);
        this.nsec = mic % 1000L * 1000L;
    }

    public long microseconds() {
        return this.getTimeInMillis() % 1000L * 1000L + this.getUSec();
    }

    @JRubyMethod(name={"sec"})
    public RubyInteger sec() {
        return this.getRuntime().newFixnum(this.dt.getSecondOfMinute());
    }

    @JRubyMethod(name={"min"})
    public RubyInteger min() {
        return this.getRuntime().newFixnum(this.dt.getMinuteOfHour());
    }

    @JRubyMethod(name={"hour"})
    public RubyInteger hour() {
        return this.getRuntime().newFixnum(this.dt.getHourOfDay());
    }

    @JRubyMethod(name={"mday", "day"})
    public RubyInteger mday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfMonth());
    }

    @JRubyMethod(name={"month", "mon"})
    public RubyInteger month() {
        return this.getRuntime().newFixnum(this.dt.getMonthOfYear());
    }

    @JRubyMethod(name={"year"})
    public RubyInteger year() {
        return this.getRuntime().newFixnum(this.dt.getYear());
    }

    @JRubyMethod(name={"wday"})
    public RubyInteger wday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfWeek() % 7);
    }

    @JRubyMethod(name={"yday"})
    public RubyInteger yday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfYear());
    }

    @JRubyMethod(name={"subsec"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject subsec() {
        Ruby runtime = this.getRuntime();
        long nanosec = (long)(this.dt.getMillisOfSecond() * 1000000) + this.nsec;
        if (nanosec % 1000000000L == 0L) {
            return RubyFixnum.zero(runtime);
        }
        return runtime.newRationalReduced(nanosec, 1000000000L);
    }

    @JRubyMethod(name={"gmt_offset", "gmtoff", "utc_offset"})
    public RubyInteger gmt_offset() {
        int offset2 = this.dt.getZone().getOffset(this.dt.getMillis());
        return this.getRuntime().newFixnum(offset2 / 1000);
    }

    @JRubyMethod(name={"isdst", "dst?"})
    public RubyBoolean isdst() {
        return this.getRuntime().newBoolean(!this.dt.getZone().isStandardOffset(this.dt.getMillis()));
    }

    @JRubyMethod(name={"zone"})
    public IRubyObject zone() {
        Ruby runtime = this.getRuntime();
        if (this.isTzRelative) {
            return runtime.getNil();
        }
        String envTZ = RubyTime.getEnvTimeZone(runtime).toString();
        if (SHORT_STD_TZNAME.containsKey(envTZ) && !this.dt.getZone().toTimeZone().inDaylightTime(this.dt.toDate())) {
            return runtime.newString(SHORT_STD_TZNAME.get(envTZ));
        }
        if (SHORT_DL_TZNAME.containsKey(envTZ) && this.dt.getZone().toTimeZone().inDaylightTime(this.dt.toDate())) {
            return runtime.newString(SHORT_DL_TZNAME.get(envTZ));
        }
        String zone2 = this.dt.getZone().getShortName(this.dt.getMillis());
        Matcher offsetMatcher = TIME_OFFSET_PATTERN.matcher(zone2);
        if (offsetMatcher.matches()) {
            boolean minus_p = offsetMatcher.group(1).toString().equals("-");
            int hourOffset = Integer.valueOf(offsetMatcher.group(2));
            if (zone2.equals("+00:00")) {
                zone2 = "GMT";
            } else {
                zone2 = this.dt.getZone().getNameKey(this.dt.getMillis());
                if (zone2 == null) {
                    char sign2 = minus_p ? (char)'+' : '-';
                    zone2 = "GMT" + sign2 + hourOffset;
                }
            }
        }
        return runtime.newString(zone2);
    }

    public void setDateTime(DateTime dt) {
        this.dt = dt;
    }

    public DateTime getDateTime() {
        return this.dt;
    }

    public java.util.Date getJavaDate() {
        return this.dt.toDate();
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum((int)((this.dt.getMillis() / 1000L ^ this.microseconds()) << 1) >> 1);
    }

    @JRubyMethod(name={"_dump"}, optional=1)
    public RubyString dump(IRubyObject[] args2, Block unusedBlock) {
        RubyString str = (RubyString)this.mdump();
        str.syncVariables(this);
        return str;
    }

    public RubyObject mdump() {
        int i2;
        Ruby runtime = this.getRuntime();
        RubyTime obj = this;
        DateTime dateTime = obj.dt.toDateTime(DateTimeZone.UTC);
        byte[] dumpValue = new byte[8];
        long nanos = this.nsec;
        long usec2 = this.nsec / 1000L;
        long nanosec = this.nsec % 1000L;
        int pe = Integer.MIN_VALUE | (obj.gmt().isTrue() ? 1 : 0) << 30 | dateTime.getYear() - 1900 << 14 | dateTime.getMonthOfYear() - 1 << 10 | dateTime.getDayOfMonth() << 5 | dateTime.getHourOfDay();
        int se = dateTime.getMinuteOfHour() << 26 | dateTime.getSecondOfMinute() << 20 | dateTime.getMillisOfSecond() * 1000 + (int)usec2;
        for (i2 = 0; i2 < 4; ++i2) {
            dumpValue[i2] = (byte)(pe & 0xFF);
            pe >>>= 8;
        }
        for (i2 = 4; i2 < 8; ++i2) {
            dumpValue[i2] = (byte)(se & 0xFF);
            se >>>= 8;
        }
        RubyString string2 = RubyString.newString(obj.getRuntime(), new ByteList(dumpValue));
        if (runtime.is1_9()) {
            this.copyInstanceVariablesInto(string2);
            if (nanosec != 0L) {
                string2.setInternalVariable("nano_num", runtime.newFixnum(nanosec));
                string2.setInternalVariable("nano_den", runtime.newFixnum(1));
            }
            byte[] submicro = new byte[2];
            int len = 2;
            submicro[1] = (byte)(nanosec % 10L << 4);
            submicro[0] = (byte)((nanosec /= 10L) % 10L);
            submicro[0] = (byte)(submicro[0] | (byte)((nanosec /= 10L) % 10L << 4));
            if (submicro[1] == 0) {
                len = 1;
            }
            string2.setInternalVariable("submicro", RubyString.newString(runtime, submicro, 0, len));
            if (this.dt.getZone() != DateTimeZone.UTC) {
                long offset2 = this.dt.getZone().getOffset(this.dt.getMillis());
                string2.setInternalVariable("offset", runtime.newFixnum(offset2 / 1000L));
            }
        }
        return string2;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block block) {
        return this;
    }

    @JRubyMethod(name={"round"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyTime round(ThreadContext context, IRubyObject[] args2) {
        int ndigits;
        int n = ndigits = args2.length == 0 ? 0 : RubyNumeric.num2int(args2[0]);
        if (ndigits > 9) {
            ndigits = 9;
        } else if (ndigits < 0) {
            throw context.getRuntime().newArgumentError("negative ndigits given");
        }
        int nsec2 = this.dt.getMillisOfSecond() * 1000000 + (int)this.nsec;
        int pow = (int)Math.pow(10.0, 9 - ndigits);
        int rounded = (nsec2 + pow / 2) / pow * pow;
        DateTime dt = this.dt.withMillisOfSecond(0).plusMillis(rounded / 1000000);
        return RubyTime.newTime(context.runtime, dt, rounded % 1000000);
    }

    public static IRubyObject s_new(IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = recv2.getRuntime();
        RubyTime time = new RubyTime(runtime, (RubyClass)recv2, new DateTime(RubyTime.getLocalTimeZone(runtime)));
        time.callInit(args2, block);
        return time;
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTime.newInstance(context, recv2);
    }

    @JRubyMethod(name={"times"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject times(ThreadContext context, IRubyObject recv2) {
        context.runtime.getWarnings().warn("obsolete method Time::times; use Process::times");
        return RubyProcess.times(context, recv2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"now"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2) {
        IRubyObject obj = ((RubyClass)recv2).allocate();
        obj.getMetaClass().getBaseCallSite(0).call(context, recv2, obj);
        return obj;
    }

    @JRubyMethod(name={"at"}, meta=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyTime time;
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubyTime) {
            RubyTime other = (RubyTime)arg2;
            time = new RubyTime(runtime, (RubyClass)recv2, other.dt);
            time.setNSec(other.getNSec());
        } else {
            time = new RubyTime(runtime, (RubyClass)recv2, new DateTime(0L, RubyTime.getLocalTimeZone(runtime)));
            long seconds = RubyNumeric.num2long(arg2);
            long millisecs = 0L;
            long nanosecs = 0L;
            if (arg2 instanceof RubyFloat || arg2 instanceof RubyRational) {
                long nano;
                double dbl = RubyNumeric.num2dbl(arg2);
                if (runtime.is1_9()) {
                    nano = Math.round((dbl - (double)seconds) * 1.0E9);
                } else {
                    long micro = Math.round((dbl - (double)seconds) * 1000000.0);
                    nano = micro * 1000L;
                }
                if (dbl < 0.0 && nano != 0L) {
                    nano += 1000000000L;
                }
                millisecs = nano / 1000000L;
                nanosecs = nano % 1000000L;
            }
            time.setNSec(nanosecs);
            time.dt = time.dt.withMillis(seconds * 1000L + millisecs);
        }
        time.getMetaClass().getBaseCallSite(0).call(context, recv2, time);
        return time;
    }

    @JRubyMethod(name={"at"}, meta=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        long millisecs;
        Ruby runtime = context.runtime;
        RubyTime time = new RubyTime(runtime, (RubyClass)recv2, new DateTime(0L, RubyTime.getLocalTimeZone(runtime)));
        long nanosecs = 0L;
        if (arg1 instanceof RubyFloat || arg1 instanceof RubyRational) {
            double dbl = RubyNumeric.num2dbl(arg1);
            millisecs = (long)(dbl * 1000.0);
            nanosecs = (long)(dbl * 1.0E9) % 1000000L;
        } else {
            millisecs = RubyNumeric.num2long(arg1) * 1000L;
        }
        if (arg2 instanceof RubyFloat || arg2 instanceof RubyRational) {
            double micros = RubyNumeric.num2dbl(arg2);
            double nanos = micros * 1000.0;
            millisecs += (long)(nanos / 1000000.0);
            nanosecs += (long)(nanos % 1000000.0);
        } else {
            long micros = RubyNumeric.num2long(arg2);
            long nanos = micros * 1000L;
            millisecs += nanos / 1000000L;
            nanosecs += nanos % 1000000L;
        }
        long nanosecOverflow = nanosecs / 1000000L;
        time.setNSec(nanosecs % 1000000L);
        time.dt = time.dt.withMillis(millisecs + nanosecOverflow);
        time.getMetaClass().getBaseCallSite(0).call(context, recv2, time);
        return time;
    }

    @JRubyMethod(name={"local", "mktime"}, required=1, optional=9, meta=true)
    public static RubyTime new_local(IRubyObject recv2, IRubyObject[] args2) {
        return RubyTime.createTime(recv2, args2, false, false);
    }

    @JRubyMethod(name={"new"}, optional=7, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length == 0) {
            return RubyTime.newInstance(context, recv2);
        }
        if (args2.length == 7) {
            Ruby runtime = context.getRuntime();
            RubySymbol dstSymbol = RubySymbol.newSymbol(runtime, "dst");
            boolean receivedDstSymbolAsArgument = args2[6].op_equal(context, dstSymbol).isTrue();
            RubyBoolean isDst = RubyBoolean.newBoolean(runtime, receivedDstSymbolAsArgument);
            args2 = new IRubyObject[]{args2[5], args2[4], args2[3], args2[2], args2[1], args2[0], runtime.getNil(), runtime.getNil(), isDst, args2[6]};
        }
        return RubyTime.createTime(recv2, args2, false, true);
    }

    @JRubyMethod(name={"utc", "gm"}, required=1, optional=9, meta=true)
    public static RubyTime new_utc(IRubyObject recv2, IRubyObject[] args2) {
        return RubyTime.createTime(recv2, args2, true, false);
    }

    @JRubyMethod(name={"_load"}, meta=true)
    public static RubyTime load(IRubyObject recv2, IRubyObject from, Block block) {
        return RubyTime.s_mload(recv2, (RubyTime)((RubyClass)recv2).allocate(), from);
    }

    @Override
    public Object toJava(Class target) {
        if (target.equals(java.util.Date.class)) {
            return this.getJavaDate();
        }
        if (target.equals(Calendar.class)) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(this.getJavaDate());
            return cal;
        }
        if (target.equals(DateTime.class)) {
            return this.dt;
        }
        if (target.equals(Date.class)) {
            return new Date(this.dt.getMillis());
        }
        if (target.equals(Time.class)) {
            return new Time(this.dt.getMillis());
        }
        if (target.equals(Timestamp.class)) {
            return new Timestamp(this.dt.getMillis());
        }
        if (target.isAssignableFrom(java.util.Date.class)) {
            return this.getJavaDate();
        }
        return super.toJava(target);
    }

    protected static RubyTime s_mload(IRubyObject recv2, RubyTime time, IRubyObject from) {
        int i2;
        Ruby runtime = recv2.getRuntime();
        DateTime dt = new DateTime(DateTimeZone.UTC);
        byte[] fromAsBytes = from.convertToString().getBytes();
        if (fromAsBytes.length != 8) {
            throw runtime.newTypeError("marshaled time format differ");
        }
        int p2 = 0;
        int s2 = 0;
        for (i2 = 0; i2 < 4; ++i2) {
            p2 |= (fromAsBytes[i2] & 0xFF) << 8 * i2;
        }
        for (i2 = 4; i2 < 8; ++i2) {
            s2 |= (fromAsBytes[i2] & 0xFF) << 8 * (i2 - 4);
        }
        boolean utc = false;
        if ((p2 & Integer.MIN_VALUE) == 0) {
            dt = dt.withMillis((long)p2 * 1000L);
            time.setUSec((s2 & 0xFFFFF) % 1000);
        } else {
            utc = ((p2 &= Integer.MAX_VALUE) >>> 30 & 1) == 1;
            dt = dt.withYear((p2 >>> 14 & 0xFFFF) + 1900);
            dt = dt.withMonthOfYear((p2 >>> 10 & 0xF) + 1);
            dt = dt.withDayOfMonth(p2 >>> 5 & 0x1F);
            dt = dt.withHourOfDay(p2 & 0x1F);
            dt = dt.withMinuteOfHour(s2 >>> 26 & 0x3F);
            dt = dt.withSecondOfMinute(s2 >>> 20 & 0x3F);
            dt = dt.withMillisOfSecond((s2 & 0xFFFFF) / 1000);
            time.setUSec((s2 & 0xFFFFF) % 1000);
        }
        time.setDateTime(dt);
        if (!utc) {
            time.localtime();
        }
        from.getInstanceVariables().copyInstanceVariablesInto(time);
        if (runtime.is1_9()) {
            IRubyObject nano_num = (IRubyObject)from.getInternalVariables().getInternalVariable("nano_num");
            IRubyObject nano_den = (IRubyObject)from.getInternalVariables().getInternalVariable("nano_den");
            IRubyObject offset2 = (IRubyObject)from.getInternalVariables().getInternalVariable("offset");
            if (nano_num != null && nano_den != null) {
                long nanos = nano_num.convertToInteger().getLongValue() / nano_den.convertToInteger().getLongValue();
                time.nsec += nanos;
            }
            if (offset2 != null) {
                long tz = offset2.convertToInteger().getLongValue();
                time.dt = dt.withZone(DateTimeZone.forOffsetMillis((int)(tz * 1000L)));
            }
        }
        return time;
    }

    private static RubyTime createTime(IRubyObject recv2, IRubyObject[] args2, boolean gmt2, boolean utcOffset) {
        DateTime dt;
        DateTimeZone dtz;
        Ruby runtime = recv2.getRuntime();
        int len = 7;
        boolean isDst = false;
        boolean setTzRelative = false;
        long nanos = 0L;
        if (gmt2) {
            dtz = DateTimeZone.UTC;
        } else if (args2.length == 10 && args2[9] instanceof RubyString) {
            if (utcOffset) {
                dtz = RubyTime.getTimeZoneFromUtcOffset(runtime, ((RubyString)args2[9]).toString());
                setTzRelative = true;
            } else {
                dtz = RubyTime.getTimeZone(runtime, ((RubyString)args2[9]).toString());
            }
        } else if (args2.length == 10 && args2[9].respondsTo("to_int")) {
            IRubyObject offsetInt = args2[9].callMethod(runtime.getCurrentContext(), "to_int");
            dtz = RubyTime.getTimeZone(runtime, ((RubyNumeric)offsetInt).getLongValue());
        } else {
            dtz = RubyTime.getLocalTimeZone(runtime);
        }
        if (args2.length == 10) {
            if (args2[8] instanceof RubyBoolean) {
                isDst = ((RubyBoolean)args2[8]).isTrue();
            }
            args2 = new IRubyObject[]{args2[5], args2[4], args2[3], args2[2], args2[1], args2[0], runtime.getNil()};
        } else {
            len = args2.length;
            if (len < 7) {
                IRubyObject[] newArgs = new IRubyObject[7];
                System.arraycopy(args2, 0, newArgs, 0, args2.length);
                for (int i2 = len; i2 < 7; ++i2) {
                    newArgs[i2] = runtime.getNil();
                }
                args2 = newArgs;
                len = 7;
            }
        }
        if (args2[0] instanceof RubyString) {
            args2[0] = RubyNumeric.str2inum(runtime, (RubyString)args2[0], 10, false);
        }
        int year2 = (int)RubyNumeric.num2long(args2[0]);
        int month2 = 1;
        if (len > 1) {
            if (!args2[1].isNil()) {
                IRubyObject tmp = args2[1].checkStringType();
                if (!tmp.isNil()) {
                    String monthString = tmp.toString().toLowerCase();
                    Integer monthInt = MONTHS_MAP.get(monthString);
                    if (monthInt != null) {
                        month2 = monthInt;
                    } else {
                        try {
                            month2 = Integer.parseInt(monthString);
                        }
                        catch (NumberFormatException nfExcptn) {
                            throw runtime.newArgumentError("Argument out of range.");
                        }
                    }
                } else {
                    month2 = (int)RubyNumeric.num2long(args2[1]);
                }
            }
            if (1 > month2 || month2 > 12) {
                throw runtime.newArgumentError("Argument out of range: for month: " + month2);
            }
        }
        int[] int_args = new int[]{1, 0, 0, 0, 0, 0};
        int i3 = 0;
        while (int_args.length >= i3 + 2) {
            if (!args2[i3 + 2].isNil()) {
                if (!(args2[i3 + 2] instanceof RubyNumeric)) {
                    args2[i3 + 2] = args2[i3 + 2].respondsTo("to_int") ? args2[i3 + 2].callMethod(runtime.getCurrentContext(), "to_int") : args2[i3 + 2].callMethod(runtime.getCurrentContext(), "to_i");
                }
                int_args[i3] = RubyNumeric.num2int(args2[i3 + 2]);
            }
            ++i3;
        }
        if (int_args[0] < 1 || int_args[0] > 31 || int_args[1] < 0 || int_args[1] > 24 || int_args[1] == 24 && (int_args[2] > 0 || int_args[3] > 0) || int_args[2] < 0 || int_args[2] > 59 || int_args[3] < 0 || int_args[3] > 60) {
            throw runtime.newArgumentError("argument out of range.");
        }
        if (runtime.is1_8()) {
            if (0 <= year2 && year2 < 39) {
                year2 += 2000;
                runtime.getWarnings().warn("2 digits year is used");
            } else if (69 <= year2 && year2 < 139) {
                year2 += 1900;
                runtime.getWarnings().warn("2 or 3 digits year is used");
            }
        }
        try {
            dt = new DateTime(year2, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            dt = dt.plusMonths(month2 - 1).plusDays(int_args[0] - 1).plusHours(int_args[1]).plusMinutes(int_args[2]).plusSeconds(int_args[3]);
            if (runtime.is1_9() && !args2[5].isNil() && args2[6].isNil()) {
                double secs = RubyFloat.num2dbl(args2[5]);
                int int_millis = (int)(secs * 1000.0) % 1000;
                dt = dt.plusMillis(int_millis);
                nanos = (long)(secs * 1.0E9) % 1000000L;
            }
            dt = dt.withZoneRetainFields(dtz);
            if (isDst) {
                int offsetAfterBoundary;
                DateTime beforeDstBoundary = dt.withEarlierOffsetAtOverlap();
                DateTime afterDstBoundary = dt.withLaterOffsetAtOverlap();
                int offsetBeforeBoundary = dtz.getOffset(beforeDstBoundary);
                dt = offsetBeforeBoundary > (offsetAfterBoundary = dtz.getOffset(afterDstBoundary)) ? beforeDstBoundary : afterDstBoundary;
            }
        }
        catch (IllegalFieldValueException e) {
            throw runtime.newArgumentError("time out of range");
        }
        RubyTime time = new RubyTime(runtime, (RubyClass)recv2, dt);
        if (args2.length != 8 && !args2[6].isNil()) {
            boolean fractionalUSecGiven;
            boolean bl = fractionalUSecGiven = args2[6] instanceof RubyFloat || args2[6] instanceof RubyRational;
            if (runtime.is1_9() && fractionalUSecGiven) {
                double micros = RubyNumeric.num2dbl(args2[6]);
                time.dt = dt.withMillis(dt.getMillis() + (long)(micros / 1000.0));
                nanos = (long)(micros * 1000.0) % 1000000L;
            } else {
                int usec2 = int_args[4] % 1000;
                int msec = int_args[4] / 1000;
                if (int_args[4] < 0) {
                    --msec;
                    usec2 += 1000;
                }
                time.dt = dt.withMillis(dt.getMillis() + (long)msec);
                time.setUSec(usec2);
            }
        }
        if (nanos != 0L) {
            time.setNSec(nanos);
        }
        time.callInit(IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        time.setIsTzRelative(setTzRelative);
        return time;
    }

    static {
        for (int i2 = 0; i2 < MONTHS.length; ++i2) {
            MONTHS_MAP.put(MONTHS[i2], i2 + 1);
        }
    }
}

