/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CoverageData {
    private volatile Map<String, int[]> coverage;
    private final EventHook COVERAGE_HOOK = new EventHook(){

        @Override
        public synchronized void eventHandler(ThreadContext context, String eventName, String file2, int line, String name2, IRubyObject type2) {
            int count2;
            if (CoverageData.this.coverage == null || line <= 0) {
                return;
            }
            int[] lines2 = (int[])CoverageData.this.coverage.get(file2);
            if (lines2 == null) {
                return;
            }
            if (lines2.length < line) {
                int[] newLines = new int[line];
                Arrays.fill(newLines, lines2.length, line, -1);
                System.arraycopy(lines2, 0, newLines, 0, lines2.length);
                lines2 = newLines;
                CoverageData.this.coverage.put(file2, lines2);
            }
            lines2[line - 1] = (count2 = lines2[line - 1]) == -1 ? 1 : count2 + 1;
        }

        @Override
        public boolean isInterestedInEvent(RubyEvent event2) {
            return event2 == RubyEvent.LINE;
        }
    };

    public boolean isCoverageEnabled() {
        return this.coverage != null;
    }

    public synchronized void setCoverageEnabled(Ruby runtime, boolean enabled) {
        if (enabled) {
            this.coverage = new HashMap<String, int[]>();
            runtime.addEventHook(this.COVERAGE_HOOK);
        } else {
            this.coverage = null;
        }
    }

    public synchronized Map<String, int[]> resetCoverage(Ruby runtime) {
        Map<String, int[]> coverage2 = this.coverage;
        runtime.removeEventHook(this.COVERAGE_HOOK);
        this.coverage = null;
        return coverage2;
    }

    public synchronized Map<String, int[]> prepareCoverage(String filename2, int[] lines2) {
        assert (lines2 != null);
        Map<String, int[]> coverage2 = this.coverage;
        if (coverage2 != null) {
            coverage2.put(filename2, lines2);
        }
        return coverage2;
    }
}

